/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.animator.internal;

import com.teamwizardry.librarianlib.features.animator.Lerper;
import com.teamwizardry.librarianlib.features.animator.LerperHandler;
import com.teamwizardry.librarianlib.features.animator.internal.Edit;
import com.teamwizardry.librarianlib.features.animator.internal.StringLerperKt;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004JK\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u00062\b\b\u0002\u0010\u000f\u001a\u00020\u00062\b\b\u0002\u0010\u0010\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J-\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0002\u0010\u0019J@\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0006J(\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fJ\u001c\u0010\u001b\u001a\u00020\u00022\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00170\f2\u0006\u0010\u000b\u001a\u00020\u0002J\u001e\u0010%\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u0010(\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u0010)\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u0016\u0010-\u001a\u00020.2\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002J\u001e\u0010/\u001a\u00020'2\u0006\u0010\u000b\u001a\u00020'2\u0006\u0010\r\u001a\u00020'2\u0006\u0010&\u001a\u00020'J\u001e\u00100\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u00101\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u00102\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u00103\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J\u001e\u00104\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010&\u001a\u00020'J \u00105\u001a\u00020\u00022\u0006\u00106\u001a\u00020\u00022\u0006\u00107\u001a\u00020\u00022\u0006\u00108\u001a\u00020'H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0012\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\bR\u0014\u0010\u0014\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!R\u001a\u0010*\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u001f\"\u0004\b,\u0010!\u00a8\u00069"}, d2={"Lcom/teamwizardry/librarianlib/features/animator/internal/StringLerper;", "Lcom/teamwizardry/librarianlib/features/animator/Lerper;", "", "<init>", "()V", "MAX_MATRIX_SIZE", "", "getMAX_MATRIX_SIZE", "()I", "costMatrix", "", "source", "", "target", "ins", "del", "sub", "(Ljava/util/List;Ljava/util/List;III)[Ljava/lang/Integer;", "INS", "getINS", "SUB", "getSUB", "editPath", "Lcom/teamwizardry/librarianlib/features/animator/internal/Edit;", "costs", "([Ljava/lang/Integer;Ljava/util/List;)Ljava/util/List;", "diff", "patch", "MULTI", "Lkotlin/text/Regex;", "getMULTI", "()Lkotlin/text/Regex;", "setMULTI", "(Lkotlin/text/Regex;)V", "GLYPH", "getGLYPH", "setGLYPH", "diffLerpAstral", "amount", "", "diffLerpBasic", "diffLerp", "NUMBERS", "getNUMBERS", "setNUMBERS", "areNumericTwins", "", "nlerp", "numericLerp", "fastLerpAstral", "fastLerpBasic", "fastLerp", "lerpInternal", "lerp", "from", "to", "fraction", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nStringLerper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StringLerper.kt\ncom/teamwizardry/librarianlib/features/animator/internal/StringLerper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,300:1\n1#2:301\n*E\n"})
public final class StringLerper
implements Lerper<String> {
    @NotNull
    public static final StringLerper INSTANCE = new StringLerper();
    private static final int MAX_MATRIX_SIZE = 65536;
    private static final int INS;
    private static final int SUB;
    @NotNull
    private static Regex MULTI;
    @NotNull
    private static Regex GLYPH;
    @NotNull
    private static Regex NUMBERS;

    private StringLerper() {
    }

    public final int getMAX_MATRIX_SIZE() {
        return MAX_MATRIX_SIZE;
    }

    @NotNull
    public final Integer[] costMatrix(@NotNull List<String> source, @NotNull List<String> target, int ins, int del, int sub) {
        int j;
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        int m = source.size() + 1;
        int n = target.size() + 1;
        int n2 = 0;
        int n3 = m * n;
        Integer[] integerArray = new Integer[n3];
        while (n2 < n3) {
            int n4 = n2++;
            integerArray[n4] = 0;
        }
        Integer[] d = integerArray;
        for (int i = 1; i < m; ++i) {
            d[n * i] = i;
        }
        for (j = 1; j < n; ++j) {
            d[j] = j;
        }
        for (j = 1; j < n; ++j) {
            for (int i = 1; i < m; ++i) {
                d[n * i + j] = Intrinsics.areEqual((Object)source.get(i - 1), (Object)target.get(j - 1)) ? d[n * (i - 1) + j - 1] : Integer.valueOf(Math.min(del + d[n * (i - 1) + j], Math.min(ins + d[n * i + j - 1], sub + d[n * (i - 1) + j - 1])));
            }
        }
        return d;
    }

    public static /* synthetic */ Integer[] costMatrix$default(StringLerper stringLerper, List list, List list2, int n, int n2, int n3, int n4, Object object) {
        if ((n4 & 4) != 0) {
            n = 1;
        }
        if ((n4 & 8) != 0) {
            n2 = n;
        }
        if ((n4 & 0x10) != 0) {
            n3 = Math.max(n, n2);
        }
        return stringLerper.costMatrix(list, list2, n, n2, n3);
    }

    public final int getINS() {
        return INS;
    }

    public final int getSUB() {
        return SUB;
    }

    @NotNull
    public final List<Edit> editPath(@NotNull Integer[] costs, @NotNull List<String> target) {
        Intrinsics.checkNotNullParameter((Object)costs, (String)"costs");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        LinkedList<Edit> path = new LinkedList<Edit>();
        int j = target.size();
        int n = j + 1;
        int i = costs.length / n - 1;
        while (i != 0 || j != 0) {
            double ins;
            double sub = i != 0 && j != 0 ? (double)costs[n * (i - 1) + j - 1].intValue() : Double.POSITIVE_INFINITY;
            double del = i != 0 ? (double)costs[n * (i - 1) + j].intValue() : Double.POSITIVE_INFINITY;
            double d = ins = j != 0 ? (double)costs[n * i + j - 1].intValue() : Double.POSITIVE_INFINITY;
            if (sub <= ins && sub <= del) {
                if (costs[n * i + j].intValue() != costs[n * (i - 1) + j - 1].intValue()) {
                    path.push(new Edit(SUB, i - 1, target.get(j - 1)));
                }
                --i;
                --j;
                continue;
            }
            if (ins <= del) {
                path.push(new Edit(INS, i, target.get(j - 1)));
                --j;
                continue;
            }
            path.push(new Edit(SUB, i - 1, ""));
            --i;
        }
        return path;
    }

    @NotNull
    public final List<Edit> diff(@NotNull List<String> source, @NotNull List<String> target, int ins, int del, int sub) {
        Intrinsics.checkNotNullParameter(source, (String)"source");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.editPath(this.costMatrix(source, target, ins, del, sub), target);
    }

    @NotNull
    public final List<String> patch(@NotNull List<Edit> diff, @NotNull List<String> source) {
        Intrinsics.checkNotNullParameter(diff, (String)"diff");
        Intrinsics.checkNotNullParameter(source, (String)"source");
        List<String> changed = source;
        for (Edit edit : diff) {
            String[] stringArray = new String[]{edit.getInsert()};
            changed = StringLerperKt.splice(changed, edit.getStart(), edit.getDelete(), stringArray);
        }
        return changed;
    }

    @NotNull
    public final String patch(@NotNull List<Edit> diff, @NotNull String source) {
        Intrinsics.checkNotNullParameter(diff, (String)"diff");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String changed = source;
        for (Edit edit : diff) {
            StringBuilder stringBuilder = new StringBuilder();
            String string = changed.substring(0, edit.getStart());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            StringBuilder stringBuilder2 = stringBuilder.append(string).append(edit.getInsert());
            String string2 = changed.substring(edit.getStart() + edit.getDelete());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            changed = stringBuilder2.append(string2).toString();
        }
        return changed;
    }

    @NotNull
    public final Regex getMULTI() {
        return MULTI;
    }

    public final void setMULTI(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        MULTI = regex;
    }

    @NotNull
    public final Regex getGLYPH() {
        return GLYPH;
    }

    public final void setGLYPH(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        GLYPH = regex;
    }

    @NotNull
    public final String diffLerpAstral(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List sourceGlyphs = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)GLYPH, (CharSequence)source, (int)0, (int)2, null), StringLerper::diffLerpAstral$lambda$0));
        List targetGlyphs = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)GLYPH, (CharSequence)target, (int)0, (int)2, null), StringLerper::diffLerpAstral$lambda$1));
        List<Edit> edits = this.diff(targetGlyphs, sourceGlyphs, 2, 2, 3);
        List<Edit> partial = edits.subList(0, Math.round((1.0f - amount) * (float)edits.size()));
        return CollectionsKt.joinToString$default((Iterable)this.patch(partial, targetGlyphs), (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String diffLerpBasic(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String[] stringArray = new String[]{""};
        List list = StringsKt.split$default((CharSequence)target, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        stringArray = new String[]{""};
        List<Edit> edits = this.diff(list, StringsKt.split$default((CharSequence)source, (String[])stringArray, (boolean)false, (int)0, (int)6, null), 2, 2, 3);
        List<Edit> partial = edits.subList(0, Math.round((1.0f - amount) * (float)edits.size()));
        return this.patch(partial, target);
    }

    @NotNull
    public final String diffLerp(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return MULTI.matches((CharSequence)source) || MULTI.matches((CharSequence)target) ? this.diffLerpAstral(source, target, amount) : this.diffLerpBasic(source, target, amount);
    }

    @NotNull
    public final Regex getNUMBERS() {
        return NUMBERS;
    }

    public final void setNUMBERS(@NotNull Regex regex) {
        Intrinsics.checkNotNullParameter((Object)regex, (String)"<set-?>");
        NUMBERS = regex;
    }

    public final boolean areNumericTwins(@NotNull String source, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CharSequence charSequence = source;
        Regex regex = NUMBERS;
        String string = "0";
        String string2 = regex.replace(charSequence, string);
        charSequence = target;
        regex = NUMBERS;
        string = "0";
        return string2 == regex.replace(charSequence, string);
    }

    public final float nlerp(float source, float target, float amount) {
        return source + (target - source) * amount;
    }

    @NotNull
    public final String numericLerp(@NotNull String source, @NotNull String target, float amount) {
        int i;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        CharSequence charSequence = target;
        Regex regex = NUMBERS;
        int n = 0;
        List splits = regex.split(charSequence, n);
        List matches = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)NUMBERS, (CharSequence)source, (int)0, (int)2, null), StringLerper::numericLerp$lambda$2));
        List targetParts = new ArrayList();
        int n2 = ((Collection)splits).size();
        for (i = 0; i < n2; ++i) {
            String string;
            String split = (String)targetParts.get(i);
            String match = (String)CollectionsKt.getOrNull((List)matches, (int)i);
            targetParts.add(split);
            if (match == null) continue;
            String it = string;
            boolean bl = false;
            targetParts.add(it);
        }
        i = 1;
        for (String sourcePart : matches) {
            String targetPart = (String)targetParts.get(i);
            float part = this.nlerp(Float.parseFloat(sourcePart), Float.parseFloat(targetPart), amount);
            int sourcePoint = StringsKt.indexOf$default((CharSequence)sourcePart, (String)".", (int)0, (boolean)false, (int)6, null);
            int targetPoint = StringsKt.indexOf$default((CharSequence)targetPart, (String)".", (int)0, (boolean)false, (int)6, null);
            int point = Math.round(this.nlerp(sourcePoint >= 0 ? (float)(sourcePart.length() - 1) - (float)sourcePoint : 0.0f, targetPoint >= 0 ? (float)(targetPart.length() - 1) - (float)targetPoint : 0.0f, amount));
            String string = "%." + point + 'f';
            Object[] objectArray = new Object[]{Float.valueOf(part)};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            targetParts.set(i, string2);
            i += 2;
        }
        return CollectionsKt.joinToString$default((Iterable)targetParts, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String fastLerpAstral(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List sourceGlyphs = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)GLYPH, (CharSequence)source, (int)0, (int)2, null), StringLerper::fastLerpAstral$lambda$4));
        List targetGlyphs = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)GLYPH, (CharSequence)target, (int)0, (int)2, null), StringLerper::fastLerpAstral$lambda$5));
        int sourceLength = Math.round((float)sourceGlyphs.size() * amount);
        int targetLength = Math.round((float)targetGlyphs.size() * amount);
        List head = targetGlyphs.subList(0, targetLength);
        List tail = sourceGlyphs.subList(sourceLength, sourceGlyphs.size());
        head = CollectionsKt.plus((Collection)head, (Iterable)tail);
        return CollectionsKt.joinToString$default((Iterable)head, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String fastLerpBasic(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        int sourceLength = Math.round((float)source.length() * amount);
        int targetLength = Math.round((float)target.length() * amount);
        String string = target.substring(0, targetLength);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String head = string;
        String string2 = source.substring(sourceLength, source.length());
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        String tail = string2;
        return head + tail;
    }

    @NotNull
    public final String fastLerp(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return MULTI.matches((CharSequence)source) || MULTI.matches((CharSequence)target) ? this.fastLerpAstral(source, target, amount) : this.fastLerpBasic(source, target, amount);
    }

    @NotNull
    public final String lerpInternal(@NotNull String source, @NotNull String target, float amount) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (amount == 0.0f) {
            return source;
        }
        if (amount == 1.0f) {
            return target;
        }
        if (this.areNumericTwins(source, target)) {
            return this.numericLerp(source, target, amount);
        }
        if (amount < 0.0f) {
            return source;
        }
        if (amount > 1.0f) {
            return target;
        }
        int n = source.length() * target.length();
        return n != 0 && n < MAX_MATRIX_SIZE ? this.diffLerp(source, target, amount) : this.fastLerp(source, target, amount);
    }

    @Override
    @NotNull
    public String lerp(@NotNull String from, @NotNull String to, float fraction) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        return this.lerpInternal(from, to, CommonUtilMethods.clamp(fraction, 0.0f, 1.0f));
    }

    private static final String diffLerpAstral$lambda$0(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final String diffLerpAstral$lambda$1(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final String numericLerp$lambda$2(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final String fastLerpAstral$lambda$4(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final String fastLerpAstral$lambda$5(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    static {
        SUB = 1;
        MULTI = new Regex("[\u0300-\u036f\u1dc0-\u1dff\u20d0-\u20ff\ud800-\udbff\ufe20-\ufe2f]");
        GLYPH = new Regex("[\\00-\u02ff\u0370-\u1dbf\u1e00-\u20cf\u2100-\ud7ff\ud800-\ufe1f\ufe30-\uffff][\u0300-\u036f\u1dc0-\u1dff\u20d0-\u20ff\udc00-\udfff\ufe20-\ufe2f]*");
        NUMBERS = new Regex("(-?\\d{1,20}(?:\\.\\d{1,20})?)");
        LerperHandler.INSTANCE.registerLerper(String.class, INSTANCE);
    }
}

