/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.autoregister;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.autoregister.AMPRegister;
import com.teamwizardry.librarianlib.features.autoregister.AnnotationMarkerProcessor;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.DefaultedMutableMap;
import com.teamwizardry.librarianlib.features.utilities.LoggerBase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraftforge.fml.common.discovery.ASMDataTable;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J6\u0010\u0014\u001a\u00020\u0011\"\b\b\u0000\u0010\u0015*\u00020\u0016\"\b\b\u0001\u0010\u0017*\u00020\u00012\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00170\u00062\u0006\u0010\u0019\u001a\u00020\u001aR\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR1\u0010\t\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\r\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler;", "", "<init>", "()V", "processors", "", "Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkerProcessor;", "getProcessors", "()Ljava/util/List;", "errors", "Lcom/teamwizardry/librarianlib/features/kotlin/DefaultedMutableMap;", "Ljava/lang/Class;", "Lcom/google/common/collect/Multimap;", "", "getErrors", "()Lcom/teamwizardry/librarianlib/features/kotlin/DefaultedMutableMap;", "preInit", "", "e", "Lnet/minecraftforge/fml/common/event/FMLPreInitializationEvent;", "handle", "A", "", "T", "processor", "asmDataTable", "Lnet/minecraftforge/fml/common/discovery/ASMDataTable;", "GetProcessors", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nAnnotationMarkers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AnnotationMarkers.kt\ncom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1863#2,2:100\n1863#2,2:102\n1053#2:104\n*S KotlinDebug\n*F\n+ 1 AnnotationMarkers.kt\ncom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler\n*L\n35#1:100,2\n46#1:102,2\n64#1:104\n*E\n"})
public final class AnnotationMarkersHandler {
    @NotNull
    public static final AnnotationMarkersHandler INSTANCE = new AnnotationMarkersHandler();
    @NotNull
    private static final List<AnnotationMarkerProcessor<?, ?>> processors = new ArrayList();
    @NotNull
    private static final DefaultedMutableMap<Class<?>, Multimap<String, Class<?>>> errors = CommonUtilMethods.withRealDefault(new LinkedHashMap(), AnnotationMarkersHandler::errors$lambda$0);

    private AnnotationMarkersHandler() {
    }

    @NotNull
    public final List<AnnotationMarkerProcessor<?, ?>> getProcessors() {
        return processors;
    }

    @NotNull
    public final DefaultedMutableMap<Class<?>, Multimap<String, Class<?>>> getErrors() {
        return errors;
    }

    public final void preInit(@NotNull FMLPreInitializationEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        ASMDataTable data = e.getAsmData();
        AnnotationMarkerProcessor annotationMarkerProcessor = GetProcessors.INSTANCE;
        Intrinsics.checkNotNull((Object)data);
        this.handle(annotationMarkerProcessor, data);
        Iterable $this$forEach$iv = CollectionsKt.toMutableList((Collection)processors);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AnnotationMarkerProcessor it = (AnnotationMarkerProcessor)element$iv;
            boolean bl = false;
            INSTANCE.handle(it, data);
        }
        if (!((Map)errors).isEmpty()) {
            String[] stringArray = new String[]{"AnnotationMarker Errors:"};
            List build = CollectionsKt.mutableListOf((Object[])stringArray);
            for (Map.Entry entry : ((Map)errors).entrySet()) {
                Class annot = (Class)entry.getKey();
                Multimap map = (Multimap)entry.getValue();
                build.add("-+ Errors for @" + annot.getTypeName());
                Map map2 = map.asMap();
                Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"asMap(...)");
                for (Map.Entry entry2 : map2.entrySet()) {
                    String error = (String)entry2.getKey();
                    Collection affected = (Collection)entry2.getValue();
                    build.add(" |-+ Affected classes:");
                    Intrinsics.checkNotNull((Object)affected);
                    Iterable $this$forEach$iv2 = affected;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv2) {
                        Class it = (Class)element$iv;
                        boolean bl = false;
                        build.add(" | |-+ " + it.getCanonicalName());
                    }
                    build.add(" |-+ Stacktrace:");
                    build.add(" | | ============================================================\n" + error + " | | ============================================================");
                }
            }
            LoggerBase.bigDie$default(LibrarianLog.INSTANCE, "FATAL: AnnotationMarkers failed!!", build, false, 4, null);
        }
    }

    public final <A extends Annotation, T> void handle(@NotNull AnnotationMarkerProcessor<A, T> processor, @NotNull ASMDataTable asmDataTable) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)asmDataTable, (String)"asmDataTable");
        Class<A> annotationClass = processor.getAnnotationClass();
        String annotationClassName = annotationClass.getCanonicalName();
        Set asmDatas = asmDataTable.getAll(annotationClassName);
        Intrinsics.checkNotNull((Object)asmDatas);
        Iterable $this$sortedBy$iv = asmDatas;
        boolean $i$f$sortedBy = false;
        for (ASMDataTable.ASMData asmData : CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ASMDataTable.ASMData it = (ASMDataTable.ASMData)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getClassName());
                it = (ASMDataTable.ASMData)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getClassName())));
            }
        })) {
            Class<?> clazz;
            Class<?> clazz2;
            try {
                clazz2 = Class.forName(asmData.getClassName());
            }
            catch (ClassNotFoundException e) {
                LibrarianLog.INSTANCE.error(e, "Marked class " + asmData.getClassName() + " not found!", new Object[0]);
                clazz2 = null;
            }
            if ((clazz = clazz2) == null) continue;
            if (!processor.isClassValid(clazz)) {
                LibrarianLog.INSTANCE.error("Class " + clazz.getCanonicalName() + " annotated with " + annotationClass.getTypeName() + " is invalid", new Object[0]);
            }
            A annot = clazz.getAnnotation(annotationClass);
            try {
                Intrinsics.checkNotNull(annot);
                processor.process(clazz, annot);
            }
            catch (Throwable e) {
                String str;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                Intrinsics.checkNotNullExpressionValue((Object)sw.toString(), (String)"toString(...)");
                errors.get(annotationClass).put((Object)str, clazz);
                e.printStackTrace();
            }
        }
    }

    private static final Multimap errors$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        HashMultimap hashMultimap = HashMultimap.create();
        Intrinsics.checkNotNullExpressionValue((Object)hashMultimap, (String)"create(...)");
        return (Multimap)hashMultimap;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0014\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u00010\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkersHandler$GetProcessors;", "Lcom/teamwizardry/librarianlib/features/autoregister/AnnotationMarkerProcessor;", "Lcom/teamwizardry/librarianlib/features/autoregister/AMPRegister;", "<init>", "()V", "process", "", "clazz", "Ljava/lang/Class;", "annotation", "LibrarianLib-Continuous-1.12.2"})
    public static final class GetProcessors
    extends AnnotationMarkerProcessor<AMPRegister, AnnotationMarkerProcessor<?, ?>> {
        @NotNull
        public static final GetProcessors INSTANCE = new GetProcessors();

        private GetProcessors() {
            Class[] classArray = new Class[]{AnnotationMarkerProcessor.class};
            super(AMPRegister.class, classArray);
        }

        @Override
        public void process(@NotNull Class<AnnotationMarkerProcessor<?, ?>> clazz, @NotNull AMPRegister annotation) {
            Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
            Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
            AnnotationMarkerProcessor<?, ?> annotationMarkerProcessor = CommonUtilMethods.getSingletonInstance(clazz);
            if (annotationMarkerProcessor == null) {
                throw new RuntimeException("No singleton instance!");
            }
            INSTANCE.getProcessors().add(annotationMarkerProcessor);
        }
    }
}

