/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.base;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.core.common.OwnershipHandler;
import com.teamwizardry.librarianlib.core.common.RegistrationHandler;
import com.teamwizardry.librarianlib.features.helpers.VariantHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.JsonMaker;
import com.teamwizardry.librarianlib.features.utilities.JsonGenerationUtilsKt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bB/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\t\"\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\nB\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\fJ\b\u0010\u0002\u001a\u00020\u0003H\u0016J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0010H\u0016J\n\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent;", "Lnet/minecraft/util/SoundEvent;", "name", "", "subtitle", "sounds", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "", "(Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)V", "(Ljava/lang/String;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "modid", "id", "Lnet/minecraft/util/ResourceLocation;", "", "json", "Lcom/google/gson/JsonElement;", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nModSoundEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModSoundEvent.kt\ncom/teamwizardry/librarianlib/features/base/ModSoundEvent\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,128:1\n1#2:129\n381#3,7:130\n*S KotlinDebug\n*F\n+ 1 ModSoundEvent.kt\ncom/teamwizardry/librarianlib/features/base/ModSoundEvent\n*L\n63#1:130,7\n*E\n"})
public class ModSoundEvent
extends SoundEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> sounds;
    @NotNull
    private final String modid;
    @Nullable
    private final String subtitle;
    @NotNull
    private final ResourceLocation id;
    @NotNull
    private static final Map<String, List<ModSoundEvent>> modSounds = new LinkedHashMap();

    /*
     * WARNING - void declaration
     */
    public ModSoundEvent(@NotNull String name, @Nullable String subtitle, @NotNull List<String> sounds) {
        Object object;
        void $this$getOrPut$iv;
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(sounds, (String)"sounds");
        super(ModSoundEvent.Companion.rl(name));
        this.sounds = sounds;
        this.modid = com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods.getCurrentModId();
        ModSoundEvent modSoundEvent = this;
        String string2 = subtitle;
        if (string2 != null) {
            String string3 = string2;
            ModSoundEvent modSoundEvent2 = modSoundEvent;
            boolean bl = false;
            string = this.modid + ".subtitle." + VariantHelper.toSnakeCase(subtitle);
            modSoundEvent = modSoundEvent2;
        } else {
            string = null;
        }
        modSoundEvent.subtitle = string;
        this.id = ModSoundEvent.Companion.rl(name);
        RegistrationHandler.register((IForgeRegistryEntry)this, this.id);
        Map<String, List<ModSoundEvent>> map = modSounds;
        String key$iv = this.modid;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(this);
    }

    public ModSoundEvent(@NotNull String name, @Nullable String subtitle, String ... sounds) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sounds, (String)"sounds");
        this(name, subtitle, CollectionsKt.listOf((Object[])Arrays.copyOf(sounds, sounds.length)));
    }

    public ModSoundEvent(@NotNull String name, @Nullable String subtitle) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, subtitle, CollectionsKt.listOf((Object)ModSoundEvent.Companion.rl(name).toString()));
    }

    public ModSoundEvent(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(name, null);
    }

    @NotNull
    public String name() {
        String string = this.id.func_110623_a();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    @NotNull
    public Iterable<String> sounds() {
        return this.sounds;
    }

    @Nullable
    public String subtitle() {
        return this.subtitle;
    }

    @NotNull
    public JsonElement json() {
        JsonObject obj = new JsonObject();
        obj.add("sounds", JsonMaker.convertJSON(this.sounds()));
        String sub = this.subtitle();
        if (sub != null) {
            obj.addProperty("subtitle", sub);
        }
        return (JsonElement)obj;
    }

    @JvmStatic
    @NotNull
    public static final ModSoundEvent simple(@NotNull String name) {
        return Companion.simple(name);
    }

    @JvmStatic
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static final void onSoundRegistry(@NotNull RegistryEvent.Register<SoundEvent> event) {
        Companion.onSoundRegistry(event);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0002J\u0016\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0007R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent$Companion;", "", "<init>", "()V", "simple", "Lcom/teamwizardry/librarianlib/features/base/ModSoundEvent;", "name", "", "rl", "Lnet/minecraft/util/ResourceLocation;", "modSounds", "", "", "shouldGenerateAnyJson", "", "serialize", "el", "Lcom/google/gson/JsonElement;", "log", "", "text", "onSoundRegistry", "event", "Lnet/minecraftforge/event/RegistryEvent$Register;", "Lnet/minecraft/util/SoundEvent;", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ModSoundEvent simple(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new ModSoundEvent(name, name);
        }

        private final ResourceLocation rl(String name) {
            return new ResourceLocation(com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods.getCurrentModId(), VariantHelper.toSnakeCase(name));
        }

        private final boolean shouldGenerateAnyJson() {
            return LibrarianLib.DEV_ENVIRONMENT && LibLibConfig.getGenerateJson();
        }

        private final String serialize(JsonElement el) {
            return LibLibConfig.getPrettyJsonSerialization() ? JsonMaker.serialize(el) : "" + el + '\n';
        }

        private final void log(String text) {
            if (LibrarianLib.DEV_ENVIRONMENT) {
                LibrarianLog.INSTANCE.info(text, new Object[0]);
            }
        }

        @JvmStatic
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public final void onSoundRegistry(@NotNull RegistryEvent.Register<SoundEvent> event) {
            Intrinsics.checkNotNullParameter(event, (String)"event");
            if (this.shouldGenerateAnyJson()) {
                for (Map.Entry entry : modSounds.entrySet()) {
                    Object object;
                    String mod = (String)entry.getKey();
                    List sounds = (List)entry.getValue();
                    if (!OwnershipHandler.INSTANCE.getDEV_OWNED().contains(mod)) continue;
                    this.log(mod + " | Registering sounds in json");
                    String modpad = CommonUtilMethods.times(" ", mod.length());
                    String soundJsonPath = JsonGenerationUtilsKt.getPathForSounds(mod);
                    File file = new File(soundJsonPath);
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                    boolean flag = false;
                    try {
                        object = file;
                        Charset charset = Charsets.UTF_8;
                        object = new JsonParser().parse((Reader)new InputStreamReader((InputStream)new FileInputStream((File)object), charset)).getAsJsonObject();
                    }
                    catch (Throwable ignored) {
                        flag = true;
                        object = new JsonObject();
                    }
                    File json = object;
                    for (ModSoundEvent sound : sounds) {
                        String name = sound.name();
                        this.log(modpad + " | Registering sound " + name);
                        if (json.has(name)) continue;
                        json.add(name, sound.json());
                        this.log(modpad + " | Successfully registered " + name + '!');
                        flag = true;
                    }
                    if (!flag) continue;
                    this.log(modpad + " | Writing new sound json");
                    Intrinsics.checkNotNull((Object)json);
                    FilesKt.writeText$default((File)file, (String)this.serialize((JsonElement)json), null, (int)2, null);
                    JsonGenerationUtilsKt.getGeneratedFiles().add(soundJsonPath);
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

