/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.base.block;

import com.google.common.base.Optional;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.block.properties.PropertyHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0016\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB%\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\t\"\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\nJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001d\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0005H\u0016\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0002J\u000e\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u001f\u001a\u00020\u0010J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0096\u0002J\b\u0010$\u001a\u00020\u0010H\u0016R&\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00020\u0006j\b\u0012\u0004\u0012\u00020\u0002`\u0005X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR'\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00020\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00100\u000f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0014\u001a\u0004\b\u0016\u0010\u0012\u00a8\u0006%"}, d2={"Lcom/teamwizardry/librarianlib/features/base/block/PropertyString;", "Lnet/minecraft/block/properties/PropertyHelper;", "", "name", "values", "Lkotlin/collections/LinkedHashSet;", "Ljava/util/LinkedHashSet;", "<init>", "(Ljava/lang/String;Ljava/util/LinkedHashSet;)V", "", "(Ljava/lang/String;[Ljava/lang/String;)V", "getValues", "()Ljava/util/LinkedHashSet;", "Ljava/util/LinkedHashSet;", "indexToValues", "", "", "getIndexToValues", "()Ljava/util/Map;", "indexToValues$delegate", "Lkotlin/Lazy;", "valuesToIndex", "getValuesToIndex", "valuesToIndex$delegate", "parseValue", "Lcom/google/common/base/Optional;", "value", "getName", "getAllowedValues", "getMetaFromName", "getNameFromMeta", "meta", "equals", "", "other", "", "hashCode", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nPropertyString.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropertyString.kt\ncom/teamwizardry/librarianlib/features/base/block/PropertyString\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,42:1\n1187#2,2:43\n1261#2,4:45\n1187#2,2:49\n1261#2,4:51\n*S KotlinDebug\n*F\n+ 1 PropertyString.kt\ncom/teamwizardry/librarianlib/features/base/block/PropertyString\n*L\n19#1:43,2\n19#1:45,4\n20#1:49,2\n20#1:51,4\n*E\n"})
public class PropertyString
extends PropertyHelper<String> {
    @NotNull
    private final LinkedHashSet<String> values;
    @NotNull
    private final Lazy indexToValues$delegate;
    @NotNull
    private final Lazy valuesToIndex$delegate;

    public PropertyString(@NotNull String name, @NotNull LinkedHashSet<String> values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        super(name, String.class);
        this.values = values;
        if (this.getValues().isEmpty()) {
            throw new IllegalArgumentException("Values are empty!");
        }
        this.indexToValues$delegate = LazyKt.lazy(() -> PropertyString.indexToValues_delegate$lambda$1(this));
        this.valuesToIndex$delegate = LazyKt.lazy(() -> PropertyString.valuesToIndex_delegate$lambda$3(this));
    }

    @NotNull
    public LinkedHashSet<String> getValues() {
        return this.values;
    }

    public PropertyString(@NotNull String name, String ... values) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)values, (String)"values");
        this(name, new LinkedHashSet<String>(ArraysKt.toList((Object[])values)));
    }

    private final Map<Integer, String> getIndexToValues() {
        Lazy lazy = this.indexToValues$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, Integer> getValuesToIndex() {
        Lazy lazy = this.valuesToIndex$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public Optional<String> func_185929_b(@NotNull String value) {
        Optional optional;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.getValues().contains(value)) {
            Optional optional2 = Optional.of((Object)value);
            optional = optional2;
            Intrinsics.checkNotNullExpressionValue((Object)optional2, (String)"of(...)");
        } else {
            Optional optional3 = Optional.absent();
            optional = optional3;
            Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"absent(...)");
        }
        return optional;
    }

    @NotNull
    public String getName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return value;
    }

    @NotNull
    public LinkedHashSet<String> getAllowedValues() {
        return this.getValues();
    }

    public final int getMetaFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Integer n = this.getValuesToIndex().get(name);
        return n != null ? n : 0;
    }

    @NotNull
    public final String getNameFromMeta(int meta) {
        String string = this.getIndexToValues().get(meta);
        if (string == null) {
            string = (String)CollectionsKt.first((Iterable)this.getValues());
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PropertyString)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        return Intrinsics.areEqual(this.getValues(), ((PropertyString)((Object)other)).getValues());
    }

    public int hashCode() {
        return 31 * super.hashCode() + this.getValues().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    private static final Map indexToValues_delegate$lambda$1(PropertyString this$0) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)this$0.getValues());
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getIndex(), (Object)it.getValue());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map valuesToIndex_delegate$lambda$3(PropertyString this$0) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)this$0.getValues());
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            IndexedValue it = (IndexedValue)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

