/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.base.item;

import baubles.api.BaubleType;
import baubles.api.BaublesApi;
import baubles.api.IBauble;
import baubles.api.cap.IBaublesItemHandler;
import com.teamwizardry.librarianlib.core.common.LibLibSoundEvents;
import com.teamwizardry.librarianlib.features.base.item.ItemMod;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.utilities.client.TooltipHelper;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Optional.Interface(iface="baubles.api.IBauble", modid="baubles")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0006\"\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH'J&\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0017H\u0017J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0017H\u0017J0\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J0\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a8\u0006!"}, d2={"Lcom/teamwizardry/librarianlib/features/base/item/ItemModBauble;", "Lcom/teamwizardry/librarianlib/features/base/item/ItemMod;", "Lbaubles/api/IBauble;", "name", "", "variants", "", "<init>", "(Ljava/lang/String;[Ljava/lang/String;)V", "getBaubleType", "Lbaubles/api/BaubleType;", "stack", "Lnet/minecraft/item/ItemStack;", "onItemRightClick", "Lnet/minecraft/util/ActionResult;", "world", "Lnet/minecraft/world/World;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "hand", "Lnet/minecraft/util/EnumHand;", "onEquippedOrLoadedIntoWorld", "", "Lnet/minecraft/entity/EntityLivingBase;", "onEquipped", "onWornTick", "addInformation", "tooltip", "", "flag", "Lnet/minecraft/client/util/ITooltipFlag;", "addHiddenTooltip", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nItemModBauble.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemModBauble.kt\ncom/teamwizardry/librarianlib/features/base/item/ItemModBauble\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,110:1\n1310#2,2:111\n*S KotlinDebug\n*F\n+ 1 ItemModBauble.kt\ncom/teamwizardry/librarianlib/features/base/item/ItemModBauble\n*L\n104#1:111,2\n*E\n"})
public abstract class ItemModBauble
extends ItemMod
implements IBauble {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG_HASHCODE = "playerHashcode";

    public ItemModBauble(@NotNull String name, String ... variants2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)variants2, (String)"variants");
        super(name, Arrays.copyOf(variants2, variants2.length));
        this.field_77777_bU = 1;
    }

    @Optional.Method(modid="baubles")
    @NotNull
    public abstract BaubleType getBaubleType(@NotNull ItemStack var1);

    @NotNull
    public ActionResult<ItemStack> func_77659_a(@NotNull World world, @NotNull EntityPlayer player, @NotNull EnumHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        ItemStack stack = player.func_184586_b(hand);
        if (this.canEquip(stack, (EntityLivingBase)player)) {
            IBaublesItemHandler iBaublesItemHandler = BaublesApi.getBaublesHandler((EntityPlayer)player);
            if (iBaublesItemHandler == null) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            IBaublesItemHandler baubles = iBaublesItemHandler;
            int n = baubles.getSlots();
            for (int i = 0; i < n; ++i) {
                ItemStack stackInSlot;
                if (!baubles.isItemValidForSlot(i, stack, (EntityLivingBase)player)) continue;
                Intrinsics.checkNotNullExpressionValue((Object)baubles.getStackInSlot(i), (String)"getStackInSlot(...)");
                if (!stackInSlot.func_190926_b()) {
                    Item item = stackInSlot.func_77973_b();
                    Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type baubles.api.IBauble");
                    if (!((IBauble)item).canUnequip(stackInSlot, (EntityLivingBase)player)) continue;
                }
                if (!world.field_72995_K) {
                    ItemStack cpy = stack.func_77946_l();
                    baubles.setStackInSlot(i, cpy);
                    Intrinsics.checkNotNull((Object)cpy);
                    this.onEquipped(cpy, (EntityLivingBase)player);
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                    }
                }
                if (!CommonUtilMethods.isNotEmpty(stackInSlot)) break;
                Item item = stackInSlot.func_77973_b();
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type baubles.api.IBauble");
                ((IBauble)item).onUnequipped(stackInSlot, (EntityLivingBase)player);
                ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stackInSlot.func_77946_l());
                Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"newResult(...)");
                return actionResult;
            }
        }
        ActionResult actionResult = ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        Intrinsics.checkNotNullExpressionValue((Object)actionResult, (String)"newResult(...)");
        return actionResult;
    }

    public void onEquippedOrLoadedIntoWorld(@NotNull ItemStack stack, @NotNull EntityLivingBase player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
    }

    @Optional.Method(modid="baubles")
    public void onEquipped(@NotNull ItemStack stack, @NotNull EntityLivingBase player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, (SoundEvent)LibLibSoundEvents.INSTANCE.getBaubleEquip(), SoundCategory.PLAYERS, 0.1f, 1.3f);
        }
        this.onEquippedOrLoadedIntoWorld(stack, player);
        Companion.setLastPlayerHashcode(stack, player.hashCode());
    }

    @Optional.Method(modid="baubles")
    public void onWornTick(@NotNull ItemStack stack, @NotNull EntityLivingBase player) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (Companion.getLastPlayerHashcode(stack) != player.hashCode()) {
            this.onEquippedOrLoadedIntoWorld(stack, player);
            Companion.setLastPlayerHashcode(stack, player.hashCode());
        }
    }

    @Optional.Method(modid="baubles")
    public void func_77624_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        TooltipHelper.INSTANCE.tooltipIfShift(tooltip, (Function1<? super List<String>, Unit>)((Function1)arg_0 -> ItemModBauble.addInformation$lambda$0(this, stack, world, tooltip, flag, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public void addHiddenTooltip(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag flag) {
        String key;
        Object[] objectArray;
        block2: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            Intrinsics.checkNotNullParameter(tooltip, (String)"tooltip");
            Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
            KeyBinding[] keys = Minecraft.func_71410_x().field_71474_y.field_74324_K;
            Intrinsics.checkNotNull((Object)keys);
            KeyBinding[] keyBindingArray = keys;
            boolean $i$f$firstOrNull = false;
            int n = ((void)$this$firstOrNull$iv).length;
            for (int i = 0; i < n; ++i) {
                void element$iv;
                void it = element$iv = $this$firstOrNull$iv[i];
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.func_151464_g(), (Object)"Baubles Inventory")) continue;
                objectArray = element$iv;
                break block2;
            }
            objectArray = null;
        }
        Object[] objectArray2 = objectArray;
        String string = key = objectArray2 != null ? objectArray2.getDisplayName() : null;
        if (key != null) {
            objectArray2 = new Object[]{key};
            TooltipHelper.addToTooltip(tooltip, "librarianlib.bauble_tooltip", objectArray2);
        }
    }

    private static final Unit addInformation$lambda$0(ItemModBauble this$0, ItemStack $stack, World $world, List $tooltip, ITooltipFlag $flag, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$stack, (String)"$stack");
        Intrinsics.checkNotNullParameter((Object)$tooltip, (String)"$tooltip");
        Intrinsics.checkNotNullParameter((Object)$flag, (String)"$flag");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addHiddenTooltip($stack, $world, $tooltip, $flag);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/teamwizardry/librarianlib/features/base/item/ItemModBauble$Companion;", "", "<init>", "()V", "TAG_HASHCODE", "", "getLastPlayerHashcode", "", "stack", "Lnet/minecraft/item/ItemStack;", "setLastPlayerHashcode", "", "hash", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public final int getLastPlayerHashcode(@NotNull ItemStack stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            return NBTHelper.getInt(stack, ItemModBauble.TAG_HASHCODE, 0);
        }

        public final void setLastPlayerHashcode(@NotNull ItemStack stack, int hash) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            NBTHelper.setInt(stack, ItemModBauble.TAG_HASHCODE, hash);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

