/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.base.item;

import com.google.gson.JsonElement;
import com.teamwizardry.librarianlib.core.client.ModelHandler;
import com.teamwizardry.librarianlib.features.base.IModelGenerator;
import com.teamwizardry.librarianlib.features.base.ModCreativeTab;
import com.teamwizardry.librarianlib.features.base.item.IModItemProvider;
import com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.helpers.VariantHelper;
import com.teamwizardry.librarianlib.features.utilities.FileDsl;
import com.teamwizardry.librarianlib.features.utilities.JsonGenerationUtilsKt;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001eH\u0016J\u0018\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00022\u0006\u0010&\u001a\u00020\u0005H\u0016R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0011X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u0014\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u001f\u001a\u0004\u0018\u00010 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lcom/teamwizardry/librarianlib/features/base/item/ItemModSpade;", "Lnet/minecraft/item/ItemSpade;", "Lcom/teamwizardry/librarianlib/features/base/item/IModItemProvider;", "Lcom/teamwizardry/librarianlib/features/base/IModelGenerator;", "name", "", "toolMaterial", "Lnet/minecraft/item/Item$ToolMaterial;", "<init>", "(Ljava/lang/String;Lnet/minecraft/item/Item$ToolMaterial;)V", "providedItem", "Lnet/minecraft/item/Item;", "getProvidedItem", "()Lnet/minecraft/item/Item;", "bareName", "modId", "variants", "", "getVariants", "()[Ljava/lang/String;", "[Ljava/lang/String;", "setTranslationKey", "getTranslationKey", "stack", "Lnet/minecraft/item/ItemStack;", "getSubItems", "", "tab", "Lnet/minecraft/creativetab/CreativeTabs;", "subItems", "Lnet/minecraft/util/NonNullList;", "creativeTab", "Lcom/teamwizardry/librarianlib/features/base/ModCreativeTab;", "getCreativeTab", "()Lcom/teamwizardry/librarianlib/features/base/ModCreativeTab;", "generateMissingItem", "", "item", "variant", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nItemModTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemModTool.kt\ncom/teamwizardry/librarianlib/features/base/item/ItemModSpade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ModelHandler.kt\ncom/teamwizardry/librarianlib/core/client/ModelHandler\n*L\n1#1,272:1\n1628#2,3:273\n286#3,11:276\n*S KotlinDebug\n*F\n+ 1 ItemModTool.kt\ncom/teamwizardry/librarianlib/features/base/item/ItemModSpade\n*L\n205#1:273,3\n217#1:276,11\n*E\n"})
public class ItemModSpade
extends ItemSpade
implements IModItemProvider,
IModelGenerator {
    @NotNull
    private final String bareName;
    @NotNull
    private final String modId;
    @NotNull
    private final String[] variants;

    public ItemModSpade(@NotNull String name, @NotNull Item.ToolMaterial toolMaterial) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)toolMaterial, (String)"toolMaterial");
        super(toolMaterial);
        this.bareName = VariantHelper.toSnakeCase(name);
        this.modId = CommonUtilMethods.getCurrentModId();
        this.variants = VariantHelper.setupItem((Item)this, this.bareName, new String[0], (Function0<? extends ModCreativeTab>)((Function0)new PropertyReference0Impl(this){

            public Object get() {
                return ((ItemModSpade)this.receiver).getCreativeTab();
            }
        }));
    }

    @Override
    @NotNull
    public Item getProvidedItem() {
        return (Item)this;
    }

    @Override
    @NotNull
    public String[] getVariants() {
        return this.variants;
    }

    @NotNull
    public Item func_77655_b(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        VariantHelper.setTranslationKeyForItem((Item)this, this.modId, name);
        Item item = super.func_77655_b(name);
        Intrinsics.checkNotNullExpressionValue((Object)item, (String)"setTranslationKey(...)");
        return item;
    }

    @NotNull
    public String func_77667_c(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        int dmg = stack.func_77952_i();
        String[] variants2 = this.getVariants();
        String name = dmg >= variants2.length ? this.bareName : variants2[dmg];
        return "item." + this.modId + ':' + name;
    }

    /*
     * WARNING - void declaration
     */
    public void func_150895_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> subItems) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        Intrinsics.checkNotNullParameter(subItems, (String)"subItems");
        if (this.func_194125_a(tab)) {
            Iterable $this$mapTo$iv = (Iterable)ArraysKt.getIndices((Object[])this.getVariants());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv.iterator();
            while (iterator2.hasNext()) {
                void it;
                int item$iv;
                int n = item$iv = ((IntIterator)iterator2).nextInt();
                Collection collection = (Collection)subItems;
                boolean bl = false;
                collection.add(new ItemStack((Item)this, 1, (int)it));
            }
            Collection cfr_ignored_0 = (Collection)subItems;
        }
    }

    @Nullable
    public ModCreativeTab getCreativeTab() {
        return ModCreativeTab.Companion.getDefaultTabs().get(this.modId);
    }

    @Override
    public boolean generateMissingItem(@NotNull IModItemProvider item, @NotNull String variant) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        ModelHandler this_$iv = ModelHandler.INSTANCE;
        boolean $i$f$generateItemJson = false;
        FileDsl<Item> fileDsl = new FileDsl<Item>((IForgeRegistryEntry)((IModItemProvider)this).getProvidedItem(), null, 2, null);
        FileDsl<Item> entry = fileDsl;
        boolean bl = false;
        entry.to(JsonGenerationUtilsKt.getPathForItemModel(entry, variant), (JsonElement)JsonGenerationUtilsKt.generateBaseItemModel(entry, variant, "item/handheld"));
        Map<String, JsonElement> files$iv = fileDsl.getMap();
        for (Map.Entry entry2 : files$iv.entrySet()) {
            String path$iv = (String)entry2.getKey();
            JsonElement model$iv = (JsonElement)entry2.getValue();
            File file$iv = new File(path$iv);
            file$iv.getParentFile().mkdirs();
            if (!file$iv.createNewFile()) continue;
            FilesKt.writeText$default((File)file$iv, (String)this_$iv.serialize(model$iv), null, (int)2, null);
            this_$iv.log(this_$iv.getNamePad() + " | Creating " + file$iv.getName() + " for item model of " + this_$iv.getNameForItemProvider(this));
            JsonGenerationUtilsKt.getGeneratedFiles().add(path$iv);
        }
        return true;
    }
}

