/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.chunkdata;

import com.teamwizardry.librarianlib.features.chunkdata.ChunkData;
import com.teamwizardry.librarianlib.features.chunkdata.ChunkDataContainer;
import com.teamwizardry.librarianlib.features.chunkdata.ChunkDataRegistry;
import com.teamwizardry.librarianlib.features.chunkdata.ChunkDataRegistryItem;
import com.teamwizardry.librarianlib.features.network.PacketCustomChunkData;
import com.teamwizardry.librarianlib.features.network.PacketHandler;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0016J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0016J\b\u0010\u0010\u001a\u00020\u000eH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/chunkdata/ChunkWorldData;", "Lnet/minecraft/world/storage/WorldSavedData;", "<init>", "()V", "containers", "", "Lnet/minecraft/util/math/ChunkPos;", "Lcom/teamwizardry/librarianlib/features/chunkdata/ChunkDataContainer;", "getContainers", "()Ljava/util/Map;", "writeToNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "compound", "readFromNBT", "", "nbt", "markDirty", "isDirty", "", "setDirty", "Companion", "LibrarianLib-Continuous-1.12.2"})
public final class ChunkWorldData
extends WorldSavedData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<ChunkPos, ChunkDataContainer> containers = new LinkedHashMap();
    @NotNull
    public static final String NAME = "librarianlib:chunkdata";

    public ChunkWorldData() {
        super(NAME);
    }

    @NotNull
    public final Map<ChunkPos, ChunkDataContainer> getContainers() {
        return this.containers;
    }

    @Nullable
    public NBTTagCompound func_189551_b(@Nullable NBTTagCompound compound) {
        return compound;
    }

    public void func_76184_a(@Nullable NBTTagCompound nbt) {
    }

    public void func_76185_a() {
    }

    public boolean func_76188_b() {
        return false;
    }

    public void func_76186_a(boolean isDirty) {
    }

    @JvmStatic
    @SubscribeEvent
    public static final void loadChunk(@NotNull ChunkDataEvent.Load e) {
        Companion.loadChunk(e);
    }

    @JvmStatic
    @SubscribeEvent
    public static final void saveChunk(@NotNull ChunkDataEvent.Save e) {
        Companion.saveChunk(e);
    }

    @JvmStatic
    @SubscribeEvent
    public static final void unloadChunk(@NotNull ChunkEvent.Unload e) {
        Companion.unloadChunk(e);
    }

    @JvmStatic
    @SubscribeEvent
    public static final void clientLoad(@NotNull ChunkEvent.Load e) {
        Companion.clientLoad(e);
    }

    @JvmStatic
    @SubscribeEvent
    public static final void watch(@NotNull ChunkWatchEvent.Watch e) {
        Companion.watch(e);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000bH\u0007J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\rH\u0007J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0011H\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/teamwizardry/librarianlib/features/chunkdata/ChunkWorldData$Companion;", "", "<init>", "()V", "NAME", "", "loadChunk", "", "e", "Lnet/minecraftforge/event/world/ChunkDataEvent$Load;", "saveChunk", "Lnet/minecraftforge/event/world/ChunkDataEvent$Save;", "unloadChunk", "Lnet/minecraftforge/event/world/ChunkEvent$Unload;", "clientLoad", "Lnet/minecraftforge/event/world/ChunkEvent$Load;", "watch", "Lnet/minecraftforge/event/world/ChunkWatchEvent$Watch;", "get", "Lcom/teamwizardry/librarianlib/features/chunkdata/ChunkWorldData;", "world", "Lnet/minecraft/world/World;", "LibrarianLib-Continuous-1.12.2"})
    @SourceDebugExtension(value={"SMAP\nChunkWorldData.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChunkWorldData.kt\ncom/teamwizardry/librarianlib/features/chunkdata/ChunkWorldData$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n1863#2,2:133\n1863#2,2:135\n1863#2,2:137\n1863#2,2:139\n216#3,2:141\n1#4:143\n*S KotlinDebug\n*F\n+ 1 ChunkWorldData.kt\ncom/teamwizardry/librarianlib/features/chunkdata/ChunkWorldData$Companion\n*L\n35#1:133,2\n57#1:135,2\n77#1:137,2\n88#1:139,2\n105#1:141,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @SubscribeEvent
        public final void loadChunk(@NotNull ChunkDataEvent.Load e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            NBTTagCompound nBTTagCompound = e.getData().func_74775_l("librarianlib_chunkdata");
            if (nBTTagCompound == null) {
                nBTTagCompound = new NBTTagCompound();
            }
            NBTTagCompound rootData = nBTTagCompound;
            ChunkDataContainer container = new ChunkDataContainer();
            Chunk chunk = e.getChunk();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
            Iterable $this$forEach$iv = ChunkDataRegistry.getApplicable(chunk);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkDataRegistryItem it = (ChunkDataRegistryItem)element$iv;
                boolean bl = false;
                Function1<Chunk, ChunkData> function1 = it.getConstructor();
                Chunk chunk2 = e.getChunk();
                Intrinsics.checkNotNullExpressionValue((Object)chunk2, (String)"getChunk(...)");
                ChunkData data = (ChunkData)function1.invoke((Object)chunk2);
                data.setName(it.getName());
                if (rootData.func_74764_b(it.getName().toString())) {
                    NBTTagCompound nbt = rootData.func_74775_l(it.getName().toString());
                    Intrinsics.checkNotNull((Object)nbt);
                    data.loadFromNBT(nbt);
                } else {
                    data.initializeNewChunk();
                }
                container.getDatas().put(it.getClazz(), data);
            }
            World world = e.getChunk().func_177412_p();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            Map<ChunkPos, ChunkDataContainer> map = this.get(world).getContainers();
            map.put(e.getChunk().func_76632_l(), container);
        }

        @JvmStatic
        @SubscribeEvent
        public final void saveChunk(@NotNull ChunkDataEvent.Save e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            NBTTagCompound rootData = new NBTTagCompound();
            World world = e.getChunk().func_177412_p();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            ChunkDataContainer chunkDataContainer = this.get(world).getContainers().get(e.getChunk().func_76632_l());
            if (chunkDataContainer == null) {
                return;
            }
            ChunkDataContainer container = chunkDataContainer;
            Chunk chunk = e.getChunk();
            Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
            Iterable $this$forEach$iv = ChunkDataRegistry.getApplicable(chunk);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ChunkData data;
                ChunkDataRegistryItem it = (ChunkDataRegistryItem)element$iv;
                boolean bl = false;
                if (container.getDatas().get(it.getClazz()) == null) continue;
                NBTTagCompound nbt = data.saveToNBT(new NBTTagCompound());
                rootData.func_74782_a(it.getName().toString(), (NBTBase)nbt);
            }
            e.getData().func_74782_a("librarianlib_chunkdata", (NBTBase)rootData);
        }

        @JvmStatic
        @SubscribeEvent
        public final void unloadChunk(@NotNull ChunkEvent.Unload e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            World world = e.getChunk().func_177412_p();
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
            this.get(world).getContainers().remove(e.getChunk().func_76632_l());
        }

        @JvmStatic
        @SubscribeEvent
        public final void clientLoad(@NotNull ChunkEvent.Load e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getChunk().func_177412_p().field_72995_K) {
                ChunkDataContainer container = new ChunkDataContainer();
                Chunk chunk = e.getChunk();
                Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
                Object $this$forEach$iv = ChunkDataRegistry.getApplicable(chunk);
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv = iterator2.next();
                    ChunkDataRegistryItem it = (ChunkDataRegistryItem)element$iv;
                    boolean bl = false;
                    Function1<Chunk, ChunkData> function1 = it.getConstructor();
                    Chunk chunk2 = e.getChunk();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk2, (String)"getChunk(...)");
                    ChunkData data = (ChunkData)function1.invoke((Object)chunk2);
                    data.setName(it.getName());
                    container.getDatas().put(it.getClazz(), data);
                }
                World world = e.getChunk().func_177412_p();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                $this$forEach$iv = this.get(world).getContainers();
                $this$forEach$iv.put(e.getChunk().func_76632_l(), container);
            } else {
                World world = e.getChunk().func_177412_p();
                Intrinsics.checkNotNullExpressionValue((Object)world, (String)"getWorld(...)");
                ChunkWorldData worldData = this.get(world);
                if (!worldData.getContainers().containsKey(e.getChunk().func_76632_l())) {
                    ChunkDataContainer container = new ChunkDataContainer();
                    Chunk chunk = e.getChunk();
                    Intrinsics.checkNotNullExpressionValue((Object)chunk, (String)"getChunk(...)");
                    Iterable $this$forEach$iv = ChunkDataRegistry.getApplicable(chunk);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ChunkDataRegistryItem it = (ChunkDataRegistryItem)element$iv;
                        boolean bl = false;
                        Function1<Chunk, ChunkData> function1 = it.getConstructor();
                        Chunk chunk3 = e.getChunk();
                        Intrinsics.checkNotNullExpressionValue((Object)chunk3, (String)"getChunk(...)");
                        ChunkData data = (ChunkData)function1.invoke((Object)chunk3);
                        data.setName(it.getName());
                        data.initializeNewChunk();
                        container.getDatas().put(it.getClazz(), data);
                    }
                    worldData.getContainers().put(e.getChunk().func_76632_l(), container);
                }
            }
        }

        @JvmStatic
        @SubscribeEvent
        public final void watch(@NotNull ChunkWatchEvent.Watch e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            World world = e.getPlayer().field_70170_p;
            Intrinsics.checkNotNullExpressionValue((Object)world, (String)"world");
            ChunkDataContainer chunkDataContainer = this.get(world).getContainers().get(e.getChunk());
            if (chunkDataContainer == null) {
                return;
            }
            ChunkDataContainer container = chunkDataContainer;
            Map<Class<?>, ChunkData> $this$forEach$iv = container.getDatas();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<Class<?>, ChunkData>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                ChunkDataRegistryItem dataType;
                Map.Entry<Class<?>, ChunkData> element$iv;
                Map.Entry<Class<?>, ChunkData> it = element$iv = iterator2.next();
                boolean bl = false;
                if (ChunkDataRegistry.get(it.getKey()) == null) continue;
                ChunkPos chunkPos = e.getChunk();
                Intrinsics.checkNotNullExpressionValue((Object)chunkPos, (String)"getChunk(...)");
                PacketHandler.NETWORK.sendTo((IMessage)new PacketCustomChunkData(chunkPos, dataType.getName(), it.getValue()), e.getPlayer());
            }
        }

        @NotNull
        public final ChunkWorldData get(@NotNull World world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            WorldSavedData worldSavedData = world.getPerWorldStorage().func_75742_a(ChunkWorldData.class, ChunkWorldData.NAME);
            ChunkWorldData chunkWorldData = worldSavedData instanceof ChunkWorldData ? (ChunkWorldData)worldSavedData : null;
            if (chunkWorldData == null) {
                WorldSavedData it = worldSavedData = new ChunkWorldData();
                boolean bl = false;
                world.getPerWorldStorage().func_75745_a(ChunkWorldData.NAME, it);
                chunkWorldData = worldSavedData;
            }
            return chunkWorldData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

