/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.component.supporting;

import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.LayerHierarchyException;
import com.teamwizardry.librarianlib.features.facade.component.supporting.IComponentFocus;
import com.teamwizardry.librarianlib.features.facade.components.RootComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000bH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0016J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\f\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/component/supporting/ComponentFocusHandler;", "Lcom/teamwizardry/librarianlib/features/facade/component/supporting/IComponentFocus;", "<init>", "()V", "component", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "getComponent", "()Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "setComponent", "(Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;)V", "isFocused", "", "()Z", "requestFocus", "forceFocus", "", "requestBlur", "forceBlur", "requestFocusedState", "focused", "forceFocusedState", "LibrarianLib-Continuous-1.12.2"})
public final class ComponentFocusHandler
implements IComponentFocus {
    public GuiComponent component;

    @NotNull
    public final GuiComponent getComponent() {
        GuiComponent guiComponent = this.component;
        if (guiComponent != null) {
            return guiComponent;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"component");
        return null;
    }

    public final void setComponent(@NotNull GuiComponent guiComponent) {
        Intrinsics.checkNotNullParameter((Object)guiComponent, (String)"<set-?>");
        this.component = guiComponent;
    }

    @Override
    public boolean isFocused() {
        RootComponent rootComponent = this.getComponent().getGui();
        return (rootComponent != null ? rootComponent.getFocusedComponent() : null) == this.getComponent();
    }

    @Override
    public boolean requestFocus() {
        RootComponent rootComponent = this.getComponent().getGui();
        if (rootComponent == null) {
            throw new LayerHierarchyException("Component not contained within GUI");
        }
        RootComponent gui = rootComponent;
        if (this.getComponent().isFocused()) {
            return true;
        }
        GuiComponentEvents.RequestFocusEvent focusRequest = new GuiComponentEvents.RequestFocusEvent(false, 1, null);
        this.getComponent().BUS.fire((Event)focusRequest);
        if (focusRequest.getAllow()) {
            GuiComponent guiComponent = gui.getFocusedComponent();
            boolean bl = guiComponent != null ? !guiComponent.requestBlur() : false;
            if (bl) {
                return false;
            }
            gui.setFocusedComponent(this.getComponent());
            this.getComponent().BUS.fire((Event)new GuiComponentEvents.FocusEvent());
            return true;
        }
        return false;
    }

    @Override
    public void forceFocus() {
        RootComponent rootComponent = this.getComponent().getGui();
        if (rootComponent == null) {
            throw new LayerHierarchyException("Component not contained within GUI");
        }
        RootComponent gui = rootComponent;
        if (this.getComponent().isFocused()) {
            return;
        }
        GuiComponent guiComponent = gui.getFocusedComponent();
        if (guiComponent != null) {
            guiComponent.forceBlur();
        }
        gui.setFocusedComponent(this.getComponent());
        this.getComponent().BUS.fire((Event)new GuiComponentEvents.FocusEvent());
    }

    @Override
    public boolean requestBlur() {
        RootComponent rootComponent = this.getComponent().getGui();
        if (rootComponent == null) {
            throw new LayerHierarchyException("Component not contained within GUI");
        }
        RootComponent gui = rootComponent;
        if (!this.getComponent().isFocused()) {
            return true;
        }
        GuiComponentEvents.RequestBlurEvent blurRequest = new GuiComponentEvents.RequestBlurEvent(false, 1, null);
        this.getComponent().BUS.fire((Event)blurRequest);
        if (blurRequest.getAllow()) {
            gui.setFocusedComponent(null);
            this.getComponent().BUS.fire((Event)new GuiComponentEvents.BlurEvent());
            return true;
        }
        return false;
    }

    @Override
    public void forceBlur() {
        RootComponent rootComponent = this.getComponent().getGui();
        if (rootComponent == null) {
            throw new LayerHierarchyException("Component not contained within GUI");
        }
        RootComponent gui = rootComponent;
        if (!this.getComponent().isFocused()) {
            return;
        }
        gui.setFocusedComponent(null);
        this.getComponent().BUS.fire((Event)new GuiComponentEvents.BlurEvent());
    }

    @Override
    public boolean requestFocusedState(boolean focused) {
        return focused ? this.requestFocus() : this.requestBlur();
    }

    @Override
    public void forceFocusedState(boolean focused) {
        if (focused) {
            this.forceFocus();
        } else {
            this.forceBlur();
        }
    }
}

