/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.layout;

import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.supporting.ILayerData;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.Axis2d;
import com.teamwizardry.librarianlib.features.math.Cardinal2d;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u0004789:B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0001H\u0002J\u001e\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002J&\u00104\u001a\u00020+2\u0006\u00105\u001a\u00020\u00032\u0006\u00106\u001a\u00020\u00032\f\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0002R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006;"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox;", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "x", "", "y", "width", "height", "flexDirection", "Lcom/teamwizardry/librarianlib/features/math/Cardinal2d;", "<init>", "(IIIILcom/teamwizardry/librarianlib/features/math/Cardinal2d;)V", "getFlexDirection", "()Lcom/teamwizardry/librarianlib/features/math/Cardinal2d;", "setFlexDirection", "(Lcom/teamwizardry/librarianlib/features/math/Cardinal2d;)V", "alignItems", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;", "getAlignItems", "()Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;", "setAlignItems", "(Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;)V", "stretch", "", "getStretch", "()Z", "setStretch", "(Z)V", "justifyContent", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Justify;", "getJustifyContent", "()Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Justify;", "setJustifyContent", "(Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Justify;)V", "spacing", "getSpacing", "()I", "setSpacing", "(I)V", "minSize", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getMinSize", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "layoutChildren", "", "inertData", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;", "component", "layoutMajorAxis", "space", "list", "", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$FlexItem;", "layoutAlignment", "majorSpace", "crossSpace", "FlexItem", "Data", "Align", "Justify", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nFlexbox.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Flexbox.kt\ncom/teamwizardry/librarianlib/features/facade/layout/Flexbox\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LayerDataHandler.kt\ncom/teamwizardry/librarianlib/features/facade/component/supporting/LayerDataHandlerKt\n+ 4 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n+ 5 RectHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/RectHelpersKt\n*L\n1#1,365:1\n1557#2:366\n1628#2,2:367\n1630#2:370\n1863#2,2:371\n1557#2:374\n1628#2,2:375\n1630#2:378\n1053#2:379\n1863#2:380\n1864#2:383\n1863#2,2:384\n2979#2,5:386\n1863#2,2:391\n2979#2,5:393\n1863#2,2:398\n1863#2,2:400\n1863#2,2:402\n1863#2,2:404\n1863#2,2:406\n1872#2,3:408\n1872#2,3:411\n1872#2,3:414\n139#3:369\n139#3:377\n49#4:373\n8#5:381\n8#5:382\n*S KotlinDebug\n*F\n+ 1 Flexbox.kt\ncom/teamwizardry/librarianlib/features/facade/layout/Flexbox\n*L\n50#1:366\n50#1:367,2\n50#1:370\n57#1:371,2\n71#1:374\n71#1:375,2\n71#1:378\n77#1:379\n85#1:380\n85#1:383\n124#1:384,2\n128#1:386,5\n136#1:391,2\n152#1:393,5\n160#1:398,2\n178#1:400,2\n192#1:402,2\n205#1:404,2\n211#1:406,2\n218#1:408,3\n226#1:411,3\n233#1:414,3\n54#1:369\n75#1:377\n66#1:373\n91#1:381\n96#1:382\n*E\n"})
public class Flexbox
extends GuiComponent {
    @NotNull
    private Cardinal2d flexDirection;
    @NotNull
    private Align alignItems;
    private boolean stretch;
    @NotNull
    private Justify justifyContent;
    private int spacing;

    public Flexbox(int x, int y, int width, int height, @NotNull Cardinal2d flexDirection) {
        Intrinsics.checkNotNullParameter((Object)((Object)flexDirection), (String)"flexDirection");
        super(x, y, width, height);
        this.flexDirection = flexDirection;
        this.alignItems = Align.START;
        this.stretch = true;
        this.justifyContent = Justify.SPACE_BETWEEN;
    }

    public /* synthetic */ Flexbox(int n, int n2, int n3, int n4, Cardinal2d cardinal2d, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            cardinal2d = Cardinal2d.RIGHT;
        }
        this(n, n2, n3, n4, cardinal2d);
    }

    @NotNull
    public final Cardinal2d getFlexDirection() {
        return this.flexDirection;
    }

    public final void setFlexDirection(@NotNull Cardinal2d cardinal2d) {
        Intrinsics.checkNotNullParameter((Object)((Object)cardinal2d), (String)"<set-?>");
        this.flexDirection = cardinal2d;
    }

    @NotNull
    public final Align getAlignItems() {
        return this.alignItems;
    }

    public final void setAlignItems(@NotNull Align align) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"<set-?>");
        this.alignItems = align;
    }

    public final boolean getStretch() {
        return this.stretch;
    }

    public final void setStretch(boolean bl) {
        this.stretch = bl;
    }

    @NotNull
    public final Justify getJustifyContent() {
        return this.justifyContent;
    }

    public final void setJustifyContent(@NotNull Justify justify) {
        Intrinsics.checkNotNullParameter((Object)((Object)justify), (String)"<set-?>");
        this.justifyContent = justify;
    }

    public final int getSpacing() {
        return this.spacing;
    }

    public final void setSpacing(int n) {
        this.spacing = n;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getMinSize() {
        Vec2d vec2d;
        int y$iv;
        Iterator $this$mapTo$iv$iv;
        int major = 0;
        int cross = 0;
        Iterable $this$map$iv = this.getSubComponents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            Object item$iv$iv = iterator2.next();
            GuiComponent guiComponent = (GuiComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = this.flexDirection.getAxis() == Axis2d.X ? it.getFrame().getHeighti() : it.getFrame().getWidthi();
            ILayerData $this$getData$iv = (ILayerData)it;
            boolean $i$f$getData = false;
            Data data = $this$getData$iv.getData(Data.class);
            if (data == null) {
                data = this.inertData((GuiComponent)it);
            }
            collection.add(new FlexItem((GuiComponent)it, n, data));
        }
        List items = (List)destination$iv$iv;
        Iterable $this$forEach$iv2 = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            FlexItem it = (FlexItem)element$iv;
            boolean bl = false;
            major += it.getFlexBasis() + it.getData().getMarginBefore() + it.getData().getMarginAfter();
            int n = cross;
            Boolean bl2 = it.getData().getStretchSelf();
            int n2 = (bl2 != null ? bl2 : this.stretch) ? it.getData().getMinCrossSize() : it.getCrossSize();
            cross = Math.max(n, n2);
        }
        if (this.flexDirection.getAxis() == Axis2d.X) {
            void x$iv;
            int $this$forEach$iv2 = major;
            y$iv = cross;
            boolean $i$f$vec = false;
            vec2d = Vec2d.Companion.getPooled((double)x$iv, y$iv);
        } else {
            int x$iv = cross;
            y$iv = major;
            boolean $i$f$vec = false;
            vec2d = Vec2d.Companion.getPooled(x$iv, y$iv);
        }
        return vec2d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutChildren() {
        int $i$f$getData;
        void $this$mapTo$iv$iv;
        super.layoutChildren();
        Iterable $this$map$iv = this.getSubComponents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GuiComponent guiComponent = (GuiComponent)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int n = this.flexDirection.getAxis() == Axis2d.X ? it.getFrame().getHeighti() : it.getFrame().getWidthi();
            ILayerData $this$getData$iv = (ILayerData)it;
            $i$f$getData = 0;
            Data data = $this$getData$iv.getData(Data.class);
            if (data == null) {
                data = this.inertData((GuiComponent)it);
            }
            collection.add(new FlexItem((GuiComponent)it, n, data));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List items = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                FlexItem it = (FlexItem)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getData().getOrder());
                it = (FlexItem)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getData().getOrder()));
            }
        });
        int majorLength = this.flexDirection.getAxis() == Axis2d.X ? this.getWidthi() : this.getHeighti();
        int crossLength = this.flexDirection.getAxis() == Axis2d.X ? this.getHeighti() : this.getWidthi();
        this.layoutMajorAxis(majorLength, items);
        this.layoutAlignment(majorLength, crossLength, items);
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int height$iv;
            int width$iv;
            int y$iv;
            int x$iv;
            boolean $i$f$rect;
            int majorPos;
            FlexItem it = (FlexItem)element$iv;
            boolean bl = false;
            int n = majorPos = this.flexDirection.getSign() < 1 ? majorLength - it.getPos() - it.getSize() : it.getPos();
            if (this.flexDirection.getAxis() == Axis2d.X) {
                int $this$getData$iv = majorPos;
                $i$f$getData = it.getCrossPos();
                int n2 = it.getSize();
                int n3 = it.getCrossSize();
                $i$f$rect = false;
                it.getComponent().setFrame(new Rect2d(x$iv, y$iv, width$iv, height$iv));
                continue;
            }
            x$iv = it.getCrossPos();
            y$iv = majorPos;
            width$iv = it.getCrossSize();
            height$iv = it.getSize();
            $i$f$rect = false;
            it.getComponent().setFrame(new Rect2d(x$iv, y$iv, width$iv, height$iv));
        }
    }

    private final Data inertData(GuiComponent component) {
        return new Data(0, this.flexDirection.getAxis() == Axis2d.X ? component.getWidthi() : component.getHeighti(), 0, 0, 0, 0, 0, Integer.MAX_VALUE, 0, 0, 0, Integer.MAX_VALUE, false, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutMajorAxis(int space, List<FlexItem> list) {
        int n;
        int n2;
        int remaining = 0;
        remaining = space;
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FlexItem it = (FlexItem)element$iv;
            boolean bl = false;
            remaining -= it.getFlexBasis() + it.getData().getMarginBefore() + it.getData().getMarginAfter();
        }
        Iterable $this$sumBy$iv = list;
        boolean $i$f$sumBy = false;
        int sum$iv = 0;
        for (Object element$iv : $this$sumBy$iv) {
            Iterator it;
            FlexItem flexItem = (FlexItem)element$iv;
            n2 = sum$iv;
            boolean bl = false;
            n = ((FlexItem)((Object)it)).getData().getFlexGrow();
            sum$iv = n2 + n;
        }
        int growSum = sum$iv;
        if (remaining > 0 && growSum != 0) {
            int lastRemaining = 0;
            while (remaining != lastRemaining) {
                lastRemaining = remaining;
                int leftover = 0;
                double unitsLeft = 0.0;
                unitsLeft = growSum;
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    FlexItem it = (FlexItem)element$iv2;
                    boolean bl = false;
                    if (unitsLeft == 0.0) continue;
                    int portion = MathKt.roundToInt((double)((double)(remaining * it.getData().getFlexGrow()) / unitsLeft));
                    it.setSize(it.getSize() + portion);
                    remaining -= portion;
                    unitsLeft -= (double)it.getData().getFlexGrow();
                    if (it.getSize() <= it.getData().getMaxSize()) continue;
                    leftover += it.getSize() - it.getData().getMaxSize();
                    it.setSize(it.getData().getMaxSize());
                }
                remaining += leftover;
            }
        }
        Iterable $this$sumBy$iv2 = list;
        boolean $i$f$sumBy2 = false;
        int sum$iv2 = 0;
        for (Object element$iv : $this$sumBy$iv2) {
            void it;
            FlexItem element$iv2 = (FlexItem)element$iv;
            n2 = sum$iv2;
            boolean bl = false;
            n = Math.max(1, it.getFlexBasis());
            sum$iv2 = n2 + n;
        }
        int basisSum = sum$iv2;
        if (remaining < 0 && basisSum != 0) {
            int lastRemaining = 0;
            while (remaining != lastRemaining) {
                lastRemaining = remaining;
                int leftover = 0;
                double unitsLeft = 0.0;
                unitsLeft = basisSum;
                Iterable $this$forEach$iv3 = list;
                boolean $i$f$forEach3 = false;
                for (Object element$iv : $this$forEach$iv3) {
                    FlexItem it = (FlexItem)element$iv;
                    boolean bl = false;
                    if (unitsLeft == 0.0) continue;
                    int portion = MathKt.roundToInt((double)((double)(remaining * it.getData().getFlexShrink() * Math.max(1, it.getFlexBasis())) / unitsLeft));
                    it.setSize(it.getSize() + portion);
                    remaining -= portion;
                    unitsLeft -= (double)Math.max(1, it.getFlexBasis());
                    if (it.getSize() >= it.getData().getMinSize()) continue;
                    leftover -= it.getData().getMinSize() - it.getSize();
                    it.setSize(it.getData().getMinSize());
                }
                remaining = leftover;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void layoutAlignment(int majorSpace, int crossSpace, List<FlexItem> list) {
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Align align;
            FlexItem it = (FlexItem)element$iv;
            boolean bl = false;
            Boolean bl2 = it.getData().getStretchSelf();
            if (bl2 != null ? bl2 : this.stretch) {
                it.setCrossSize(CommonUtilMethods.clamp(crossSpace, it.getData().getMinCrossSize(), it.getData().getMaxCrossSize()));
            }
            if ((align = it.getData().getAlignSelf()) == null) {
                align = this.alignItems;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[align.ordinal()]) {
                case 1: {
                    it.setCrossPos(it.getData().getMarginCrossBefore());
                    break;
                }
                case 2: {
                    it.setCrossPos((crossSpace - (it.getCrossSize() + it.getData().getMarginCrossBefore() + it.getData().getMarginCrossAfter())) / 2);
                    break;
                }
                case 3: {
                    it.setCrossPos(crossSpace - (it.getCrossSize() + it.getData().getMarginCrossAfter()));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        int width = 0;
        Iterable $this$forEach$iv2 = list;
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv2) {
            FlexItem it = (FlexItem)element$iv;
            boolean bl = false;
            it.setPos(width + it.getData().getMarginBefore());
            width += it.getData().getMarginBefore() + it.getSize() + it.getData().getMarginAfter();
        }
        int emptySpace = majorSpace - width;
        if (emptySpace > 0) {
            Justify justify = this.justifyContent;
            switch (WhenMappings.$EnumSwitchMapping$1[justify.ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    Iterable $this$forEach$iv3 = list;
                    boolean $i$f$forEach3 = false;
                    for (Object element$iv : $this$forEach$iv3) {
                        FlexItem it = (FlexItem)element$iv;
                        boolean bl = false;
                        it.setPos(it.getPos() + emptySpace);
                    }
                    break;
                }
                case 3: {
                    int offset = emptySpace / 2;
                    Iterable $this$forEach$iv4 = list;
                    boolean $i$f$forEach4 = false;
                    for (Object element$iv : $this$forEach$iv4) {
                        FlexItem it = (FlexItem)element$iv;
                        boolean bl = false;
                        it.setPos(it.getPos() + offset);
                    }
                    break;
                }
                case 4: {
                    if (!(!((Collection)list).isEmpty())) break;
                    double gap = (double)emptySpace / (double)list.size();
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        void it;
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        FlexItem flexItem = (FlexItem)item$iv;
                        int i = n;
                        boolean bl = false;
                        it.setPos(it.getPos() + MathKt.roundToInt((double)(gap * ((double)i + 0.5))));
                    }
                    break;
                }
                case 5: {
                    if (list.size() <= 1) break;
                    double gap = (double)emptySpace / (double)(list.size() - 1);
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        FlexItem it = (FlexItem)item$iv;
                        int i = n;
                        boolean bl = false;
                        it.setPos(it.getPos() + MathKt.roundToInt((double)(gap * (double)i)));
                    }
                    break;
                }
                case 6: {
                    double gap = (double)emptySpace / (double)(list.size() + 1);
                    Iterable $this$forEachIndexed$iv = list;
                    boolean $i$f$forEachIndexed = false;
                    int index$iv = 0;
                    for (Object item$iv : $this$forEachIndexed$iv) {
                        int n;
                        if ((n = index$iv++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        FlexItem it = (FlexItem)item$iv;
                        int i = n;
                        boolean bl = false;
                        it.setPos(it.getPos() + MathKt.roundToInt((double)(gap * (double)(i + 1))));
                    }
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;", "", "<init>", "(Ljava/lang/String;I)V", "START", "CENTER", "END", "LibrarianLib-Continuous-1.12.2"})
    public static final class Align
    extends Enum<Align> {
        public static final /* enum */ Align START = new Align();
        public static final /* enum */ Align CENTER = new Align();
        public static final /* enum */ Align END = new Align();
        private static final /* synthetic */ Align[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Align[] values() {
            return (Align[])$VALUES.clone();
        }

        public static Align valueOf(String value) {
            return Enum.valueOf(Align.class, value);
        }

        @NotNull
        public static EnumEntries<Align> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = alignArray = new Align[]{Align.START, Align.CENTER, Align.END};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u0002\n\u0002\b\u0015\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B}\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u009d\u0001\u0010;\u001a\u00020<2\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0002\u0010=J\t\u0010>\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010?\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\u001aJ\t\u0010@\u001a\u00020\u0003H\u00c6\u0003J\t\u0010A\u001a\u00020\u0003H\u00c6\u0003J\t\u0010B\u001a\u00020\u0003H\u00c6\u0003J\t\u0010C\u001a\u00020\u0003H\u00c6\u0003J\t\u0010D\u001a\u00020\u0003H\u00c6\u0003J\t\u0010E\u001a\u00020\u0003H\u00c6\u0003J\t\u0010F\u001a\u00020\u0003H\u00c6\u0003J\t\u0010G\u001a\u00020\u0003H\u00c6\u0003J\t\u0010H\u001a\u00020\u0003H\u00c6\u0003J\t\u0010I\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010J\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003\u00a2\u0006\u0002\u00103J\u000b\u0010K\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u00a0\u0001\u0010L\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\u00032\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u00032\b\b\u0002\u0010\u000e\u001a\u00020\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00c6\u0001\u00a2\u0006\u0002\u0010MJ\u0013\u0010N\u001a\u00020\u00102\b\u0010O\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010P\u001a\u00020\u0003H\u00d6\u0001J\t\u0010Q\u001a\u00020RH\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001d\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0016\"\u0004\b\u001f\u0010\u0018R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0016\"\u0004\b!\u0010\u0018R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0016\"\u0004\b#\u0010\u0018R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u0016\"\u0004\b%\u0010\u0018R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0016\"\u0004\b'\u0010\u0018R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u0016\"\u0004\b)\u0010\u0018R\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0016\"\u0004\b+\u0010\u0018R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\u0016\"\u0004\b-\u0010\u0018R\u001a\u0010\r\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0016\"\u0004\b/\u0010\u0018R\u001a\u0010\u000e\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u0010\u0016\"\u0004\b1\u0010\u0018R\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u00106\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:\u00a8\u0006S"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;", "", "order", "", "flexBasis", "flexGrow", "flexShrink", "marginBefore", "marginAfter", "minSize", "maxSize", "marginCrossBefore", "marginCrossAfter", "minCrossSize", "maxCrossSize", "stretchSelf", "", "alignSelf", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;", "<init>", "(ILjava/lang/Integer;IIIIIIIIIILjava/lang/Boolean;Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;)V", "getOrder", "()I", "setOrder", "(I)V", "getFlexBasis", "()Ljava/lang/Integer;", "setFlexBasis", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getFlexGrow", "setFlexGrow", "getFlexShrink", "setFlexShrink", "getMarginBefore", "setMarginBefore", "getMarginAfter", "setMarginAfter", "getMinSize", "setMinSize", "getMaxSize", "setMaxSize", "getMarginCrossBefore", "setMarginCrossBefore", "getMarginCrossAfter", "setMarginCrossAfter", "getMinCrossSize", "setMinCrossSize", "getMaxCrossSize", "setMaxCrossSize", "getStretchSelf", "()Ljava/lang/Boolean;", "setStretchSelf", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "getAlignSelf", "()Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;", "setAlignSelf", "(Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;)V", "config", "", "(IIILjava/lang/Integer;IIIIIIIILjava/lang/Boolean;Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;)V", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "copy", "(ILjava/lang/Integer;IIIIIIIIIILjava/lang/Boolean;Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Align;)Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;", "equals", "other", "hashCode", "toString", "", "LibrarianLib-Continuous-1.12.2"})
    public static final class Data {
        private int order;
        @Nullable
        private Integer flexBasis;
        private int flexGrow;
        private int flexShrink;
        private int marginBefore;
        private int marginAfter;
        private int minSize;
        private int maxSize;
        private int marginCrossBefore;
        private int marginCrossAfter;
        private int minCrossSize;
        private int maxCrossSize;
        @Nullable
        private Boolean stretchSelf;
        @Nullable
        private Align alignSelf;

        public Data(int order, @Nullable Integer flexBasis, int flexGrow, int flexShrink, int marginBefore, int marginAfter, int minSize, int maxSize, int marginCrossBefore, int marginCrossAfter, int minCrossSize, int maxCrossSize, @Nullable Boolean stretchSelf, @Nullable Align alignSelf) {
            this.order = order;
            this.flexBasis = flexBasis;
            this.flexGrow = flexGrow;
            this.flexShrink = flexShrink;
            this.marginBefore = marginBefore;
            this.marginAfter = marginAfter;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.marginCrossBefore = marginCrossBefore;
            this.marginCrossAfter = marginCrossAfter;
            this.minCrossSize = minCrossSize;
            this.maxCrossSize = maxCrossSize;
            this.stretchSelf = stretchSelf;
            this.alignSelf = alignSelf;
        }

        public final int getOrder() {
            return this.order;
        }

        public final void setOrder(int n) {
            this.order = n;
        }

        @Nullable
        public final Integer getFlexBasis() {
            return this.flexBasis;
        }

        public final void setFlexBasis(@Nullable Integer n) {
            this.flexBasis = n;
        }

        public final int getFlexGrow() {
            return this.flexGrow;
        }

        public final void setFlexGrow(int n) {
            this.flexGrow = n;
        }

        public final int getFlexShrink() {
            return this.flexShrink;
        }

        public final void setFlexShrink(int n) {
            this.flexShrink = n;
        }

        public final int getMarginBefore() {
            return this.marginBefore;
        }

        public final void setMarginBefore(int n) {
            this.marginBefore = n;
        }

        public final int getMarginAfter() {
            return this.marginAfter;
        }

        public final void setMarginAfter(int n) {
            this.marginAfter = n;
        }

        public final int getMinSize() {
            return this.minSize;
        }

        public final void setMinSize(int n) {
            this.minSize = n;
        }

        public final int getMaxSize() {
            return this.maxSize;
        }

        public final void setMaxSize(int n) {
            this.maxSize = n;
        }

        public final int getMarginCrossBefore() {
            return this.marginCrossBefore;
        }

        public final void setMarginCrossBefore(int n) {
            this.marginCrossBefore = n;
        }

        public final int getMarginCrossAfter() {
            return this.marginCrossAfter;
        }

        public final void setMarginCrossAfter(int n) {
            this.marginCrossAfter = n;
        }

        public final int getMinCrossSize() {
            return this.minCrossSize;
        }

        public final void setMinCrossSize(int n) {
            this.minCrossSize = n;
        }

        public final int getMaxCrossSize() {
            return this.maxCrossSize;
        }

        public final void setMaxCrossSize(int n) {
            this.maxCrossSize = n;
        }

        @Nullable
        public final Boolean getStretchSelf() {
            return this.stretchSelf;
        }

        public final void setStretchSelf(@Nullable Boolean bl) {
            this.stretchSelf = bl;
        }

        @Nullable
        public final Align getAlignSelf() {
            return this.alignSelf;
        }

        public final void setAlignSelf(@Nullable Align align) {
            this.alignSelf = align;
        }

        public final void config(int order, int flexGrow, int flexShrink, @Nullable Integer flexBasis, int marginBefore, int marginAfter, int minSize, int maxSize, int marginCrossBefore, int marginCrossAfter, int minCrossSize, int maxCrossSize, @Nullable Boolean stretchSelf, @Nullable Align alignSelf) {
            this.order = order;
            this.flexBasis = flexBasis;
            this.flexGrow = flexGrow;
            this.flexShrink = flexShrink;
            this.marginBefore = marginBefore;
            this.marginAfter = marginAfter;
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.marginCrossBefore = marginCrossBefore;
            this.marginCrossAfter = marginCrossAfter;
            this.minCrossSize = minCrossSize;
            this.maxCrossSize = maxCrossSize;
            this.stretchSelf = stretchSelf;
            this.alignSelf = alignSelf;
        }

        public static /* synthetic */ void config$default(Data data, int n, int n2, int n3, Integer n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Boolean bl, Align align, int n13, Object object) {
            if ((n13 & 1) != 0) {
                n = data.order;
            }
            if ((n13 & 2) != 0) {
                n2 = data.flexGrow;
            }
            if ((n13 & 4) != 0) {
                n3 = data.flexShrink;
            }
            if ((n13 & 8) != 0) {
                Integer n14 = n4 = n2 == 0 && n3 == 0 ? null : data.flexBasis;
            }
            if ((n13 & 0x10) != 0) {
                n5 = data.marginBefore;
            }
            if ((n13 & 0x20) != 0) {
                n6 = data.marginAfter;
            }
            if ((n13 & 0x40) != 0) {
                n7 = data.minSize;
            }
            if ((n13 & 0x80) != 0) {
                n8 = data.maxSize;
            }
            if ((n13 & 0x100) != 0) {
                n9 = data.marginCrossBefore;
            }
            if ((n13 & 0x200) != 0) {
                n10 = data.marginCrossAfter;
            }
            if ((n13 & 0x400) != 0) {
                n11 = data.minCrossSize;
            }
            if ((n13 & 0x800) != 0) {
                n12 = data.maxCrossSize;
            }
            if ((n13 & 0x1000) != 0) {
                bl = data.stretchSelf;
            }
            if ((n13 & 0x2000) != 0) {
                align = data.alignSelf;
            }
            data.config(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl, align);
        }

        public final int component1() {
            return this.order;
        }

        @Nullable
        public final Integer component2() {
            return this.flexBasis;
        }

        public final int component3() {
            return this.flexGrow;
        }

        public final int component4() {
            return this.flexShrink;
        }

        public final int component5() {
            return this.marginBefore;
        }

        public final int component6() {
            return this.marginAfter;
        }

        public final int component7() {
            return this.minSize;
        }

        public final int component8() {
            return this.maxSize;
        }

        public final int component9() {
            return this.marginCrossBefore;
        }

        public final int component10() {
            return this.marginCrossAfter;
        }

        public final int component11() {
            return this.minCrossSize;
        }

        public final int component12() {
            return this.maxCrossSize;
        }

        @Nullable
        public final Boolean component13() {
            return this.stretchSelf;
        }

        @Nullable
        public final Align component14() {
            return this.alignSelf;
        }

        @NotNull
        public final Data copy(int order, @Nullable Integer flexBasis, int flexGrow, int flexShrink, int marginBefore, int marginAfter, int minSize, int maxSize, int marginCrossBefore, int marginCrossAfter, int minCrossSize, int maxCrossSize, @Nullable Boolean stretchSelf, @Nullable Align alignSelf) {
            return new Data(order, flexBasis, flexGrow, flexShrink, marginBefore, marginAfter, minSize, maxSize, marginCrossBefore, marginCrossAfter, minCrossSize, maxCrossSize, stretchSelf, alignSelf);
        }

        public static /* synthetic */ Data copy$default(Data data, int n, Integer n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, Boolean bl, Align align, int n13, Object object) {
            if ((n13 & 1) != 0) {
                n = data.order;
            }
            if ((n13 & 2) != 0) {
                n2 = data.flexBasis;
            }
            if ((n13 & 4) != 0) {
                n3 = data.flexGrow;
            }
            if ((n13 & 8) != 0) {
                n4 = data.flexShrink;
            }
            if ((n13 & 0x10) != 0) {
                n5 = data.marginBefore;
            }
            if ((n13 & 0x20) != 0) {
                n6 = data.marginAfter;
            }
            if ((n13 & 0x40) != 0) {
                n7 = data.minSize;
            }
            if ((n13 & 0x80) != 0) {
                n8 = data.maxSize;
            }
            if ((n13 & 0x100) != 0) {
                n9 = data.marginCrossBefore;
            }
            if ((n13 & 0x200) != 0) {
                n10 = data.marginCrossAfter;
            }
            if ((n13 & 0x400) != 0) {
                n11 = data.minCrossSize;
            }
            if ((n13 & 0x800) != 0) {
                n12 = data.maxCrossSize;
            }
            if ((n13 & 0x1000) != 0) {
                bl = data.stretchSelf;
            }
            if ((n13 & 0x2000) != 0) {
                align = data.alignSelf;
            }
            return data.copy(n, n2, n3, n4, n5, n6, n7, n8, n9, n10, n11, n12, bl, align);
        }

        @NotNull
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Data(order=").append(this.order).append(", flexBasis=").append(this.flexBasis).append(", flexGrow=").append(this.flexGrow).append(", flexShrink=").append(this.flexShrink).append(", marginBefore=").append(this.marginBefore).append(", marginAfter=").append(this.marginAfter).append(", minSize=").append(this.minSize).append(", maxSize=").append(this.maxSize).append(", marginCrossBefore=").append(this.marginCrossBefore).append(", marginCrossAfter=").append(this.marginCrossAfter).append(", minCrossSize=").append(this.minCrossSize).append(", maxCrossSize=");
            stringBuilder.append(this.maxCrossSize).append(", stretchSelf=").append(this.stretchSelf).append(", alignSelf=").append((Object)this.alignSelf).append(')');
            return stringBuilder.toString();
        }

        public int hashCode() {
            int result = Integer.hashCode(this.order);
            result = result * 31 + (this.flexBasis == null ? 0 : ((Object)this.flexBasis).hashCode());
            result = result * 31 + Integer.hashCode(this.flexGrow);
            result = result * 31 + Integer.hashCode(this.flexShrink);
            result = result * 31 + Integer.hashCode(this.marginBefore);
            result = result * 31 + Integer.hashCode(this.marginAfter);
            result = result * 31 + Integer.hashCode(this.minSize);
            result = result * 31 + Integer.hashCode(this.maxSize);
            result = result * 31 + Integer.hashCode(this.marginCrossBefore);
            result = result * 31 + Integer.hashCode(this.marginCrossAfter);
            result = result * 31 + Integer.hashCode(this.minCrossSize);
            result = result * 31 + Integer.hashCode(this.maxCrossSize);
            result = result * 31 + (this.stretchSelf == null ? 0 : ((Object)this.stretchSelf).hashCode());
            result = result * 31 + (this.alignSelf == null ? 0 : this.alignSelf.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Data)) {
                return false;
            }
            Data data = (Data)other;
            if (this.order != data.order) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.flexBasis, (Object)data.flexBasis)) {
                return false;
            }
            if (this.flexGrow != data.flexGrow) {
                return false;
            }
            if (this.flexShrink != data.flexShrink) {
                return false;
            }
            if (this.marginBefore != data.marginBefore) {
                return false;
            }
            if (this.marginAfter != data.marginAfter) {
                return false;
            }
            if (this.minSize != data.minSize) {
                return false;
            }
            if (this.maxSize != data.maxSize) {
                return false;
            }
            if (this.marginCrossBefore != data.marginCrossBefore) {
                return false;
            }
            if (this.marginCrossAfter != data.marginCrossAfter) {
                return false;
            }
            if (this.minCrossSize != data.minCrossSize) {
                return false;
            }
            if (this.maxCrossSize != data.maxCrossSize) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.stretchSelf, (Object)data.stretchSelf)) {
                return false;
            }
            return this.alignSelf == data.alignSelf;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0016\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\r\"\u0004\b\u0016\u0010\u000fR\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\u001a\u0010\u001a\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\r\"\u0004\b\u001c\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$FlexItem;", "", "component", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "crossSize", "", "data", "Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;ILcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;)V", "getComponent", "()Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "getCrossSize", "()I", "setCrossSize", "(I)V", "getData", "()Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Data;", "flexBasis", "getFlexBasis", "size", "getSize", "setSize", "crossPos", "getCrossPos", "setCrossPos", "pos", "getPos", "setPos", "LibrarianLib-Continuous-1.12.2"})
    private static final class FlexItem {
        @NotNull
        private final GuiComponent component;
        private int crossSize;
        @NotNull
        private final Data data;
        private final int flexBasis;
        private int size;
        private int crossPos;
        private int pos;

        public FlexItem(@NotNull GuiComponent component, int crossSize, @NotNull Data data) {
            Intrinsics.checkNotNullParameter((Object)component, (String)"component");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.component = component;
            this.crossSize = crossSize;
            this.data = data;
            Integer n = this.data.getFlexBasis();
            this.size = this.flexBasis = CommonUtilMethods.clamp(n != null ? n.intValue() : this.component.getFrame().getWidthi(), this.data.getMinSize(), this.data.getMaxSize());
        }

        @NotNull
        public final GuiComponent getComponent() {
            return this.component;
        }

        public final int getCrossSize() {
            return this.crossSize;
        }

        public final void setCrossSize(int n) {
            this.crossSize = n;
        }

        @NotNull
        public final Data getData() {
            return this.data;
        }

        public final int getFlexBasis() {
            return this.flexBasis;
        }

        public final int getSize() {
            return this.size;
        }

        public final void setSize(int n) {
            this.size = n;
        }

        public final int getCrossPos() {
            return this.crossPos;
        }

        public final void setCrossPos(int n) {
            this.crossPos = n;
        }

        public final int getPos() {
            return this.pos;
        }

        public final void setPos(int n) {
            this.pos = n;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/Flexbox$Justify;", "", "<init>", "(Ljava/lang/String;I)V", "START", "END", "CENTER", "SPACE_AROUND", "SPACE_BETWEEN", "SPACE_EVENLY", "LibrarianLib-Continuous-1.12.2"})
    public static final class Justify
    extends Enum<Justify> {
        public static final /* enum */ Justify START = new Justify();
        public static final /* enum */ Justify END = new Justify();
        public static final /* enum */ Justify CENTER = new Justify();
        public static final /* enum */ Justify SPACE_AROUND = new Justify();
        public static final /* enum */ Justify SPACE_BETWEEN = new Justify();
        public static final /* enum */ Justify SPACE_EVENLY = new Justify();
        private static final /* synthetic */ Justify[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Justify[] values() {
            return (Justify[])$VALUES.clone();
        }

        public static Justify valueOf(String value) {
            return Enum.valueOf(Justify.class, value);
        }

        @NotNull
        public static EnumEntries<Justify> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = justifyArray = new Justify[]{Justify.START, Justify.END, Justify.CENTER, Justify.SPACE_AROUND, Justify.SPACE_BETWEEN, Justify.SPACE_EVENLY};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Align.values().length];
            try {
                nArray[Align.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align.END.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Justify.values().length];
            try {
                nArray[Justify.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Justify.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Justify.CENTER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Justify.SPACE_AROUND.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Justify.SPACE_BETWEEN.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Justify.SPACE_EVENLY.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

