/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.layout;

import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.layout.StackLayout;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.Align2d;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\u0006\u0010(\u001a\u00020&R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0006\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\t\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010R\u001a\u0010\u001f\u001a\u00020 X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006)"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/layout/StackLayoutImpl;", "Lcom/teamwizardry/librarianlib/features/facade/layout/StackLayout;", "horizontal", "", "align", "Lcom/teamwizardry/librarianlib/features/math/Align2d;", "reverse", "spacing", "", "collapseInvisible", "preserveCrosswise", "<init>", "(ZLcom/teamwizardry/librarianlib/features/math/Align2d;ZDZZ)V", "getHorizontal", "()Z", "setHorizontal", "(Z)V", "getAlign", "()Lcom/teamwizardry/librarianlib/features/math/Align2d;", "setAlign", "(Lcom/teamwizardry/librarianlib/features/math/Align2d;)V", "getReverse", "setReverse", "getSpacing", "()D", "setSpacing", "(D)V", "getCollapseInvisible", "setCollapseInvisible", "getPreserveCrosswise", "setPreserveCrosswise", "layer", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiLayer;", "getLayer", "()Lcom/teamwizardry/librarianlib/features/facade/component/GuiLayer;", "setLayer", "(Lcom/teamwizardry/librarianlib/features/facade/component/GuiLayer;)V", "fitToLength", "", "fitToBreadth", "layoutChildren", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nStackLayout.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackLayout.kt\ncom/teamwizardry/librarianlib/features/facade/layout/StackLayoutImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 RectHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/RectHelpersKt\n*L\n1#1,443:1\n1863#2,2:444\n1863#2,2:446\n1557#2:448\n1628#2,3:449\n1863#2:452\n1864#2:455\n1863#2:456\n1864#2:459\n10#3:453\n8#3:454\n10#3:457\n8#3:458\n*S KotlinDebug\n*F\n+ 1 StackLayout.kt\ncom/teamwizardry/librarianlib/features/facade/layout/StackLayoutImpl\n*L\n83#1:444,2\n102#1:446,2\n121#1:448\n121#1:449,3\n141#1:452\n141#1:455\n161#1:456\n161#1:459\n152#1:453\n152#1:454\n172#1:457\n172#1:458\n*E\n"})
final class StackLayoutImpl
implements StackLayout {
    private boolean horizontal;
    @NotNull
    private Align2d align;
    private boolean reverse;
    private double spacing;
    private boolean collapseInvisible;
    private boolean preserveCrosswise;
    public GuiLayer layer;

    public StackLayoutImpl(boolean horizontal, @NotNull Align2d align, boolean reverse, double spacing, boolean collapseInvisible, boolean preserveCrosswise) {
        Intrinsics.checkNotNullParameter((Object)((Object)align), (String)"align");
        this.horizontal = horizontal;
        this.align = align;
        this.reverse = reverse;
        this.spacing = spacing;
        this.collapseInvisible = collapseInvisible;
        this.preserveCrosswise = preserveCrosswise;
    }

    @Override
    public boolean getHorizontal() {
        return this.horizontal;
    }

    @Override
    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    @Override
    @NotNull
    public Align2d getAlign() {
        return this.align;
    }

    @Override
    public void setAlign(@NotNull Align2d align2d) {
        Intrinsics.checkNotNullParameter((Object)((Object)align2d), (String)"<set-?>");
        this.align = align2d;
    }

    @Override
    public boolean getReverse() {
        return this.reverse;
    }

    @Override
    public void setReverse(boolean bl) {
        this.reverse = bl;
    }

    @Override
    public double getSpacing() {
        return this.spacing;
    }

    @Override
    public void setSpacing(double d) {
        this.spacing = d;
    }

    @Override
    public boolean getCollapseInvisible() {
        return this.collapseInvisible;
    }

    @Override
    public void setCollapseInvisible(boolean bl) {
        this.collapseInvisible = bl;
    }

    @Override
    public boolean getPreserveCrosswise() {
        return this.preserveCrosswise;
    }

    @Override
    public void setPreserveCrosswise(boolean bl) {
        this.preserveCrosswise = bl;
    }

    @NotNull
    public final GuiLayer getLayer() {
        GuiLayer guiLayer = this.layer;
        if (guiLayer != null) {
            return guiLayer;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"layer");
        return null;
    }

    public final void setLayer(@NotNull GuiLayer guiLayer) {
        Intrinsics.checkNotNullParameter((Object)guiLayer, (String)"<set-?>");
        this.layer = guiLayer;
    }

    @Override
    public void fitToLength() {
        if (this.getLayer().getChildren().isEmpty()) {
            if (this.getHorizontal()) {
                this.getLayer().setWidth(0.0);
            } else {
                this.getLayer().setHeight(0.0);
            }
            return;
        }
        double length = 0.0;
        Iterable $this$forEach$iv = this.getLayer().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiLayer child = (GuiLayer)element$iv;
            boolean bl = false;
            if (this.getCollapseInvisible() && !child.isVisible()) continue;
            Rect2d frame = child.getFrame();
            if (this.getHorizontal()) {
                length += frame.getWidth() + this.getSpacing();
                continue;
            }
            length += frame.getHeight() + this.getSpacing();
        }
        length -= this.getSpacing();
        if (this.getHorizontal()) {
            this.getLayer().setWidth(length);
        } else {
            this.getLayer().setHeight(length);
        }
    }

    @Override
    public void fitToBreadth() {
        double bredth = 0.0;
        Iterable $this$forEach$iv = this.getLayer().getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiLayer child = (GuiLayer)element$iv;
            boolean bl = false;
            if (this.getCollapseInvisible() && !child.isVisible()) continue;
            Rect2d frame = child.getFrame();
            if (this.getHorizontal()) {
                bredth = Math.max(bredth, frame.getHeight());
                continue;
            }
            bredth = Math.max(bredth, frame.getWidth());
        }
        if (this.getHorizontal()) {
            this.getLayer().setHeight(bredth);
        } else {
            this.getLayer().setWidth(bredth);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void layoutChildren() {
        double reverseOffset;
        void $this$mapTo$iv$iv;
        double accumulator = 0.0;
        Iterable $this$map$iv = this.getLayer().getChildren();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void child;
            double d;
            GuiLayer guiLayer = (GuiLayer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            double it = d = accumulator;
            boolean bl2 = false;
            if (!this.getCollapseInvisible() || child.isVisible()) {
                accumulator = this.getHorizontal() ? (accumulator += child.getFrame().getWidth() + this.getSpacing()) : (accumulator += child.getFrame().getHeight() + this.getSpacing());
            }
            collection.add(d);
        }
        List positions = (List)destination$iv$iv;
        double d = reverseOffset = this.getReverse() ? accumulator : 0.0;
        if (this.getHorizontal()) {
            double d2;
            switch (WhenMappings.$EnumSwitchMapping$0[this.getAlign().getX().ordinal()]) {
                case 1: {
                    d2 = 0.0 + reverseOffset;
                    break;
                }
                case 2: {
                    d2 = Math.floor((this.getLayer().getWidth() - accumulator) / (double)2 + reverseOffset);
                    break;
                }
                case 3: {
                    d2 = Math.ceil(this.getLayer().getWidth() - accumulator + reverseOffset);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double xOffset = d2;
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)this.getLayer().getChildren(), (Iterable)positions);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void width$iv$iv;
                void y$iv$iv;
                void x$iv$iv;
                void y$iv;
                void x$iv;
                int n;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                GuiLayer child = (GuiLayer)pair.component1();
                double position = ((Number)pair.component2()).doubleValue();
                Rect2d frame = child.getFrame();
                double x = xOffset + (this.getReverse() ? -position : position);
                if (this.getPreserveCrosswise()) {
                    n = (int)child.getFrame().getMinY();
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$1[this.getAlign().getY().ordinal()]) {
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = CommonUtilMethods.floorInt((this.getLayer().getHeight() - frame.getHeight()) / (double)2);
                            break;
                        }
                        case 3: {
                            n = CommonUtilMethods.ceilInt(this.getLayer().getHeight() - frame.getHeight());
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                int y = n;
                double d3 = this.getReverse() ? x - frame.getWidth() : x;
                int n2 = y;
                Vec2d size$iv = frame.getSize();
                boolean $i$f$rect = false;
                void var26_45 = x$iv;
                double d4 = (double)y$iv;
                double d5 = size$iv.getX();
                double height$iv$iv = size$iv.getY();
                boolean $i$f$rect2 = false;
                child.setFrame(new Rect2d((double)x$iv$iv, (double)y$iv$iv, (double)width$iv$iv, height$iv$iv));
            }
        } else {
            double d6;
            switch (WhenMappings.$EnumSwitchMapping$1[this.getAlign().getY().ordinal()]) {
                case 1: {
                    d6 = 0.0 + reverseOffset;
                    break;
                }
                case 2: {
                    d6 = Math.floor((this.getLayer().getHeight() - accumulator) / (double)2 + reverseOffset);
                    break;
                }
                case 3: {
                    d6 = Math.ceil(this.getLayer().getHeight() - accumulator + reverseOffset);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            double yOffset = d6;
            Iterable $this$forEach$iv = CollectionsKt.zip((Iterable)this.getLayer().getChildren(), (Iterable)positions);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int x;
                int n;
                Pair pair = (Pair)element$iv;
                boolean bl = false;
                GuiLayer child = (GuiLayer)pair.component1();
                double position = ((Number)pair.component2()).doubleValue();
                Rect2d frame = child.getFrame();
                double y = yOffset + (this.getReverse() ? -position : position);
                if (this.getPreserveCrosswise()) {
                    n = (int)child.getFrame().getMinX();
                } else {
                    switch (WhenMappings.$EnumSwitchMapping$0[this.getAlign().getX().ordinal()]) {
                        case 1: {
                            n = 0;
                            break;
                        }
                        case 2: {
                            n = CommonUtilMethods.floorInt((this.getLayer().getWidth() - frame.getWidth()) / (double)2);
                            break;
                        }
                        case 3: {
                            n = CommonUtilMethods.ceilInt(this.getLayer().getWidth() - frame.getWidth());
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                int x$iv = x = n;
                double y$iv = this.getReverse() ? y - frame.getHeight() : y;
                Vec2d size$iv = frame.getSize();
                boolean $i$f$rect = false;
                double x$iv$iv = x$iv;
                double y$iv$iv = y$iv;
                double width$iv$iv = size$iv.getX();
                double height$iv$iv = size$iv.getY();
                boolean $i$f$rect3 = false;
                child.setFrame(new Rect2d(x$iv$iv, y$iv$iv, width$iv$iv, height$iv$iv));
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Align2d.X.values().length];
            try {
                nArray[Align2d.X.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align2d.X.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align2d.X.RIGHT.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Align2d.Y.values().length];
            try {
                nArray[Align2d.Y.TOP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align2d.Y.CENTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Align2d.Y.BOTTOM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

