/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.category;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.facade.provided.book.helper.TranslationHolder;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.category.ComponentCategoryPage;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.Entry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/J\u0016\u00100\u001a\b\u0012\u0004\u0012\u0002010\u000b2\u0006\u0010\u0002\u001a\u000202H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u0011\u0010#\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001cR\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010'\"\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020&8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010'R\u0014\u0010+\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\t\u00a8\u00063"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/category/Category;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/IBookElement;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;", "json", "Lcom/google/gson/JsonObject;", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;Lcom/google/gson/JsonObject;)V", "getBook", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;", "entries", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "getEntries", "()Ljava/util/List;", "title", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/helper/TranslationHolder;", "getTitle", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/helper/TranslationHolder;", "desc", "getDesc", "icon", "Lcom/google/gson/JsonElement;", "getIcon", "()Lcom/google/gson/JsonElement;", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "sheet", "", "getSheet", "()Ljava/lang/String;", "outerColor", "getOuterColor", "bindingColor", "getBindingColor", "isValid", "", "()Z", "setValid", "(Z)V", "isSingleEntry", "bookParent", "getBookParent", "anyUnlocked", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createComponents", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/context/PaginationContext;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nCategory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Category.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/category/Category\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1755#2,3:107\n*S KotlinDebug\n*F\n+ 1 Category.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/category/Category\n*L\n92#1:107,3\n*E\n"})
public final class Category
implements IBookElement {
    @NotNull
    private final Book book;
    @NotNull
    private final List<Entry> entries;
    @Nullable
    private final TranslationHolder title;
    @Nullable
    private final TranslationHolder desc;
    @NotNull
    private final JsonElement icon;
    @NotNull
    private final Color color;
    @NotNull
    private final String sheet;
    @NotNull
    private final Color outerColor;
    @NotNull
    private final Color bindingColor;
    private boolean isValid;

    public Category(@NotNull Book book, @NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.book = book;
        TranslationHolder title = null;
        TranslationHolder desc = null;
        JsonElement icon = (JsonElement)new JsonObject();
        List entries = new ArrayList();
        Color color = this.book.getHighlightColor();
        String sheet = this.book.getTextureSheet();
        Color outerColor = this.book.getBookColor();
        Color bindingColor = this.book.getBindingColor();
        try {
            title = TranslationHolder.Companion.fromJson(json.get("title"));
            desc = TranslationHolder.Companion.fromJson(json.get("description"));
            icon = json.get("icon");
            if (json.has("color")) {
                JsonElement jsonElement = json.get("color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                color = Book.Companion.colorFromJson(jsonElement);
            }
            if (json.has("style")) {
                JsonObject obj = json.getAsJsonObject("style");
                if (obj.has("sheet")) {
                    sheet = obj.getAsJsonPrimitive("sheet").getAsString();
                }
                if (obj.has("color")) {
                    JsonElement jsonElement = obj.get("color");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    outerColor = Book.Companion.colorFromJson(jsonElement);
                }
                if (obj.has("binding")) {
                    JsonElement jsonElement = obj.get("binding");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    bindingColor = Book.Companion.colorFromJson(jsonElement);
                }
            }
            JsonArray allEntries = json.getAsJsonArray("entries");
            Iterator iterator2 = allEntries.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator2, (String)"iterator(...)");
            Iterator iterator3 = iterator2;
            while (iterator3.hasNext()) {
                JsonElement entryJson = (JsonElement)iterator3.next();
                String string = entryJson.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAsString(...)");
                JsonElement parsable = Book.Companion.getJsonFromLink(string);
                String string2 = entryJson.getAsString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
                JsonElement jsonElement = parsable;
                Intrinsics.checkNotNull((Object)jsonElement);
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                Entry entry = new Entry(this.book, sheet, outerColor, bindingColor, string2, jsonObject);
                if (!entry.isValid()) continue;
                entries.add(entry);
            }
            this.isValid = !((Collection)entries).isEmpty();
        }
        catch (Exception exception) {
            LibrarianLog.INSTANCE.error(exception, "Failed trying to parse a category component", new Object[0]);
        }
        this.title = title;
        this.desc = desc;
        this.icon = icon;
        this.entries = entries;
        this.color = color;
        this.sheet = sheet;
        this.outerColor = outerColor;
        this.bindingColor = bindingColor;
    }

    @NotNull
    public final Book getBook() {
        return this.book;
    }

    @NotNull
    public final List<Entry> getEntries() {
        return this.entries;
    }

    @Nullable
    public final TranslationHolder getTitle() {
        return this.title;
    }

    @Nullable
    public final TranslationHolder getDesc() {
        return this.desc;
    }

    @NotNull
    public final JsonElement getIcon() {
        return this.icon;
    }

    @NotNull
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final String getSheet() {
        return this.sheet;
    }

    @NotNull
    public final Color getOuterColor() {
        return this.outerColor;
    }

    @NotNull
    public final Color getBindingColor() {
        return this.bindingColor;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public final boolean isSingleEntry() {
        return this.entries.size() == 1;
    }

    @Override
    @NotNull
    public Book getBookParent() {
        return this.book;
    }

    public final boolean anyUnlocked(@NotNull EntityPlayer player) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            Iterable $this$any$iv = this.entries;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Entry it = (Entry)element$iv;
                    boolean bl2 = false;
                    if (!it.isUnlocked(player)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        List list;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        if (this.isSingleEntry()) {
            list = this.entries.get(0).createComponents(book);
        } else {
            book.updateTextureData(this.sheet, this.outerColor, this.bindingColor);
            int n = ComponentCategoryPage.Companion.numberOfPages(this);
            ArrayList<PaginationContext> arrayList = new ArrayList<PaginationContext>(n);
            int n2 = 0;
            while (n2 < n) {
                void it;
                int n3;
                int n4 = n3 = n2++;
                ArrayList<PaginationContext> arrayList2 = arrayList;
                boolean bl = false;
                arrayList2.add(new PaginationContext((Function0<? extends GuiComponent>)((Function0)() -> Category.createComponents$lambda$2$lambda$1(book, this, (int)it))));
            }
            list = arrayList;
        }
        return list;
    }

    private static final GuiComponent createComponents$lambda$2$lambda$1(IBookGui $book, Category this$0, int $it) {
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return new ComponentCategoryPage($book, this$0, $it);
    }
}

