/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.components.ComponentSprite;
import com.teamwizardry.librarianlib.features.facade.components.ComponentText;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.facade.provided.book.helper.TranslationHolder;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.book.Book;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.criterion.ICriterion;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.criterion.game.EntryUnlockedEvent;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.page.Page;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 72\u00020\u0001:\u00017B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00112\u0006\u00105\u001a\u000206H\u0017R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0018R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010(R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010-\"\u0004\b.\u0010/\u00a8\u00068"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/IBookElement;", "bookParent", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;", "parentSheet", "", "parentOuter", "Ljava/awt/Color;", "parentBinding", "rl", "json", "Lcom/google/gson/JsonObject;", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;Ljava/lang/String;Ljava/awt/Color;Ljava/awt/Color;Ljava/lang/String;Lcom/google/gson/JsonObject;)V", "getBookParent", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/book/Book;", "pages", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/page/Page;", "getPages", "()Ljava/util/List;", "title", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/helper/TranslationHolder;", "getTitle", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/helper/TranslationHolder;", "desc", "getDesc", "icon", "Lcom/google/gson/JsonElement;", "getIcon", "()Lcom/google/gson/JsonElement;", "criterion", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/criterion/ICriterion;", "getCriterion", "()Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/criterion/ICriterion;", "sheet", "getSheet", "()Ljava/lang/String;", "outerColor", "getOuterColor", "()Ljava/awt/Color;", "bindingColor", "getBindingColor", "isValid", "", "()Z", "setValid", "(Z)V", "isUnlocked", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "createComponents", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/context/PaginationContext;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nEntry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Entry.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n*L\n1#1,151:1\n1619#2:152\n1863#2:153\n1864#2:155\n1620#2:156\n1#3:154\n49#4:157\n*S KotlinDebug\n*F\n+ 1 Entry.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry\n*L\n93#1:152\n93#1:153\n93#1:155\n93#1:156\n93#1:154\n120#1:157\n*E\n"})
public final class Entry
implements IBookElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Book bookParent;
    @NotNull
    private final List<Page> pages;
    @Nullable
    private final TranslationHolder title;
    @Nullable
    private final TranslationHolder desc;
    @NotNull
    private final JsonElement icon;
    @Nullable
    private final ICriterion criterion;
    @NotNull
    private final String sheet;
    @NotNull
    private final Color outerColor;
    @NotNull
    private final Color bindingColor;
    private boolean isValid;
    @NotNull
    private static final Map<ResourceLocation, Entry> ENTRIES = new LinkedHashMap();

    public Entry(@NotNull Book bookParent, @NotNull String parentSheet, @NotNull Color parentOuter, @NotNull Color parentBinding, @NotNull String rl, @NotNull JsonObject json) {
        Intrinsics.checkNotNullParameter((Object)bookParent, (String)"bookParent");
        Intrinsics.checkNotNullParameter((Object)parentSheet, (String)"parentSheet");
        Intrinsics.checkNotNullParameter((Object)parentOuter, (String)"parentOuter");
        Intrinsics.checkNotNullParameter((Object)parentBinding, (String)"parentBinding");
        Intrinsics.checkNotNullParameter((Object)rl, (String)"rl");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        this.bookParent = bookParent;
        ENTRIES.put(new ResourceLocation(rl), this);
        List pages = new ArrayList();
        CharSequence charSequence = rl;
        Regex regex = new Regex("^.*/(?=\\w+)");
        String string = "";
        String baseKey = this.getBookParent().getLocation().func_110624_b() + '.' + this.getBookParent().getLocation().func_110623_a() + '.' + regex.replace(charSequence, string);
        TranslationHolder title = new TranslationHolder(baseKey + ".title", null, 2, null);
        TranslationHolder desc = new TranslationHolder(baseKey + ".description", null, 2, null);
        JsonElement icon = (JsonElement)new JsonObject();
        ICriterion criterion = null;
        String sheet = parentSheet;
        Color outerColor = parentOuter;
        Color bindingColor = parentBinding;
        try {
            if (json.has("title")) {
                title = TranslationHolder.Companion.fromJson(json.get("title"));
            }
            if (json.has("description")) {
                desc = TranslationHolder.Companion.fromJson(json.get("description"));
            }
            icon = json.get("icon");
            if (json.has("criteria")) {
                JsonElement jsonElement = json.get("criteria");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                criterion = ICriterion.Companion.fromJson(jsonElement);
            }
            if (json.has("style")) {
                JsonObject obj = json.getAsJsonObject("style");
                if (obj.has("sheet")) {
                    sheet = obj.getAsJsonPrimitive("sheet").getAsString();
                }
                if (obj.has("color")) {
                    JsonElement jsonElement = obj.get("color");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    outerColor = Book.Companion.colorFromJson(jsonElement);
                }
                if (obj.has("binding")) {
                    JsonElement jsonElement = obj.get("binding");
                    Intrinsics.checkNotNullExpressionValue((Object)jsonElement, (String)"get(...)");
                    bindingColor = Book.Companion.colorFromJson(jsonElement);
                }
            }
            this.isValid = true;
        }
        catch (Exception exception) {
            LibrarianLog.INSTANCE.error(exception, "Failed trying to parse an entry component", new Object[0]);
        }
        this.title = title;
        this.desc = desc;
        this.icon = icon;
        this.criterion = criterion;
        this.sheet = sheet;
        this.outerColor = outerColor;
        this.bindingColor = bindingColor;
        if (this.isValid) {
            try {
                this.isValid = false;
                JsonArray allPages = json.getAsJsonArray("content");
                Intrinsics.checkNotNull((Object)allPages);
                Iterable $this$mapNotNullTo$iv = (Iterable)allPages;
                boolean $i$f$mapNotNullTo = false;
                Iterable $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Page it$iv;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator2.next();
                    boolean bl = false;
                    JsonElement it = (JsonElement)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (Page.Companion.fromJson(this, it) == null) continue;
                    boolean bl3 = false;
                    ((Collection)pages).add(it$iv);
                }
                this.isValid = !((Collection)pages).isEmpty();
            }
            catch (Exception exception) {
                LibrarianLog.INSTANCE.error(exception, "Failed trying to parse an entry component", new Object[0]);
            }
        }
        this.pages = pages;
    }

    @Override
    @NotNull
    public Book getBookParent() {
        return this.bookParent;
    }

    @NotNull
    public final List<Page> getPages() {
        return this.pages;
    }

    @Nullable
    public final TranslationHolder getTitle() {
        return this.title;
    }

    @Nullable
    public final TranslationHolder getDesc() {
        return this.desc;
    }

    @NotNull
    public final JsonElement getIcon() {
        return this.icon;
    }

    @Nullable
    public final ICriterion getCriterion() {
        return this.criterion;
    }

    @NotNull
    public final String getSheet() {
        return this.sheet;
    }

    @NotNull
    public final Color getOuterColor() {
        return this.outerColor;
    }

    @NotNull
    public final Color getBindingColor() {
        return this.bindingColor;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final void setValid(boolean bl) {
        this.isValid = bl;
    }

    public final boolean isUnlocked(@NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.criterion == null) {
            return true;
        }
        EntryUnlockedEvent event = new EntryUnlockedEvent(player, this, false, 4, null);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return this.criterion.isUnlocked(player, event.getResult());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        void y$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        book.updateTextureData(this.sheet, this.outerColor, this.bindingColor);
        String title = String.valueOf(this.title);
        int xSize = book.getMainBookComponent().getSize().getXi() - 32;
        int ySize = book.getMainBookComponent().getSize().getYi() - 32;
        int n = xSize;
        int n2 = ySize;
        boolean $i$f$vec = false;
        Vec2d size2 = Vec2d.Companion.getPooled((double)x$iv, (double)y$iv);
        List pageComponents = new ArrayList();
        for (Page page : this.pages) {
            for (Function0<GuiComponent> component : page.createBookComponents(book, size2)) {
                pageComponents.add(new PaginationContext((Function0<? extends GuiComponent>)((Function0)() -> Entry.createComponents$lambda$1(component, book, xSize, title)), page.getExtraBookmarks()));
            }
        }
        return pageComponents;
    }

    private static final GuiComponent createComponents$lambda$1(Function0 $component, IBookGui $book, int $xSize, String $title) {
        Intrinsics.checkNotNullParameter((Object)$component, (String)"$component");
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        Intrinsics.checkNotNullParameter((Object)$title, (String)"$title");
        GuiComponent holderComponent = (GuiComponent)$component.invoke();
        ComponentSprite titleBar = new ComponentSprite($book.getTitleBarSprite(), 16 + $xSize / 2 - $book.getTitleBarSprite().getWidth() / 2, -31, 0, 0, 24, null);
        titleBar.setColor($book.getBook().getBookColor());
        GuiLayer[] guiLayerArray = new GuiLayer[]{titleBar};
        holderComponent.add(guiLayerArray);
        ComponentText titleText = new ComponentText(titleBar.getSize().getXi() / 2 - 12, titleBar.getSize().getYi() / 2 + 1, ComponentText.TextAlignH.CENTER, ComponentText.TextAlignV.MIDDLE);
        titleText.setText($title);
        titleText.setColor($book.getBook().getEntryTitleTextColor());
        GuiLayer[] guiLayerArray2 = new GuiLayer[]{titleText};
        titleBar.add(guiLayerArray2);
        return holderComponent;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry$Companion;", "", "<init>", "()V", "ENTRIES", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/hierarchy/entry/Entry;", "getENTRIES", "()Ljava/util/Map;", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<ResourceLocation, Entry> getENTRIES() {
            return ENTRIES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

