/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.search;

import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.components.ComponentTextField;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.context.ComponentBookMark;
import com.teamwizardry.librarianlib.features.facade.provided.book.search.ISearchAlgorithm;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\u0010\u0006\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u000e\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\tH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ComponentSearchBar;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/context/ComponentBookMark;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "id", "", "onType", "Lkotlin/Function1;", "", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;ILkotlin/jvm/functions/Function1;)V", "textField", "Lcom/teamwizardry/librarianlib/features/facade/components/ComponentTextField;", "slideOutShort", "slideOutLong", "slideIn", "LibrarianLib-Continuous-1.12.2"})
public final class ComponentSearchBar
extends ComponentBookMark {
    @NotNull
    private final ComponentTextField textField;

    public ComponentSearchBar(@NotNull IBookGui book, int id, @Nullable Function1<? super String, Unit> onType) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        super(book, book.getSearchIconSprite(), id, -8, 1);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderer, (String)"fontRenderer");
        this.textField = new ComponentTextField(fontRenderer, 2, 1, this.getSize().getXi() - 44 - 2 * book.getSearchIconSprite().getWidth(), Minecraft.func_71410_x().field_71466_p.field_78288_b + 2);
        this.textField.BUS.hook(ComponentTextField.PostTextEditEvent.class, arg_0 -> ComponentSearchBar._init_$lambda$0(this, onType, arg_0));
        this.textField.BUS.hook(ComponentTextField.FocusEvent.class, arg_0 -> ComponentSearchBar._init_$lambda$1(this, arg_0));
        this.textField.setEnabledColor(book.getBook().getSearchTextColor());
        this.textField.setSelectionColor(book.getBook().getSearchTextHighlight());
        this.textField.setCursorColor(book.getBook().getSearchTextCursor());
        this.textField.setAutoFocus(true);
        GuiLayer[] guiLayerArray = new GuiLayer[]{this.textField};
        this.add(guiLayerArray);
        this.setClipToBounds(true);
        this.BUS.hook(GuiComponentEvents.MouseMoveInEvent.class, arg_0 -> ComponentSearchBar._init_$lambda$2(this, arg_0));
        this.BUS.hook(GuiComponentEvents.MouseMoveOutEvent.class, arg_0 -> ComponentSearchBar._init_$lambda$3(this, arg_0));
        this.BUS.hook(GuiComponentEvents.MouseClickOutsideEvent.class, arg_0 -> ComponentSearchBar._init_$lambda$4(book, this, arg_0));
    }

    @Override
    public void slideOutShort() {
        super.slideOutShort();
        this.textField.setVisible(true);
    }

    @Override
    public void slideOutLong() {
        super.slideOutLong();
        this.textField.setVisible(true);
    }

    @Override
    public void slideIn() {
        super.slideIn();
        this.textField.setVisible(false);
    }

    private static final Unit _init_$lambda$0(ComponentSearchBar this$0, Function1 $onType, ComponentTextField.PostTextEditEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.textField.isFocused() && ((CharSequence)it.getWhole()).length() == 0) {
            this$0.slideOutShort();
        } else if (((CharSequence)it.getWhole()).length() > 0) {
            this$0.slideOutLong();
        } else {
            this$0.slideIn();
        }
        if (this$0.textField.isFocused() && $onType != null) {
            $onType.invoke((Object)it.getWhole());
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ComponentSearchBar this$0, ComponentTextField.FocusEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.getWasFocused()) {
            if (((CharSequence)this$0.textField.getText()).length() == 0) {
                this$0.slideOutShort();
            } else {
                this$0.slideOutLong();
            }
        } else if (it.getWasFocused()) {
            this$0.slideIn();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ComponentSearchBar this$0, GuiComponentEvents.MouseMoveInEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.textField.isFocused()) {
            if (((CharSequence)this$0.textField.getText()).length() == 0) {
                this$0.slideOutShort();
            } else {
                this$0.slideOutLong();
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$3(ComponentSearchBar this$0, GuiComponentEvents.MouseMoveOutEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!this$0.textField.isFocused()) {
            this$0.slideIn();
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$4(IBookGui $book, ComponentSearchBar this$0, GuiComponentEvents.MouseClickOutsideEvent it) {
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if ($book.getContext().getBookElement() instanceof ISearchAlgorithm.ResultAcceptor) {
            GuiComponent focus = $book.getFocus();
            if (focus == null || !focus.getMouseOver()) {
                $book.up();
                this$0.textField.setText("");
                this$0.textField.requestBlur();
            }
        } else {
            this$0.textField.setText("");
            this$0.textField.requestBlur();
        }
        return Unit.INSTANCE;
    }
}

