/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.search;

import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.components.ComponentText;
import com.teamwizardry.librarianlib.features.facade.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.facade.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.facade.provided.book.search.ISearchAlgorithm;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ComponentSearchResults;", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "book", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;", "results", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "index", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/provided/book/IBookGui;Ljava/util/List;I)V", "margin", "pageHeader", "Lcom/teamwizardry/librarianlib/features/facade/components/ComponentText;", "resultSection", "Companion", "LibrarianLib-Continuous-1.12.2"})
public final class ComponentSearchResults
extends GuiComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int margin;
    @NotNull
    private final ComponentText pageHeader;
    @NotNull
    private GuiComponent resultSection;

    /*
     * WARNING - void declaration
     */
    public ComponentSearchResults(@NotNull IBookGui book, @Nullable List<? extends ISearchAlgorithm.Result> results, int index) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        super(16, 16, book.getMainBookComponent().getSize().getXi() - 32, book.getMainBookComponent().getSize().getYi() - 32);
        this.margin = 16;
        this.pageHeader = new ComponentText(0, 0, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
        this.resultSection = new GuiComponent(0, this.margin, this.getSize().getXi(), this.getSize().getYi() - this.margin);
        this.pageHeader.setText(I18n.func_135052_a((String)"librarianlib.book.results.notfound", (Object[])new Object[0]));
        this.pageHeader.setUnicode(true);
        this.pageHeader.setWrap(this.getSize().getXi());
        GuiLayer[] guiLayerArray = new GuiLayer[]{this.pageHeader};
        this.add(guiLayerArray);
        guiLayerArray = new GuiLayer[]{this.resultSection};
        this.add(guiLayerArray);
        if (results != null && !((Collection)results).isEmpty()) {
            Object[] objectArray;
            ISearchAlgorithm.Result forTyping = results.get(0);
            if (forTyping.isSpecificResult()) {
                String string;
                if (results.size() == 1) {
                    string = I18n.func_135052_a((String)"librarianlib.book.results.oneresult", (Object[])new Object[0]);
                } else {
                    objectArray = new Object[]{results.size()};
                    string = I18n.func_135052_a((String)"librarianlib.book.results.nresults", (Object[])objectArray);
                }
                this.pageHeader.setText(string);
            } else {
                objectArray = new Object[]{results.size()};
                this.pageHeader.setText(I18n.func_135052_a((String)"librarianlib.book.results.toobroad", (Object[])objectArray));
            }
            GuiComponent pageComponent = new GuiComponent(0, 0, this.getSize().getXi(), this.getSize().getYi());
            GuiLayer[] guiLayerArray2 = new GuiLayer[]{pageComponent};
            this.resultSection.add(guiLayerArray2);
            double largestFrequency = 0.0;
            double smallestFrequency = 2.147483647E9;
            for (ISearchAlgorithm.Result result : results) {
                if (result.getFrequency() > largestFrequency) {
                    largestFrequency = result.getFrequency();
                }
                if (!(result.getFrequency() < smallestFrequency)) continue;
                smallestFrequency = result.getFrequency();
            }
            int itemsPerPage = 8;
            int n = -itemsPerPage * index;
            for (ISearchAlgorithm.Result result : results) {
                Object[] objectArray2;
                void var11_13;
                if (var11_13 < 0) {
                    ++var11_13;
                    continue;
                }
                double matchPercentage = Math.round(result.getFrequency() * 100.0);
                if (matchPercentage <= 0.0) continue;
                Entry resultEntry = result.getEntry();
                ComponentText textComponent = new ComponentText(25, Minecraft.func_71410_x().field_71466_p.field_78288_b + 2, ComponentText.TextAlignH.LEFT, ComponentText.TextAlignV.TOP);
                GuiComponent indexButton = book.makeNavigationButton((int)var11_13, resultEntry, (Function1<? super GuiComponent, Unit>)((Function1)arg_0 -> ComponentSearchResults._init_$lambda$0(textComponent, arg_0)));
                GuiLayer[] guiLayerArray3 = new GuiLayer[]{indexButton};
                pageComponent.add(guiLayerArray3);
                TextFormatting color = null;
                String exactResult = null;
                String simplifiedResult = null;
                if (forTyping.isSpecificResult()) {
                    color = matchPercentage <= 25.0 ? TextFormatting.DARK_RED : (matchPercentage <= 50.0 ? TextFormatting.YELLOW : (matchPercentage <= 75.0 ? TextFormatting.GREEN : TextFormatting.DARK_GREEN));
                    objectArray2 = new Object[]{matchPercentage};
                    exactResult = I18n.func_135052_a((String)"librarianlib.book.results.match", (Object[])objectArray2);
                    objectArray2 = new Object[]{Math.round(matchPercentage)};
                    simplifiedResult = I18n.func_135052_a((String)"librarianlib.book.results.match", (Object[])objectArray2);
                } else {
                    String string;
                    color = TextFormatting.RESET;
                    if (result.getFrequency() == 1.0) {
                        string = I18n.func_135052_a((String)"librarianlib.book.results.kwd", (Object[])new Object[0]);
                    } else {
                        objectArray2 = new Object[]{(int)result.getFrequency()};
                        string = I18n.func_135052_a((String)"librarianlib.book.results.kwds", (Object[])objectArray2);
                    }
                    exactResult = simplifiedResult = string;
                }
                textComponent.setUnicode(true);
                textComponent.setText("| " + color + simplifiedResult);
                indexButton.BUS.hook(GuiComponentEvents.MouseMoveInEvent.class, arg_0 -> ComponentSearchResults._init_$lambda$1(textComponent, color, exactResult, arg_0));
                indexButton.BUS.hook(GuiComponentEvents.MouseMoveOutEvent.class, arg_0 -> ComponentSearchResults._init_$lambda$2(textComponent, color, simplifiedResult, arg_0));
                if (++var11_13 < itemsPerPage) continue;
                break;
            }
        }
    }

    private static final Unit _init_$lambda$0(ComponentText $textComponent, GuiComponent it) {
        Intrinsics.checkNotNullParameter((Object)$textComponent, (String)"$textComponent");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        GuiLayer[] guiLayerArray = new GuiLayer[]{$textComponent};
        it.add(guiLayerArray);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ComponentText $textComponent, TextFormatting $color, String $exactResult, GuiComponentEvents.MouseMoveInEvent it) {
        Intrinsics.checkNotNullParameter((Object)$textComponent, (String)"$textComponent");
        Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
        Intrinsics.checkNotNullParameter((Object)$exactResult, (String)"$exactResult");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $textComponent.setText("  | " + $color + TextFormatting.ITALIC + $exactResult);
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ComponentText $textComponent, TextFormatting $color, String $simplifiedResult, GuiComponentEvents.MouseMoveOutEvent it) {
        Intrinsics.checkNotNullParameter((Object)$textComponent, (String)"$textComponent");
        Intrinsics.checkNotNullParameter((Object)$color, (String)"$color");
        Intrinsics.checkNotNullParameter((Object)$simplifiedResult, (String)"$simplifiedResult");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $textComponent.setText("| " + $color + $simplifiedResult);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ComponentSearchResults$Companion;", "", "<init>", "()V", "numberOfPages", "", "results", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/search/ISearchAlgorithm$Result;", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public final int numberOfPages(@Nullable List<? extends ISearchAlgorithm.Result> results) {
            if (results == null || results.isEmpty()) {
                return 1;
            }
            return (int)Math.ceil((double)results.size() / 8.0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

