/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.book.structure;

import com.teamwizardry.librarianlib.features.facade.provided.book.structure.RenderableStructure;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\nJ\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\nJ\u0016\u0010\u0012\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00132\u0006\u0010\u0010\u001a\u00020\nR\u001c\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/book/structure/StructureCacheRegistry;", "", "<init>", "()V", "structures", "", "Lnet/minecraft/util/ResourceLocation;", "Lcom/teamwizardry/librarianlib/features/facade/provided/book/structure/RenderableStructure;", "toLoad", "", "", "hasPassedInit", "", "passInit", "", "addStructure", "name", "getStructureOrAdd", "getPromise", "Lkotlin/Function0;", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nStructureCacheRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StructureCacheRegistry.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/structure/StructureCacheRegistry\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,51:1\n381#2,7:52\n*S KotlinDebug\n*F\n+ 1 StructureCacheRegistry.kt\ncom/teamwizardry/librarianlib/features/facade/provided/book/structure/StructureCacheRegistry\n*L\n39#1:52,7\n*E\n"})
public final class StructureCacheRegistry {
    @NotNull
    public static final StructureCacheRegistry INSTANCE = new StructureCacheRegistry();
    @NotNull
    private static final Map<ResourceLocation, RenderableStructure> structures = new LinkedHashMap();
    @NotNull
    private static List<String> toLoad = new ArrayList();
    private static boolean hasPassedInit;

    private StructureCacheRegistry() {
    }

    public final void passInit() {
        if (hasPassedInit) {
            return;
        }
        hasPassedInit = true;
        for (String structure : toLoad) {
            this.addStructure(structure);
        }
        toLoad.clear();
        ClientRunnable.registerReloadHandler(StructureCacheRegistry::passInit$lambda$0);
    }

    @Nullable
    public final RenderableStructure addStructure(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        RenderableStructure structure = new RenderableStructure(new ResourceLocation(name), null);
        if (structure.blockInfos().isEmpty()) {
            return null;
        }
        structures.put(structure.getName(), structure);
        return structure;
    }

    @Nullable
    public final RenderableStructure getStructureOrAdd(@NotNull String name) {
        RenderableStructure renderableStructure;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        ResourceLocation trueName = new ResourceLocation(name);
        Map<ResourceLocation, RenderableStructure> $this$getOrPut$iv = structures;
        boolean $i$f$getOrPut = false;
        RenderableStructure value$iv = $this$getOrPut$iv.get(trueName);
        if (value$iv == null) {
            boolean bl = false;
            RenderableStructure answer$iv = INSTANCE.addStructure(name);
            $this$getOrPut$iv.put(trueName, answer$iv);
            renderableStructure = answer$iv;
        } else {
            renderableStructure = value$iv;
        }
        return renderableStructure;
    }

    @NotNull
    public final Function0<RenderableStructure> getPromise(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (hasPassedInit) {
            RenderableStructure structure = this.getStructureOrAdd(name);
            return () -> StructureCacheRegistry.getPromise$lambda$2(structure);
        }
        toLoad.add(name);
        return () -> StructureCacheRegistry.getPromise$lambda$3(name);
    }

    private static final void passInit$lambda$0() {
        for (ResourceLocation key : structures.keySet()) {
            String string = key.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            INSTANCE.addStructure(string);
        }
    }

    private static final RenderableStructure getPromise$lambda$2(RenderableStructure $structure) {
        return $structure;
    }

    private static final RenderableStructure getPromise$lambda$3(String $name) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        return INSTANCE.getStructureOrAdd($name);
    }
}

