/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.filter;

import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.shader.Shader;
import com.teamwizardry.librarianlib.features.shader.ShaderHelper;
import com.teamwizardry.librarianlib.features.shader.uniforms.BoolTypes;
import com.teamwizardry.librarianlib.features.shader.uniforms.FloatTypes;
import com.teamwizardry.librarianlib.features.shader.uniforms.IntTypes;
import com.teamwizardry.librarianlib.features.shader.uniforms.Uniform;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL20;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0005J\u0010\u0010!\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/filter/GaussianBlurShader;", "Lcom/teamwizardry/librarianlib/features/shader/Shader;", "<init>", "()V", "kernelTexture", "", "kernelArray", "", "sigma", "getSigma", "()I", "setSigma", "(I)V", "horizontal", "", "getHorizontal", "()Z", "setHorizontal", "(Z)V", "displaySize", "Lcom/teamwizardry/librarianlib/features/shader/uniforms/FloatTypes$FloatVec2Uniform;", "sigmaUniform", "Lcom/teamwizardry/librarianlib/features/shader/uniforms/IntTypes$IntUniform;", "horizontalUniform", "Lcom/teamwizardry/librarianlib/features/shader/uniforms/BoolTypes$BoolUniform;", "image", "Lcom/teamwizardry/librarianlib/features/shader/uniforms/Uniform;", "kernel", "initUniforms", "", "uniformDefaults", "bindTexture", "texture", "generateGaussianKernel", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nGaussianBlurShader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GaussianBlurShader.kt\ncom/teamwizardry/librarianlib/features/facade/provided/filter/GaussianBlurShader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,120:1\n13471#2,3:121\n*S KotlinDebug\n*F\n+ 1 GaussianBlurShader.kt\ncom/teamwizardry/librarianlib/features/facade/provided/filter/GaussianBlurShader\n*L\n32#1:121,3\n*E\n"})
public final class GaussianBlurShader
extends Shader {
    @NotNull
    public static final GaussianBlurShader INSTANCE = new GaussianBlurShader();
    private static final int kernelTexture = GL11.glGenTextures();
    @NotNull
    private static final double[] kernelArray = INSTANCE.generateGaussianKernel(64);
    private static int sigma;
    private static boolean horizontal;
    @Nullable
    private static FloatTypes.FloatVec2Uniform displaySize;
    @Nullable
    private static IntTypes.IntUniform sigmaUniform;
    @Nullable
    private static BoolTypes.BoolUniform horizontalUniform;
    @Nullable
    private static Uniform image;
    @Nullable
    private static Uniform kernel;

    private GaussianBlurShader() {
        super(null, new ResourceLocation("librarianlib:shaders/gaussian_blur.frag"));
    }

    public final int getSigma() {
        return sigma;
    }

    public final void setSigma(int n) {
        sigma = n;
    }

    public final boolean getHorizontal() {
        return horizontal;
    }

    public final void setHorizontal(boolean bl) {
        horizontal = bl;
    }

    @Override
    public void initUniforms() {
        super.initUniforms();
        displaySize = (FloatTypes.FloatVec2Uniform)this.getUniform("displaySize");
        sigmaUniform = (IntTypes.IntUniform)this.getUniform("sigma");
        horizontalUniform = (BoolTypes.BoolUniform)this.getUniform("horizontal");
        image = this.getUniform("image");
        kernel = this.getUniform("kernel");
    }

    @Override
    public void uniformDefaults() {
        block2: {
            super.uniformDefaults();
            FloatTypes.FloatVec2Uniform floatVec2Uniform = displaySize;
            if (floatVec2Uniform != null) {
                floatVec2Uniform.set(Client.INSTANCE.getMinecraft().field_71443_c, Client.INSTANCE.getMinecraft().field_71440_d);
            }
            IntTypes.IntUniform intUniform = sigmaUniform;
            if (intUniform != null) {
                intUniform.set(sigma);
            }
            BoolTypes.BoolUniform boolUniform = horizontalUniform;
            if (boolUniform == null) break block2;
            boolUniform.set(horizontal);
        }
    }

    public final void bindTexture(int texture) {
        Uniform uniform;
        GL11.glEnable((int)3552);
        GlStateManager.func_179138_g((int)33986);
        GlStateManager.func_179144_i((int)texture);
        GlStateManager.func_179138_g((int)33987);
        GL11.glBindTexture((int)3552, (int)kernelTexture);
        Uniform uniform2 = image;
        if (uniform2 != null) {
            Uniform image = uniform = uniform2;
            boolean bl = false;
            GL20.glUniform1i((int)image.getLocation(), (int)2);
        }
        Uniform uniform3 = kernel;
        if (uniform3 != null) {
            Uniform kernel = uniform = uniform3;
            boolean bl = false;
            GL20.glUniform1i((int)kernel.getLocation(), (int)3);
        }
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    private final double[] generateGaussianKernel(int sigma) {
        double[] kernel = new double[2 * sigma + 2];
        double sum = 0.0;
        if (sigma == 0) {
            kernel[0] = 1.0;
        } else {
            int i;
            int n = kernel.length;
            for (i = 0; i < n; ++i) {
                double result;
                kernel[i] = result = Math.exp((double)(-(i * i)) / (double)(2 * sigma * sigma));
                sum += result;
                if (i == 0) continue;
                sum += result;
            }
            i = 0;
            n = kernel.length;
            while (i < n) {
                int n2 = i++;
                kernel[n2] = kernel[n2] / sum;
            }
        }
        return kernel;
    }

    /*
     * WARNING - void declaration
     */
    static {
        GL11.glEnable((int)3552);
        GL11.glBindTexture((int)3552, (int)kernelTexture);
        FloatBuffer buffer = ByteBuffer.allocateDirect(kernelArray.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        double[] $this$forEachIndexed$iv = kernelArray;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (double item$iv : $this$forEachIndexed$iv) {
            void it;
            int n = index$iv++;
            double d = item$iv;
            int i = n;
            boolean bl = false;
            buffer.put(i, (float)it);
        }
        GL11.glTexParameteri((int)3552, (int)10240, (int)9729);
        GL11.glTexParameteri((int)3552, (int)10241, (int)9729);
        GL11.glTexImage1D((int)3552, (int)0, (int)6403, (int)kernelArray.length, (int)0, (int)6403, (int)5126, (FloatBuffer)buffer);
        GL11.glDisable((int)3552);
        horizontal = true;
        ShaderHelper.INSTANCE.addShader((Shader)INSTANCE);
    }
}

