/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.provided.pastry.components.dropdown;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.eventbus.Hook;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponent;
import com.teamwizardry.librarianlib.features.facade.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayer;
import com.teamwizardry.librarianlib.features.facade.component.GuiLayerEvents;
import com.teamwizardry.librarianlib.features.facade.components.RootComponent;
import com.teamwizardry.librarianlib.features.facade.layers.SpriteLayer;
import com.teamwizardry.librarianlib.features.facade.layout.StackComponent;
import com.teamwizardry.librarianlib.features.facade.layout.StackLayout;
import com.teamwizardry.librarianlib.features.facade.provided.pastry.PastryTexture;
import com.teamwizardry.librarianlib.features.facade.provided.pastry.components.dropdown.DropdownStackItem;
import com.teamwizardry.librarianlib.features.facade.provided.pastry.components.dropdown.PastryDropdown;
import com.teamwizardry.librarianlib.features.facade.provided.pastry.components.dropdown.PastryDropdownItem;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import com.teamwizardry.librarianlib.features.facade.value.IMValue;
import com.teamwizardry.librarianlib.features.kotlin.ExtCollectionsKt;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.math.coordinatespaces.ScreenSpace;
import java.awt.Color;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u00104\u001a\u000205H\u0016J\u0014\u00106\u001a\u0002052\f\u00107\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019J\u0010\u00108\u001a\u0002052\u0006\u00109\u001a\u00020:H\u0007J\u0010\u0010;\u001a\u0002052\u0006\u00109\u001a\u00020<H\u0007J\u0010\u0010=\u001a\u0002052\u0006\u00109\u001a\u00020>H\u0007J\u0006\u0010?\u001a\u000205J\u0006\u0010@\u001a\u000205R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R#\u0010\u0017\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0019\u0012\u0004\u0012\u00020\u001a0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001fR\u0014\u0010\"\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u001a\u0010'\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\f\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\f\"\u0004\b3\u0010*\u00a8\u0006A"}, d2={"Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/DropdownMenu;", "T", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "button", "Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/PastryDropdown;", "mouseActivated", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/PastryDropdown;Z)V", "getButton", "()Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/PastryDropdown;", "getMouseActivated", "()Z", "creationTime", "", "background", "Lcom/teamwizardry/librarianlib/features/facade/layers/SpriteLayer;", "getBackground", "()Lcom/teamwizardry/librarianlib/features/facade/layers/SpriteLayer;", "stack", "Lcom/teamwizardry/librarianlib/features/facade/layout/StackComponent;", "getStack", "()Lcom/teamwizardry/librarianlib/features/facade/layout/StackComponent;", "items", "", "Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/PastryDropdownItem;", "Lcom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/DropdownStackItem;", "getItems", "()Ljava/util/Map;", "contents", "getContents", "()Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponent;", "contentsClip", "getContentsClip", "dragSelectTime", "getDragSelectTime", "()I", "dragSelectDist", "getDragSelectDist", "mouseClickStarted", "getMouseClickStarted", "setMouseClickStarted", "(Z)V", "initialMousePos", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getInitialMousePos", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "setInitialMousePos", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "disableLayout", "getDisableLayout", "setDisableLayout", "layoutChildren", "", "scrollTo", "item", "preFrame", "e", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiLayerEvents$PreFrameEvent;", "mouseDown", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponentEvents$MouseDownEvent;", "mouseUp", "Lcom/teamwizardry/librarianlib/features/facade/component/GuiComponentEvents$MouseUpEvent;", "select", "close", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nDropdownMenu.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropdownMenu.kt\ncom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/DropdownMenu\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n+ 4 RectHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/RectHelpersKt\n*L\n1#1,227:1\n1863#2,2:228\n1863#2,2:230\n1755#2,3:242\n295#2,2:245\n360#2,7:247\n1863#2,2:254\n49#3:232\n49#3:233\n49#3:234\n49#3:235\n49#3:236\n49#3:239\n49#3:240\n49#3:241\n49#3:256\n49#3:257\n49#3:258\n49#3:259\n49#3:260\n49#3:261\n8#4:237\n8#4:238\n*S KotlinDebug\n*F\n+ 1 DropdownMenu.kt\ncom/teamwizardry/librarianlib/features/facade/provided/pastry/components/dropdown/DropdownMenu\n*L\n45#1:228,2\n59#1:230,2\n128#1:242,3\n144#1:245,2\n145#1:247,7\n153#1:254,2\n61#1:232\n69#1:233\n70#1:234\n72#1:235\n73#1:236\n79#1:239\n85#1:240\n92#1:241\n163#1:256\n164#1:257\n165#1:258\n171#1:259\n174#1:260\n175#1:261\n76#1:237\n78#1:238\n*E\n"})
public final class DropdownMenu<T>
extends GuiComponent {
    @NotNull
    private final PastryDropdown<T> button;
    private final boolean mouseActivated;
    private final int creationTime;
    @NotNull
    private final SpriteLayer background;
    @NotNull
    private final StackComponent stack;
    @NotNull
    private final Map<PastryDropdownItem<T>, DropdownStackItem> items;
    @NotNull
    private final GuiComponent contents;
    @NotNull
    private final GuiComponent contentsClip;
    private final int dragSelectTime;
    private final int dragSelectDist;
    private boolean mouseClickStarted;
    public Vec2d initialMousePos;
    private boolean disableLayout;

    public DropdownMenu(@NotNull PastryDropdown<T> button, boolean mouseActivated) {
        Intrinsics.checkNotNullParameter(button, (String)"button");
        super(0, 0);
        this.button = button;
        this.mouseActivated = mouseActivated;
        this.creationTime = ClientTickHandler.getTicks();
        this.background = new SpriteLayer(PastryTexture.INSTANCE.getDropdownBackground());
        this.stack = StackLayout.Companion.build(0, 0).spacing(1).component();
        this.items = ExtCollectionsKt.identityMapOf();
        this.contents = new GuiComponent(-2, 0);
        this.contentsClip = new GuiComponent(0, 0);
        this.dragSelectTime = 10;
        this.dragSelectDist = 10;
        this.setZIndex(GuiLayer.Companion.getOVERLAY_Z());
        GuiLayer[] guiLayerArray = new GuiLayer[]{this.background, this.contents};
        this.add(guiLayerArray);
        guiLayerArray = new GuiLayer[]{this.contentsClip};
        this.contents.add(guiLayerArray);
        guiLayerArray = new GuiLayer[]{this.stack};
        this.contentsClip.add(guiLayerArray);
        this.contentsClip.setClipToBounds(true);
        Iterable $this$forEach$iv = this.button.getItems();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PastryDropdownItem item = (PastryDropdownItem)element$iv;
            boolean bl = false;
            DropdownStackItem stackItem = new DropdownStackItem(item);
            this.items.put(item, stackItem);
            GuiLayer[] guiLayerArray2 = new GuiLayer[]{stackItem};
            this.stack.componentWrapper().add(guiLayerArray2);
        }
        this.stack.fitToLength();
    }

    @NotNull
    public final PastryDropdown<T> getButton() {
        return this.button;
    }

    public final boolean getMouseActivated() {
        return this.mouseActivated;
    }

    @NotNull
    public final SpriteLayer getBackground() {
        return this.background;
    }

    @NotNull
    public final StackComponent getStack() {
        return this.stack;
    }

    @NotNull
    public final Map<PastryDropdownItem<T>, DropdownStackItem> getItems() {
        return this.items;
    }

    @NotNull
    public final GuiComponent getContents() {
        return this.contents;
    }

    @NotNull
    public final GuiComponent getContentsClip() {
        return this.contentsClip;
    }

    public final int getDragSelectTime() {
        return this.dragSelectTime;
    }

    public final int getDragSelectDist() {
        return this.dragSelectDist;
    }

    public final boolean getMouseClickStarted() {
        return this.mouseClickStarted;
    }

    public final void setMouseClickStarted(boolean bl) {
        this.mouseClickStarted = bl;
    }

    @NotNull
    public final Vec2d getInitialMousePos() {
        Vec2d vec2d = this.initialMousePos;
        if (vec2d != null) {
            return vec2d;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"initialMousePos");
        return null;
    }

    public final void setInitialMousePos(@NotNull Vec2d vec2d) {
        Intrinsics.checkNotNullParameter((Object)vec2d, (String)"<set-?>");
        this.initialMousePos = vec2d;
    }

    public final boolean getDisableLayout() {
        return this.disableLayout;
    }

    public final void setDisableLayout(boolean bl) {
        this.disableLayout = bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layoutChildren() {
        void width$iv;
        double y$iv;
        boolean x$iv;
        void width$iv22;
        boolean x$iv2;
        void x$iv3;
        super.layoutChildren();
        if (this.disableLayout) {
            return;
        }
        this.setSize(this.button.getSize());
        Iterable $this$forEach$iv22 = this.items.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv22) {
            DropdownStackItem it = (DropdownStackItem)element$iv;
            boolean bl = false;
            it.setWidth(this.button.getWidth());
        }
        double $this$forEach$iv22 = this.button.getWidth();
        double y$iv2 = Math.max(this.button.getHeight(), this.stack.getHeight() + (double)4);
        boolean $i$f$vec = false;
        this.contents.setSize(Vec2d.Companion.getPooled((double)x$iv3, y$iv2));
        Rect2d contentsFrame = this.contents.getFrame();
        double top = contentsFrame.getMinY();
        double bottom = contentsFrame.getMaxY();
        double rootMinLimit = this.getRoot().getBounds().getMinY() + (double)10;
        double rootMaxLimit = this.getRoot().getBounds().getMaxY() - (double)10;
        boolean bl = false;
        double y$iv3 = top;
        boolean $i$f$vec2 = false;
        if (this.convertPointTo(Vec2d.Companion.getPooled((double)x$iv2, y$iv3), this.getRoot()).getY() < rootMinLimit) {
            x$iv2 = false;
            y$iv3 = rootMinLimit;
            $i$f$vec2 = false;
            top = this.getRoot().convertPointTo(Vec2d.Companion.getPooled((double)x$iv2, y$iv3), this).getY();
        }
        x$iv2 = false;
        y$iv3 = bottom;
        $i$f$vec2 = false;
        if (this.convertPointTo(Vec2d.Companion.getPooled((double)x$iv2, y$iv3), this.getRoot()).getY() > rootMaxLimit) {
            x$iv2 = false;
            y$iv3 = rootMaxLimit;
            $i$f$vec2 = false;
            bottom = this.getRoot().convertPointTo(Vec2d.Companion.getPooled((double)x$iv2, y$iv3), this).getY();
        }
        double x$iv22 = contentsFrame.getMinX();
        y$iv3 = top;
        double $i$f$vec22 = contentsFrame.getWidth();
        double height$iv = bottom - top;
        boolean $i$f$rect22 = false;
        this.background.setFrame(new Rect2d(x$iv22, y$iv3, (double)width$iv22, height$iv));
        double clipY = top - contentsFrame.getMinY();
        boolean width$iv22 = false;
        height$iv = clipY + (double)2;
        double $i$f$rect22 = contentsFrame.getWidth();
        double height$iv2 = bottom - top - (double)4;
        boolean $i$f$rect = false;
        this.contentsClip.setFrame(new Rect2d((double)x$iv, y$iv, (double)width$iv, height$iv2));
        x$iv = false;
        y$iv = -clipY;
        boolean $i$f$vec3 = false;
        this.contentsClip.setContentsOffset(Vec2d.Companion.getPooled((double)x$iv, y$iv));
    }

    /*
     * WARNING - void declaration
     */
    public final void scrollTo(@NotNull PastryDropdownItem<T> item) {
        void x$iv;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        this.runLayoutIfNeeded();
        DropdownStackItem dropdownStackItem = this.items.get(item);
        if (dropdownStackItem == null) {
            return;
        }
        DropdownStackItem stackItem = dropdownStackItem;
        boolean bl = false;
        boolean y$iv = false;
        boolean $i$f$vec = false;
        double itemPos = stackItem.getItemLayer().convertPointTo(Vec2d.Companion.getPooled((double)x$iv, (double)y$iv), this).getY();
        GuiComponent guiComponent = this.contents;
        guiComponent.setYi(guiComponent.getYi() - ((int)itemPos - 2));
    }

    /*
     * WARNING - void declaration
     */
    @Hook
    public final void preFrame(@NotNull GuiLayerEvents.PreFrameEvent e) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GuiLayer guiLayer = this.getParent();
        if (guiLayer == null) {
            return;
        }
        GuiLayer parent2 = guiLayer;
        boolean bl = false;
        boolean y$iv = false;
        boolean $i$f$vec = false;
        Vec2d min = this.button.convertPointTo(Vec2d.Companion.getPooled((double)x$iv, (double)y$iv), parent2);
        this.setPos(min);
        if (this.stack.getFrame().getMinY() < this.contentsClip.getBounds().getMinY() && this.getMouseHit() != null && !this.disableLayout) {
            double y = this.contentsClip.getMousePos().getY() - this.contentsClip.getBounds().getMinY();
            if (y <= 4.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() + 5);
            } else if (y <= 8.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() + 3);
            } else if (y <= 16.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() + 1);
            }
        }
        if (this.stack.getFrame().getMaxY() > this.contentsClip.getBounds().getMaxY() && this.getMouseHit() != null && !this.disableLayout) {
            double y = this.contentsClip.getBounds().getMaxY() - this.contentsClip.getMousePos().getY();
            if (y <= 4.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() - 5);
            } else if (y <= 8.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() - 3);
            } else if (y <= 16.0) {
                GuiComponent guiComponent = this.contents;
                guiComponent.setYi(guiComponent.getYi() - 1);
            }
        }
    }

    @Hook
    public final void mouseDown(@NotNull GuiComponentEvents.MouseDownEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.getMouseOver()) {
            this.close();
            return;
        }
        this.mouseClickStarted = true;
    }

    @Hook
    public final void mouseUp(@NotNull GuiComponentEvents.MouseUpEvent e) {
        block12: {
            Object newMousePos;
            block14: {
                Object object;
                block13: {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!this.getMouseOver()) {
                        this.close();
                        return;
                    }
                    if (this.mouseClickStarted) {
                        boolean bl;
                        block11: {
                            Iterable $this$any$iv = this.items.values();
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (Object element$iv : $this$any$iv) {
                                    DropdownStackItem it = (DropdownStackItem)element$iv;
                                    boolean bl2 = false;
                                    if (!it.getMouseOver()) continue;
                                    bl = true;
                                    break block11;
                                }
                                bl = false;
                            }
                        }
                        if (bl) {
                            this.select();
                        }
                        return;
                    }
                    if (!this.mouseActivated) break block12;
                    object = this.getGui();
                    if (object == null) break block13;
                    RootComponent gui = object;
                    boolean bl = false;
                    Vec2d vec2d = gui.convertPointTo(gui.getMousePos(), ScreenSpace.INSTANCE);
                    object = vec2d;
                    if (vec2d != null) break block14;
                }
                object = newMousePos = this.getInitialMousePos();
            }
            if (ClientTickHandler.getTicks() - this.creationTime > this.dragSelectTime || this.getInitialMousePos().squareDist((Vec2d)newMousePos) > (double)(this.dragSelectDist * this.dragSelectDist)) {
                this.select();
            }
        }
    }

    public final void select() {
        boolean x$iv;
        int index;
        DropdownStackItem selected;
        block7: {
            int n;
            Object v0;
            block6: {
                Iterable $this$firstOrNull$iv = this.items.values();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    DropdownStackItem it = (DropdownStackItem)element$iv;
                    boolean bl = false;
                    if (!it.getMouseOver()) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            selected = v0;
            List<PastryDropdownItem<T>> $this$indexOfFirst$iv = this.button.getItems();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object e : $this$indexOfFirst$iv) {
                PastryDropdownItem it = (PastryDropdownItem)e;
                boolean bl = false;
                DropdownStackItem dropdownStackItem = selected;
                if (it == (dropdownStackItem != null ? dropdownStackItem.getItem() : null)) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (selected == null || selected.getItem().getDecoration() || index < 0) {
            this.close();
            return;
        }
        this.button.selectIndex(index);
        GuiLayer guiLayer = this.button.getButtonContents$LibrarianLib_Continuous_1_12_2();
        if (guiLayer != null) {
            guiLayer.setVisible(false);
        }
        Object $this$forEach$iv = this.items.values();
        boolean $i$f$forEach = false;
        Iterator index$iv = $this$forEach$iv.iterator();
        while (index$iv.hasNext()) {
            Object element$iv = index$iv.next();
            DropdownStackItem dropdownStackItem = (DropdownStackItem)element$iv;
            boolean bl = false;
            dropdownStackItem.setVisible(false);
        }
        selected.setVisible(true);
        selected.getHighlight().setVisible(false);
        this.contentsClip.setClipToBounds(false);
        this.runLayoutIfNeeded();
        this.disableLayout = true;
        $this$forEach$iv = this.contents;
        $i$f$forEach = false;
        int y$iv = 2;
        boolean $i$f$vec = false;
        ((GuiLayer)$this$forEach$iv).setPos(((GuiLayer)$this$forEach$iv).getPos().plus(Vec2d.Companion.getPooled((double)x$iv, y$iv)));
        $this$forEach$iv = this.stack;
        x$iv = false;
        y$iv = 2;
        $i$f$vec = false;
        ((GuiLayer)$this$forEach$iv).setPos(((GuiLayer)$this$forEach$iv).getPos().minus(Vec2d.Companion.getPooled((double)x$iv, y$iv)));
        $this$forEach$iv = this.contents;
        x$iv = false;
        y$iv = 4;
        $i$f$vec = false;
        ((GuiLayer)$this$forEach$iv).setSize(((GuiLayer)$this$forEach$iv).getSize().minus(Vec2d.Companion.getPooled((double)x$iv, y$iv)));
        float collapseTime = 11.0f;
        Easing.BezierEasing easing = Easing.easeOutQuint;
        float fadeTime = 2.0f;
        Animation<?> anim = GuiAnimator.Companion.animate(collapseTime, (Easing)easing, (Function0<Unit>)((Function0)() -> DropdownMenu.select$lambda$7(this, selected)));
        Animation<IMValue<Color>> animation = this.background.getTint_im().animate(new Color(1.0f, 1.0f, 1.0f, 0.0f), fadeTime, easing, collapseTime);
        animation.setCompletion(() -> DropdownMenu.select$lambda$8(this));
        Animation[] animationArray = new Animation[]{anim};
        Animator.global.add(animationArray);
    }

    public final void close() {
        GuiLayer guiLayer = this.getParent();
        if (guiLayer != null) {
            guiLayer.remove(this);
        }
        this.button.menuClosed$LibrarianLib_Continuous_1_12_2();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit select$lambda$7(DropdownMenu this$0, DropdownStackItem $selected) {
        void x$iv;
        void x$iv2;
        void x$iv3;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean bl = false;
        boolean y$iv = false;
        boolean $i$f$vec = false;
        this$0.background.setPos(Vec2d.Companion.getPooled((double)x$iv3, (double)y$iv));
        this$0.background.setSize(this$0.button.getSize());
        y$iv = false;
        int y$iv2 = 0;
        boolean $i$f$vec2 = false;
        Vec2d itemLayerPos = $selected.getItemLayer().convertPointTo(Vec2d.Companion.getPooled((double)x$iv2, y$iv2), this$0);
        StackComponent stackComponent = this$0.stack;
        y$iv2 = 2;
        int y$iv3 = 2;
        boolean $i$f$vec3 = false;
        stackComponent.setPos(stackComponent.getPos().minus(itemLayerPos.minus(Vec2d.Companion.getPooled((double)x$iv, y$iv3))));
        return Unit.INSTANCE;
    }

    private static final void select$lambda$8(DropdownMenu this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        GuiLayer guiLayer = this$0.button.getButtonContents$LibrarianLib_Continuous_1_12_2();
        if (guiLayer != null) {
            guiLayer.setVisible(true);
        }
        this$0.close();
    }
}

