/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.function.BooleanSupplier;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IMValueBoolean
implements GuiAnimatable<IMValueBoolean> {
    private Storage storage;

    private IMValueBoolean(Storage initialStorage) {
        this.storage = initialStorage;
    }

    public IMValueBoolean(boolean initialValue) {
        this.storage = new Storage.Fixed(initialValue);
    }

    public IMValueBoolean(BooleanSupplier initialCallback) {
        this.storage = new Storage.Callback(initialCallback);
    }

    public boolean get() {
        return this.storage.get();
    }

    public void set(BooleanSupplier callback) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Callback) {
            ((Storage.Callback)this.storage).callback = callback;
        } else {
            this.storage = new Storage.Callback(callback);
        }
    }

    public void setValue(boolean value) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Fixed) {
            ((Storage.Fixed)this.storage).value = value;
        } else {
            this.storage = new Storage.Fixed(value);
        }
    }

    public boolean getValue(Object thisRef, KProperty property) {
        return this.storage.get();
    }

    public void setValue(Object thisRef, KProperty property, boolean value) {
        this.setValue(value);
    }

    public void invoke(BooleanSupplier callback) {
        this.set(callback);
    }

    @Nullable
    public BooleanSupplier getCallback() {
        if (this.storage instanceof Storage.Callback) {
            return ((Storage.Callback)this.storage).callback;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getAnimatableValue() {
        return this.get();
    }

    @Override
    public void setAnimatableValue(@Nullable Object value) {
        this.setValue((Boolean)value);
    }

    @Override
    @Nullable
    public Object getAnimatableCallback() {
        return this.getCallback();
    }

    @Override
    public void setAnimatableCallback(@NotNull Object supplier) {
        this.set((BooleanSupplier)supplier);
    }

    public Animation<IMValueBoolean> animate(boolean to, float delay) {
        AnimationImpl anim = (AnimationImpl)this.animate(this.get(), to, delay);
        anim.implicitStart = true;
        return anim;
    }

    public Animation<IMValueBoolean> animate(boolean from, boolean to, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(delay);
        Animator.global.add(animation);
        return animation;
    }

    private class AnimationImpl
    extends Animation<IMValueBoolean> {
        boolean from;
        boolean to;
        boolean implicitStart;

        AnimationImpl(boolean from, boolean to, IMValueBoolean target) {
            super(target, new NullAnimatable());
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((IMValueBoolean)this.getTarget()).get();
                this.implicitStart = false;
            }
            ((IMValueBoolean)this.getTarget()).setValue(time == 1.0f ? this.to : this.from);
        }
    }

    private static abstract class Storage {
        private Storage() {
        }

        abstract boolean get();

        static class Callback
        extends Storage {
            BooleanSupplier callback;

            public Callback(BooleanSupplier callback) {
                this.callback = callback;
            }

            @Override
            boolean get() {
                return this.callback.getAsBoolean();
            }
        }

        static class Fixed
        extends Storage {
            boolean value;

            public Fixed(boolean value) {
                this.value = value;
            }

            @Override
            boolean get() {
                return this.value;
            }
        }
    }
}

