/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.DoubleSupplier;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IMValueDouble
implements GuiAnimatable<IMValueDouble> {
    private Storage storage;

    private IMValueDouble(Storage initialStorage) {
        this.storage = initialStorage;
    }

    public IMValueDouble(double initialValue) {
        this.storage = new Storage.Fixed(initialValue);
    }

    public IMValueDouble(DoubleSupplier initialCallback) {
        this.storage = new Storage.Callback(initialCallback);
    }

    public double get() {
        return this.storage.get();
    }

    public void set(DoubleSupplier callback) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Callback) {
            ((Storage.Callback)this.storage).callback = callback;
        } else {
            this.storage = new Storage.Callback(callback);
        }
    }

    public void setValue(double value) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Fixed) {
            ((Storage.Fixed)this.storage).value = value;
        } else {
            this.storage = new Storage.Fixed(value);
        }
    }

    public double getValue(Object thisRef, KProperty property) {
        return this.storage.get();
    }

    public void setValue(Object thisRef, KProperty property, double value) {
        this.setValue(value);
    }

    public void invoke(DoubleSupplier callback) {
        this.set(callback);
    }

    @Nullable
    public DoubleSupplier getCallback() {
        if (this.storage instanceof Storage.Callback) {
            return ((Storage.Callback)this.storage).callback;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getAnimatableValue() {
        return this.get();
    }

    @Override
    public void setAnimatableValue(@Nullable Object value) {
        this.setValue((Double)value);
    }

    @Override
    @Nullable
    public Object getAnimatableCallback() {
        return this.getCallback();
    }

    @Override
    public void setAnimatableCallback(@NotNull Object supplier) {
        this.set((DoubleSupplier)supplier);
    }

    public Animation<IMValueDouble> animate(double from, double to, float duration, Easing easing, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(duration);
        animation.easing = easing;
        animation.setStart(delay);
        Animator.global.add(animation);
        return animation;
    }

    public Animation<IMValueDouble> animate(double from, double to, float duration, Easing easing) {
        return this.animate(from, to, duration, easing, 0.0f);
    }

    public Animation<IMValueDouble> animate(double from, double to, float duration) {
        return this.animate(from, to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueDouble> animate(double to, float duration, Easing easing, float delay) {
        AnimationImpl anim = (AnimationImpl)this.animate(this.get(), to, duration, easing, delay);
        anim.implicitStart = true;
        return anim;
    }

    public Animation<IMValueDouble> animate(double to, float duration) {
        return this.animate(to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueDouble> animate(double to, float duration, Easing easing) {
        return this.animate(to, duration, easing, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(double initialValue) {
        return this.animateKeyframes(initialValue, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(double initialValue, float delay) {
        return new KeyframeAnimationBuilder(initialValue, delay, this);
    }

    private static class KeyframeAnimation
    extends Animation<IMValueDouble> {
        private List<Keyframe> keyframes;

        KeyframeAnimation(IMValueDouble target, List<Keyframe> keyframes) {
            super(target, new NullAnimatable());
            this.keyframes = keyframes;
        }

        @Override
        public void update(float time) {
            float progress = this.timeFraction(time);
            Keyframe prev = null;
            Keyframe next = null;
            for (Keyframe it : this.keyframes) {
                if (it.time <= progress) {
                    prev = it;
                }
                if (!(it.time >= progress) || next != null) continue;
                next = it;
            }
            if (prev != null && next != null) {
                if (next.time == prev.time) {
                    ((IMValueDouble)this.getTarget()).setValue(next.value);
                } else {
                    float partialProgress = next.easing.invoke((progress - prev.time) / (next.time - prev.time));
                    ((IMValueDouble)this.getTarget()).setValue(prev.value + (next.value - prev.value) * (double)partialProgress);
                }
            } else if (next != null) {
                ((IMValueDouble)this.getTarget()).setValue(next.value);
            } else if (prev != null) {
                ((IMValueDouble)this.getTarget()).setValue(prev.value);
            }
        }
    }

    private static class Keyframe {
        float time;
        double value;
        Easing easing;

        Keyframe(float time, double value, Easing easing) {
            this.time = time;
            this.value = value;
            this.easing = easing;
        }
    }

    public static class KeyframeAnimationBuilder {
        private float delay;
        private IMValueDouble target;
        private List<Keyframe> keyframes = new ArrayList<Keyframe>();

        KeyframeAnimationBuilder(double initialValue, float delay, IMValueDouble target) {
            this.target = target;
            this.delay = delay;
            this.keyframes.add(new Keyframe(0.0f, initialValue, Easing.linear));
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, double value) {
            return this.add(time, value, Easing.linear);
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, double value, @NotNull Easing easing) {
            this.keyframes.add(new Keyframe(time, value, easing));
            return this;
        }

        @NotNull
        public Animation<IMValueDouble> finish() {
            if (this.keyframes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty keyframe animation");
            }
            float duration = 0.0f;
            for (Keyframe keyframe : this.keyframes) {
                duration += keyframe.time;
            }
            float total = 0.0f;
            for (Keyframe it : this.keyframes) {
                it.time = (total += it.time) / duration;
            }
            KeyframeAnimation keyframeAnimation = new KeyframeAnimation(this.target, this.keyframes);
            keyframeAnimation.setDuration(duration);
            keyframeAnimation.setStart(this.delay);
            Animator.global.add(keyframeAnimation);
            return keyframeAnimation;
        }
    }

    private class AnimationImpl
    extends Animation<IMValueDouble> {
        double from;
        double to;
        boolean implicitStart;
        Easing easing;

        AnimationImpl(double from, double to, IMValueDouble target) {
            super(target, new NullAnimatable());
            this.easing = Easing.linear;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((IMValueDouble)this.getTarget()).get();
                this.implicitStart = false;
            }
            float progress = this.easing.invoke(this.timeFraction(time));
            double newValue = this.from + (this.to - this.from) * (double)progress;
            ((IMValueDouble)this.getTarget()).setValue(newValue);
        }
    }

    private static abstract class Storage {
        private Storage() {
        }

        abstract double get();

        static class Callback
        extends Storage {
            DoubleSupplier callback;

            public Callback(DoubleSupplier callback) {
                this.callback = callback;
            }

            @Override
            double get() {
                return this.callback.getAsDouble();
            }
        }

        static class Fixed
        extends Storage {
            double value;

            public Fixed(double value) {
                this.value = value;
            }

            @Override
            double get() {
                return this.value;
            }
        }
    }
}

