/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.facade.value;

import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.animator.Easing;
import com.teamwizardry.librarianlib.features.animator.NullAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimatable;
import com.teamwizardry.librarianlib.features.facade.value.GuiAnimator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IMValueLong
implements GuiAnimatable<IMValueLong> {
    private Storage storage;

    private IMValueLong(Storage initialStorage) {
        this.storage = initialStorage;
    }

    public IMValueLong(long initialValue) {
        this.storage = new Storage.Fixed(initialValue);
    }

    public IMValueLong(LongSupplier initialCallback) {
        this.storage = new Storage.Callback(initialCallback);
    }

    public long get() {
        return this.storage.get();
    }

    public void set(LongSupplier callback) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Callback) {
            ((Storage.Callback)this.storage).callback = callback;
        } else {
            this.storage = new Storage.Callback(callback);
        }
    }

    public void setValue(long value) {
        GuiAnimator.getCurrent().add(this);
        if (this.storage instanceof Storage.Fixed) {
            ((Storage.Fixed)this.storage).value = value;
        } else {
            this.storage = new Storage.Fixed(value);
        }
    }

    public long getValue(Object thisRef, KProperty property) {
        return this.storage.get();
    }

    public void setValue(Object thisRef, KProperty property, long value) {
        this.setValue(value);
    }

    public void invoke(LongSupplier callback) {
        this.set(callback);
    }

    @Nullable
    public LongSupplier getCallback() {
        if (this.storage instanceof Storage.Callback) {
            return ((Storage.Callback)this.storage).callback;
        }
        return null;
    }

    @Override
    @Nullable
    public Object getAnimatableValue() {
        return this.get();
    }

    @Override
    public void setAnimatableValue(@Nullable Object value) {
        this.setValue((Long)value);
    }

    @Override
    @Nullable
    public Object getAnimatableCallback() {
        return this.getCallback();
    }

    @Override
    public void setAnimatableCallback(@NotNull Object supplier) {
        this.set((LongSupplier)supplier);
    }

    public Animation<IMValueLong> animate(long from, long to, float duration, Easing easing, float delay) {
        AnimationImpl animation = new AnimationImpl(from, to, this);
        animation.setDuration(duration);
        animation.easing = easing;
        animation.setStart(delay);
        Animator.global.add(animation);
        return animation;
    }

    public Animation<IMValueLong> animate(long from, long to, float duration, Easing easing) {
        return this.animate(from, to, duration, easing, 0.0f);
    }

    public Animation<IMValueLong> animate(long from, long to, float duration) {
        return this.animate(from, to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueLong> animate(long to, float duration, Easing easing, float delay) {
        AnimationImpl anim = (AnimationImpl)this.animate(this.get(), to, duration, easing, delay);
        anim.implicitStart = true;
        return anim;
    }

    public Animation<IMValueLong> animate(long to, float duration) {
        return this.animate(to, duration, Easing.linear, 0.0f);
    }

    public Animation<IMValueLong> animate(long to, float duration, Easing easing) {
        return this.animate(to, duration, easing, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(long initialValue) {
        return this.animateKeyframes(initialValue, 0.0f);
    }

    public KeyframeAnimationBuilder animateKeyframes(long initialValue, float delay) {
        return new KeyframeAnimationBuilder(initialValue, delay, this);
    }

    private static class KeyframeAnimation
    extends Animation<IMValueLong> {
        private List<Keyframe> keyframes;

        KeyframeAnimation(IMValueLong target, List<Keyframe> keyframes) {
            super(target, new NullAnimatable());
            this.keyframes = keyframes;
        }

        @Override
        public void update(float time) {
            float progress = this.timeFraction(time);
            Keyframe prev = null;
            Keyframe next = null;
            for (Keyframe it : this.keyframes) {
                if (it.time <= progress) {
                    prev = it;
                }
                if (!(it.time >= progress) || next != null) continue;
                next = it;
            }
            if (prev != null && next != null) {
                if (next.time == prev.time) {
                    ((IMValueLong)this.getTarget()).setValue(next.value);
                } else {
                    float partialProgress = next.easing.invoke((progress - prev.time) / (next.time - prev.time));
                    ((IMValueLong)this.getTarget()).setValue((int)((float)prev.value + (float)(next.value - prev.value) * partialProgress));
                }
            } else if (next != null) {
                ((IMValueLong)this.getTarget()).setValue(next.value);
            } else if (prev != null) {
                ((IMValueLong)this.getTarget()).setValue(prev.value);
            }
        }
    }

    private static class Keyframe {
        float time;
        long value;
        Easing easing;

        Keyframe(float time, long value, Easing easing) {
            this.time = time;
            this.value = value;
            this.easing = easing;
        }
    }

    public static class KeyframeAnimationBuilder {
        private float delay;
        private IMValueLong target;
        private List<Keyframe> keyframes = new ArrayList<Keyframe>();

        KeyframeAnimationBuilder(long initialValue, float delay, IMValueLong target) {
            this.target = target;
            this.delay = delay;
            this.keyframes.add(new Keyframe(0.0f, initialValue, Easing.linear));
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, long value) {
            return this.add(time, value, Easing.linear);
        }

        @NotNull
        public KeyframeAnimationBuilder add(float time, long value, @NotNull Easing easing) {
            this.keyframes.add(new Keyframe(time, value, easing));
            return this;
        }

        @NotNull
        public Animation<IMValueLong> finish() {
            if (this.keyframes.isEmpty()) {
                throw new IllegalStateException("Cannot create an empty keyframe animation");
            }
            float duration = 0.0f;
            for (Keyframe keyframe : this.keyframes) {
                duration += keyframe.time;
            }
            float total = 0.0f;
            for (Keyframe it : this.keyframes) {
                it.time = (total += it.time) / duration;
            }
            KeyframeAnimation keyframeAnimation = new KeyframeAnimation(this.target, this.keyframes);
            keyframeAnimation.setDuration(duration);
            keyframeAnimation.setStart(this.delay);
            Animator.global.add(keyframeAnimation);
            return keyframeAnimation;
        }
    }

    private class AnimationImpl
    extends Animation<IMValueLong> {
        long from;
        long to;
        boolean implicitStart;
        Easing easing;

        AnimationImpl(long from, long to, IMValueLong target) {
            super(target, new NullAnimatable());
            this.easing = Easing.linear;
            this.from = from;
            this.to = to;
        }

        @Override
        public void update(float time) {
            if (this.implicitStart) {
                this.from = ((IMValueLong)this.getTarget()).get();
                this.implicitStart = false;
            }
            float progress = this.easing.invoke(this.timeFraction(time));
            long newValue = (long)((float)this.from + (float)(this.to - this.from) * progress);
            ((IMValueLong)this.getTarget()).setValue(newValue);
        }
    }

    private static abstract class Storage {
        private Storage() {
        }

        abstract long get();

        static class Callback
        extends Storage {
            LongSupplier callback;

            public Callback(LongSupplier callback) {
                this.callback = callback;
            }

            @Override
            long get() {
                return this.callback.getAsLong();
            }
        }

        static class Fixed
        extends Storage {
            long value;

            public Fixed(long value) {
                this.value = value;
            }

            @Override
            long get() {
                return this.value;
            }
        }
    }
}

