/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.component.supporting;

import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\rH\u0002J#\u0010\"\u001a\u00020\u00172\u0016\u0010\f\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00030#\"\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010$J\u0012\u0010%\u001a\u00020\u00172\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003H\u0004J\u0011\u0010&\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u001a\u0010)\u001a\u00020\u00172\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00170+J$\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\b\b\u0000\u0010.*\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00J$\u00101\u001a\b\u0012\u0004\u0012\u0002H.0-\"\b\b\u0000\u0010.*\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.00J.\u00102\u001a\u00020\u0017\"\b\b\u0000\u0010.*\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H.0\rH\u0004J.\u00103\u001a\u00020\u0017\"\b\b\u0000\u0010.*\u00020\u00032\f\u0010/\u001a\b\u0012\u0004\u0012\u0002H.002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H.0\rH\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00030\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR(\u0010\u001e\u001a\u0004\u0018\u00010\u00032\b\u0010\u001d\u001a\u0004\u0018\u00010\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\u0005R\u0011\u00104\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b5\u0010 \u00a8\u00066"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRelationshipHandler;", "", "component", "Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;", "<init>", "(Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;)V", "zIndex", "", "getZIndex", "()I", "setZIndex", "(I)V", "components", "", "getComponents$LibrarianLib_Continuous_1_12_2", "()Ljava/util/List;", "children", "", "getChildren", "()Ljava/util/Collection;", "allChildren", "getAllChildren", "addChildrenRecursively", "", "list", "parents", "", "getParents", "()Ljava/util/Set;", "value", "parent", "getParent", "()Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;", "setParent", "add", "", "([Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;)V", "addInternal", "contains", "", "remove", "forEachChild", "l", "Lkotlin/Function1;", "getByClass", "", "C", "clazz", "Ljava/lang/Class;", "getAllByClass", "addAllByClass", "addByClass", "root", "getRoot", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nComponentRelationshipHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentRelationshipHandler.kt\ncom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRelationshipHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,152:1\n1863#2,2:153\n1755#2,3:157\n1863#2,2:160\n1863#2,2:162\n13346#3,2:155\n*S KotlinDebug\n*F\n+ 1 ComponentRelationshipHandler.kt\ncom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRelationshipHandler\n*L\n31#1:153,2\n90#1:157,3\n112#1:160,2\n135#1:162,2\n53#1:155,2\n*E\n"})
public class ComponentRelationshipHandler {
    @NotNull
    private final GuiComponent component;
    private int zIndex;
    @NotNull
    private final List<GuiComponent> components;
    @NotNull
    private final Collection<GuiComponent> children;
    @NotNull
    private final Set<GuiComponent> parents;
    @Nullable
    private GuiComponent parent;

    public ComponentRelationshipHandler(@NotNull GuiComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.components = new ArrayList();
        Collection collection = Collections.unmodifiableCollection((Collection)this.components);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"unmodifiableCollection(...)");
        this.children = collection;
        this.parents = new LinkedHashSet();
    }

    public final int getZIndex() {
        return this.zIndex;
    }

    public final void setZIndex(int n) {
        this.zIndex = n;
    }

    @NotNull
    public final List<GuiComponent> getComponents$LibrarianLib_Continuous_1_12_2() {
        return this.components;
    }

    @NotNull
    public final Collection<GuiComponent> getChildren() {
        return this.children;
    }

    @NotNull
    public final Collection<GuiComponent> getAllChildren() {
        List list = new ArrayList();
        this.addChildrenRecursively(list);
        Collection<GuiComponent> collection = Collections.unmodifiableCollection(list);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"unmodifiableCollection(...)");
        return collection;
    }

    private final void addChildrenRecursively(List<GuiComponent> list) {
        list.addAll((Collection<GuiComponent>)this.components);
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiComponent it = (GuiComponent)element$iv;
            boolean bl = false;
            it.relationships.addChildrenRecursively(list);
        }
    }

    @NotNull
    public final Set<GuiComponent> getParents() {
        return this.parents;
    }

    @Nullable
    public final GuiComponent getParent() {
        return this.parent;
    }

    public final void setParent(@Nullable GuiComponent value) {
        this.parents.clear();
        if (value != null) {
            this.parents.addAll((Collection<GuiComponent>)value.relationships.parents);
            this.parents.add(value);
        }
        this.parent = value;
    }

    public final void add(GuiComponent ... components) {
        Intrinsics.checkNotNullParameter((Object)components, (String)"components");
        GuiComponent[] $this$forEach$iv = components;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            GuiComponent element$iv;
            GuiComponent it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.addInternal(it);
        }
    }

    protected final void addInternal(@Nullable GuiComponent component) {
        if (component == null) {
            LibrarianLog.INSTANCE.error("Null component, ignoring", new Object[0]);
            return;
        }
        if (component == this.component) {
            throw new IllegalArgumentException("Immediately recursive component hierarchy");
        }
        if (component.getParent() != null) {
            if (Intrinsics.areEqual((Object)component.getParent(), (Object)this.component)) {
                LibrarianLog.INSTANCE.error(new Exception(), "You tried to add the component to the same parent twice. Why?", new Object[0]);
                return;
            }
            throw new IllegalArgumentException("Component already had a parent");
        }
        if (this.parents.contains(component)) {
            throw new IllegalArgumentException("Recursive component hierarchy");
        }
        if (((GuiComponentEvents.AddChildEvent)component.BUS.fire((Event)new GuiComponentEvents.AddChildEvent(this.component, component))).isCanceled()) {
            return;
        }
        if (((GuiComponentEvents.AddToParentEvent)component.BUS.fire((Event)new GuiComponentEvents.AddToParentEvent(component, this.component))).isCanceled()) {
            return;
        }
        this.components.add(component);
        component.relationships.setParent(this.component);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull GuiComponent component) {
        GuiComponent it;
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (this.components.contains(component)) return true;
        Iterable $this$any$iv = this.components;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (GuiComponent)element$iv;
            boolean bl = false;
        } while (!it.relationships.contains(component));
        return true;
    }

    public final void remove(@NotNull GuiComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if (!this.components.contains(component)) {
            return;
        }
        if (((GuiComponentEvents.RemoveChildEvent)this.component.BUS.fire((Event)new GuiComponentEvents.RemoveChildEvent(this.component, component))).isCanceled()) {
            return;
        }
        if (((GuiComponentEvents.RemoveFromParentEvent)component.BUS.fire((Event)new GuiComponentEvents.RemoveFromParentEvent(component, this.component))).isCanceled()) {
            return;
        }
        component.relationships.setParent(null);
        this.components.remove(component);
    }

    public final void forEachChild(@NotNull Function1<? super GuiComponent, Unit> l) {
        Intrinsics.checkNotNullParameter(l, (String)"l");
        List copy = CollectionsKt.toList((Iterable)this.components);
        Iterable $this$forEach$iv = copy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            l.invoke(element$iv);
        }
    }

    @NotNull
    public final <C extends GuiComponent> List<C> getByClass(@NotNull Class<C> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List list = new ArrayList();
        this.addByClass(clazz, list);
        return list;
    }

    @NotNull
    public final <C extends GuiComponent> List<C> getAllByClass(@NotNull Class<C> clazz) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        List list = new ArrayList();
        this.addAllByClass(clazz, list);
        return list;
    }

    protected final <C extends GuiComponent> void addAllByClass(@NotNull Class<C> clazz, @NotNull List<C> list) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.addByClass(clazz, list);
        Iterable $this$forEach$iv = this.components;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GuiComponent it = (GuiComponent)element$iv;
            boolean bl = false;
            it.relationships.addAllByClass(clazz, list);
        }
    }

    protected final <C extends GuiComponent> void addByClass(@NotNull Class<C> clazz, @NotNull List<C> list) {
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        this.forEachChild((Function1<? super GuiComponent, Unit>)((Function1)arg_0 -> ComponentRelationshipHandler.addByClass$lambda$4(clazz, list, arg_0)));
    }

    @NotNull
    public final GuiComponent getRoot() {
        GuiComponent guiComponent = this.parent;
        if (guiComponent == null || (guiComponent = guiComponent.getRoot()) == null) {
            guiComponent = this.component;
        }
        return guiComponent;
    }

    private static final Unit addByClass$lambda$4(Class $clazz, List $list, GuiComponent component) {
        Intrinsics.checkNotNullParameter((Object)$clazz, (String)"$clazz");
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        if ($clazz.isAssignableFrom(component.getClass())) {
            $list.add(component);
        }
        return Unit.INSTANCE;
    }
}

