/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.component.supporting;

import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.features.animator.Animation;
import com.teamwizardry.librarianlib.features.animator.Animator;
import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.gui.Option;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.utilities.client.LibCursor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.client.config.GuiUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\f\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010 \u001a\u0004\u0018\u00010\u000fJ\u0014\u0010\f\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\t0\bJ'\u0010*\u001a\u00020\u001e2\u001a\u0010+\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030-0,\"\u0006\u0012\u0002\b\u00030-\u00a2\u0006\u0002\u0010.J\u0016\u0010/\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\u001e2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u000203R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\u0003\u0012\f\u0012\n\u0012\u0004\u0012\u00020\t\u0018\u00010\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R*\u0010\u001b\u001a\u0004\u0018\u00010\u00152\b\u0010\u001a\u001a\u0004\u0018\u00010\u00158F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R$\u0010\"\u001a\u00020!2\u0006\u0010\u001a\u001a\u00020!8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010'\u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRenderHandler;", "", "component", "Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;", "<init>", "(Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;)V", "tooltip", "Lcom/teamwizardry/librarianlib/features/gui/Option;", "", "", "getTooltip", "()Lcom/teamwizardry/librarianlib/features/gui/Option;", "setTooltip", "(Lcom/teamwizardry/librarianlib/features/gui/Option;)V", "tooltipFont", "Lnet/minecraft/client/gui/FontRenderer;", "getTooltipFont", "()Lnet/minecraft/client/gui/FontRenderer;", "setTooltipFont", "(Lnet/minecraft/client/gui/FontRenderer;)V", "hoverCursor", "Lcom/teamwizardry/librarianlib/features/utilities/client/LibCursor;", "getHoverCursor", "()Lcom/teamwizardry/librarianlib/features/utilities/client/LibCursor;", "setHoverCursor", "(Lcom/teamwizardry/librarianlib/features/utilities/client/LibCursor;)V", "value", "cursor", "getCursor", "setCursor", "", "text", "font", "Lcom/teamwizardry/librarianlib/features/animator/Animator;", "animator", "getAnimator", "()Lcom/teamwizardry/librarianlib/features/animator/Animator;", "setAnimator", "(Lcom/teamwizardry/librarianlib/features/animator/Animator;)V", "animatorStorage", "wasMouseOver", "", "add", "animations", "", "Lcom/teamwizardry/librarianlib/features/animator/Animation;", "([Lcom/teamwizardry/librarianlib/features/animator/Animation;)V", "draw", "mousePos", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "partialTicks", "", "drawLate", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nComponentRenderHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentRenderHandler.kt\ncom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRenderHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n1010#2,2:203\n*S KotlinDebug\n*F\n+ 1 ComponentRenderHandler.kt\ncom/teamwizardry/librarianlib/features/gui/component/supporting/ComponentRenderHandler\n*L\n95#1:203,2\n*E\n"})
public final class ComponentRenderHandler {
    @NotNull
    private final GuiComponent component;
    @NotNull
    private Option<GuiComponent, List<String>> tooltip;
    @Nullable
    private FontRenderer tooltipFont;
    @Nullable
    private LibCursor hoverCursor;
    @Nullable
    private LibCursor cursor;
    @Nullable
    private Animator animatorStorage;
    private boolean wasMouseOver;

    public ComponentRenderHandler(@NotNull GuiComponent component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.component = component;
        this.tooltip = new Option(null);
    }

    @NotNull
    public final Option<GuiComponent, List<String>> getTooltip() {
        return this.tooltip;
    }

    public final void setTooltip(@NotNull Option<GuiComponent, List<String>> option) {
        Intrinsics.checkNotNullParameter(option, (String)"<set-?>");
        this.tooltip = option;
    }

    @Nullable
    public final FontRenderer getTooltipFont() {
        return this.tooltipFont;
    }

    public final void setTooltipFont(@Nullable FontRenderer fontRenderer) {
        this.tooltipFont = fontRenderer;
    }

    @Nullable
    public final LibCursor getHoverCursor() {
        return this.hoverCursor;
    }

    public final void setHoverCursor(@Nullable LibCursor libCursor) {
        this.hoverCursor = libCursor;
    }

    @Nullable
    public final LibCursor getCursor() {
        GuiComponent parent2 = this.component.getParent();
        if (parent2 == null) {
            return this.cursor;
        }
        return parent2.render.getCursor();
    }

    public final void setCursor(@Nullable LibCursor value) {
        GuiComponent parent2 = this.component.getParent();
        if (parent2 == null) {
            this.cursor = value;
        } else {
            parent2.render.setCursor(value);
        }
    }

    public final void setTooltip(@NotNull List<String> text, @Nullable FontRenderer font) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.tooltip.invoke(text);
        this.tooltipFont = font;
    }

    public final void setTooltip(@NotNull List<String> text) {
        Intrinsics.checkNotNullParameter(text, (String)"text");
        this.setTooltip(text, null);
    }

    @NotNull
    public final Animator getAnimator() {
        Animator a;
        Animator animator2 = this.animatorStorage;
        if (animator2 == null) {
            GuiComponent guiComponent = this.component.getParent();
            animator2 = guiComponent != null ? guiComponent.getAnimator() : null;
        }
        if ((a = animator2) == null) {
            this.animatorStorage = a = new Animator();
        }
        return a;
    }

    public final void setAnimator(@NotNull Animator value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.animatorStorage = value;
    }

    public final void add(Animation<?> ... animations) {
        Intrinsics.checkNotNullParameter(animations, (String)"animations");
        this.getAnimator().add(Arrays.copyOf(animations, animations.length));
    }

    public final void draw(@NotNull Vec2d mousePos, float partialTicks) {
        List<GuiComponent> components;
        Intrinsics.checkNotNullParameter((Object)mousePos, (String)"mousePos");
        Vec2d transformedPos = this.component.geometry.transformFromParentContext(mousePos);
        List<GuiComponent> $this$sortBy$iv = components = this.component.relationships.getComponents$LibrarianLib_Continuous_1_12_2();
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    GuiComponent it = (GuiComponent)a;
                    boolean bl = false;
                    it = (GuiComponent)b;
                    Comparable comparable = Integer.valueOf(it.relationships.getZIndex());
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.relationships.getZIndex()));
                }
            });
        }
        if (!this.component.isVisible()) {
            return;
        }
        CollectionsKt.removeAll(components, arg_0 -> ComponentRenderHandler.draw$lambda$1(this, arg_0));
        if (this.wasMouseOver != this.component.getMouseOver()) {
            Event event = this.component.getMouseOver() ? this.component.BUS.fire((Event)new GuiComponentEvents.MouseInEvent(this.component, transformedPos)) : this.component.BUS.fire((Event)new GuiComponentEvents.MouseOutEvent(this.component, transformedPos));
        }
        this.wasMouseOver = this.component.getMouseOver();
        if (this.component.getMouseOver() && this.hoverCursor != null) {
            this.setCursor(this.hoverCursor);
        }
        this.component.BUS.fire((Event)new GuiComponentEvents.PreTransformEvent(this.component, transformedPos, partialTicks));
        GlStateManager.func_179094_E();
        this.component.getTransform().glApply();
        this.component.clipping.pushEnable$LibrarianLib_Continuous_1_12_2();
        this.component.BUS.fire((Event)new GuiComponentEvents.PreDrawEvent(this.component, transformedPos, partialTicks));
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.component.drawComponent(transformedPos, partialTicks);
        if (LibrarianLib.DEV_ENVIRONMENT && Minecraft.func_71410_x().func_175598_ae().func_178634_b()) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179124_c((float)1.0f, (float)0.0f, (float)1.0f);
            if (this.component.geometry.getMouseOverNoOcclusion()) {
                GlStateManager.func_179124_c((float)0.75f, (float)0.75f, (float)0.75f);
            }
            if (this.component.getMouseOver()) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            }
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vb = tessellator.func_178180_c();
            vb.func_181668_a(3, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), 0.0, 0.0).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), this.component.getSize().getY(), 0.0).func_181675_d();
            vb.func_181662_b(0.0, this.component.getSize().getY(), 0.0).func_181675_d();
            vb.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            double big = 1000.0;
            vb.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(0.0, 0.0, 0.0).func_181675_d();
            vb.func_181662_b(0.0, 0.0, -big).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), 0.0, 0.0).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), 0.0, -big).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), this.component.getSize().getY(), 0.0).func_181675_d();
            vb.func_181662_b(this.component.getSize().getX(), this.component.getSize().getY(), -big).func_181675_d();
            vb.func_181662_b(0.0, this.component.getSize().getY(), 0.0).func_181675_d();
            vb.func_181662_b(0.0, this.component.getSize().getY(), -big).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179124_c((float)0.0f, (float)1.0f, (float)1.0f);
            vb.func_181668_a(1, DefaultVertexFormats.field_181705_e);
            vb.func_181662_b(transformedPos.getX(), transformedPos.getY(), 0.0).func_181675_d();
            vb.func_181662_b(transformedPos.getX(), transformedPos.getY(), big).func_181675_d();
            tessellator.func_78381_a();
        }
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.component.BUS.fire((Event)new GuiComponentEvents.PreChildrenDrawEvent(this.component, transformedPos, partialTicks));
        this.component.relationships.forEachChild((Function1<? super GuiComponent, Unit>)((Function1)arg_0 -> ComponentRenderHandler.draw$lambda$2(transformedPos, partialTicks, arg_0)));
        this.component.BUS.fire((Event)new GuiComponentEvents.PostDrawEvent(this.component, transformedPos, partialTicks));
        this.component.clipping.popDisable$LibrarianLib_Continuous_1_12_2();
        GlStateManager.func_179121_F();
    }

    public final void drawLate(@NotNull Vec2d mousePos, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mousePos, (String)"mousePos");
        if (!this.component.isVisible()) {
            return;
        }
        if (this.component.getMouseOver()) {
            List<String> tt;
            List<String> list = tt = this.tooltip.invoke(this.component);
            boolean bl = list != null ? !((Collection)list).isEmpty() : false;
            if (bl) {
                int n = mousePos.getXi();
                int n2 = mousePos.getYi();
                int n3 = this.component.getRoot().getSize().getXi();
                int n4 = this.component.getRoot().getSize().getYi();
                FontRenderer fontRenderer = this.tooltipFont;
                if (fontRenderer == null) {
                    fontRenderer = Minecraft.func_71410_x().field_71466_p;
                }
                GuiUtils.drawHoveringText(tt, (int)n, (int)n2, (int)n3, (int)n4, (int)-1, (FontRenderer)fontRenderer);
            }
        }
        this.component.relationships.forEachChild((Function1<? super GuiComponent, Unit>)((Function1)arg_0 -> ComponentRenderHandler.drawLate$lambda$3(mousePos, partialTicks, arg_0)));
    }

    private static final boolean draw$lambda$1(ComponentRenderHandler this$0, GuiComponent e) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        boolean b = e.isInvalid();
        if (((GuiComponentEvents.RemoveChildEvent)this$0.component.BUS.fire((Event)new GuiComponentEvents.RemoveChildEvent(this$0.component, e))).isCanceled()) {
            b = false;
        }
        if (((GuiComponentEvents.RemoveFromParentEvent)e.BUS.fire((Event)new GuiComponentEvents.RemoveFromParentEvent(e, this$0.component))).isCanceled()) {
            b = false;
        }
        if (b) {
            e.relationships.setParent(null);
        }
        return b;
    }

    private static final Unit draw$lambda$2(Vec2d $transformedPos, float $partialTicks, GuiComponent it) {
        Intrinsics.checkNotNullParameter((Object)$transformedPos, (String)"$transformedPos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.render.draw($transformedPos, $partialTicks);
        return Unit.INSTANCE;
    }

    private static final Unit drawLate$lambda$3(Vec2d $mousePos, float $partialTicks, GuiComponent it) {
        Intrinsics.checkNotNullParameter((Object)$mousePos, (String)"$mousePos");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.render.drawLate($mousePos, $partialTicks);
        return Unit.INSTANCE;
    }
}

