/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.components;

import com.teamwizardry.librarianlib.features.eventbus.Event;
import com.teamwizardry.librarianlib.features.eventbus.EventCancelable;
import com.teamwizardry.librarianlib.features.gui.Option;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponentEvents;
import com.teamwizardry.librarianlib.features.kotlin.ClientUtilMethods;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.awt.Color;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ChatAllowedCharacters;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Deprecated(message="As of version 4.20 this has been superseded by Facade")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0012\n\u0002\u0010\f\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001:\u0003mnoB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nB)\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\u000bJ\u0018\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020JH\u0016J\u0006\u0010K\u001a\u00020FJ\u000e\u0010L\u001a\u00020F2\u0006\u0010M\u001a\u00020\u000fJ\u000e\u0010N\u001a\u00020F2\u0006\u0010O\u001a\u00020\u0005J\u000e\u0010P\u001a\u00020F2\u0006\u0010O\u001a\u00020\u0005J\u000e\u0010Q\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u0005J\u0016\u0010S\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u0005J\u001e\u0010U\u001a\u00020\u00052\u0006\u0010R\u001a\u00020\u00052\u0006\u0010T\u001a\u00020\u00052\u0006\u0010V\u001a\u00020\u001aJ\u000e\u0010W\u001a\u00020F2\u0006\u0010X\u001a\u00020\u0005J\u0006\u0010Y\u001a\u00020FJ\u0006\u0010Z\u001a\u00020FJ\u0016\u0010[\u001a\u00020\u001a2\u0006\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020\u0005J\u001e\u0010_\u001a\u00020\u001a2\u0006\u0010`\u001a\u00020\u00052\u0006\u0010a\u001a\u00020\u00052\u0006\u0010b\u001a\u00020\u0005J(\u0010c\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020J2\u0006\u0010\u0006\u001a\u00020J2\u0006\u0010d\u001a\u00020\u0005H\u0002J\u0006\u0010e\u001a\u00020FJ(\u0010f\u001a\u00020F2\u0006\u0010g\u001a\u00020\u00052\u0006\u0010h\u001a\u00020\u00052\u0006\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020\u0005H\u0002J\u000e\u0010k\u001a\u00020F2\u0006\u0010l\u001a\u00020\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u00050\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001d\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u001d\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0018R\u001d\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0018R\u001d\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u001a0\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0018R*\u0010\"\u001a\u0012\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R$\u0010(\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u001a@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\u00020\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010)\"\u0004\b-\u0010+R$\u0010/\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b0\u00101\"\u0004\b2\u00103R&\u00104\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002050\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u0010\u0018\"\u0004\b7\u00108R\u001d\u00109\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002050\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010\u0018R&\u0010;\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002050\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010\u0018\"\u0004\b=\u00108R&\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u0002050\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b?\u0010\u0018\"\u0004\b@\u00108R\u001e\u0010A\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u00101R\u0011\u0010C\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\u0012\u00a8\u0006p"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/components/ComponentTextField;", "Lcom/teamwizardry/librarianlib/features/gui/component/GuiComponent;", "fontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "x", "", "y", "width", "height", "<init>", "(Lnet/minecraft/client/gui/FontRenderer;IIII)V", "(IIII)V", "cursorCounter", "lineScrollOffset", "value", "", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "maxStringLength", "Lcom/teamwizardry/librarianlib/features/gui/Option;", "getMaxStringLength", "()Lcom/teamwizardry/librarianlib/features/gui/Option;", "canLoseFocus", "", "getCanLoseFocus", "autoFocus", "getAutoFocus", "useShadow", "getUseShadow", "useVanillaFilter", "getUseVanillaFilter", "filter", "Lkotlin/Function1;", "getFilter", "()Lkotlin/jvm/functions/Function1;", "setFilter", "(Lkotlin/jvm/functions/Function1;)V", "isFocused", "()Z", "setFocused", "(Z)V", "isEnabled", "setEnabled", "pos", "cursorPosition", "getCursorPosition", "()I", "setCursorPosition", "(I)V", "enabledColor", "Ljava/awt/Color;", "getEnabledColor", "setEnabledColor", "(Lcom/teamwizardry/librarianlib/features/gui/Option;)V", "disabledColor", "getDisabledColor", "selectionColor", "getSelectionColor", "setSelectionColor", "cursorColor", "getCursorColor", "setCursorColor", "selectionEnd", "getSelectionEnd", "selectedText", "getSelectedText", "drawComponent", "", "mousePos", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "partialTicks", "", "updateCursorCounter", "writeText", "textToWrite", "deleteWords", "count", "deleteFromCursor", "getWordStartingFromCursor", "relativeIndex", "getWord", "startingPos", "getWordSkippingWhitespace", "skipWhitespace", "shiftCursor", "num", "cursorToStart", "cursorToEnd", "handleKeyTyped", "input", "", "inputCode", "mouseClicked", "mouseX", "mouseY", "mouseButton", "drawString", "color", "drawTextBox", "drawSelectionBox", "startX", "startY", "endX", "endY", "setSelectionPosition", "targetPosition", "TextEditEvent", "TextSentEvent", "FocusEvent", "LibrarianLib-Continuous-1.12.2"})
public final class ComponentTextField
extends GuiComponent {
    @NotNull
    private final FontRenderer fontRenderer;
    private int cursorCounter;
    private int lineScrollOffset;
    @NotNull
    private String text;
    @NotNull
    private final Option<ComponentTextField, Integer> maxStringLength;
    @NotNull
    private final Option<ComponentTextField, Boolean> canLoseFocus;
    @NotNull
    private final Option<ComponentTextField, Boolean> autoFocus;
    @NotNull
    private final Option<ComponentTextField, Boolean> useShadow;
    @NotNull
    private final Option<ComponentTextField, Boolean> useVanillaFilter;
    @Nullable
    private Function1<? super String, String> filter;
    private boolean isFocused;
    private boolean isEnabled;
    private int cursorPosition;
    @NotNull
    private Option<ComponentTextField, Color> enabledColor;
    @NotNull
    private final Option<ComponentTextField, Color> disabledColor;
    @NotNull
    private Option<ComponentTextField, Color> selectionColor;
    @NotNull
    private Option<ComponentTextField, Color> cursorColor;
    private int selectionEnd;

    public ComponentTextField(@NotNull FontRenderer fontRenderer, int x, int y, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)fontRenderer, (String)"fontRenderer");
        super(x, y, width, height);
        this.fontRenderer = fontRenderer;
        this.text = "";
        this.maxStringLength = new Option(100);
        this.canLoseFocus = new Option(true);
        this.autoFocus = new Option(false);
        this.useShadow = new Option(true);
        this.useVanillaFilter = new Option(true);
        this.isEnabled = true;
        this.enabledColor = new Option(new Color(0xE0E0E0));
        this.disabledColor = new Option(new Color(0x707070));
        this.selectionColor = new Option(new Color(255));
        this.cursorColor = new Option(new Color(0xD0D0D0));
        this.BUS.hook(GuiComponentEvents.MouseDownEvent.class, arg_0 -> ComponentTextField._init_$lambda$0(this, arg_0));
        this.BUS.hook(GuiComponentEvents.KeyDownEvent.class, arg_0 -> ComponentTextField._init_$lambda$1(this, arg_0));
        this.BUS.hook(GuiComponentEvents.ComponentTickEvent.class, arg_0 -> ComponentTextField._init_$lambda$2(this, arg_0));
    }

    public ComponentTextField(int x, int y, int width, int height) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        Intrinsics.checkNotNullExpressionValue((Object)fontRenderer, (String)"fontRenderer");
        this(fontRenderer, x, y, width, height);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        String result;
        String string;
        String trimmed;
        String string2;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int max = ((Number)this.maxStringLength.getValue(this)).intValue();
        if (value.length() > max) {
            String string3 = value.substring(0, max);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        } else {
            string2 = trimmed = value;
        }
        if (this.filter != null) {
            Function1<? super String, String> function1 = this.filter;
            string = function1 != null ? (String)function1.invoke((Object)trimmed) : null;
        } else {
            string = result = trimmed;
        }
        if (result != null) {
            this.text = result;
        }
        if (((CharSequence)this.text).length() == 0) {
            this.cursorToEnd();
        }
    }

    @NotNull
    public final Option<ComponentTextField, Integer> getMaxStringLength() {
        return this.maxStringLength;
    }

    @NotNull
    public final Option<ComponentTextField, Boolean> getCanLoseFocus() {
        return this.canLoseFocus;
    }

    @NotNull
    public final Option<ComponentTextField, Boolean> getAutoFocus() {
        return this.autoFocus;
    }

    @NotNull
    public final Option<ComponentTextField, Boolean> getUseShadow() {
        return this.useShadow;
    }

    @NotNull
    public final Option<ComponentTextField, Boolean> getUseVanillaFilter() {
        return this.useVanillaFilter;
    }

    @Nullable
    public final Function1<String, String> getFilter() {
        return this.filter;
    }

    public final void setFilter(@Nullable Function1<? super String, String> function1) {
        this.filter = function1;
    }

    public final boolean isFocused() {
        return this.isFocused;
    }

    public final void setFocused(boolean isFocused) {
        if (isFocused == this.isFocused || ((FocusEvent)this.BUS.fire((Event)new FocusEvent(this.isFocused))).isCanceled()) {
            return;
        }
        if (isFocused && !this.isFocused) {
            this.cursorCounter = 0;
        }
        this.isFocused = isFocused;
        GuiScreen currentScreen = Minecraft.func_71410_x().field_71462_r;
        if (currentScreen != null) {
            currentScreen.func_193975_a(isFocused);
        }
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final void setEnabled(boolean bl) {
        this.isEnabled = bl;
    }

    public final int getCursorPosition() {
        return this.cursorPosition;
    }

    public final void setCursorPosition(int pos2) {
        this.cursorPosition = MathHelper.func_76125_a((int)pos2, (int)0, (int)this.text.length());
        this.setSelectionPosition(this.cursorPosition);
    }

    @NotNull
    public final Option<ComponentTextField, Color> getEnabledColor() {
        return this.enabledColor;
    }

    public final void setEnabledColor(@NotNull Option<ComponentTextField, Color> option) {
        Intrinsics.checkNotNullParameter(option, (String)"<set-?>");
        this.enabledColor = option;
    }

    @NotNull
    public final Option<ComponentTextField, Color> getDisabledColor() {
        return this.disabledColor;
    }

    @NotNull
    public final Option<ComponentTextField, Color> getSelectionColor() {
        return this.selectionColor;
    }

    public final void setSelectionColor(@NotNull Option<ComponentTextField, Color> option) {
        Intrinsics.checkNotNullParameter(option, (String)"<set-?>");
        this.selectionColor = option;
    }

    @NotNull
    public final Option<ComponentTextField, Color> getCursorColor() {
        return this.cursorColor;
    }

    public final void setCursorColor(@NotNull Option<ComponentTextField, Color> option) {
        Intrinsics.checkNotNullParameter(option, (String)"<set-?>");
        this.cursorColor = option;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    @NotNull
    public final String getSelectedText() {
        int start = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int end = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        String string = this.text.substring(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return string;
    }

    @Override
    public void drawComponent(@NotNull Vec2d mousePos, float partialTicks) {
        Intrinsics.checkNotNullParameter((Object)mousePos, (String)"mousePos");
        this.drawTextBox();
    }

    public final void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public final void writeText(@NotNull String textToWrite) {
        TextEditEvent editEvent;
        String string;
        String build;
        String string2;
        Intrinsics.checkNotNullParameter((Object)textToWrite, (String)"textToWrite");
        String allowed = this.useVanillaFilter.invoke(this) != false ? ChatAllowedCharacters.func_71565_a((String)textToWrite) : textToWrite;
        int max = ((Number)this.maxStringLength.getValue(this)).intValue();
        int selectionStart = this.cursorPosition < this.selectionEnd ? this.cursorPosition : this.selectionEnd;
        int selectionEnd = this.cursorPosition < this.selectionEnd ? this.selectionEnd : this.cursorPosition;
        int remainingSpace = max - this.text.length() - (selectionStart - selectionEnd);
        if (((CharSequence)this.text).length() == 0) {
            string2 = "";
        } else {
            String string3 = this.text.substring(0, selectionStart);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        }
        String fakeBuildStart = build = string2;
        String set = null;
        if (remainingSpace < allowed.length()) {
            Intrinsics.checkNotNull((Object)allowed);
            String string4 = allowed.substring(0, remainingSpace);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
        } else {
            Intrinsics.checkNotNull((Object)allowed);
            string = allowed;
        }
        set = string;
        build = build + set;
        String fakeBuildEnd = "";
        if (!(((CharSequence)this.text).length() == 0) && selectionEnd < this.text.length()) {
            String string5 = this.text.substring(selectionEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
            fakeBuildEnd = string5;
            build = build + fakeBuildEnd;
        }
        if (!(editEvent = (TextEditEvent)this.BUS.fire((Event)new TextEditEvent(set, build))).isCanceled()) {
            String section = editEvent.getSection();
            this.setText(fakeBuildStart + section + fakeBuildEnd);
            this.shiftCursor(selectionStart - this.selectionEnd + section.length());
        }
    }

    public final void deleteWords(int count) {
        if (!(((CharSequence)this.text).length() == 0)) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                this.deleteFromCursor(this.getWordStartingFromCursor(count) - this.cursorPosition);
            }
        }
    }

    public final void deleteFromCursor(int count) {
        if (!(((CharSequence)this.text).length() == 0)) {
            if (this.selectionEnd != this.cursorPosition) {
                this.writeText("");
            } else {
                TextEditEvent editEvent;
                String build;
                String string;
                int end;
                boolean backwards = count < 0;
                int start = backwards ? this.cursorPosition + count : this.cursorPosition;
                int n = end = backwards ? this.cursorPosition : this.cursorPosition + count;
                if (start >= 0) {
                    String string2 = this.text.substring(0, start);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = "";
                }
                String buildStart = build = string;
                String buildEnd = "";
                if (end < this.text.length()) {
                    String string3 = this.text.substring(end);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                    buildEnd = string3;
                    build = build + buildEnd;
                }
                if (!(editEvent = (TextEditEvent)this.BUS.fire((Event)new TextEditEvent("", build))).isCanceled()) {
                    String section = editEvent.getSection();
                    this.setText(buildStart + section + buildEnd);
                    if (backwards) {
                        this.shiftCursor(count);
                    }
                }
            }
        }
    }

    public final int getWordStartingFromCursor(int relativeIndex) {
        return this.getWord(relativeIndex, this.cursorPosition);
    }

    public final int getWord(int relativeIndex, int startingPos) {
        return this.getWordSkippingWhitespace(relativeIndex, startingPos, true);
    }

    public final int getWordSkippingWhitespace(int relativeIndex, int startingPos, boolean skipWhitespace) {
        int pos2 = startingPos;
        boolean backwards = relativeIndex < 0;
        int toSearch = Math.abs(relativeIndex);
        for (int i = 0; i < toSearch; ++i) {
            if (!backwards) {
                int length = this.text.length();
                if ((pos2 = StringsKt.indexOf$default((CharSequence)this.text, (char)' ', (int)pos2, (boolean)false, (int)4, null)) == -1) {
                    pos2 = length;
                    continue;
                }
                while (skipWhitespace && pos2 < length && this.text.charAt(pos2) == ' ') {
                    ++pos2;
                }
                continue;
            }
            while (skipWhitespace && pos2 > 0 && this.text.charAt(pos2 - 1) == ' ') {
                --pos2;
            }
            while (pos2 > 0 && this.text.charAt(pos2 - 1) != ' ') {
                --pos2;
            }
        }
        return pos2;
    }

    public final void shiftCursor(int num) {
        this.setCursorPosition(this.selectionEnd + num);
    }

    public final void cursorToStart() {
        this.setCursorPosition(0);
    }

    public final void cursorToEnd() {
        this.setCursorPosition(this.text.length());
    }

    public final boolean handleKeyTyped(char input, int inputCode) {
        if (!this.isFocused && !this.autoFocus.getValue(this).booleanValue()) {
            return false;
        }
        if (GuiScreen.func_175278_g((int)inputCode)) {
            this.cursorToEnd();
            this.setSelectionPosition(0);
            return true;
        }
        if (GuiScreen.func_175280_f((int)inputCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            return true;
        }
        if (GuiScreen.func_175279_e((int)inputCode)) {
            if (this.isEnabled) {
                String string = GuiScreen.func_146277_j();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClipboardString(...)");
                this.writeText(string);
            }
            return true;
        }
        if (GuiScreen.func_175277_d((int)inputCode)) {
            GuiScreen.func_146275_d((String)this.getSelectedText());
            if (this.isEnabled) {
                this.writeText("");
            }
            return true;
        }
        switch (inputCode) {
            case 14: {
                if (this.isEnabled) {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWords(-1);
                    } else {
                        this.deleteFromCursor(-1);
                    }
                }
                return true;
            }
            case 199: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPosition(0);
                } else {
                    this.cursorToStart();
                }
                return true;
            }
            case 203: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPosition(this.getWord(-1, this.selectionEnd));
                    } else {
                        this.setSelectionPosition(this.selectionEnd - 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getWordStartingFromCursor(-1));
                } else {
                    this.shiftCursor(-1);
                }
                return true;
            }
            case 205: {
                if (GuiScreen.func_146272_n()) {
                    if (GuiScreen.func_146271_m()) {
                        this.setSelectionPosition(this.getWord(1, this.selectionEnd));
                    } else {
                        this.setSelectionPosition(this.selectionEnd + 1);
                    }
                } else if (GuiScreen.func_146271_m()) {
                    this.setCursorPosition(this.getWordStartingFromCursor(1));
                } else {
                    this.shiftCursor(1);
                }
                return true;
            }
            case 207: {
                if (GuiScreen.func_146272_n()) {
                    this.setSelectionPosition(this.text.length());
                } else {
                    this.cursorToEnd();
                }
                return true;
            }
            case 211: {
                if (this.isEnabled) {
                    if (GuiScreen.func_146271_m()) {
                        this.deleteWords(1);
                    } else {
                        this.deleteFromCursor(1);
                    }
                }
                return true;
            }
            case 28: {
                this.BUS.fire((Event)new TextSentEvent(this.text));
                return true;
            }
        }
        if (!this.useVanillaFilter.invoke(this).booleanValue() || ChatAllowedCharacters.func_71566_a((char)input)) {
            if (this.isEnabled) {
                String string = Character.toString(input);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                this.writeText(string);
            }
            return true;
        }
        return false;
    }

    public final boolean mouseClicked(int mouseX, int mouseY, int mouseButton) {
        boolean bl;
        boolean withinBoundary;
        boolean bl2 = withinBoundary = mouseX >= ClientUtilMethods.getX(this) && mouseX < ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this) && mouseY >= ClientUtilMethods.getY(this) && mouseY < ClientUtilMethods.getY(this) + ClientUtilMethods.getHeight(this);
        if (this.canLoseFocus.getValue(this).booleanValue()) {
            this.setFocused(withinBoundary);
        }
        if (this.isFocused && withinBoundary && mouseButton == 0) {
            int xFromLeft = mouseX - ClientUtilMethods.getX(this);
            String string = this.text.substring(this.lineScrollOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String visible = this.fontRenderer.func_78269_a(string, ClientUtilMethods.getWidth(this));
            this.setCursorPosition(this.fontRenderer.func_78269_a(visible, xFromLeft).length() + this.lineScrollOffset);
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private final int drawString(String text, float x, float y, int color) {
        return this.fontRenderer.func_175065_a(text, x, y, color, this.useShadow.invoke(this).booleanValue());
    }

    public final void drawTextBox() {
        if (this.isVisible()) {
            int max = ((Number)this.maxStringLength.getValue(this)).intValue();
            int textColor = this.isEnabled ? this.enabledColor.getValue(this).getRGB() : this.disabledColor.getValue(this).getRGB();
            int cursorRelativePosition = this.cursorPosition - this.lineScrollOffset;
            int selectionEndPosition = this.selectionEnd - this.lineScrollOffset;
            String string = this.text.substring(this.lineScrollOffset);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String visible = this.fontRenderer.func_78269_a(string, ClientUtilMethods.getWidth(this) - this.fontRenderer.func_78256_a("_"));
            boolean cursorVisible = cursorRelativePosition >= 0 && cursorRelativePosition <= visible.length();
            boolean cursorBlinkActive = this.isFocused && this.cursorCounter / 12 % 2 == 0 && cursorVisible;
            int offset = ClientUtilMethods.getX(this);
            if (selectionEndPosition > visible.length()) {
                selectionEndPosition = visible.length();
            }
            Intrinsics.checkNotNull((Object)visible);
            if (!(((CharSequence)visible).length() == 0)) {
                String string2;
                if (cursorVisible) {
                    String string3 = visible.substring(0, cursorRelativePosition);
                    string2 = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                } else {
                    string2 = visible;
                }
                String toCursor = string2;
                Intrinsics.checkNotNull((Object)toCursor);
                offset = this.drawString(toCursor, offset, ClientUtilMethods.getY(this), textColor);
            }
            boolean cursorInText = this.cursorPosition < this.text.length() || this.text.length() >= max;
            int unselectedBound = offset--;
            if (!cursorVisible) {
                unselectedBound = cursorRelativePosition > 0 ? ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this) - this.fontRenderer.func_78256_a("_") : ClientUtilMethods.getX(this);
            } else if (cursorInText) {
                unselectedBound = offset;
            }
            if (!(((CharSequence)visible).length() == 0) && cursorVisible && cursorRelativePosition < visible.length()) {
                String string4 = visible.substring(cursorRelativePosition);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                this.drawString(string4, offset, ClientUtilMethods.getY(this), textColor);
            }
            if (cursorBlinkActive) {
                if (cursorInText) {
                    Gui.func_73734_a((int)unselectedBound, (int)(ClientUtilMethods.getY(this) - 1), (int)(unselectedBound + 1), (int)(ClientUtilMethods.getY(this) + 2 + this.fontRenderer.field_78288_b), (int)this.cursorColor.getValue(this).getRGB());
                    GlStateManager.func_179147_l();
                } else {
                    this.drawString("_", unselectedBound, ClientUtilMethods.getY(this) + 1, textColor);
                }
            }
            if (selectionEndPosition != cursorRelativePosition) {
                int n = ClientUtilMethods.getX(this);
                String string5 = visible.substring(0, selectionEndPosition);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                int selectionX = n + this.fontRenderer.func_78256_a(string5);
                this.drawSelectionBox(unselectedBound, ClientUtilMethods.getY(this), selectionX - 1, ClientUtilMethods.getY(this) + this.fontRenderer.field_78288_b);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private final void drawSelectionBox(int startX, int startY, int endX, int endY) {
        int minX = Math.min(startX, endX);
        int maxX = Math.max(startX, endX);
        int minY = Math.min(startY, endY);
        int maxY = Math.max(startY, endY);
        if (minX > ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this)) {
            minX = ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this);
        }
        if (maxX > ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this)) {
            maxX = ClientUtilMethods.getX(this) + ClientUtilMethods.getWidth(this);
        }
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        ClientUtilMethods.glColor(this.selectionColor.getValue(this));
        GlStateManager.func_179090_x();
        GlStateManager.func_179115_u();
        GlStateManager.func_187422_a((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        bufferbuilder.func_181662_b((double)maxX, (double)minY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)minX, (double)minY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)minX, (double)maxY, 0.0).func_181675_d();
        bufferbuilder.func_181662_b((double)maxX, (double)maxY, 0.0).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179134_v();
        GlStateManager.func_179098_w();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public final void setSelectionPosition(int targetPosition) {
        int position = targetPosition;
        int length = this.text.length();
        if (position > length) {
            position = length;
        }
        if (position < 0) {
            position = 0;
        }
        this.selectionEnd = position;
        if (this.lineScrollOffset > length) {
            this.lineScrollOffset = length;
        }
        int boxWidth = ClientUtilMethods.getWidth(this) - this.fontRenderer.func_78256_a("_");
        String string = this.text.substring(this.lineScrollOffset);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String visible = this.fontRenderer.func_78269_a(string, boxWidth);
        int positionInOverall = visible.length() + this.lineScrollOffset;
        if (position == this.lineScrollOffset) {
            this.lineScrollOffset -= this.fontRenderer.func_78262_a(this.text, boxWidth, true).length();
        }
        if (position > positionInOverall) {
            this.lineScrollOffset += position - positionInOverall;
        } else if (position <= this.lineScrollOffset) {
            this.lineScrollOffset -= this.lineScrollOffset - position;
        }
        this.lineScrollOffset = MathHelper.func_76125_a((int)this.lineScrollOffset, (int)0, (int)length);
    }

    private static final Unit _init_$lambda$0(ComponentTextField this$0, GuiComponentEvents.MouseDownEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.mouseClicked(it.getMousePos().getXi(), it.getMousePos().getYi(), it.getButton().getMouseCode());
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(ComponentTextField this$0, GuiComponentEvents.KeyDownEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.handleKeyTyped(it.getKey(), it.getKeyCode())) {
            this$0.setFocused(true);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$2(ComponentTextField this$0, GuiComponentEvents.ComponentTickEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateCursorCounter();
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/components/ComponentTextField$FocusEvent;", "Lcom/teamwizardry/librarianlib/features/eventbus/EventCancelable;", "wasFocused", "", "<init>", "(Z)V", "getWasFocused", "()Z", "LibrarianLib-Continuous-1.12.2"})
    public static final class FocusEvent
    extends EventCancelable {
        private final boolean wasFocused;

        public FocusEvent(boolean wasFocused) {
            super(false, 1, null);
            this.wasFocused = wasFocused;
        }

        public final boolean getWasFocused() {
            return this.wasFocused;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\f"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/components/ComponentTextField$TextEditEvent;", "Lcom/teamwizardry/librarianlib/features/eventbus/EventCancelable;", "section", "", "whole", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getSection", "()Ljava/lang/String;", "setSection", "(Ljava/lang/String;)V", "getWhole", "LibrarianLib-Continuous-1.12.2"})
    public static final class TextEditEvent
    extends EventCancelable {
        @NotNull
        private String section;
        @NotNull
        private final String whole;

        public TextEditEvent(@NotNull String section, @NotNull String whole) {
            Intrinsics.checkNotNullParameter((Object)section, (String)"section");
            Intrinsics.checkNotNullParameter((Object)whole, (String)"whole");
            super(false, 1, null);
            this.section = section;
            this.whole = whole;
        }

        @NotNull
        public final String getSection() {
            return this.section;
        }

        public final void setSection(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.section = string;
        }

        @NotNull
        public final String getWhole() {
            return this.whole;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/components/ComponentTextField$TextSentEvent;", "Lcom/teamwizardry/librarianlib/features/eventbus/Event;", "content", "", "<init>", "(Ljava/lang/String;)V", "getContent", "()Ljava/lang/String;", "LibrarianLib-Continuous-1.12.2"})
    public static final class TextSentEvent
    extends Event {
        @NotNull
        private final String content;

        public TextSentEvent(@NotNull String content) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            super(false, 1, null);
            this.content = content;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }
    }
}

