/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.teamwizardry.librarianlib.core.LibrarianLib;
import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibCommonProxy;
import com.teamwizardry.librarianlib.features.gui.component.GuiComponent;
import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.Bookmark;
import com.teamwizardry.librarianlib.features.gui.provided.book.context.PaginationContext;
import com.teamwizardry.librarianlib.features.gui.provided.book.helper.TranslationHolder;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.IBookElement;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.book.ComponentMainIndex;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.category.Category;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.page.Page;
import com.teamwizardry.librarianlib.features.gui.provided.book.search.SearchBookmark;
import com.teamwizardry.librarianlib.features.helpers.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import java.awt.Color;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 N2\u00020\u0001:\u0001NB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\b\u0010E\u001a\u00020FH\u0016J\u0016\u0010G\u001a\b\u0012\u0004\u0012\u00020H0\f2\u0006\u0010I\u001a\u00020JH\u0017J\u001e\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\f2\u000e\u0010M\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0013X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017R\u001a\u0010\u001b\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u001e\"\u0004\b#\u0010 R\u001a\u0010$\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u001e\"\u0004\b&\u0010 R\u001a\u0010'\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u001e\"\u0004\b)\u0010 R\u001a\u0010*\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010\bR\u001a\u0010.\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u001e\"\u0004\b0\u0010 R\u001a\u00101\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\u001e\"\u0004\b3\u0010 R\u001a\u00104\u001a\u00020\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001e\"\u0004\b6\u0010 R$\u00109\u001a\u0002082\u0006\u00107\u001a\u000208@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R \u0010=\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020\u00070>8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b@\u0010AR\u0011\u0010B\u001a\u00020\u00008F\u00a2\u0006\u0006\u001a\u0004\bC\u0010D\u00a8\u0006O"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/IBookElement;", "location", "Lnet/minecraft/util/ResourceLocation;", "<init>", "(Lnet/minecraft/util/ResourceLocation;)V", "name", "", "(Ljava/lang/String;)V", "getLocation", "()Lnet/minecraft/util/ResourceLocation;", "categories", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/category/Category;", "getCategories", "()Ljava/util/List;", "setCategories", "(Ljava/util/List;)V", "header", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "getHeader", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;", "setHeader", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/helper/TranslationHolder;)V", "subtitle", "getSubtitle", "setSubtitle", "bookColor", "Ljava/awt/Color;", "getBookColor", "()Ljava/awt/Color;", "setBookColor", "(Ljava/awt/Color;)V", "entryTitleTextColor", "getEntryTitleTextColor", "setEntryTitleTextColor", "bindingColor", "getBindingColor", "setBindingColor", "highlightColor", "getHighlightColor", "setHighlightColor", "textureSheet", "getTextureSheet", "()Ljava/lang/String;", "setTextureSheet", "searchTextColor", "getSearchTextColor", "setSearchTextColor", "searchTextHighlight", "getSearchTextHighlight", "setSearchTextHighlight", "searchTextCursor", "getSearchTextCursor", "setSearchTextCursor", "value", "", "isValid", "()Z", "setValid", "(Z)V", "contentCache", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "getContentCache", "()Ljava/util/Map;", "bookParent", "getBookParent", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "reload", "", "createComponents", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/context/PaginationContext;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "addAllBookmarks", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/context/Bookmark;", "list", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nBook.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Book.kt\ncom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,191:1\n1557#2:192\n1628#2,3:193\n774#2:196\n865#2,2:197\n1#3:199\n*S KotlinDebug\n*F\n+ 1 Book.kt\ncom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book\n*L\n124#1:192\n124#1:193,3\n125#1:196\n125#1:197,2\n*E\n"})
public class Book
implements IBookElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResourceLocation location;
    @NotNull
    private List<Category> categories;
    @Nullable
    private TranslationHolder header;
    @Nullable
    private TranslationHolder subtitle;
    @NotNull
    private Color bookColor;
    @NotNull
    private Color entryTitleTextColor;
    @NotNull
    private Color bindingColor;
    @NotNull
    private Color highlightColor;
    @NotNull
    private String textureSheet;
    @NotNull
    private Color searchTextColor;
    @NotNull
    private Color searchTextHighlight;
    @NotNull
    private Color searchTextCursor;
    private boolean isValid;
    private static boolean hasEverReloaded;
    @NotNull
    private static final List<Book> allBooks;

    public Book(@NotNull ResourceLocation location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        this.location = location;
        this.categories = CollectionsKt.emptyList();
        Color color = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
        this.bookColor = color;
        Color color2 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"WHITE");
        this.entryTitleTextColor = color2;
        Color color3 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"WHITE");
        this.bindingColor = color3;
        Color color4 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"WHITE");
        this.highlightColor = color4;
        this.textureSheet = "";
        Color color5 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"WHITE");
        this.searchTextColor = color5;
        Color color6 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
        this.searchTextHighlight = color6;
        Color color7 = Color.WHITE;
        Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"WHITE");
        this.searchTextCursor = color7;
        allBooks.add(this);
        if (hasEverReloaded) {
            this.reload();
        }
    }

    @NotNull
    public final ResourceLocation getLocation() {
        return this.location;
    }

    public Book(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(Book.Companion.makeResource(name));
    }

    @NotNull
    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(@NotNull List<Category> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.categories = list;
    }

    @Nullable
    public TranslationHolder getHeader() {
        return this.header;
    }

    public void setHeader(@Nullable TranslationHolder translationHolder) {
        this.header = translationHolder;
    }

    @Nullable
    public TranslationHolder getSubtitle() {
        return this.subtitle;
    }

    public void setSubtitle(@Nullable TranslationHolder translationHolder) {
        this.subtitle = translationHolder;
    }

    @NotNull
    public Color getBookColor() {
        return this.bookColor;
    }

    public void setBookColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.bookColor = color;
    }

    @NotNull
    public Color getEntryTitleTextColor() {
        return this.entryTitleTextColor;
    }

    public void setEntryTitleTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.entryTitleTextColor = color;
    }

    @NotNull
    public Color getBindingColor() {
        return this.bindingColor;
    }

    public void setBindingColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.bindingColor = color;
    }

    @NotNull
    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.highlightColor = color;
    }

    @NotNull
    public String getTextureSheet() {
        return this.textureSheet;
    }

    public void setTextureSheet(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.textureSheet = string;
    }

    @NotNull
    public Color getSearchTextColor() {
        return this.searchTextColor;
    }

    public void setSearchTextColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.searchTextColor = color;
    }

    @NotNull
    public Color getSearchTextHighlight() {
        return this.searchTextHighlight;
    }

    public void setSearchTextHighlight(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.searchTextHighlight = color;
    }

    @NotNull
    public Color getSearchTextCursor() {
        return this.searchTextCursor;
    }

    public void setSearchTextCursor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"<set-?>");
        this.searchTextCursor = color;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    protected final void setValid(boolean bl) {
        this.isValid = bl;
    }

    @SideOnly(value=Side.CLIENT)
    @NotNull
    public Map<Entry, String> getContentCache() {
        Map searchCache = new LinkedHashMap();
        for (Category category : this.getCategories()) {
            for (Entry entry : category.getEntries()) {
                StringBuilder searchBuilder = new StringBuilder();
                searchBuilder.append(String.valueOf(entry.getTitle())).append(' ').append(String.valueOf(entry.getDesc())).append(' ');
                for (Page page : entry.getPages()) {
                    Collection<String> searchable = page.getSearchableKeys();
                    if (searchable != null) {
                        for (String key : searchable) {
                            searchBuilder.append(I18n.func_135052_a((String)key, (Object[])new Object[0])).append(' ');
                        }
                    }
                    if ((searchable = page.getSearchableStrings()) == null) continue;
                    for (String value : searchable) {
                        searchBuilder.append(value).append(' ');
                    }
                }
                searchCache.put(entry, searchBuilder.toString());
            }
        }
        return searchCache;
    }

    @Override
    @NotNull
    public final Book getBookParent() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public void reload() {
        this.isValid = false;
        try {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            Category it;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            Color color;
            Color color2;
            Color color3;
            String string;
            Color color4;
            Color color5;
            JsonElement jsonElement = Companion.getJsonFromLink(this.location);
            if (jsonElement == null) {
                throw new FileNotFoundException(this.location.toString());
            }
            if (!jsonElement.isJsonObject()) {
                throw new JsonSyntaxException(this.location.toString());
            }
            JsonObject json = jsonElement.getAsJsonObject();
            if (json.has("color")) {
                JsonElement jsonElement2 = json.get("color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement2, (String)"get(...)");
                color5 = Companion.colorFromJson(jsonElement2);
            } else {
                Color color6 = Color.WHITE;
                color5 = color6;
                Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"WHITE");
            }
            this.setBookColor(color5);
            if (json.has("binding")) {
                JsonElement jsonElement3 = json.get("binding");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement3, (String)"get(...)");
                color4 = Companion.colorFromJson(jsonElement3);
            } else {
                Color color7 = this.getBookColor().brighter().brighter();
                color4 = color7;
                Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"brighter(...)");
            }
            this.setBindingColor(color4);
            JsonElement jsonElement4 = json.get("highlight");
            Intrinsics.checkNotNullExpressionValue((Object)jsonElement4, (String)"get(...)");
            this.setHighlightColor(Companion.colorFromJson(jsonElement4));
            this.setHeader(TranslationHolder.Companion.fromJson(json.get("title")));
            this.setSubtitle(TranslationHolder.Companion.fromJson(json.get("subtitle")));
            if (json.has("texture_sheet")) {
                String string2 = json.getAsJsonPrimitive("texture_sheet").getAsString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAsString(...)");
            } else {
                string = "librarianlib:gui/book/guide_book";
            }
            this.setTextureSheet(string);
            if (json.has("search_text_color")) {
                JsonElement jsonElement5 = json.get("search_text_color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement5, (String)"get(...)");
                color3 = Companion.colorFromJson(jsonElement5);
            } else {
                Color color8 = Color.WHITE;
                color3 = color8;
                Intrinsics.checkNotNullExpressionValue((Object)color8, (String)"WHITE");
            }
            this.setSearchTextColor(color3);
            if (json.has("search_highlight_color")) {
                JsonElement jsonElement6 = json.get("search_highlight_color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement6, (String)"get(...)");
                color2 = Companion.colorFromJson(jsonElement6);
            } else {
                Color color9 = Color.BLUE;
                color2 = color9;
                Intrinsics.checkNotNullExpressionValue((Object)color9, (String)"BLUE");
            }
            this.setSearchTextHighlight(color2);
            if (json.has("search_cursor_color")) {
                JsonElement jsonElement7 = json.get("search_cursor_color");
                Intrinsics.checkNotNullExpressionValue((Object)jsonElement7, (String)"get(...)");
                color = Companion.colorFromJson(jsonElement7);
            } else {
                color = new Color(0xD0D0D0);
            }
            this.setSearchTextCursor(color);
            JsonArray allCategories = json.getAsJsonArray("categories");
            Intrinsics.checkNotNull((Object)allCategories);
            Iterable iterable = (Iterable)allCategories;
            Book book = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonElement jsonElement8 = (JsonElement)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                JsonObject jsonObject = it.getAsJsonObject();
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"getAsJsonObject(...)");
                collection.add(new Category(this, jsonObject));
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$filter = false;
            $this$mapTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Category)element$iv$iv;
                boolean bl = false;
                if (!it.isValid()) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            book.setCategories((List)destination$iv$iv);
            this.isValid = true;
        }
        catch (Exception error) {
            LibrarianLog.INSTANCE.error(error, "Failed trying to parse a book component", new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    public List<PaginationContext> createComponents(@NotNull IBookGui book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        book.updateTextureData(this.getTextureSheet(), this.getBookColor(), this.getBindingColor());
        int n = ComponentMainIndex.Companion.numberOfPages(book);
        ArrayList<PaginationContext> arrayList = new ArrayList<PaginationContext>(n);
        int n2 = 0;
        while (n2 < n) {
            void it;
            int n3;
            int n4 = n3 = n2++;
            ArrayList<PaginationContext> arrayList2 = arrayList;
            boolean bl = false;
            arrayList2.add(new PaginationContext((Function0<? extends GuiComponent>)((Function0)() -> Book.createComponents$lambda$3$lambda$2(book, (int)it))));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<Bookmark> addAllBookmarks(@Nullable List<? extends Bookmark> list) {
        List newList = new ArrayList();
        if (list != null) {
            newList.addAll((Collection)list);
        }
        newList.add(new SearchBookmark());
        return newList;
    }

    private static final GuiComponent createComponents$lambda$3$lambda$2(IBookGui $book, int $it) {
        Intrinsics.checkNotNullParameter((Object)$book, (String)"$book");
        return new ComponentMainIndex($book, $it);
    }

    private static final void _init_$lambda$4() {
        hasEverReloaded = true;
        for (Book book : allBooks) {
            book.reload();
        }
    }

    static {
        allBooks = new ArrayList();
        ClientRunnable.registerReloadHandler(Book::_init_$lambda$4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0007J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0005R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book$Companion;", "", "<init>", "()V", "makeResource", "Lnet/minecraft/util/ResourceLocation;", "str", "", "hasEverReloaded", "", "getHasEverReloaded", "()Z", "setHasEverReloaded", "(Z)V", "allBooks", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/book/Book;", "colorFromJson", "Ljava/awt/Color;", "element", "Lcom/google/gson/JsonElement;", "getJsonFromLink", "location", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        private final ResourceLocation makeResource(String str) {
            ResourceLocation resource = new ResourceLocation(str);
            return new ResourceLocation(CommonUtilMethods.getCurrentModId(), resource.func_110623_a());
        }

        public final boolean getHasEverReloaded() {
            return hasEverReloaded;
        }

        public final void setHasEverReloaded(boolean bl) {
            hasEverReloaded = bl;
        }

        @NotNull
        public final Color colorFromJson(@NotNull JsonElement element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            if (element.isJsonPrimitive()) {
                Color color;
                JsonPrimitive primitive = element.getAsJsonPrimitive();
                if (primitive.isNumber()) {
                    color = new Color(primitive.getAsInt());
                } else {
                    Integer n = Integer.decode(element.getAsString());
                    Intrinsics.checkNotNull((Object)n);
                    color = new Color(n);
                }
                return color;
            }
            if (element.isJsonArray()) {
                JsonArray array = element.getAsJsonArray();
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            Color color = Color.WHITE;
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"WHITE");
            return color;
        }

        @Nullable
        public final JsonElement getJsonFromLink(@NotNull String location) {
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            return this.getJsonFromLink(new ResourceLocation(location));
        }

        @Nullable
        public final JsonElement getJsonFromLink(@NotNull ResourceLocation location) {
            InputStream stream;
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            LibCommonProxy libCommonProxy = LibrarianLib.INSTANCE.getPROXY();
            String string = location.func_110624_b();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNamespace(...)");
            InputStream inputStream = libCommonProxy.getResource(string, "book/" + location.func_110623_a() + ".json");
            if (inputStream == null) {
                return null;
            }
            InputStream inputStream2 = stream = inputStream;
            Charset charset = Charsets.UTF_8;
            return new JsonParser().parse((Reader)new InputStreamReader(inputStream2, charset));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

