/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.criterion;

import com.google.gson.JsonObject;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.criterion.ICriterion;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.criterion.game.CriterionCode;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00062\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000e2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u0006J\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u000eR&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/criterion/CriterionTypes;", "", "<init>", "()V", "criterionTypes", "", "", "Lkotlin/Function1;", "Lcom/google/gson/JsonObject;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/criterion/ICriterion;", "registerCriterion", "", "name", "provider", "Lnet/minecraft/util/ResourceLocation;", "getCriterion", "type", "LibrarianLib-Continuous-1.12.2"})
public final class CriterionTypes {
    @NotNull
    public static final CriterionTypes INSTANCE = new CriterionTypes();
    @NotNull
    private static final Map<String, Function1<JsonObject, ICriterion>> criterionTypes = new LinkedHashMap();

    private CriterionTypes() {
    }

    public final void registerCriterion(@NotNull String name, @NotNull Function1<? super JsonObject, ? extends ICriterion> provider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        this.registerCriterion(new ResourceLocation(name), provider);
    }

    public final void registerCriterion(@NotNull ResourceLocation name, @NotNull Function1<? super JsonObject, ? extends ICriterion> provider) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        String string = name.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String key = string;
        if (!criterionTypes.containsKey(key)) {
            criterionTypes.put(key, provider);
        }
    }

    @Nullable
    public final Function1<JsonObject, ICriterion> getCriterion(@NotNull String type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        String string = type;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return this.getCriterion(new ResourceLocation(string2));
    }

    @Nullable
    public final Function1<JsonObject, ICriterion> getCriterion(@NotNull ResourceLocation type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return criterionTypes.getOrDefault(type.toString(), null);
    }

    private static final ICriterion _init_$lambda$0(JsonObject it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new CriterionCode();
    }

    static {
        INSTANCE.registerCriterion("and", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)1.INSTANCE));
        INSTANCE.registerCriterion("or", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)2.INSTANCE));
        INSTANCE.registerCriterion("not", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)3.INSTANCE));
        INSTANCE.registerCriterion("choose", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)4.INSTANCE));
        INSTANCE.registerCriterion("xor", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)5.INSTANCE));
        INSTANCE.registerCriterion("entry", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)6.INSTANCE));
        INSTANCE.registerCriterion("advancement", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)7.INSTANCE));
        INSTANCE.registerCriterion("manual", (Function1<? super JsonObject, ? extends ICriterion>)((Function1)CriterionTypes::_init_$lambda$0));
    }
}

