/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.gui.provided.book.search;

import com.teamwizardry.librarianlib.features.gui.provided.book.IBookGui;
import com.teamwizardry.librarianlib.features.gui.provided.book.hierarchy.entry.Entry;
import com.teamwizardry.librarianlib.features.gui.provided.book.search.ISearchAlgorithm;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u000b\fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm;", "book", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;", "<init>", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/IBookGui;)V", "search", "", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "input", "", "FrequencySearchResult", "MatchCountSearchResult", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nTFIDFSearch.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TFIDFSearch.kt\ncom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,118:1\n739#2,9:119\n739#2,9:130\n1187#2,2:139\n1261#2,2:141\n1782#2,4:143\n1264#2:147\n774#2:149\n865#2,2:150\n1557#2:152\n1628#2,3:153\n1782#2,4:156\n37#3,2:128\n1#4:148\n11102#5:160\n11437#5,3:161\n*S KotlinDebug\n*F\n+ 1 TFIDFSearch.kt\ncom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch\n*L\n22#1:119,9\n36#1:130,9\n38#1:139,2\n38#1:141,2\n38#1:143,4\n38#1:147\n52#1:149\n52#1:150,2\n53#1:152\n53#1:153,3\n54#1:156,4\n22#1:128,2\n94#1:160\n94#1:161,3\n*E\n"})
public final class TFIDFSearch
implements ISearchAlgorithm {
    @NotNull
    private final IBookGui book;

    public TFIDFSearch(@NotNull IBookGui book) {
        Intrinsics.checkNotNullParameter((Object)book, (String)"book");
        this.book = book;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public List<ISearchAlgorithm.Result> search(@NotNull String input) {
        Collection collection;
        Object keyword;
        void $this$toTypedArray$iv;
        List list;
        Collection $this$dropLastWhile$iv;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        String string = StringsKt.replace$default((String)input, (String)"'", (String)"", (boolean)false, (int)4, null);
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String query = string2;
        Object object = query;
        Regex regex = new Regex(" ");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$dropLastWhile = false;
        if (!$this$dropLastWhile$iv.isEmpty()) {
            ListIterator iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
            while (iterator$iv.hasPrevious()) {
                String it = (String)iterator$iv.previous();
                boolean bl = false;
                if (((CharSequence)it).length() == 0) continue;
                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                break;
            }
        } else {
            list = CollectionsKt.emptyList();
        }
        $this$dropLastWhile$iv = list;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] keywords = thisCollection$iv.toArray(new String[0]);
        ArrayList<FrequencySearchResult> unfilteredTfidfResults = new ArrayList<FrequencySearchResult>();
        ArrayList<MatchCountSearchResult> matchCountSearchResults = new ArrayList<MatchCountSearchResult>();
        Map<Entry, String> contentCache = this.book.getCachedSearchContent();
        int nbOfDocuments = contentCache.size();
        for (Entry cachedEntry : contentCache.keySet()) {
            Map.Entry mostRepeatedWord;
            Object it32;
            Object t;
            Map map;
            Object $this$associateTo$iv$iv22;
            void $this$associate$iv;
            List list2;
            void $this$dropLastWhile$iv2;
            Intrinsics.checkNotNull((Object)player);
            if (!cachedEntry.isUnlocked((EntityPlayer)player)) continue;
            String string3 = contentCache.getOrDefault(cachedEntry, "");
            Locale locale2 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"ROOT");
            String string4 = string3.toLowerCase(locale2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            String cachedDocument = StringsKt.replace$default((String)string4, (String)"'", (String)"", (boolean)false, (int)4, null);
            Object object2 = cachedDocument;
            Regex regex2 = new Regex("\\s+");
            int n2 = 0;
            object2 = regex2.split((CharSequence)object2, n2);
            boolean $i$f$dropLastWhile22 = false;
            if (!$this$dropLastWhile$iv2.isEmpty()) {
                ListIterator iterator$iv = $this$dropLastWhile$iv2.listIterator($this$dropLastWhile$iv2.size());
                while (iterator$iv.hasPrevious()) {
                    String it = (String)iterator$iv.previous();
                    boolean bl = false;
                    if (((CharSequence)it).length() == 0) continue;
                    list2 = CollectionsKt.take((Iterable)((Iterable)$this$dropLastWhile$iv2), (int)(iterator$iv.nextIndex() + 1));
                    break;
                }
            } else {
                list2 = CollectionsKt.emptyList();
            }
            List words = list2;
            Iterable $i$f$dropLastWhile22 = CollectionsKt.toSet((Iterable)words);
            boolean $i$f$associate22 = false;
            int capacity$iv222 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            void bl = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv222);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv22) {
                int n3;
                void $this$count$iv;
                map = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable = words;
                String string5 = it;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n3 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        String word = (String)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)word, (Object)it) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n3 = count$iv;
                }
                int n4 = n3;
                it = TuplesKt.to((Object)string5, (Object)n4);
                map.put(it.getFirst(), it.getSecond());
            }
            Iterable $i$f$associate22 = destination$iv$iv.entrySet();
            Iterator capacity$iv222 = $i$f$associate22.iterator();
            if (!capacity$iv222.hasNext()) {
                throw new NoSuchElementException();
            }
            $this$associateTo$iv$iv22 = capacity$iv222.next();
            if (!capacity$iv222.hasNext()) {
                t = $this$associateTo$iv$iv22;
            } else {
                Map.Entry it22 = (Map.Entry)$this$associateTo$iv$iv22;
                boolean bl42 = false;
                int it22 = ((Number)it22.getValue()).intValue();
                do {
                    Object bl42 = capacity$iv222.next();
                    it32 = (Map.Entry)bl42;
                    boolean $i$a$-maxByOrThrow-TFIDFSearch$search$mostRepeatedWord$3 = false;
                    int it32 = ((Number)it32.getValue()).intValue();
                    if (it22 >= it32) continue;
                    $this$associateTo$iv$iv22 = bl42;
                    it22 = it32;
                } while (capacity$iv222.hasNext());
                t = $this$associateTo$iv$iv22;
            }
            if ((mostRepeatedWord = (Map.Entry)t) == null) continue;
            double documentTfidf = 0.0;
            int $this$associateTo$iv$iv22 = keywords.length;
            for (int capacity$iv222 = 0; capacity$iv222 < $this$associateTo$iv$iv22; ++capacity$iv222) {
                int n5;
                void $this$count$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv;
                Entry it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                keyword = keywords[capacity$iv222];
                it32 = (CharSequence)keyword;
                Regex $i$a$-maxByOrThrow-TFIDFSearch$search$mostRepeatedWord$3 = new Regex("[\\\\.+*?^$\\[\\](){}/'#:!=|]");
                map = TFIDFSearch::search$lambda$5;
                String pattern = "\\b" + $i$a$-maxByOrThrow-TFIDFSearch$search$mostRepeatedWord$3.replace((CharSequence)it32, (Function1)map);
                int keywordOccurance = SequencesKt.count((Sequence)Regex.findAll$default((Regex)new Regex(pattern), (CharSequence)cachedDocument, (int)0, (int)2, null)) - 1;
                double termFrequency = 0.5 + 0.5 * (double)keywordOccurance / ((Number)mostRepeatedWord.getValue()).doubleValue();
                Iterable bl2 = contentCache.keySet();
                boolean $i$f$filter = false;
                void var26_69 = $this$filter$iv;
                Object destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Entry)element$iv$iv;
                    boolean bl5 = false;
                    if (!it.isUnlocked((EntityPlayer)player)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv2;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (Entry)item$iv$iv;
                    collection = destination$iv$iv2;
                    boolean bl6 = false;
                    String string6 = contentCache.getOrDefault(it, "");
                    Locale locale3 = Locale.ROOT;
                    Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"ROOT");
                    String string7 = string6.toLowerCase(locale3);
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"toLowerCase(...)");
                    collection.add(string7);
                }
                $this$map$iv = (List)destination$iv$iv2;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n5 = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        String it2 = (String)element$iv;
                        boolean bl7 = false;
                        if (!StringsKt.contains$default((CharSequence)it2, (CharSequence)((CharSequence)keyword), (boolean)false, (int)2, null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n5 = count$iv;
                }
                int keywordDocumentOccurance = n5;
                keywordDocumentOccurance = keywordDocumentOccurance == 0 ? keywordDocumentOccurance + 1 : keywordDocumentOccurance;
                double inverseDocumentFrequency = Math.log(nbOfDocuments / keywordDocumentOccurance);
                double keywordTfidf = termFrequency * inverseDocumentFrequency;
                documentTfidf += keywordTfidf;
            }
            unfilteredTfidfResults.add(new FrequencySearchResult(cachedEntry, documentTfidf));
        }
        ArrayList<FrequencySearchResult> filteredTfidfResults = new ArrayList<FrequencySearchResult>();
        double largestTFIDF = 0.0;
        double smallestTFIDF = 2.147483647E9;
        Iterator iterator2 = unfilteredTfidfResults.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Object> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FrequencySearchResult resultItem2 = (FrequencySearchResult)e;
            largestTFIDF = resultItem2.getFrequency() > largestTFIDF ? resultItem2.getFrequency() : largestTFIDF;
            smallestTFIDF = resultItem2.getFrequency() < smallestTFIDF ? resultItem2.getFrequency() : smallestTFIDF;
        }
        Iterator iterator4 = unfilteredTfidfResults.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator4, (String)"iterator(...)");
        iterator3 = iterator4;
        while (iterator3.hasNext()) {
            Object e = iterator3.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            FrequencySearchResult resultItem = (FrequencySearchResult)e;
            double matchPercentage = Math.round((resultItem.getFrequency() - smallestTFIDF) / (largestTFIDF - smallestTFIDF) * (double)100);
            if (matchPercentage < 5.0 || Double.isNaN(matchPercentage)) continue;
            filteredTfidfResults.add(resultItem);
        }
        if (!filteredTfidfResults.isEmpty()) {
            return filteredTfidfResults;
        }
        for (Entry cachedComponent : contentCache.keySet()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNull((Object)player);
            if (!cachedComponent.isUnlocked((EntityPlayer)player)) continue;
            String $this$associateTo$iv$iv22 = contentCache.getOrDefault(cachedComponent, "");
            Locale locale4 = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale4, (String)"ROOT");
            String string8 = $this$associateTo$iv$iv22.toLowerCase(locale4);
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
            String cachedDocument = StringsKt.replace$default((String)string8, (String)"'", (String)"", (boolean)false, (int)4, null);
            keyword = keywords;
            boolean $i$f$map = false;
            void keywordOccurance = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n6 = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n6; ++i) {
                void it;
                void item$iv$iv;
                void keywordTfidf = item$iv$iv = $this$mapTo$iv$iv[i];
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringUtils.countMatches((CharSequence)cachedDocument, (CharSequence)((CharSequence)it)));
            }
            int mostMatches = CollectionsKt.sumOfInt((Iterable)((List)destination$iv$iv));
            if (mostMatches <= 0) continue;
            matchCountSearchResults.add(new MatchCountSearchResult(cachedComponent, mostMatches));
        }
        return !matchCountSearchResults.isEmpty() ? (List)matchCountSearchResults : null;
    }

    private static final CharSequence search$lambda$5(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return '\\' + it.getValue();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch$FrequencySearchResult;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "frequency", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;D)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "getFrequency", "()D", "isSpecificResult", "", "()Z", "LibrarianLib-Continuous-1.12.2"})
    public static final class FrequencySearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final double frequency;

        public FrequencySearchResult(@NotNull Entry entry, double frequency) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.frequency = frequency;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        @Override
        public double getFrequency() {
            return this.frequency;
        }

        @Override
        public boolean isSpecificResult() {
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/TFIDFSearch$MatchCountSearchResult;", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/search/ISearchAlgorithm$Result;", "entry", "Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "nbOfMatches", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;I)V", "getEntry", "()Lcom/teamwizardry/librarianlib/features/gui/provided/book/hierarchy/entry/Entry;", "isSpecificResult", "", "()Z", "frequency", "", "getFrequency", "()D", "LibrarianLib-Continuous-1.12.2"})
    public static final class MatchCountSearchResult
    implements ISearchAlgorithm.Result {
        @NotNull
        private final Entry entry;
        private final int nbOfMatches;

        public MatchCountSearchResult(@NotNull Entry entry, int nbOfMatches) {
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.entry = entry;
            this.nbOfMatches = nbOfMatches;
        }

        @Override
        @NotNull
        public Entry getEntry() {
            return this.entry;
        }

        @Override
        public boolean isSpecificResult() {
            return false;
        }

        @Override
        public double getFrequency() {
            return this.nbOfMatches;
        }
    }
}

