/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.kotlin;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=5, xi=48, d1={"\u0000J\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0018\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\n\u0010\u0005\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0006\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0007\u001a\n\u0010\b\u001a\u00020\u0007*\u00020\u0002\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\n\u001a\n\u0010\u000b\u001a\u00020\n*\u00020\u0002\u001a\u0012\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\r\u001a\n\u0010\u000e\u001a\u00020\r*\u00020\u0002\u001a\u0012\u0010\u000f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0002\u001a\u0012\u0010\u0012\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0013\u001a\u0016\u0010\u0014\u001a\u00020\u0013*\u00020\u00022\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0013\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0002\u001a\u0012\u0010\u001a\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u001b\u001a\f\u0010\u001c\u001a\u0004\u0018\u00010\u001b*\u00020\u0002\u00a8\u0006\u001d"}, d2={"writeString", "", "Lio/netty/buffer/ByteBuf;", "value", "", "readString", "writeStack", "Lnet/minecraft/item/ItemStack;", "readStack", "writeTag", "Lnet/minecraft/nbt/NBTTagCompound;", "readTag", "writeVarInt", "", "readVarInt", "writeVarLong", "", "readVarLong", "writeBooleanArray", "", "readBooleanArray", "tryReadInto", "writeNullSignature", "writeNonnullSignature", "hasNullSignature", "", "writeFluidStack", "Lnet/minecraftforge/fluids/FluidStack;", "readFluidStack", "LibrarianLib-Continuous-1.12.2"}, xs="com/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods")
@SourceDebugExtension(value={"SMAP\nExtByteBuf.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtByteBuf.kt\ncom/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods__ExtByteBufKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n774#2:141\n865#2,2:142\n1863#2,2:144\n*S KotlinDebug\n*F\n+ 1 ExtByteBuf.kt\ncom/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods__ExtByteBufKt\n*L\n91#1:141\n91#1:142,2\n92#1:144,2\n*E\n"})
final class CommonUtilMethods__ExtByteBufKt {
    public static final void writeString(@NotNull ByteBuf $this$writeString, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeString, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufUtils.writeUTF8String((ByteBuf)$this$writeString, (String)value);
    }

    @NotNull
    public static final String readString(@NotNull ByteBuf $this$readString) {
        Intrinsics.checkNotNullParameter((Object)$this$readString, (String)"<this>");
        String string = ByteBufUtils.readUTF8String((ByteBuf)$this$readString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF8String(...)");
        return string;
    }

    public static final void writeStack(@NotNull ByteBuf $this$writeStack, @NotNull ItemStack value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeStack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufUtils.writeItemStack((ByteBuf)$this$writeStack, (ItemStack)value);
    }

    @NotNull
    public static final ItemStack readStack(@NotNull ByteBuf $this$readStack) {
        Intrinsics.checkNotNullParameter((Object)$this$readStack, (String)"<this>");
        ItemStack itemStack = ByteBufUtils.readItemStack((ByteBuf)$this$readStack);
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"readItemStack(...)");
        return itemStack;
    }

    public static final void writeTag(@NotNull ByteBuf $this$writeTag, @NotNull NBTTagCompound value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeTag, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        ByteBufUtils.writeTag((ByteBuf)$this$writeTag, (NBTTagCompound)value);
    }

    @NotNull
    public static final NBTTagCompound readTag(@NotNull ByteBuf $this$readTag) {
        Intrinsics.checkNotNullParameter((Object)$this$readTag, (String)"<this>");
        NBTTagCompound nBTTagCompound = ByteBufUtils.readTag((ByteBuf)$this$readTag);
        if (nBTTagCompound == null) {
            nBTTagCompound = new NBTTagCompound();
        }
        return nBTTagCompound;
    }

    public static final void writeVarInt(@NotNull ByteBuf $this$writeVarInt, int value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarInt, (String)"<this>");
        int input = value;
        while ((input & 0xFFFFFF80) != 0) {
            $this$writeVarInt.writeByte(input & 0x7F | 0x80);
            input >>>= 7;
        }
        $this$writeVarInt.writeByte(input);
    }

    public static final int readVarInt(@NotNull ByteBuf $this$readVarInt) {
        byte b0;
        Intrinsics.checkNotNullParameter((Object)$this$readVarInt, (String)"<this>");
        int i = 0;
        int j = 0;
        do {
            b0 = $this$readVarInt.readByte();
            i |= (b0 & 0x7F) << j++ * 7;
            if (j <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    public static final void writeVarLong(@NotNull ByteBuf $this$writeVarLong, long value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeVarLong, (String)"<this>");
        long input = value;
        while ((input & 0xFFFFFFFFFFFFFF80L) != 0L) {
            $this$writeVarLong.writeByte((int)(input & 0x7FL) | 0x80);
            input = value >>> 7;
        }
        $this$writeVarLong.writeByte((int)value);
    }

    public static final long readVarLong(@NotNull ByteBuf $this$readVarLong) {
        byte b0;
        Intrinsics.checkNotNullParameter((Object)$this$readVarLong, (String)"<this>");
        long i = 0L;
        int j = 0;
        do {
            b0 = $this$readVarLong.readByte();
            i |= (long)(b0 & 0x7F) << j++ * 7;
            if (j <= 10) continue;
            throw new RuntimeException("VarLong too big");
        } while ((b0 & 0x80) == 128);
        return i;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeBooleanArray(@NotNull ByteBuf $this$writeBooleanArray, @NotNull boolean[] value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeBooleanArray, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        int len = value.length;
        CommonUtilMethods.writeVarInt($this$writeBooleanArray, len);
        byte[] toReturn = new byte[(len + 7) / 8];
        int n = toReturn.length;
        for (int entry = 0; entry < n; ++entry) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Iterable iterable = (Iterable)new IntRange(0, 7);
            boolean $i$f$filter = false;
            Iterator iterator2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                int it = ((Number)element$iv$iv).intValue();
                boolean bl = false;
                if (!(entry * 8 + it < len && value[entry * 8 + it])) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int it = ((Number)element$iv).intValue();
                boolean bl = false;
                toReturn[entry] = (byte)(toReturn[entry] | 128 >> it);
            }
        }
        $this$writeBooleanArray.writeBytes(toReturn);
    }

    @NotNull
    public static final boolean[] readBooleanArray(@NotNull ByteBuf $this$readBooleanArray, @Nullable boolean[] tryReadInto) {
        Intrinsics.checkNotNullParameter((Object)$this$readBooleanArray, (String)"<this>");
        int len = CommonUtilMethods.readVarInt($this$readBooleanArray);
        byte[] bytes = new byte[(len + 7) / 8];
        $this$readBooleanArray.readBytes(bytes);
        boolean[] toReturn = tryReadInto != null && tryReadInto.length == len ? tryReadInto : new boolean[len];
        int n = bytes.length;
        for (int entry = 0; entry < n; ++entry) {
            for (int bit = 0; bit < 8; ++bit) {
                int bitThing = bytes[entry] & 128 >> bit;
                if (entry * 8 + bit >= len || bitThing == 0) continue;
                toReturn[entry * 8 + bit] = true;
            }
        }
        return toReturn;
    }

    public static /* synthetic */ boolean[] readBooleanArray$default(ByteBuf byteBuf, boolean[] blArray, int n, Object object) {
        if ((n & 1) != 0) {
            blArray = null;
        }
        return CommonUtilMethods.readBooleanArray(byteBuf, blArray);
    }

    public static final void writeNullSignature(@NotNull ByteBuf $this$writeNullSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNullSignature, (String)"<this>");
        $this$writeNullSignature.writeBoolean(true);
    }

    public static final void writeNonnullSignature(@NotNull ByteBuf $this$writeNonnullSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$writeNonnullSignature, (String)"<this>");
        $this$writeNonnullSignature.writeBoolean(false);
    }

    public static final boolean hasNullSignature(@NotNull ByteBuf $this$hasNullSignature) {
        Intrinsics.checkNotNullParameter((Object)$this$hasNullSignature, (String)"<this>");
        return $this$hasNullSignature.readBoolean();
    }

    public static final void writeFluidStack(@NotNull ByteBuf $this$writeFluidStack, @NotNull FluidStack value) {
        Intrinsics.checkNotNullParameter((Object)$this$writeFluidStack, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = FluidRegistry.getFluidName((Fluid)value.getFluid());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFluidName(...)");
        CommonUtilMethods.writeString($this$writeFluidStack, string);
        $this$writeFluidStack.writeInt(value.amount);
        if (value.tag != null) {
            $this$writeFluidStack.writeBoolean(true);
            NBTTagCompound nBTTagCompound = value.tag;
            Intrinsics.checkNotNullExpressionValue((Object)nBTTagCompound, (String)"tag");
            CommonUtilMethods.writeTag($this$writeFluidStack, nBTTagCompound);
        } else {
            $this$writeFluidStack.writeBoolean(false);
        }
    }

    @Nullable
    public static final FluidStack readFluidStack(@NotNull ByteBuf $this$readFluidStack) {
        FluidStack fluidStack;
        Intrinsics.checkNotNullParameter((Object)$this$readFluidStack, (String)"<this>");
        Fluid fluid = FluidRegistry.getFluid((String)CommonUtilMethods.readString($this$readFluidStack));
        if (fluid != null) {
            int amount = $this$readFluidStack.readInt();
            fluidStack = $this$readFluidStack.readBoolean() ? new FluidStack(fluid, amount, CommonUtilMethods.readTag($this$readFluidStack)) : new FluidStack(fluid, amount);
        } else {
            fluidStack = null;
        }
        return fluidStack;
    }
}

