/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.math.AllocationTracker;
import com.teamwizardry.librarianlib.features.math.AllocationWindow;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0007J\u001f\u0010&\u001a\u00020#2\b\u0010'\u001a\u0004\u0018\u00010\u00112\b\b\u0002\u0010(\u001a\u00020\u001d\u00a2\u0006\u0002\u0010)J\u0006\u0010*\u001a\u00020#J\u0010\u0010+\u001a\u00020#2\u0006\u0010$\u001a\u00020,H\u0007JI\u0010-\u001a\u00020#2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u001d0/2\u0006\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u0001022\u0006\u00104\u001a\u00020\u00112\f\u00105\u001a\b\u0012\u0002\b\u0003\u0018\u000106\u00a2\u0006\u0002\u00107R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001b\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u00108\u001a\u00020\u0011X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u00109\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/teamwizardry/librarianlib/features/math/AllocationDisplay;", "", "<init>", "()V", "vec2dAllocations", "Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "getVec2dAllocations", "()Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "vec2dPooledAllocations", "getVec2dPooledAllocations", "rect2dAllocations", "getRect2dAllocations", "vec3dAllocations", "getVec3dAllocations", "vec3dPooledAllocations", "getVec3dPooledAllocations", "statsStartTime", "", "getStatsStartTime", "()I", "setStatsStartTime", "(I)V", "statsEndTime", "getStatsEndTime", "()Ljava/lang/Integer;", "setStatsEndTime", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "statsOutputDir", "", "getStatsOutputDir", "()Ljava/lang/String;", "setStatsOutputDir", "(Ljava/lang/String;)V", "tick", "", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "startStats", "duration", "outputDir", "(Ljava/lang/Integer;Ljava/lang/String;)V", "endStats", "debug", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Text;", "line", "list", "", "name", "allocations", "", "pooled", "size", "stats", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "(Ljava/util/List;Ljava/lang/String;DLjava/lang/Double;ILit/unimi/dsi/fastutil/objects/Object2IntMap;)V", "B_PER_KB", "B_PER_MB", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nAllocationTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AllocationTracker.kt\ncom/teamwizardry/librarianlib/features/math/AllocationDisplay\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1863#3,2:174\n1863#3,2:176\n1863#3,2:178\n*S KotlinDebug\n*F\n+ 1 AllocationTracker.kt\ncom/teamwizardry/librarianlib/features/math/AllocationDisplay\n*L\n79#1:174,2\n88#1:176,2\n97#1:178,2\n*E\n"})
public final class AllocationDisplay {
    @NotNull
    public static final AllocationDisplay INSTANCE = new AllocationDisplay();
    @NotNull
    private static final AllocationWindow vec2dAllocations;
    @NotNull
    private static final AllocationWindow vec2dPooledAllocations;
    @NotNull
    private static final AllocationWindow rect2dAllocations;
    @NotNull
    private static final AllocationWindow vec3dAllocations;
    @NotNull
    private static final AllocationWindow vec3dPooledAllocations;
    private static int statsStartTime;
    @Nullable
    private static Integer statsEndTime;
    @NotNull
    private static String statsOutputDir;
    private static final int B_PER_KB;
    private static final int B_PER_MB;

    private AllocationDisplay() {
    }

    @NotNull
    public final AllocationWindow getVec2dAllocations() {
        return vec2dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec2dPooledAllocations() {
        return vec2dPooledAllocations;
    }

    @NotNull
    public final AllocationWindow getRect2dAllocations() {
        return rect2dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec3dAllocations() {
        return vec3dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec3dPooledAllocations() {
        return vec3dPooledAllocations;
    }

    public final int getStatsStartTime() {
        return statsStartTime;
    }

    public final void setStatsStartTime(int n) {
        statsStartTime = n;
    }

    @Nullable
    public final Integer getStatsEndTime() {
        return statsEndTime;
    }

    public final void setStatsEndTime(@Nullable Integer n) {
        statsEndTime = n;
    }

    @NotNull
    public final String getStatsOutputDir() {
        return statsOutputDir;
    }

    public final void setStatsOutputDir(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        statsOutputDir = string;
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ClientTickEvent event) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        vec2dAllocations.sample(AllocationTracker.INSTANCE.getVec2dAllocations());
        vec2dPooledAllocations.sample(AllocationTracker.INSTANCE.getVec2dPooledAllocations());
        rect2dAllocations.sample(AllocationTracker.INSTANCE.getRect2dAllocations());
        vec3dAllocations.sample(AllocationTracker.INSTANCE.getVec3dAllocations());
        vec3dPooledAllocations.sample(AllocationTracker.INSTANCE.getVec3dPooledAllocations());
        Integer n = statsEndTime;
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl2 = false;
            bl = ClientTickHandler.getTicks() >= it;
        } else {
            bl = false;
        }
        if (bl) {
            this.endStats();
            statsEndTime = null;
        }
    }

    public final void startStats(@Nullable Integer duration, @NotNull String outputDir) {
        Integer n;
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        AllocationTracker.INSTANCE.setVec2dAllocationStats((Object2IntMap<Vec2d>)((Object2IntMap)new Object2IntOpenHashMap()));
        AllocationTracker.INSTANCE.setRect2dAllocationStats((Object2IntMap<Rect2d>)((Object2IntMap)new Object2IntOpenHashMap()));
        AllocationTracker.INSTANCE.setVec3dAllocationStats((Object2IntMap<Vec3d>)((Object2IntMap)new Object2IntOpenHashMap()));
        statsOutputDir = outputDir;
        Integer n2 = duration;
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = ClientTickHandler.getTicks() + it;
        } else {
            n = null;
        }
        statsEndTime = n;
    }

    public static /* synthetic */ void startStats$default(AllocationDisplay allocationDisplay, Integer n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "~";
        }
        allocationDisplay.startStats(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endStats() {
        block22: {
            try {
                Object2IntMap.Entry it;
                boolean $i$f$forEach;
                Iterable $this$forEach$iv;
                BufferedWriter file2;
                Object object;
                Object object2;
                Object object3;
                new File(String.valueOf(statsOutputDir)).mkdirs();
                double duration = (double)(ClientTickHandler.getTicks() - statsStartTime) / 20.0;
                Object2IntMap<Vec2d> object2IntMap = AllocationTracker.INSTANCE.getVec2dAllocationStats();
                if (object2IntMap != null) {
                    Object2IntMap<Vec2d> vec2dStats = object3 = object2IntMap;
                    boolean bl = false;
                    object2 = new File(statsOutputDir + "/vec2d-" + (int)duration + "s.csv");
                    object = Charsets.UTF_8;
                    int n = 8192;
                    Object object4 = object2;
                    object2 = (object4 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object4), (Charset)object)) instanceof BufferedWriter ? (BufferedWriter)object4 : new BufferedWriter((Writer)object4, n);
                    object = null;
                    try {
                        file2 = (BufferedWriter)object2;
                        boolean bl2 = false;
                        file2.write("X,Y,Count\n");
                        ObjectSet objectSet = vec2dStats.object2IntEntrySet();
                        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"object2IntEntrySet(...)");
                        $this$forEach$iv = (Iterable)objectSet;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (Object2IntMap.Entry)element$iv;
                            boolean bl3 = false;
                            file2.write("" + ((Vec2d)it.getKey()).getX() + ',' + ((Vec2d)it.getKey()).getY() + ',' + it.getIntValue() + '\n');
                        }
                        file2 = Unit.INSTANCE;
                    }
                    catch (Throwable file2) {
                        object = file2;
                        throw file2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                    }
                }
                Object2IntMap<Rect2d> object2IntMap2 = AllocationTracker.INSTANCE.getRect2dAllocationStats();
                if (object2IntMap2 != null) {
                    Object rect2dStats = object3 = object2IntMap2;
                    boolean bl = false;
                    object2 = new File(statsOutputDir + "/rect2d-" + (int)duration + "s.csv");
                    object = Charsets.UTF_8;
                    int file2 = 8192;
                    Object bl2 = object2;
                    object2 = (bl2 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)bl2), (Charset)object)) instanceof BufferedWriter ? (BufferedWriter)bl2 : new BufferedWriter((Writer)bl2, file2);
                    object = null;
                    try {
                        file2 = (BufferedWriter)object2;
                        boolean bl4 = false;
                        file2.write("X,Y,Width,Height,Count\n");
                        ObjectSet objectSet = rect2dStats.object2IntEntrySet();
                        Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"object2IntEntrySet(...)");
                        $this$forEach$iv = (Iterable)objectSet;
                        $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            it = (Object2IntMap.Entry)element$iv;
                            boolean bl5 = false;
                            file2.write("" + ((Rect2d)it.getKey()).getX() + ',' + ((Rect2d)it.getKey()).getY() + ',' + ((Rect2d)it.getKey()).getWidth() + ',' + ((Rect2d)it.getKey()).getHeight() + ',' + it.getIntValue() + '\n');
                        }
                        file2 = Unit.INSTANCE;
                    }
                    catch (Throwable file3) {
                        object = file3;
                        throw file3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                    }
                }
                Object2IntMap<Vec3d> object2IntMap3 = AllocationTracker.INSTANCE.getVec3dAllocationStats();
                if (object2IntMap3 == null) break block22;
                Object vec3dStats = object3 = object2IntMap3;
                boolean bl = false;
                object2 = new File(statsOutputDir + "/vec3d-" + (int)duration + "s.csv");
                object = Charsets.UTF_8;
                int file3 = 8192;
                Object bl4 = object2;
                object2 = (bl4 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)bl4), (Charset)object)) instanceof BufferedWriter ? (BufferedWriter)bl4 : new BufferedWriter((Writer)bl4, file3);
                object = null;
                try {
                    BufferedWriter file4 = (BufferedWriter)object2;
                    boolean bl6 = false;
                    file4.write("X,Y,Z,Count\n");
                    ObjectSet objectSet = vec3dStats.object2IntEntrySet();
                    Intrinsics.checkNotNullExpressionValue((Object)objectSet, (String)"object2IntEntrySet(...)");
                    $this$forEach$iv = (Iterable)objectSet;
                    $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Object2IntMap.Entry)element$iv;
                        boolean bl7 = false;
                        file4.write("" + ((Vec3d)it.getKey()).field_72450_a + ',' + ((Vec3d)it.getKey()).field_72448_b + ',' + ((Vec3d)it.getKey()).field_72449_c + ',' + it.getIntValue());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        AllocationTracker.INSTANCE.setVec2dAllocationStats(null);
        AllocationTracker.INSTANCE.setRect2dAllocationStats(null);
        AllocationTracker.INSTANCE.setVec3dAllocationStats(null);
    }

    @SubscribeEvent
    public final void debug(@NotNull RenderGameOverlayEvent.Text event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        event.getLeft().add("LibrarianLib Allocations:");
        ArrayList arrayList = event.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"getLeft(...)");
        this.line(arrayList, "Vec3d", vec3dAllocations.getAverage(), vec3dPooledAllocations.getAverage(), AllocationTracker.INSTANCE.getVec3dSize(), AllocationTracker.INSTANCE.getVec3dAllocationStats());
        ArrayList arrayList2 = event.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList2, (String)"getLeft(...)");
        this.line(arrayList2, "Vec2d", vec2dAllocations.getAverage(), vec2dPooledAllocations.getAverage(), AllocationTracker.INSTANCE.getVec2dSize(), AllocationTracker.INSTANCE.getVec2dAllocationStats());
        ArrayList arrayList3 = event.getLeft();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList3, (String)"getLeft(...)");
        this.line(arrayList3, "Rect2d", rect2dAllocations.getAverage(), null, AllocationTracker.INSTANCE.getRect2dSize(), AllocationTracker.INSTANCE.getRect2dAllocationStats());
    }

    public final void line(@NotNull List<String> list, @NotNull String name, double allocations, @Nullable Double pooled, int size2, @Nullable Object2IntMap<?> stats) {
        String string;
        Map map;
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (allocations == 0.0 && (pooled == null || Intrinsics.areEqual((Double)pooled, (double)0.0)) && ((map = (Map)stats) == null || map.isEmpty())) {
            return;
        }
        String line = " - " + name + ':';
        line = line + ' ' + (int)allocations + " unpooled/s";
        if (pooled != null) {
            double percent = (double)100 * pooled / (allocations + pooled);
            line = line + " (" + (int)percent + "% pooled)";
        }
        double memory = (double)size2 * allocations;
        StringBuilder stringBuilder = new StringBuilder().append(line);
        if (memory > (double)B_PER_MB) {
            String string2 = " - %.2f MiB/s";
            Object[] objectArray = new Object[]{memory / (double)B_PER_MB};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        } else if (memory > (double)B_PER_KB) {
            String string4 = " - %.2f KiB/s";
            Object[] objectArray = new Object[]{memory / (double)B_PER_KB};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            string = string5;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        } else {
            String string6 = " - %d bytes/s";
            Object[] objectArray = new Object[]{(int)memory};
            String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
            string = string7;
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(...)");
        }
        line = stringBuilder.append(string).toString();
        if (stats != null) {
            line = line + " - Stats: " + stats.size() + " unique allocations";
        }
        list.add(line);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        vec2dAllocations = new AllocationWindow();
        vec2dPooledAllocations = new AllocationWindow();
        rect2dAllocations = new AllocationWindow();
        vec3dAllocations = new AllocationWindow();
        vec3dPooledAllocations = new AllocationWindow();
        statsOutputDir = "~";
        B_PER_KB = 1024;
        B_PER_MB = 0x100000;
    }
}

