/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "", "<init>", "()V", "windowSize", "", "getWindowSize", "()I", "setWindowSize", "(I)V", "values", "Lit/unimi/dsi/fastutil/longs/LongArrayFIFOQueue;", "getValues", "()Lit/unimi/dsi/fastutil/longs/LongArrayFIFOQueue;", "times", "getTimes", "sample", "", "value", "", "average", "", "getAverage", "()D", "LibrarianLib-Continuous-1.12.2"})
public final class AllocationWindow {
    private int windowSize = 5000;
    @NotNull
    private final LongArrayFIFOQueue values = new LongArrayFIFOQueue();
    @NotNull
    private final LongArrayFIFOQueue times = new LongArrayFIFOQueue();

    public final int getWindowSize() {
        return this.windowSize;
    }

    public final void setWindowSize(int n) {
        this.windowSize = n;
    }

    @NotNull
    public final LongArrayFIFOQueue getValues() {
        return this.values;
    }

    @NotNull
    public final LongArrayFIFOQueue getTimes() {
        return this.times;
    }

    public final void sample(long value) {
        long now = System.currentTimeMillis();
        long cutoff = now - (long)this.windowSize;
        while (!this.times.isEmpty() && this.times.firstLong() < cutoff) {
            this.times.dequeueLong();
            this.values.dequeueLong();
        }
        this.times.enqueue(now);
        this.values.enqueue(value);
    }

    public final double getAverage() {
        if (this.values.isEmpty()) {
            return 0.0;
        }
        long timeDelta = this.times.lastLong() - this.times.firstLong();
        if (timeDelta == 0L) {
            return 0.0;
        }
        long valueDelta = this.values.lastLong() - this.values.firstLong();
        return (double)((long)1000 * valueDelta) / (double)timeDelta;
    }
}

