/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.math.Vec2d;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B)\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\bJ\u0011\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0013\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u000eR\u0011\u0010!\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u000e\u00a8\u0006#"}, d2={"Lcom/teamwizardry/librarianlib/features/math/BoundingBox2D;", "", "min", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "max", "<init>", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "minX", "", "minY", "maxX", "maxY", "(DDDD)V", "getMin", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getMax", "union", "other", "offset", "pos", "scale", "amount", "contains", "", "height", "width", "heightF", "", "widthF", "heightI", "", "widthI", "getPos", "size", "getSize", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nBoundingBox2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BoundingBox2D.kt\ncom/teamwizardry/librarianlib/features/math/BoundingBox2D\n+ 2 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n+ 3 Vec2d.kt\ncom/teamwizardry/librarianlib/features/math/Vec2d\n*L\n1#1,62:1\n49#2:63\n81#3:64\n*S KotlinDebug\n*F\n+ 1 BoundingBox2D.kt\ncom/teamwizardry/librarianlib/features/math/BoundingBox2D\n*L\n11#1:63\n26#1:64\n*E\n"})
public final class BoundingBox2D {
    @NotNull
    private final Vec2d min;
    @NotNull
    private final Vec2d max;

    public BoundingBox2D(@NotNull Vec2d min, @NotNull Vec2d max) {
        Intrinsics.checkNotNullParameter((Object)min, (String)"min");
        Intrinsics.checkNotNullParameter((Object)max, (String)"max");
        this.min = min;
        this.max = max;
    }

    @NotNull
    public final Vec2d getMin() {
        return this.min;
    }

    @NotNull
    public final Vec2d getMax() {
        return this.max;
    }

    public BoundingBox2D(double minX, double minY, double maxX, double maxY) {
        double x$iv;
        double d = minX;
        double y$iv = minY;
        boolean $i$f$vec = false;
        Vec2d vec2d = Vec2d.Companion.getPooled(x$iv, y$iv);
        x$iv = maxX;
        y$iv = maxY;
        $i$f$vec = false;
        this(vec2d, Vec2d.Companion.getPooled(x$iv, y$iv));
    }

    @NotNull
    public final BoundingBox2D union(@NotNull BoundingBox2D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new BoundingBox2D(Math.min(this.min.getX(), other.min.getX()), Math.min(this.min.getY(), other.min.getY()), Math.max(this.max.getX(), other.max.getX()), Math.max(this.max.getY(), other.max.getY()));
    }

    @NotNull
    public final BoundingBox2D offset(@NotNull Vec2d pos2) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        return new BoundingBox2D(this.min.plus(pos2), this.max.plus(pos2));
    }

    @NotNull
    public final BoundingBox2D scale(double amount) {
        Vec2d this_$iv;
        Vec2d vec2d = this.min;
        double amount$iv = amount;
        boolean $i$f$times = false;
        Vec2d vec2d2 = this_$iv.mul(amount$iv);
        this_$iv = this.max;
        amount$iv = amount;
        $i$f$times = false;
        return new BoundingBox2D(vec2d2, this_$iv.mul(amount$iv));
    }

    public final boolean contains(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.getX() <= this.max.getX() && other.getX() >= this.min.getX() && other.getY() <= this.max.getY() && other.getY() >= this.min.getY();
    }

    public final double height() {
        return this.max.getY() - this.min.getY();
    }

    public final double width() {
        return this.max.getX() - this.min.getX();
    }

    public final float heightF() {
        return this.max.getYf() - this.min.getYf();
    }

    public final float widthF() {
        return this.max.getXf() - this.min.getXf();
    }

    public final int heightI() {
        return this.max.getYi() - this.min.getYi();
    }

    public final int widthI() {
        return this.max.getXi() - this.min.getXi();
    }

    @NotNull
    public final Vec2d getPos() {
        return this.min;
    }

    @NotNull
    public final Vec2d getSize() {
        return this.max.minus(this.min);
    }
}

