/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.util.Arrays;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\t\b\u0016\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0006\u0010\u000e\u001a\u00020\u0000J\u0016\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u0016\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0012J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0000J\u0006\u0010\u0004\u001a\u00020\u0000J\u0011\u0010\u001c\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\u0018H\u0086\u0002J\u0011\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u0010H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "", "matrix", "Ljavax/vecmath/Matrix3d;", "frozen", "", "<init>", "(Ljavax/vecmath/Matrix3d;Z)V", "()V", "getFrozen", "()Z", "transform", "point", "Ljavax/vecmath/Point3d;", "invert", "translate", "", "x", "", "y", "scale", "rotate", "angle", "vec", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "apply", "mul", "copy", "times", "timesAssign", "equals", "other", "hashCode", "", "toString", "", "checkFrozen", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nMatrix3.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Matrix3.kt\ncom/teamwizardry/librarianlib/features/math/Matrix3\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n*L\n1#1,182:1\n1#2:183\n49#3:184\n*S KotlinDebug\n*F\n+ 1 Matrix3.kt\ncom/teamwizardry/librarianlib/features/math/Matrix3\n*L\n95#1:184\n*E\n"})
public final class Matrix3 {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Matrix3d matrix;
    private final boolean frozen;
    @NotNull
    private final Matrix3d transform;
    @NotNull
    private final Point3d point;
    @JvmField
    @NotNull
    public static final Matrix3 identity = new Matrix3().frozen();

    private Matrix3(Matrix3d matrix, boolean frozen) {
        this.matrix = matrix;
        this.frozen = frozen;
        this.transform = new Matrix3d();
        this.point = new Point3d();
    }

    public final boolean getFrozen() {
        return this.frozen;
    }

    /*
     * WARNING - void declaration
     */
    public Matrix3() {
        void $this$_init__u24lambda_u240;
        Matrix3d matrix3d;
        Matrix3d matrix3d2 = matrix3d = new Matrix3d();
        Matrix3 matrix3 = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.setIdentity();
        matrix3(matrix3d, false);
    }

    @NotNull
    public final Matrix3 invert() {
        Matrix3 inverseMatrix = this.copy();
        inverseMatrix.matrix.invert();
        return inverseMatrix;
    }

    public final void translate(double x, double y) {
        this.checkFrozen();
        this.transform.setIdentity();
        this.transform.m02 = x;
        this.transform.m12 = y;
        this.matrix.mul(this.transform);
    }

    public final void scale(double x, double y) {
        this.checkFrozen();
        this.transform.setIdentity();
        this.transform.m00 = x;
        this.transform.m11 = y;
        this.matrix.mul(this.transform);
    }

    public final void rotate(double angle) {
        double cos;
        this.checkFrozen();
        this.transform.setIdentity();
        double sin = Math.sin(-angle);
        this.transform.m00 = cos = Math.cos(-angle);
        this.transform.m01 = sin;
        this.transform.m10 = -sin;
        this.transform.m11 = cos;
        this.matrix.mul(this.transform);
    }

    public final void translate(@NotNull Vec2d vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.translate(vec.getX(), vec.getY());
    }

    public final void scale(@NotNull Vec2d vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        this.scale(vec.getX(), vec.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d apply(@NotNull Vec2d point) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        this.point.x = point.getX();
        this.point.y = point.getY();
        this.point.z = 1.0;
        this.matrix.transform((Tuple3d)this.point);
        double d = this.point.x;
        double y$iv = this.point.y;
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final void mul(@NotNull Matrix3 matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.checkFrozen();
        this.matrix.mul(matrix.matrix);
    }

    @NotNull
    public final Matrix3 copy() {
        Object object = this.matrix.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.vecmath.Matrix3d");
        return new Matrix3((Matrix3d)object, false);
    }

    @NotNull
    public final Matrix3 frozen() {
        Object object = this.matrix.clone();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.vecmath.Matrix3d");
        return new Matrix3((Matrix3d)object, true);
    }

    @NotNull
    public final Vec2d times(@NotNull Vec2d point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.apply(point);
    }

    public final void timesAssign(@NotNull Matrix3 matrix) {
        Intrinsics.checkNotNullParameter((Object)matrix, (String)"matrix");
        this.mul(matrix);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix3)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.matrix, (Object)((Matrix3)other).matrix);
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    @NotNull
    public String toString() {
        int w0 = String.valueOf(Math.floor(Math.max(this.matrix.m00, Math.max(this.matrix.m10, this.matrix.m20)))).length() + 1;
        int w1 = String.valueOf(Math.floor(Math.max(this.matrix.m01, Math.max(this.matrix.m11, this.matrix.m21)))).length() + 1;
        int w2 = String.valueOf(Math.floor(Math.max(this.matrix.m02, Math.max(this.matrix.m12, this.matrix.m22)))).length() + 1;
        String string = StringsKt.trimIndent((String)("\n            \u23a1%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a4\n            \u23a2%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a5\n            \u23a3%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a6\n        "));
        Object[] objectArray = new Object[]{this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m10, this.matrix.m11, this.matrix.m12, this.matrix.m20, this.matrix.m21, this.matrix.m22};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final void checkFrozen() {
        if (this.frozen) {
            throw new IllegalArgumentException("This matrix is frozen. Use `copy` to create a mutable copy");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Matrix3$Companion;", "", "<init>", "()V", "identity", "Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

