/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.AllocationTracker;
import com.teamwizardry.librarianlib.features.math.Margins2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 P2\u00020\u0001:\u0001PB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0019\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u0007\u0010\fJ\u000e\u00105\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0003J\u000e\u00107\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0003J\u000e\u00108\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0003J\u000e\u00109\u001a\u00020\u00002\u0006\u00106\u001a\u00020\u0003J\u000e\u0010:\u001a\u00020\u00002\u0006\u0010;\u001a\u00020\nJ\u000e\u0010:\u001a\u00020\u00002\u0006\u0010<\u001a\u00020\u0000J\u0011\u0010=\u001a\u00020>2\u0006\u0010;\u001a\u00020\nH\u0086\u0002J\u0011\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u0000H\u0086\u0002J\u000e\u0010@\u001a\u00020\n2\u0006\u0010;\u001a\u00020\nJ\u000e\u0010A\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\nJ\u000e\u0010B\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\nJ\u000e\u0010C\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0003J\u000e\u0010D\u001a\u00020\u00002\u0006\u0010A\u001a\u00020\u0003J)\u0010A\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020E2\u0006\u0010\u0019\u001a\u00020E2\u0006\u0010\u001b\u001a\u00020E2\u0006\u0010\u001d\u001a\u00020EH\u0086\bJ&\u0010A\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010F\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0011\u0010G\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IH\u0086\u0002J\u000e\u0010F\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IJ\u0011\u0010J\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IH\u0086\u0002J\u000e\u0010K\u001a\u00020\u00002\u0006\u0010H\u001a\u00020IJ\b\u0010L\u001a\u00020,H\u0016J\u0013\u0010M\u001a\u00020>2\b\u0010?\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010N\u001a\u00020OH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\u0012\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0011\u0010\u0017\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0011\u0010\u001b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u000eR\u0011\u0010\u001d\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u000eR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\u0014R\u0011\u0010!\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0011\u0010%\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0011\u0010'\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010$R\u0011\u0010)\u001a\u00020\"8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010$R\u0011\u0010+\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.R\u0011\u0010/\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010.R\u0011\u00101\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010.R\u0011\u00103\u001a\u00020,8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010.\u00a8\u0006Q"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "", "x", "", "y", "width", "height", "<init>", "(DDDD)V", "pos", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "size", "(Lcom/teamwizardry/librarianlib/features/math/Vec2d;Lcom/teamwizardry/librarianlib/features/math/Vec2d;)V", "getX", "()D", "getY", "getWidth", "getHeight", "min", "getMin", "()Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "max", "getMax", "minX", "getMinX", "minY", "getMinY", "maxX", "getMaxX", "maxY", "getMaxY", "getPos", "getSize", "xf", "", "getXf", "()F", "yf", "getYf", "widthf", "getWidthf", "heightf", "getHeightf", "xi", "", "getXi", "()I", "yi", "getYi", "widthi", "getWidthi", "heighti", "getHeighti", "setX", "value", "setY", "setWidth", "setHeight", "expandToFit", "point", "rect", "contains", "", "other", "clamp", "offset", "expand", "grow", "shrink", "", "add", "plus", "margins", "Lcom/teamwizardry/librarianlib/features/math/Margins2d;", "minus", "subtract", "hashCode", "equals", "toString", "", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nRect2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rect2d.kt\ncom/teamwizardry/librarianlib/features/math/Rect2d\n+ 2 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n*L\n1#1,178:1\n49#2:179\n49#2:180\n49#2:181\n49#2:182\n49#2:183\n49#2:184\n49#2:185\n49#2:186\n*S KotlinDebug\n*F\n+ 1 Rect2d.kt\ncom/teamwizardry/librarianlib/features/math/Rect2d\n*L\n21#1:179\n23#1:180\n35#1:181\n37#1:182\n95#1:183\n110#1:184\n114#1:185\n121#1:186\n*E\n"})
public final class Rect2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double width;
    private final double height;
    @JvmField
    @NotNull
    public static final Rect2d ZERO = new Rect2d(0.0, 0.0, 0.0, 0.0);
    @JvmField
    @NotNull
    public static final Rect2d INFINITE = new Rect2d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);

    public Rect2d(double x, double y, double width, double height) {
        block0: {
            Object2IntMap<Rect2d> object2IntMap;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            long l = AllocationTracker.INSTANCE.getRect2dAllocations();
            AllocationTracker.INSTANCE.setRect2dAllocations(l + 1L);
            Object2IntMap<Rect2d> object2IntMap2 = AllocationTracker.INSTANCE.getRect2dAllocationStats();
            if (object2IntMap2 == null) break block0;
            Object2IntMap<Rect2d> stats = object2IntMap = object2IntMap2;
            boolean bl = false;
            ((Map)stats).put(this, stats.getInt((Object)this) + 1);
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public Rect2d(@NotNull Vec2d pos2, @NotNull Vec2d size2) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        this(pos2.getX(), pos2.getY(), size2.getX(), size2.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getMin() {
        void x$iv;
        double d = this.x;
        double y$iv = this.y;
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getMax() {
        void x$iv;
        double d = this.x + this.width;
        double y$iv = this.y + this.height;
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final double getMinX() {
        return this.x;
    }

    public final double getMinY() {
        return this.y;
    }

    public final double getMaxX() {
        return this.x + this.width;
    }

    public final double getMaxY() {
        return this.y + this.height;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getPos() {
        void x$iv;
        double d = this.x;
        double y$iv = this.y;
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d getSize() {
        void x$iv;
        double d = this.width;
        double y$iv = this.height;
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final float getXf() {
        return (float)this.x;
    }

    public final float getYf() {
        return (float)this.y;
    }

    public final float getWidthf() {
        return (float)this.width;
    }

    public final float getHeightf() {
        return (float)this.height;
    }

    public final int getXi() {
        return (int)this.x;
    }

    public final int getYi() {
        return (int)this.y;
    }

    public final int getWidthi() {
        return (int)this.width;
    }

    public final int getHeighti() {
        return (int)this.height;
    }

    @NotNull
    public final Rect2d setX(double value) {
        return new Rect2d(value, this.y, this.width, this.height);
    }

    @NotNull
    public final Rect2d setY(double value) {
        return new Rect2d(this.x, value, this.width, this.height);
    }

    @NotNull
    public final Rect2d setWidth(double value) {
        return new Rect2d(this.x, this.y, value, this.height);
    }

    @NotNull
    public final Rect2d setHeight(double value) {
        return new Rect2d(this.x, this.y, this.width, value);
    }

    @NotNull
    public final Rect2d expandToFit(@NotNull Vec2d point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double newX = Math.min(this.x, point.getX());
        double newY = Math.min(this.y, point.getY());
        return new Rect2d(newX, newY, Math.max(this.x + this.width, point.getX()) - newX, Math.max(this.y + this.width, point.getY()) - newY);
    }

    @NotNull
    public final Rect2d expandToFit(@NotNull Rect2d rect) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        return new Rect2d(Vec2d.Companion.min(rect.getMin(), this.getMin()), Vec2d.Companion.max(rect.getMax(), this.getMax()).minus(Vec2d.Companion.min(rect.getMin(), this.getMin())));
    }

    public final boolean contains(@NotNull Vec2d point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return point.getX() >= this.getMinX() && point.getY() >= this.getMinY() && point.getX() < this.getMaxX() && point.getY() < this.getMaxY();
    }

    public final boolean contains(@NotNull Rect2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.getMinX() >= this.getMinX() && other.getMinY() >= this.getMinY() && other.getMaxX() <= this.getMaxX() && other.getMaxY() <= this.getMaxY();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d clamp(@NotNull Vec2d point) {
        void y$iv;
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.contains(point)) {
            return point;
        }
        double d = CommonUtilMethods.clamp(point.getX(), this.getPos().getX(), this.getPos().getX() + this.getSize().getX());
        double d2 = CommonUtilMethods.clamp(point.getY(), this.getPos().getY(), this.getPos().getY() + this.getSize().getY());
        boolean $i$f$vec = false;
        return Vec2d.Companion.getPooled((double)x$iv, (double)y$iv);
    }

    @NotNull
    public final Rect2d offset(@NotNull Vec2d offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new Rect2d(this.getPos().plus(offset), this.getSize());
    }

    @NotNull
    public final Rect2d expand(@NotNull Vec2d offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new Rect2d(this.getPos(), this.getSize().plus(offset));
    }

    @NotNull
    public final Rect2d grow(double offset) {
        double x$iv;
        double d = offset;
        double y$iv = offset;
        boolean $i$f$vec = false;
        Vec2d vec2d = this.getPos().minus(Vec2d.Companion.getPooled(x$iv, y$iv));
        x$iv = offset * (double)2;
        y$iv = offset * (double)2;
        $i$f$vec = false;
        return new Rect2d(vec2d, this.getSize().plus(Vec2d.Companion.getPooled(x$iv, y$iv)));
    }

    @NotNull
    public final Rect2d shrink(double offset) {
        double x$iv;
        double d = offset;
        double y$iv = offset;
        boolean $i$f$vec = false;
        Vec2d vec2d = this.getPos().plus(Vec2d.Companion.getPooled(x$iv, y$iv));
        x$iv = offset * (double)2;
        y$iv = offset * (double)2;
        $i$f$vec = false;
        return new Rect2d(vec2d, this.getSize().minus(Vec2d.Companion.getPooled(x$iv, y$iv)));
    }

    @NotNull
    public final Rect2d offset(@NotNull Number minX, @NotNull Number minY, @NotNull Number maxX, @NotNull Number maxY) {
        Intrinsics.checkNotNullParameter((Object)minX, (String)"minX");
        Intrinsics.checkNotNullParameter((Object)minY, (String)"minY");
        Intrinsics.checkNotNullParameter((Object)maxX, (String)"maxX");
        Intrinsics.checkNotNullParameter((Object)maxY, (String)"maxY");
        boolean $i$f$offset = false;
        return this.offset(minX.doubleValue(), minY.doubleValue(), maxX.doubleValue(), maxY.doubleValue());
    }

    @NotNull
    public final Rect2d offset(double minX, double minY, double maxX, double maxY) {
        double x$iv;
        double d = minX;
        double y$iv = minY;
        boolean $i$f$vec = false;
        Vec2d vec2d = this.getPos().plus(Vec2d.Companion.getPooled(x$iv, y$iv));
        x$iv = maxX - minX;
        y$iv = maxY - minY;
        $i$f$vec = false;
        return new Rect2d(vec2d, this.getSize().plus(Vec2d.Companion.getPooled(x$iv, y$iv)));
    }

    @NotNull
    public final Rect2d add(@NotNull Vec2d pos2, @NotNull Vec2d size2) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return new Rect2d(this.getPos().plus(pos2), this.getSize().plus(size2));
    }

    public final /* synthetic */ Rect2d plus(Margins2d margins) {
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        return this.add(margins);
    }

    @NotNull
    public final Rect2d add(@NotNull Margins2d margins) {
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        return new Rect2d(this.x - margins.getLeft(), this.y - margins.getTop(), this.width + margins.getWidth(), this.height + margins.getHeight());
    }

    public final /* synthetic */ Rect2d minus(Margins2d margins) {
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        return this.subtract(margins);
    }

    @NotNull
    public final Rect2d subtract(@NotNull Margins2d margins) {
        Intrinsics.checkNotNullParameter((Object)margins, (String)"margins");
        return new Rect2d(this.x + margins.getLeft(), this.y + margins.getTop(), this.width - margins.getWidth(), this.height - margins.getHeight());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = 0L;
        temp = Double.doubleToLongBits(this.x);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.height);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return this.x == ((Rect2d)other).x && this.y == ((Rect2d)other).y && this.width == ((Rect2d)other).width && this.height == ((Rect2d)other).height;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ',' + this.width + ',' + this.height + ')';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Rect2d$Companion;", "", "<init>", "()V", "ZERO", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "INFINITE", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

