/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.math.AllocationTracker;
import com.teamwizardry.librarianlib.features.math.Axis2d;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.util.math.MathHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0004\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 >2\u00020\u0001:\u0001>B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u0003J\u0016\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001a\u001a\u00020\u0003J\u0011\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0016\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0011\u0010$\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010%\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0016\u0010%\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010'\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0016\u0010'\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0011\u0010&\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0086\nJ\u000e\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000H\u0086\u0002J\u000e\u0010+\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u0003J\u0011\u0010*\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)H\u0086\nJ\u000e\u0010+\u001a\u00020\u00002\u0006\u0010(\u001a\u00020\u0003J\u0011\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u0000H\u0086\u0004J\t\u0010.\u001a\u00020\u0000H\u0086\u0002J\u0006\u00100\u001a\u00020\u0003J\u0006\u00101\u001a\u00020\u0003J\u0006\u00102\u001a\u00020\u0000J\u000e\u00103\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0000J\u000e\u00105\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u000e\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020\u000bJ\u0010\u00106\u001a\u00020\u00002\u0006\u00107\u001a\u00020)H\u0007J\u0011\u00108\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0086\u0002J\b\u00109\u001a\u00020\u0011H\u0016J\u0013\u0010:\u001a\u00020;2\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010<\u001a\u00020=H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010/\u001a\u00020\u00038G\u00a2\u0006\u0006\u001a\u0004\b/\u0010\b\u00a8\u0006?"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "", "x", "", "y", "<init>", "(DD)V", "getX", "()D", "getY", "xf", "", "getXf", "()F", "yf", "getYf", "xi", "", "getXi", "()I", "yi", "getYi", "floor", "ceil", "round", "setX", "value", "setY", "setAxis", "axis", "Lcom/teamwizardry/librarianlib/features/math/Axis2d;", "plus", "other", "add", "otherX", "otherY", "minus", "sub", "times", "mul", "amount", "", "div", "divide", "dot", "point", "unaryMinus", "lengthSquared", "length", "fastLength", "normalize", "squareDist", "vec", "projectOnTo", "rotate", "theta", "get", "hashCode", "equals", "", "toString", "", "Companion", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nVec2d.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vec2d.kt\ncom/teamwizardry/librarianlib/features/math/Vec2d\n*L\n1#1,272:1\n81#1:273\n*S KotlinDebug\n*F\n+ 1 Vec2d.kt\ncom/teamwizardry/librarianlib/features/math/Vec2d\n*L\n107#1:273\n*E\n"})
public final class Vec2d {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    @JvmField
    @NotNull
    public static final Vec2d ZERO = new Vec2d(0.0, 0.0);
    @JvmField
    @NotNull
    public static final Vec2d INFINITY = new Vec2d(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    @JvmField
    @NotNull
    public static final Vec2d NEG_INFINITY = new Vec2d(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    @JvmField
    @NotNull
    public static final Vec2d ONE = new Vec2d(1.0, 1.0);
    @JvmField
    @NotNull
    public static final Vec2d X = new Vec2d(1.0, 0.0);
    @JvmField
    @NotNull
    public static final Vec2d Y = new Vec2d(0.0, 1.0);
    @JvmField
    @NotNull
    public static final Vec2d X_INFINITY = new Vec2d(Double.POSITIVE_INFINITY, 0.0);
    @JvmField
    @NotNull
    public static final Vec2d Y_INFINITY = new Vec2d(0.0, Double.POSITIVE_INFINITY);
    @JvmField
    @NotNull
    public static final Vec2d NEG_ONE = new Vec2d(-1.0, -1.0);
    @JvmField
    @NotNull
    public static final Vec2d NEG_X = new Vec2d(-1.0, 0.0);
    @JvmField
    @NotNull
    public static final Vec2d NEG_Y = new Vec2d(0.0, -1.0);
    @JvmField
    @NotNull
    public static final Vec2d NEG_X_INFINITY = new Vec2d(Double.NEGATIVE_INFINITY, 0.0);
    @JvmField
    @NotNull
    public static final Vec2d NEG_Y_INFINITY = new Vec2d(0.0, Double.NEGATIVE_INFINITY);
    private static final int poolBits = 7;
    private static final int poolMask = (1 << poolBits) - 1;
    private static final int poolMax = (1 << poolBits - 1) - 1;
    private static final int poolMin = -(1 << poolBits - 1);
    @NotNull
    private static final Vec2d[] pool;

    public Vec2d(double x, double y) {
        block0: {
            Object2IntMap<Vec2d> object2IntMap;
            this.x = x;
            this.y = y;
            long l = AllocationTracker.INSTANCE.getVec2dAllocations();
            AllocationTracker.INSTANCE.setVec2dAllocations(l + 1L);
            Object2IntMap<Vec2d> object2IntMap2 = AllocationTracker.INSTANCE.getVec2dAllocationStats();
            if (object2IntMap2 == null) break block0;
            Object2IntMap<Vec2d> stats = object2IntMap = object2IntMap2;
            boolean bl = false;
            ((Map)stats).put(this, stats.getInt((Object)this) + 1);
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final float getXf() {
        return (float)this.x;
    }

    public final float getYf() {
        return (float)this.y;
    }

    public final int getXi() {
        return (int)this.x;
    }

    public final int getYi() {
        return (int)this.y;
    }

    @NotNull
    public final Vec2d floor() {
        return Companion.getPooled(Math.floor(this.x), Math.floor(this.y));
    }

    @NotNull
    public final Vec2d ceil() {
        return Companion.getPooled(Math.ceil(this.x), Math.ceil(this.y));
    }

    @NotNull
    public final Vec2d round() {
        return new Vec2d(Math.round(this.x), Math.round(this.y));
    }

    @NotNull
    public final Vec2d setX(double value) {
        return Companion.getPooled(value, this.y);
    }

    @NotNull
    public final Vec2d setY(double value) {
        return Companion.getPooled(this.x, value);
    }

    @NotNull
    public final Vec2d setAxis(@NotNull Axis2d axis, double value) {
        Vec2d vec2d;
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                vec2d = Companion.getPooled(value, this.y);
                break;
            }
            case 2: {
                vec2d = Companion.getPooled(this.x, value);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return vec2d;
    }

    public final /* synthetic */ Vec2d plus(Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.add(other);
    }

    @NotNull
    public final Vec2d add(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.getPooled(this.x + other.x, this.y + other.y);
    }

    @NotNull
    public final Vec2d add(double otherX, double otherY) {
        return Companion.getPooled(this.x + otherX, this.y + otherY);
    }

    public final /* synthetic */ Vec2d minus(Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.sub(other);
    }

    @NotNull
    public final Vec2d sub(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.getPooled(this.x - other.x, this.y - other.y);
    }

    @NotNull
    public final Vec2d sub(double otherX, double otherY) {
        return Companion.getPooled(this.x - otherX, this.y - otherY);
    }

    public final /* synthetic */ Vec2d times(Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.mul(other);
    }

    @NotNull
    public final Vec2d mul(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.getPooled(this.x * other.x, this.y * other.y);
    }

    @NotNull
    public final Vec2d mul(double otherX, double otherY) {
        return Companion.getPooled(this.x * otherX, this.y * otherY);
    }

    @NotNull
    public final Vec2d times(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        boolean $i$f$times = false;
        return this.mul(amount.doubleValue());
    }

    @NotNull
    public final Vec2d mul(double amount) {
        return Companion.getPooled(this.x * amount, this.y * amount);
    }

    public final /* synthetic */ Vec2d div(Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.divide(other);
    }

    @NotNull
    public final Vec2d divide(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Companion.getPooled(this.x / other.x, this.y / other.y);
    }

    @NotNull
    public final Vec2d divide(double otherX, double otherY) {
        return Companion.getPooled(this.x / otherX, this.y / otherY);
    }

    @NotNull
    public final Vec2d div(@NotNull Number amount) {
        Intrinsics.checkNotNullParameter((Object)amount, (String)"amount");
        boolean $i$f$div = false;
        return this.divide(amount.doubleValue());
    }

    @NotNull
    public final Vec2d divide(double amount) {
        return Companion.getPooled(this.x / amount, this.y / amount);
    }

    public final double dot(@NotNull Vec2d point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.x * point.x + this.y * point.y;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ Vec2d unaryMinus() {
        void this_$iv;
        Vec2d vec2d = this;
        int amount$iv = -1;
        boolean $i$f$times = false;
        return this_$iv.mul(amount$iv);
    }

    @JvmName(name="lengthSquared")
    public final double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public final double fastLength() {
        return CommonUtilMethods.fastSqrt(this.x * this.x + this.y * this.y);
    }

    @NotNull
    public final Vec2d normalize() {
        double norm = CommonUtilMethods.fastInvSqrt(this.x * this.x + this.y * this.y);
        return Companion.getPooled(this.x / norm, this.y / norm);
    }

    public final double squareDist(@NotNull Vec2d vec) {
        Intrinsics.checkNotNullParameter((Object)vec, (String)"vec");
        double d0 = vec.x - this.x;
        double d1 = vec.y - this.y;
        return d0 * d0 + d1 * d1;
    }

    @NotNull
    public final Vec2d projectOnTo(@NotNull Vec2d other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec2d norm = other.normalize();
        return norm.mul(this.dot(norm));
    }

    @NotNull
    public final Vec2d rotate(float theta) {
        if (theta == 0.0f) {
            return this;
        }
        float cs = MathHelper.func_76134_b((float)theta);
        float sn = MathHelper.func_76126_a((float)theta);
        return Companion.getPooled(this.x * (double)cs - this.y * (double)sn, this.x * (double)sn + this.y * (double)cs);
    }

    @Deprecated(message="Deprecated for boxing reasons. Use the primitive version instead.", replaceWith=@ReplaceWith(expression="this.rotate(theta.toFloat())", imports={}))
    @NotNull
    public final Vec2d rotate(@NotNull Number theta) {
        Intrinsics.checkNotNullParameter((Object)theta, (String)"theta");
        return this.rotate(theta.floatValue());
    }

    public final double get(@NotNull Axis2d axis) {
        double d;
        Intrinsics.checkNotNullParameter((Object)((Object)axis), (String)"axis");
        switch (WhenMappings.$EnumSwitchMapping$0[axis.ordinal()]) {
            case 1: {
                d = this.x;
                break;
            }
            case 2: {
                d = this.y;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return d;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = 0L;
        temp = Double.doubleToLongBits(this.x);
        result = prime * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = prime * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return this.x == ((Vec2d)other).x && this.y == ((Vec2d)other).y;
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ',' + this.y + ')';
    }

    @JvmStatic
    @NotNull
    public static final Vec2d min(@NotNull Vec2d a, @NotNull Vec2d b) {
        return Companion.min(a, b);
    }

    @JvmStatic
    @NotNull
    public static final Vec2d max(@NotNull Vec2d a, @NotNull Vec2d b) {
        return Companion.max(a, b);
    }

    @JvmStatic
    @NotNull
    public static final Vec2d getPooled(double x, double y) {
        return Companion.getPooled(x, y);
    }

    static {
        int n = 0;
        int n2 = 1 << poolBits * 2;
        Vec2d[] vec2dArray = new Vec2d[n2];
        while (n < n2) {
            int n3 = n++;
            int x = (n3 >> poolBits) + poolMin;
            int y = (n3 & poolMask) + poolMin;
            vec2dArray[n3] = new Vec2d(x, y);
        }
        pool = vec2dArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0018\u0010!\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005H\u0007J\u0018\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0007R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003R\u0016\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\t\u0010\u0003R\u0016\u0010\n\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000b\u0010\u0003R\u0016\u0010\f\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\r\u0010\u0003R\u0016\u0010\u000e\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u0016\u0010\u0010\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003R\u0016\u0010\u0012\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0013\u0010\u0003R\u0016\u0010\u0014\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0015\u0010\u0003R\u0016\u0010\u0016\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0017\u0010\u0003R\u0016\u0010\u0018\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0019\u0010\u0003R\u0016\u0010\u001a\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001b\u0010\u0003R\u0016\u0010\u001c\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u001d\u0010\u0003R\u000e\u0010\"\u001a\u00020#X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(8\u0002X\u0083\u0004\u00a2\u0006\n\n\u0002\u0010*\u0012\u0004\b)\u0010\u0003\u00a8\u0006/"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Vec2d$Companion;", "", "<init>", "()V", "ZERO", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "INFINITY", "getINFINITY$annotations", "NEG_INFINITY", "getNEG_INFINITY$annotations", "ONE", "getONE$annotations", "X", "getX$annotations", "Y", "getY$annotations", "X_INFINITY", "getX_INFINITY$annotations", "Y_INFINITY", "getY_INFINITY$annotations", "NEG_ONE", "getNEG_ONE$annotations", "NEG_X", "getNEG_X$annotations", "NEG_Y", "getNEG_Y$annotations", "NEG_X_INFINITY", "getNEG_X_INFINITY$annotations", "NEG_Y_INFINITY", "getNEG_Y_INFINITY$annotations", "min", "a", "b", "max", "poolBits", "", "poolMask", "poolMax", "poolMin", "pool", "", "getPool$annotations", "[Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "getPooled", "x", "", "y", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getINFINITY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_INFINITY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getONE$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getX$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getX_INFINITY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getY_INFINITY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_ONE$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_X$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_Y$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_X_INFINITY$annotations() {
        }

        @Deprecated(message="These are stupid. Past me was stupid.")
        public static /* synthetic */ void getNEG_Y_INFINITY$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Vec2d min(@NotNull Vec2d a, @NotNull Vec2d b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Companion.getPooled(Math.min(a.getX(), b.getX()), Math.min(a.getY(), b.getY()));
        }

        @JvmStatic
        @NotNull
        public final Vec2d max(@NotNull Vec2d a, @NotNull Vec2d b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Companion.getPooled(Math.max(a.getX(), b.getX()), Math.max(a.getY(), b.getY()));
        }

        @JvmStatic
        private static /* synthetic */ void getPool$annotations() {
        }

        @JvmStatic
        @NotNull
        public final Vec2d getPooled(double x, double y) {
            int xi = (int)x;
            int yi = (int)y;
            if ((double)xi == x) {
                int n = poolMin;
                boolean bl = xi <= poolMax ? n <= xi : false;
                if (bl && (double)yi == y) {
                    n = poolMin;
                    boolean bl2 = yi <= poolMax ? n <= yi : false;
                    if (bl2) {
                        long l = AllocationTracker.INSTANCE.getVec2dPooledAllocations();
                        AllocationTracker.INSTANCE.setVec2dPooledAllocations(l + 1L);
                        return pool[xi - poolMin << poolBits | yi - poolMin];
                    }
                }
            }
            return new Vec2d(x, y);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Axis2d.values().length];
            try {
                nArray[Axis2d.X.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Axis2d.Y.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

