/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.coordinatespaces;

import com.teamwizardry.librarianlib.features.math.Matrix3;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import com.teamwizardry.librarianlib.features.math.coordinatespaces.UnrelatedCoordinateSpaceException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0018\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\f\u001a\u00020\u0000H\u0016J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\f\u001a\u00020\u0000H\u0002J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u0000H\u0002J\u0010\u0010\u001d\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u0000H\u0002R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\b\u00a8\u0006\u001e\u00c0\u0006\u0001"}, d2={"Lcom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D;", "", "parentSpace", "getParentSpace", "()Lcom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D;", "matrix", "Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "getMatrix", "()Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "inverseMatrix", "getInverseMatrix", "conversionMatrixTo", "other", "conversionMatrixFrom", "convertPointTo", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "point", "convertPointFrom", "convertRectTo", "Lcom/teamwizardry/librarianlib/features/math/Rect2d;", "rect", "convertRectFrom", "convertPointToParent", "convertPointFromParent", "convertRectToParent", "convertRectFromParent", "lowestCommonAncestor", "matrixToParent", "parent", "matrixFromParent", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nCoordinateSpace2D.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordinateSpace2D.kt\ncom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D\n+ 2 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,217:1\n49#2:218\n49#2:219\n1#3:220\n1863#4,2:221\n1863#4,2:223\n*S KotlinDebug\n*F\n+ 1 CoordinateSpace2D.kt\ncom/teamwizardry/librarianlib/features/math/coordinatespaces/CoordinateSpace2D\n*L\n80#1:218\n81#1:219\n191#1:221,2\n209#1:223,2\n*E\n"})
public interface CoordinateSpace2D {
    @Nullable
    public CoordinateSpace2D getParentSpace();

    @NotNull
    public Matrix3 getMatrix();

    @NotNull
    public Matrix3 getInverseMatrix();

    @NotNull
    default public Matrix3 conversionMatrixTo(@NotNull CoordinateSpace2D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (other == this) {
            return Matrix3.identity;
        }
        if (other == this.getParentSpace()) {
            return this.getMatrix().copy();
        }
        if (other.getParentSpace() == this) {
            return other.getInverseMatrix().copy();
        }
        CoordinateSpace2D coordinateSpace2D = this.lowestCommonAncestor(other);
        if (coordinateSpace2D == null) {
            throw new UnrelatedCoordinateSpaceException(this, other);
        }
        CoordinateSpace2D lca = coordinateSpace2D;
        if (lca == other) {
            return this.matrixToParent(other);
        }
        if (lca == this) {
            return other.matrixFromParent(this);
        }
        Matrix3 matrix = new Matrix3();
        matrix.timesAssign(other.matrixFromParent(lca));
        matrix.timesAssign(this.matrixToParent(lca));
        return matrix;
    }

    @NotNull
    default public Matrix3 conversionMatrixFrom(@NotNull CoordinateSpace2D other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.conversionMatrixTo(this);
    }

    @NotNull
    default public Vec2d convertPointTo(@NotNull Vec2d point, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.conversionMatrixTo(other).times(point);
    }

    @NotNull
    default public Vec2d convertPointFrom(@NotNull Vec2d point, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.convertPointTo(point, this);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    default public Rect2d convertRectTo(@NotNull Rect2d rect, @NotNull CoordinateSpace2D other) {
        void x$iv;
        void x$iv2;
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Vec2d min = rect.getMin();
        Vec2d max = rect.getMax();
        double d = min.getX();
        double y$iv = max.getY();
        boolean $i$f$vec = false;
        Vec2d minmax = Vec2d.Companion.getPooled((double)x$iv2, y$iv);
        y$iv = max.getX();
        double y$iv2 = min.getY();
        boolean $i$f$vec2 = false;
        Vec2d maxmin = Vec2d.Companion.getPooled((double)x$iv, y$iv2);
        Matrix3 matrix = this.conversionMatrixTo(other);
        min = matrix.times(min);
        max = matrix.times(max);
        minmax = matrix.times(minmax);
        maxmin = matrix.times(maxmin);
        Vec2d pos2 = Vec2d.Companion.min(Vec2d.Companion.min(min, max), Vec2d.Companion.min(minmax, maxmin));
        Vec2d size2 = Vec2d.Companion.max(Vec2d.Companion.max(min, max), Vec2d.Companion.max(minmax, maxmin)).minus(pos2);
        return new Rect2d(pos2, size2);
    }

    @NotNull
    default public Rect2d convertRectFrom(@NotNull Rect2d rect, @NotNull CoordinateSpace2D other) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return other.convertRectTo(rect, this);
    }

    @NotNull
    default public Vec2d convertPointToParent(@NotNull Vec2d point) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                object = this.getParentSpace();
                if (object == null) break block2;
                CoordinateSpace2D it = object;
                boolean bl = false;
                Vec2d vec2d = this.convertPointTo(point, it);
                object = vec2d;
                if (vec2d != null) break block3;
            }
            object = point;
        }
        return object;
    }

    @NotNull
    default public Vec2d convertPointFromParent(@NotNull Vec2d point) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)point, (String)"point");
                object = this.getParentSpace();
                if (object == null) break block2;
                CoordinateSpace2D it = object;
                boolean bl = false;
                Vec2d vec2d = this.convertPointFrom(point, it);
                object = vec2d;
                if (vec2d != null) break block3;
            }
            object = point;
        }
        return object;
    }

    @NotNull
    default public Rect2d convertRectToParent(@NotNull Rect2d rect) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                object = this.getParentSpace();
                if (object == null) break block2;
                CoordinateSpace2D it = object;
                boolean bl = false;
                Rect2d rect2d = this.convertRectTo(rect, it);
                object = rect2d;
                if (rect2d != null) break block3;
            }
            object = rect;
        }
        return object;
    }

    @NotNull
    default public Rect2d convertRectFromParent(@NotNull Rect2d rect) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
                object = this.getParentSpace();
                if (object == null) break block2;
                CoordinateSpace2D it = object;
                boolean bl = false;
                Rect2d rect2d = this.convertRectFrom(rect, it);
                object = rect2d;
                if (rect2d != null) break block3;
            }
            object = rect;
        }
        return object;
    }

    private CoordinateSpace2D lowestCommonAncestor(CoordinateSpace2D other) {
        CoordinateSpace2D ancestor;
        CoordinateSpace2D thisAncestor = this.getParentSpace();
        CoordinateSpace2D otherAncestor = other.getParentSpace();
        while (thisAncestor != null || otherAncestor != null) {
            if (thisAncestor == other) {
                return other;
            }
            if (otherAncestor == this) {
                return this;
            }
            CoordinateSpace2D coordinateSpace2D = thisAncestor;
            thisAncestor = coordinateSpace2D != null ? coordinateSpace2D.getParentSpace() : null;
            CoordinateSpace2D coordinateSpace2D2 = otherAncestor;
            otherAncestor = coordinateSpace2D2 != null ? coordinateSpace2D2.getParentSpace() : null;
        }
        Set<CoordinateSpace2D> set = Collections.newSetFromMap(new IdentityHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        Set<CoordinateSpace2D> ancestors = set;
        for (ancestor = this.getParentSpace(); ancestor != null; ancestor = ancestor.getParentSpace()) {
            ancestors.add(ancestor);
        }
        for (ancestor = other.getParentSpace(); ancestor != null; ancestor = ancestor.getParentSpace()) {
            if (!ancestors.contains(ancestor)) continue;
            return ancestor;
        }
        return null;
    }

    private Matrix3 matrixToParent(CoordinateSpace2D parent2) {
        List ancestors = new ArrayList();
        CoordinateSpace2D space = this;
        while (space != parent2) {
            ancestors.add(space);
            Intrinsics.checkNotNull((Object)space.getParentSpace());
        }
        Matrix3 matrix = new Matrix3();
        Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)ancestors);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoordinateSpace2D it = (CoordinateSpace2D)element$iv;
            boolean bl = false;
            matrix.timesAssign(it.getMatrix());
        }
        return matrix;
    }

    private Matrix3 matrixFromParent(CoordinateSpace2D other) {
        List ancestors = new ArrayList();
        CoordinateSpace2D space = this;
        while (space != other) {
            ancestors.add(space);
            Intrinsics.checkNotNull((Object)space.getParentSpace());
        }
        Matrix3 matrix = new Matrix3();
        Iterable $this$forEach$iv = ancestors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CoordinateSpace2D it = (CoordinateSpace2D)element$iv;
            boolean bl = false;
            matrix.timesAssign(it.getInverseMatrix());
        }
        return matrix;
    }
}

