/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math.interpolate;

import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpUnionImpl;
import com.teamwizardry.librarianlib.features.math.interpolate.UnionEntry;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\f\u001a\u00020\tJ!\u0010\r\u001a\u00028\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\u0006\u0010\f\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpUnion;", "T", "", "<init>", "()V", "functions", "", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "weights", "", "with", "f", "w", "add", "(Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;F)Ljava/lang/Object;", "build", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpUnionImpl;", "LibrarianLib-Continuous-1.12.2"})
public final class InterpUnion<T> {
    @NotNull
    private final List<InterpFunction<T>> functions = new ArrayList();
    @NotNull
    private final List<Float> weights = new ArrayList();

    @NotNull
    public final InterpUnion<T> with(@NotNull InterpFunction<T> f, float w) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.functions.add(f);
        this.weights.add(Float.valueOf(w));
        return this;
    }

    public final T add(@NotNull InterpFunction<T> f, float w) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        this.functions.add(f);
        this.weights.add(Float.valueOf(w));
        return f.get(1.0f);
    }

    @NotNull
    public final InterpUnionImpl<T> build() {
        List entries = new ArrayList();
        float totalWeight = CollectionsKt.sumOfFloat((Iterable)this.weights);
        float currentPos = 0.0f;
        int n = this.functions.size();
        for (int i = 0; i < n; ++i) {
            float span = ((Number)this.weights.get(i)).floatValue() / totalWeight;
            entries.add(new UnionEntry<T>(this.functions.get(i), currentPos, currentPos + span));
            currentPos += span;
        }
        return new InterpUnionImpl(entries);
    }
}

