/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.network;

import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.kotlin.DefaultedMutableMap;
import com.teamwizardry.librarianlib.features.network.PacketAbstractUpdate;
import com.teamwizardry.librarianlib.features.network.PacketBase;
import com.teamwizardry.librarianlib.features.network.PacketBundle;
import com.teamwizardry.librarianlib.features.network.PacketTarget;
import com.teamwizardry.librarianlib.features.network.TargetServer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J'\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J1\u0010\u0017\u001a\u00020\u0010\"\b\b\u0000\u0010\u0018*\u00020\u00152\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00180\u0014\"\u0002H\u0018\u00a2\u0006\u0002\u0010\u0016J\u0016\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\rJ\u0006\u0010\u001b\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0006\u001a2\u0012\u0004\u0012\u00020\b\u0012(\u0012&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\rj\u0002`\f0\u000bj\u0002`\n0\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u000e\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0001\u0012\b\u0012\u00060\rj\u0002`\f0\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/teamwizardry/librarianlib/features/network/Channel;", "", "network", "Lnet/minecraftforge/fml/common/network/simpleimpl/SimpleNetworkWrapper;", "<init>", "(Lnet/minecraftforge/fml/common/network/simpleimpl/SimpleNetworkWrapper;)V", "updates", "Lcom/teamwizardry/librarianlib/features/kotlin/DefaultedMutableMap;", "Lnet/minecraft/entity/player/EntityPlayerMP;", "Ljava/lang/Class;", "Lcom/teamwizardry/librarianlib/features/network/PerEntity;", "", "Lcom/teamwizardry/librarianlib/features/network/PerIdentifier;", "Lcom/teamwizardry/librarianlib/features/network/PacketAbstractUpdate;", "clientToServerUpdates", "send", "", "target", "Lcom/teamwizardry/librarianlib/features/network/PacketTarget;", "packets", "", "Lcom/teamwizardry/librarianlib/features/network/PacketBase;", "(Lcom/teamwizardry/librarianlib/features/network/PacketTarget;[Lcom/teamwizardry/librarianlib/features/network/PacketBase;)V", "bundle", "T", "update", "packet", "onTickEnd", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Channel.kt\ncom/teamwizardry/librarianlib/features/network/Channel\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n13346#2,2:89\n13346#2,2:92\n1863#3:91\n1864#3:94\n1863#3,2:95\n1863#3:97\n1863#3,2:98\n1864#3:100\n1863#3,2:101\n1863#3,2:103\n1863#3,2:105\n*S KotlinDebug\n*F\n+ 1 Channel.kt\ncom/teamwizardry/librarianlib/features/network/Channel\n*L\n30#1:89,2\n36#1:92,2\n34#1:91\n34#1:94\n46#1:95,2\n50#1:97\n53#1:98,2\n50#1:100\n62#1:101,2\n72#1:103,2\n80#1:105,2\n*E\n"})
public final class Channel {
    @NotNull
    private final SimpleNetworkWrapper network;
    @NotNull
    private final DefaultedMutableMap<EntityPlayerMP, DefaultedMutableMap<Class<?>, Map<Object, PacketAbstractUpdate>>> updates;
    @NotNull
    private final DefaultedMutableMap<Class<?>, Map<Object, PacketAbstractUpdate>> clientToServerUpdates;

    public Channel(@NotNull SimpleNetworkWrapper network) {
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        this.network = network;
        this.updates = CommonUtilMethods.withRealDefault(new LinkedHashMap(), Channel::updates$lambda$1);
        this.clientToServerUpdates = CommonUtilMethods.withRealDefault(new LinkedHashMap(), Channel::clientToServerUpdates$lambda$2);
    }

    public final void send(@NotNull PacketTarget target, PacketBase ... packets) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        if (Intrinsics.areEqual((Object)target, (Object)TargetServer.INSTANCE)) {
            PacketBase[] $this$forEach$iv = packets;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                PacketBase element$iv;
                PacketBase it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                this.network.sendToServer((IMessage)it);
            }
        } else {
            Iterable $this$forEach$iv = target.getPlayers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityPlayer player = (EntityPlayer)element$iv;
                boolean bl = false;
                if (!(player instanceof EntityPlayerMP)) continue;
                PacketBase[] $this$forEach$iv2 = packets;
                boolean $i$f$forEach2 = false;
                int n = $this$forEach$iv2.length;
                for (int i = 0; i < n; ++i) {
                    PacketBase element$iv2;
                    PacketBase it = element$iv2 = $this$forEach$iv2[i];
                    boolean bl2 = false;
                    this.network.sendTo((IMessage)it, (EntityPlayerMP)player);
                }
            }
        }
    }

    public final <T extends PacketBase> void bundle(@NotNull PacketTarget target, T ... packets) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(packets, (String)"packets");
        if (Intrinsics.areEqual((Object)target, (Object)TargetServer.INSTANCE)) {
            List<PacketBundle> list = PacketBundle.Companion.compactPackets(ArraysKt.toList((Object[])packets), Short.MAX_VALUE);
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PacketBundle it = (PacketBundle)element$iv;
                boolean bl = false;
                this.network.sendToServer((IMessage)it);
            }
        } else {
            Iterable $this$forEach$iv = target.getPlayers();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                EntityPlayer player = (EntityPlayer)element$iv;
                boolean bl = false;
                List<PacketBundle> list = PacketBundle.Companion.compactPackets(ArraysKt.toList((Object[])packets), 2097050);
                if (!(player instanceof EntityPlayerMP)) continue;
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PacketBundle it = (PacketBundle)element$iv2;
                    boolean bl2 = false;
                    this.network.sendTo((IMessage)it, (EntityPlayerMP)player);
                }
            }
        }
    }

    public final void update(@NotNull PacketTarget target, @NotNull PacketAbstractUpdate packet) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Object object = packet.getIdentifier();
        if (object == null) {
            throw new IllegalArgumentException("Packet has no identifier!");
        }
        Object ident = object;
        Iterable $this$forEach$iv = target.getPlayers();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EntityPlayer player = (EntityPlayer)element$iv;
            boolean bl = false;
            if (!(player instanceof EntityPlayerMP)) continue;
            this.updates.get((EntityPlayerMP)player).get(packet.getClass()).put(ident, packet);
        }
    }

    public final void onTickEnd() {
        this.updates.forEach((arg_0, arg_1) -> Channel.onTickEnd$lambda$14((arg_0, arg_1) -> Channel.onTickEnd$lambda$13(this, arg_0, arg_1), arg_0, arg_1));
        this.clientToServerUpdates.forEach((arg_0, arg_1) -> Channel.onTickEnd$lambda$17((arg_0, arg_1) -> Channel.onTickEnd$lambda$16(this, arg_0, arg_1), arg_0, arg_1));
    }

    private static final Map updates$lambda$1$lambda$0(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final DefaultedMutableMap updates$lambda$1(EntityPlayerMP it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return CommonUtilMethods.withRealDefault(new LinkedHashMap(), Channel::updates$lambda$1$lambda$0);
    }

    private static final Map clientToServerUpdates$lambda$2(Class it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new LinkedHashMap();
    }

    private static final Unit onTickEnd$lambda$13$lambda$11(Channel this$0, EntityPlayerMP $player, Class clazz, Map packets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$player, (String)"$player");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        List<PacketBundle> list = PacketBundle.Companion.compactPackets(packets.values(), 2097050);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketBundle it = (PacketBundle)element$iv;
            boolean bl = false;
            this$0.network.sendTo((IMessage)it, $player);
        }
        packets.clear();
        return Unit.INSTANCE;
    }

    private static final void onTickEnd$lambda$13$lambda$12(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Unit onTickEnd$lambda$13(Channel this$0, EntityPlayerMP player, DefaultedMutableMap types) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        types.forEach((arg_0, arg_1) -> Channel.onTickEnd$lambda$13$lambda$12((arg_0, arg_1) -> Channel.onTickEnd$lambda$13$lambda$11(this$0, player, arg_0, arg_1), arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final void onTickEnd$lambda$14(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Unit onTickEnd$lambda$16(Channel this$0, Class clazz, Map packets) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)packets, (String)"packets");
        List<PacketBundle> list = PacketBundle.Companion.compactPackets(packets.values(), 2097050);
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PacketBundle it = (PacketBundle)element$iv;
            boolean bl = false;
            this$0.network.sendToServer((IMessage)it);
        }
        packets.clear();
        return Unit.INSTANCE;
    }

    private static final void onTickEnd$lambda$17(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }
}

