/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.particle;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.helpers.Vec3dPool;
import com.teamwizardry.librarianlib.features.particle.ParticleBase;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderInfo;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderManager;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec3d;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0012\u001a\u00020\u0013H&J\b\u0010\u0014\u001a\u00020\u0013H&J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u000eJ\u0006\u0010\u0017\u001a\u00020\u0013J\u000e\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u0013J\u0006\u0010\u001c\u001a\u00020\u0013J\u0006\u0010\u001d\u001a\u00020\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lcom/teamwizardry/librarianlib/features/particle/ParticleRenderLayer;", "", "name", "", "shouldSort", "", "<init>", "(Ljava/lang/String;Z)V", "getName", "()Ljava/lang/String;", "getShouldSort", "()Z", "value", "", "Lcom/teamwizardry/librarianlib/features/particle/ParticleBase;", "particleList", "getParticleList", "()Ljava/util/List;", "setup", "", "teardown", "add", "particle", "update", "render", "renderInfo", "Lcom/teamwizardry/librarianlib/features/particle/ParticleRenderInfo;", "clear", "clean", "sort", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nParticleRenderManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleRenderManager.kt\ncom/teamwizardry/librarianlib/features/particle/ParticleRenderLayer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 VecHelpers.kt\ncom/teamwizardry/librarianlib/features/helpers/VecHelpersKt\n*L\n1#1,299:1\n1863#2,2:300\n1863#2,2:302\n1019#2,2:305\n50#3:304\n*S KotlinDebug\n*F\n+ 1 ParticleRenderManager.kt\ncom/teamwizardry/librarianlib/features/particle/ParticleRenderLayer\n*L\n242#1:300,2\n251#1:302,2\n293#1:305,2\n287#1:304\n*E\n"})
public abstract class ParticleRenderLayer {
    @NotNull
    private final String name;
    private final boolean shouldSort;
    @NotNull
    private List<ParticleBase> particleList;

    public ParticleRenderLayer(@NotNull String name, boolean shouldSort) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.shouldSort = shouldSort;
        this.particleList = new ArrayList();
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final boolean getShouldSort() {
        return this.shouldSort;
    }

    @NotNull
    public final List<ParticleBase> getParticleList() {
        return this.particleList;
    }

    public abstract void setup();

    public abstract void teardown();

    public final void add(@NotNull ParticleBase particle) {
        Intrinsics.checkNotNullParameter((Object)particle, (String)"particle");
        this.particleList.add(particle);
    }

    public final void update() {
        Iterable $this$forEach$iv = this.particleList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticleBase it = (ParticleBase)element$iv;
            boolean bl = false;
            it.onUpdate();
        }
    }

    public final void render(@NotNull ParticleRenderInfo renderInfo) {
        Intrinsics.checkNotNullParameter((Object)renderInfo, (String)"renderInfo");
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        this.setup();
        Iterable $this$forEach$iv = this.particleList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticleBase it = (ParticleBase)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)vb);
            it.render(vb, renderInfo);
        }
        this.teardown();
    }

    public final void clear() {
        this.particleList.clear();
    }

    public final void clean() {
        Iterator<ParticleBase> iter;
        if (this.particleList.size() > 100000) {
            this.clear();
        }
        Iterator<ParticleBase> iterator2 = iter = this.particleList.iterator();
        while (iterator2.hasNext()) {
            ParticleBase particle = iterator2.next();
            if (particle.isAlive()) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void sort() {
        void z$iv;
        void y$iv;
        void x$iv;
        if (!this.shouldSort) {
            return;
        }
        float partialTicks = ClientTickHandler.getPartialTicks();
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (entity == null) {
            return;
        }
        Entity entity2 = entity;
        double d0 = entity2.field_70142_S + (entity2.field_70165_t - entity2.field_70142_S) * (double)partialTicks;
        double d1 = entity2.field_70137_T + (entity2.field_70163_u - entity2.field_70137_T) * (double)partialTicks;
        double d2 = entity2.field_70136_U + (entity2.field_70161_v - entity2.field_70136_U) * (double)partialTicks;
        double d = d0;
        double d3 = d1;
        double d4 = d2;
        boolean $i$f$vec = false;
        Vec3d playerPos = Vec3dPool.create((double)x$iv, (double)y$iv, (double)z$iv);
        Vec3d look = playerPos.func_178787_e(entity2.func_70676_i(partialTicks));
        for (ParticleBase particle : this.particleList) {
            Intrinsics.checkNotNull((Object)look);
            particle.setDepthSquared$LibrarianLib_Continuous_1_12_2(ParticleRenderManager.INSTANCE.projectToRay$LibrarianLib_Continuous_1_12_2(playerPos, look, particle.getPos()).func_189985_c());
        }
        List<ParticleBase> $this$sortByDescending$iv = this.particleList;
        boolean $i$f$sortByDescending = false;
        if ($this$sortByDescending$iv.size() > 1) {
            CollectionsKt.sortWith($this$sortByDescending$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ParticleBase it = (ParticleBase)b;
                    boolean bl = false;
                    Comparable comparable = Double.valueOf(it.getDepthSquared$LibrarianLib_Continuous_1_12_2());
                    it = (ParticleBase)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Double.valueOf(it.getDepthSquared$LibrarianLib_Continuous_1_12_2()));
                }
            });
        }
    }
}

