/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.particle;

import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpFunction;
import com.teamwizardry.librarianlib.features.math.interpolate.InterpListGenerator;
import com.teamwizardry.librarianlib.features.particle.ParticleBase;
import com.teamwizardry.librarianlib.features.particle.ParticleBuilder;
import com.teamwizardry.librarianlib.features.particle.ParticleRenderManager;
import com.teamwizardry.librarianlib.features.particle.ParticleSpawn;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u0006\u0010\u000b\u001a\u00020\bJN\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u00152\u0014\b\u0002\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u000e0\u0018H\u0007J\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0015H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/teamwizardry/librarianlib/features/particle/ParticleSpawner;", "", "<init>", "()V", "pending", "", "Lcom/teamwizardry/librarianlib/features/particle/ParticleSpawn;", "tickEvent", "", "event", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "tick", "spawn", "builder", "Lcom/teamwizardry/librarianlib/features/particle/ParticleBuilder;", "world", "Lnet/minecraft/world/World;", "curve", "Lcom/teamwizardry/librarianlib/features/math/interpolate/InterpFunction;", "Lnet/minecraft/util/math/Vec3d;", "particleCount", "", "travelTime", "callback", "Ljava/util/function/BiConsumer;", "", "modifyParticleCount", "cappedParticleCount", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nParticleSpawner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSpawner.kt\ncom/teamwizardry/librarianlib/features/particle/ParticleSpawner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,101:1\n1863#2,2:102\n1863#2,2:104\n*S KotlinDebug\n*F\n+ 1 ParticleSpawner.kt\ncom/teamwizardry/librarianlib/features/particle/ParticleSpawner\n*L\n44#1:102,2\n65#1:104,2\n*E\n"})
public final class ParticleSpawner {
    @NotNull
    public static final ParticleSpawner INSTANCE = new ParticleSpawner();
    @NotNull
    private static Set<ParticleSpawn> pending;

    private ParticleSpawner() {
    }

    @JvmStatic
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static final void tickEvent(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            GuiScreen gui = mc.field_71462_r;
            if (!(gui != null && gui.func_73868_f() || mc.func_147113_T())) {
                INSTANCE.tick();
            }
        }
    }

    public final void tick() {
        Iterable $this$forEach$iv = pending;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticleSpawn it = (ParticleSpawn)element$iv;
            boolean bl = false;
            if (it.getTicksTillSpawn() > 0) continue;
            ParticleRenderManager.spawn(it.getParticle());
        }
        CollectionsKt.removeAll((Iterable)pending, ParticleSpawner::tick$lambda$1);
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount, int travelTime, @NotNull BiConsumer<Float, ParticleBuilder> callback) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Minecraft mc = Minecraft.func_71410_x();
        GuiScreen gui = mc.field_71462_r;
        int currentCount = ParticleRenderManager.getLAYER_BLOCK_MAP().getParticleList().size() + ParticleRenderManager.getLAYER_BLOCK_MAP_ADDITIVE().getParticleList().size();
        if (!(gui != null && gui.func_73868_f() || currentCount >= LibLibConfig.getMaxParticleCount() || mc.func_147113_T())) {
            int actualParticleCount = INSTANCE.modifyParticleCount(particleCount, LibLibConfig.getMaxParticleCount() - currentCount);
            Iterable $this$forEach$iv = InterpListGenerator.getIndexList(actualParticleCount);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float t = ((Number)element$iv).floatValue();
                boolean bl = false;
                int tick = (int)Math.floor((double)t * (double)travelTime);
                callback.accept(Float.valueOf(t), builder);
                ParticleBase particle = builder.build(world, curve.get(t));
                if (particle == null) continue;
                pending.add(new ParticleSpawn(particle, tick));
            }
        }
    }

    public static /* synthetic */ void spawn$default(ParticleBuilder particleBuilder, World world, InterpFunction interpFunction, int n, int n2, BiConsumer biConsumer, int n3, Object object) {
        if ((n3 & 0x10) != 0) {
            n2 = 0;
        }
        if ((n3 & 0x20) != 0) {
            biConsumer = ParticleSpawner::spawn$lambda$2;
        }
        ParticleSpawner.spawn(particleBuilder, world, interpFunction, n, n2, biConsumer);
    }

    private final int modifyParticleCount(int particleCount, int cappedParticleCount) {
        float f;
        switch (Minecraft.func_71410_x().field_71474_y.field_74362_aa) {
            case 0: {
                f = 1.0f;
                break;
            }
            case 1: {
                f = 0.5f;
                break;
            }
            case 2: {
                f = 0.25f;
                break;
            }
            default: {
                f = 1.0f;
            }
        }
        float mul = f;
        return Math.min(cappedParticleCount, (int)Math.max(2.0f, (float)particleCount * mul));
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount, int travelTime) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        ParticleSpawner.spawn$default(builder, world, curve, particleCount, travelTime, null, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void spawn(@NotNull ParticleBuilder builder, @NotNull World world, @NotNull InterpFunction<Vec3d> curve, int particleCount) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter(curve, (String)"curve");
        ParticleSpawner.spawn$default(builder, world, curve, particleCount, 0, null, 48, null);
    }

    private static final boolean tick$lambda$1(ParticleSpawn it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        int n = it.getTicksTillSpawn();
        it.setTicksTillSpawn(n + -1);
        return n <= 0;
    }

    private static final void spawn$lambda$2(Float f, ParticleBuilder particleBuilder) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)particleBuilder, (String)"<unused var>");
    }

    static {
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(...)");
        pending = set;
    }
}

