/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.particlesystem;

import com.teamwizardry.librarianlib.features.particlesystem.GameParticleSystems;
import com.teamwizardry.librarianlib.features.particlesystem.ParticleGlobalUpdateModule;
import com.teamwizardry.librarianlib.features.particlesystem.ParticleRenderModule;
import com.teamwizardry.librarianlib.features.particlesystem.ParticleUpdateModule;
import com.teamwizardry.librarianlib.features.particlesystem.bindings.StoredBinding;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\n\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u00100\u001a\u000201H&J\u000e\u00102\u001a\u00020'2\u0006\u00103\u001a\u00020\u0012J\u001a\u00104\u001a\u00020\u001b2\u0006\u0010(\u001a\u0002052\n\u00106\u001a\u00020\u001b\"\u000205J\u0006\u00107\u001a\u000201J\u0006\u00108\u001a\u000201J\u0006\u00109\u001a\u000201J\r\u0010:\u001a\u000201H\u0000\u00a2\u0006\u0002\b;J\u0010\u0010:\u001a\u0002012\u0006\u0010<\u001a\u00020\u001bH\u0002J\r\u0010=\u001a\u000201H\u0000\u00a2\u0006\u0002\b>R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\bR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\bR\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u001a\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\bR\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001b0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001e\u0010+\u001a\u00020'2\u0006\u0010&\u001a\u00020'@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010*R\u001e\u0010-\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u0014R\u000e\u0010/\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/teamwizardry/librarianlib/features/particlesystem/ParticleSystem;", "", "<init>", "()V", "updateModules", "", "Lcom/teamwizardry/librarianlib/features/particlesystem/ParticleUpdateModule;", "getUpdateModules", "()Ljava/util/List;", "globalUpdateModules", "Lcom/teamwizardry/librarianlib/features/particlesystem/ParticleGlobalUpdateModule;", "getGlobalUpdateModules", "renderPrepModules", "getRenderPrepModules", "renderModules", "Lcom/teamwizardry/librarianlib/features/particlesystem/ParticleRenderModule;", "getRenderModules", "poolSize", "", "getPoolSize", "()I", "setPoolSize", "(I)V", "systemInitialized", "", "queuedAdditions", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "", "getQueuedAdditions$LibrarianLib_Continuous_1_12_2", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "shouldQueue", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getShouldQueue$LibrarianLib_Continuous_1_12_2", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "particles", "getParticles$LibrarianLib_Continuous_1_12_2", "particlePool", "Ljava/util/ArrayDeque;", "value", "Lcom/teamwizardry/librarianlib/features/particlesystem/bindings/StoredBinding;", "lifetime", "getLifetime", "()Lcom/teamwizardry/librarianlib/features/particlesystem/bindings/StoredBinding;", "age", "getAge", "fieldCount", "getFieldCount", "canBind", "configure", "", "bind", "size", "addParticle", "", "params", "addToGame", "removeFromGame", "reload", "update", "update$LibrarianLib_Continuous_1_12_2", "particle", "render", "render$LibrarianLib_Continuous_1_12_2", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nParticleSystem.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleSystem.kt\ncom/teamwizardry/librarianlib/features/particlesystem/ParticleSystem\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExtMisc.kt\ncom/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods__ExtMiscKt\n*L\n1#1,265:1\n1863#2,2:266\n346#3,6:268\n346#3,6:274\n*S KotlinDebug\n*F\n+ 1 ParticleSystem.kt\ncom/teamwizardry/librarianlib/features/particlesystem/ParticleSystem\n*L\n162#1:266,2\n218#1:268,6\n256#1:274,6\n*E\n"})
public abstract class ParticleSystem {
    @NotNull
    private final List<ParticleUpdateModule> updateModules;
    @NotNull
    private final List<ParticleGlobalUpdateModule> globalUpdateModules;
    @NotNull
    private final List<ParticleUpdateModule> renderPrepModules;
    @NotNull
    private final List<ParticleRenderModule> renderModules;
    private int poolSize;
    private boolean systemInitialized;
    @NotNull
    private final ConcurrentLinkedQueue<double[]> queuedAdditions;
    @NotNull
    private final AtomicBoolean shouldQueue;
    @NotNull
    private final List<double[]> particles;
    @NotNull
    private final ArrayDeque<double[]> particlePool;
    private StoredBinding lifetime;
    private StoredBinding age;
    private int fieldCount;
    private boolean canBind;

    public ParticleSystem() {
        this.addToGame();
        this.updateModules = new ArrayList();
        this.globalUpdateModules = new ArrayList();
        this.renderPrepModules = new ArrayList();
        this.renderModules = new ArrayList();
        this.poolSize = 1000;
        this.queuedAdditions = new ConcurrentLinkedQueue();
        this.shouldQueue = new AtomicBoolean(false);
        this.particles = new ArrayList();
        this.particlePool = new ArrayDeque(this.poolSize);
    }

    @NotNull
    public final List<ParticleUpdateModule> getUpdateModules() {
        return this.updateModules;
    }

    @NotNull
    public final List<ParticleGlobalUpdateModule> getGlobalUpdateModules() {
        return this.globalUpdateModules;
    }

    @NotNull
    public final List<ParticleUpdateModule> getRenderPrepModules() {
        return this.renderPrepModules;
    }

    @NotNull
    public final List<ParticleRenderModule> getRenderModules() {
        return this.renderModules;
    }

    public final int getPoolSize() {
        return this.poolSize;
    }

    public final void setPoolSize(int n) {
        this.poolSize = n;
    }

    @NotNull
    public final ConcurrentLinkedQueue<double[]> getQueuedAdditions$LibrarianLib_Continuous_1_12_2() {
        return this.queuedAdditions;
    }

    @NotNull
    public final AtomicBoolean getShouldQueue$LibrarianLib_Continuous_1_12_2() {
        return this.shouldQueue;
    }

    @NotNull
    public final List<double[]> getParticles$LibrarianLib_Continuous_1_12_2() {
        return this.particles;
    }

    @NotNull
    public final StoredBinding getLifetime() {
        StoredBinding storedBinding = this.lifetime;
        if (storedBinding != null) {
            return storedBinding;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"lifetime");
        return null;
    }

    @NotNull
    public final StoredBinding getAge() {
        StoredBinding storedBinding = this.age;
        if (storedBinding != null) {
            return storedBinding;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"age");
        return null;
    }

    public final int getFieldCount() {
        return this.fieldCount;
    }

    public abstract void configure();

    @NotNull
    public final StoredBinding bind(int size2) {
        if (!this.canBind) {
            throw new IllegalStateException("It is no longer safe to create new bindings, particles have already been created based on current field count.");
        }
        StoredBinding binding = new StoredBinding(this.fieldCount, size2);
        this.fieldCount += size2;
        return binding;
    }

    @NotNull
    public final double[] addParticle(double lifetime, double ... params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        if (!this.systemInitialized) {
            this.reload();
            this.systemInitialized = true;
        }
        double[] particle = new double[this.fieldCount];
        particle[0] = lifetime;
        particle[1] = 0.0;
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)2, (int)particle.length);
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            int element$iv;
            int i = element$iv = ((IntIterator)iterator2).nextInt();
            boolean bl = false;
            if (i - 2 < params.length) {
                particle[i] = params[i - 2];
                continue;
            }
            particle[i] = 0.0;
        }
        boolean bl = this.shouldQueue.get() ? this.queuedAdditions.add(particle) : this.particles.add(particle);
        int n = this.updateModules.size();
        for (int i = 0; i < n; ++i) {
            this.updateModules.get(i).init(particle);
        }
        return particle;
    }

    public final void addToGame() {
        GameParticleSystems.INSTANCE.add(this);
    }

    public final void removeFromGame() {
        GameParticleSystems.INSTANCE.remove(this);
    }

    public final void reload() {
        this.updateModules.clear();
        this.globalUpdateModules.clear();
        this.renderPrepModules.clear();
        this.renderModules.clear();
        this.canBind = true;
        this.fieldCount = 0;
        this.lifetime = this.bind(1);
        this.age = this.bind(1);
        this.configure();
        this.canBind = false;
    }

    public final void update$LibrarianLib_Continuous_1_12_2() {
        Iterator<double[]> iter;
        this.shouldQueue.set(true);
        boolean $i$f$whileNonNull = false;
        boolean bl = false;
        double[] value$iv = this.queuedAdditions.poll();
        while (value$iv != null) {
            double[] particle = value$iv;
            boolean bl2 = false;
            this.particles.add(particle);
            bl = false;
            value$iv = this.queuedAdditions.poll();
        }
        Iterator<double[]> $i$a$-whileNonNull-ParticleSystem$update$3 = iter = this.particles.iterator();
        while ($i$a$-whileNonNull-ParticleSystem$update$3.hasNext()) {
            double[] particle = $i$a$-whileNonNull-ParticleSystem$update$3.next();
            this.getLifetime().load(particle);
            this.getAge().load(particle);
            double lifetime = this.getLifetime().getContents()[0];
            double age = this.getAge().getContents()[0];
            if (age >= lifetime) {
                iter.remove();
                if (this.particlePool.size() >= this.poolSize) continue;
                this.particlePool.push(particle);
                continue;
            }
            this.getAge().getContents()[0] = age + 1.0;
            this.getAge().store(particle);
            this.update(particle);
        }
        int n = this.globalUpdateModules.size();
        for (int i = 0; i < n; ++i) {
            this.globalUpdateModules.get(i).update(this.particles);
        }
        this.shouldQueue.set(false);
    }

    private final void update(double[] particle) {
        int n = this.updateModules.size();
        for (int i = 0; i < n; ++i) {
            this.updateModules.get(i).update(particle);
        }
    }

    public final void render$LibrarianLib_Continuous_1_12_2() {
        this.shouldQueue.set(true);
        boolean $i$f$whileNonNull = false;
        boolean bl = false;
        double[] value$iv = this.queuedAdditions.poll();
        while (value$iv != null) {
            double[] particle = value$iv;
            boolean bl2 = false;
            this.particles.add(particle);
            bl = false;
            value$iv = this.queuedAdditions.poll();
        }
        int n = this.renderModules.size();
        for (int i = 0; i < n; ++i) {
            this.renderModules.get(i).render(this.particles, this.renderPrepModules);
        }
        this.shouldQueue.set(false);
    }
}

