/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers;

import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerException;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J'\u0010\t\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u000fJ\u001d\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u0012J'\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000eH$\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001a\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u001bJ%\u0010\u001c\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001b\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0012J%\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0016J#\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "T", "", "type", "Lcom/teamwizardry/librarianlib/features/saving/FieldType;", "<init>", "(Lcom/teamwizardry/librarianlib/features/saving/FieldType;)V", "getType", "()Lcom/teamwizardry/librarianlib/features/saving/FieldType;", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "existing", "syncing", "", "(Lnet/minecraft/nbt/NBTBase;Ljava/lang/Object;Z)Ljava/lang/Object;", "writeNBT", "value", "(Ljava/lang/Object;Z)Lnet/minecraft/nbt/NBTBase;", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Object;Z)Ljava/lang/Object;", "writeBytes", "", "(Lio/netty/buffer/ByteBuf;Ljava/lang/Object;Z)V", "getDefault", "()Ljava/lang/Object;", "read", "write", "LibrarianLib-Continuous-1.12.2"})
public abstract class Serializer<T> {
    @NotNull
    private final FieldType type;

    public Serializer(@NotNull FieldType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.type = type;
    }

    @NotNull
    public final FieldType getType() {
        return this.type;
    }

    @NotNull
    protected abstract T readNBT(@NotNull NBTBase var1, @Nullable T var2, boolean var3);

    @NotNull
    protected abstract NBTBase writeNBT(@NotNull T var1, boolean var2);

    @NotNull
    protected abstract T readBytes(@NotNull ByteBuf var1, @Nullable T var2, boolean var3);

    protected abstract void writeBytes(@NotNull ByteBuf var1, @NotNull T var2, boolean var3);

    @NotNull
    public abstract T getDefault();

    @NotNull
    public final T read(@NotNull NBTBase nbt, @Nullable T existing, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        try {
            return this.readNBT(nbt, this.type.getClazz().isInstance(existing) ? existing : null, syncing);
        }
        catch (Throwable e) {
            throw new SerializerException("[NBT] Error deserializing " + this.type, e);
        }
    }

    @NotNull
    public final NBTBase write(@NotNull T value, boolean syncing) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        try {
            return this.writeNBT(value, syncing);
        }
        catch (Throwable e) {
            throw new SerializerException("[NBT] Error serializing " + this.type, e);
        }
    }

    @NotNull
    public final T read(@NotNull ByteBuf buf, @Nullable T existing, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        try {
            return this.readBytes(buf, existing, syncing);
        }
        catch (Throwable e) {
            throw new SerializerException("[Bytes] Error deserializing " + this.type, e);
        }
    }

    public final void write(@NotNull ByteBuf buf, @NotNull T value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        try {
            this.writeBytes(buf, value, syncing);
            return;
        }
        catch (Throwable e) {
            throw new SerializerException("[Bytes] Error serializing " + this.type, e);
        }
    }
}

