/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers;

import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.NoSuchSerializerError;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerFactory;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerFactoryMatch;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00062\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u0010\u0011\u001a\u00020\u00012\u0006\u0010\u000f\u001a\u00020\u0006J-\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0014\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0015J3\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u00172\u0006\u0010\u000f\u001a\u00020\u00062\u0012\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0014\"\u00020\u000b\u00a2\u0006\u0002\u0010\u0018J%\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00062\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\u0014H\u0002\u00a2\u0006\u0002\u0010\u001aR \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00010\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerRegistry;", "", "<init>", "()V", "serializers", "", "Lcom/teamwizardry/librarianlib/features/saving/FieldType;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "factories", "Ljava/util/LinkedHashMap;", "", "Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;", "register", "", "factory", "type", "serializer", "getDefault", "getOrCreate", "ignoreFactories", "", "(Lcom/teamwizardry/librarianlib/features/saving/FieldType;[Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;)Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "lazy", "Lkotlin/Lazy;", "(Lcom/teamwizardry/librarianlib/features/saving/FieldType;[Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;)Lkotlin/Lazy;", "findFactoryForType", "(Lcom/teamwizardry/librarianlib/features/saving/FieldType;[Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;)Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nSerializerRegistry.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SerializerRegistry.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/SerializerRegistry\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,81:1\n381#2,7:82\n1948#3,14:89\n*S KotlinDebug\n*F\n+ 1 SerializerRegistry.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/SerializerRegistry\n*L\n46#1:82,7\n68#1:89,14\n*E\n"})
public final class SerializerRegistry {
    @NotNull
    public static final SerializerRegistry INSTANCE = new SerializerRegistry();
    @NotNull
    private static final Map<FieldType, Serializer<Object>> serializers = new LinkedHashMap();
    @NotNull
    private static final LinkedHashMap<String, SerializerFactory> factories = new LinkedHashMap();

    private SerializerRegistry() {
    }

    public final void register(@NotNull SerializerFactory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        ((Map)factories).put(factory.getName(), factory);
    }

    public final void register(@NotNull FieldType type, @NotNull Serializer<?> serializer) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        serializers.put(type, serializer);
    }

    @NotNull
    public final Object getDefault(@NotNull FieldType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.getOrCreate(type, new SerializerFactory[0]).getDefault();
    }

    @NotNull
    public final Serializer<Object> getOrCreate(@NotNull FieldType type, SerializerFactory ... ignoreFactories) {
        Serializer<Object> serializer;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)ignoreFactories, (String)"ignoreFactories");
        Map<FieldType, Serializer<Object>> $this$getOrPut$iv = serializers;
        boolean $i$f$getOrPut = false;
        Serializer<Object> value$iv = $this$getOrPut$iv.get(type);
        if (value$iv == null) {
            boolean bl = false;
            Serializer<?> serializer2 = INSTANCE.findFactoryForType(type, ignoreFactories).create(type);
            Intrinsics.checkNotNull(serializer2, (String)"null cannot be cast to non-null type com.teamwizardry.librarianlib.features.saving.serializers.Serializer<kotlin.Any>");
            Serializer<?> answer$iv = serializer2;
            $this$getOrPut$iv.put(type, answer$iv);
            serializer = answer$iv;
        } else {
            serializer = value$iv;
        }
        return serializer;
    }

    @NotNull
    public final Lazy<Serializer<Object>> lazy(@NotNull FieldType type, SerializerFactory ... ignoreFactories) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)ignoreFactories, (String)"ignoreFactories");
        if (!serializers.containsKey(type)) {
            this.findFactoryForType(type, ignoreFactories);
        }
        return LazyKt.lazy(() -> SerializerRegistry.lazy$lambda$1(type, ignoreFactories));
    }

    private final SerializerFactory findFactoryForType(FieldType type, SerializerFactory[] ignoreFactories) {
        Object t;
        Collection<SerializerFactory> collection = factories.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Iterable $this$maxBy$iv = collection;
        boolean $i$f$maxByOrThrow = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        Object maxElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            t = maxElem$iv;
        } else {
            SerializerFactory it = (SerializerFactory)maxElem$iv;
            boolean bl = false;
            Comparable maxValue$iv = (Comparable)((Object)(ArraysKt.contains((Object[])ignoreFactories, (Object)it) ? SerializerFactoryMatch.NONE : it.canApply(type)));
            do {
                Object e$iv = iterator$iv.next();
                SerializerFactory it2 = (SerializerFactory)e$iv;
                $i$a$-maxByOrThrow-SerializerRegistry$findFactoryForType$factory$1 = false;
                Comparable v$iv = (Comparable)((Object)(ArraysKt.contains((Object[])ignoreFactories, (Object)it2) ? SerializerFactoryMatch.NONE : it2.canApply(type)));
                if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                maxElem$iv = e$iv;
                maxValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            t = maxElem$iv;
        }
        Intrinsics.checkNotNullExpressionValue(t, (String)"maxBy(...)");
        SerializerFactory factory = (SerializerFactory)t;
        if (factory.canApply(type) == SerializerFactoryMatch.NONE) {
            throw new NoSuchSerializerError(type);
        }
        return factory;
    }

    private static final Serializer lazy$lambda$1(FieldType $type, SerializerFactory[] $ignoreFactories) {
        Intrinsics.checkNotNullParameter((Object)$type, (String)"$type");
        Intrinsics.checkNotNullParameter((Object)$ignoreFactories, (String)"$ignoreFactories");
        return INSTANCE.getOrCreate($type, Arrays.copyOf($ignoreFactories, $ignoreFactories.length));
    }
}

