/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics;

import com.teamwizardry.librarianlib.features.autoregister.SerializerRegister;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializerRegister(classes={ByteBuf.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0002H\u0016J\"\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0018\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J\"\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0014\u00a8\u0006\u0012"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/basics/SerializeByteBuf;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "Lio/netty/buffer/ByteBuf;", "<init>", "()V", "getDefault", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "existing", "syncing", "", "writeNBT", "value", "readBytes", "buf", "writeBytes", "", "LibrarianLib-Continuous-1.12.2"})
public final class SerializeByteBuf
extends Serializer<ByteBuf> {
    @NotNull
    public static final SerializeByteBuf INSTANCE = new SerializeByteBuf();

    private SerializeByteBuf() {
        super(FieldType.Companion.create(ByteBuf.class));
    }

    @Override
    @NotNull
    public ByteBuf getDefault() {
        ByteBuf byteBuf = Unpooled.buffer();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"buffer(...)");
        return byteBuf;
    }

    @Override
    @NotNull
    protected ByteBuf readNBT(@NotNull NBTBase nbt, @Nullable ByteBuf existing, boolean syncing) {
        ByteBuf byteBuf;
        NBTTagByteArray tag;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        NBTTagByteArray nBTTagByteArray = tag = nbt instanceof NBTTagByteArray ? (NBTTagByteArray)nbt : null;
        if (tag == null) {
            ByteBuf byteBuf2 = Unpooled.EMPTY_BUFFER;
            byteBuf = byteBuf2;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf2, (String)"EMPTY_BUFFER");
        } else {
            ByteBuf byteBuf3 = Unpooled.wrappedBuffer((byte[])tag.func_150292_c());
            byteBuf = byteBuf3;
            Intrinsics.checkNotNullExpressionValue((Object)byteBuf3, (String)"wrappedBuffer(...)");
        }
        return byteBuf;
    }

    @Override
    @NotNull
    protected NBTBase writeNBT(@NotNull ByteBuf value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        return (NBTBase)new NBTTagByteArray(bytes);
    }

    @Override
    @NotNull
    protected ByteBuf readBytes(@NotNull ByteBuf buf, @Nullable ByteBuf existing, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        byte[] bytes = new byte[CommonUtilMethods.readVarInt(buf)];
        buf.readBytes(bytes);
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])bytes);
        Intrinsics.checkNotNullExpressionValue((Object)byteBuf, (String)"wrappedBuffer(...)");
        return byteBuf;
    }

    @Override
    protected void writeBytes(@NotNull ByteBuf buf, @NotNull ByteBuf value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        byte[] bytes = new byte[value.readableBytes()];
        value.readBytes(bytes);
        CommonUtilMethods.writeVarInt(buf, bytes.length);
        buf.writeBytes(bytes);
    }
}

