/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.basics;

import com.teamwizardry.librarianlib.features.autoregister.SerializerRegister;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import io.netty.buffer.ByteBuf;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializerRegister(classes={FluidStack.class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\"\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\u0002H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/basics/SerializeFluidStack;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "Lnet/minecraftforge/fluids/FluidStack;", "<init>", "()V", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "existing", "syncing", "", "writeNBT", "Lnet/minecraft/nbt/NBTTagCompound;", "value", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "writeBytes", "", "getDefault", "LibrarianLib-Continuous-1.12.2"})
public final class SerializeFluidStack
extends Serializer<FluidStack> {
    @NotNull
    public static final SerializeFluidStack INSTANCE = new SerializeFluidStack();

    private SerializeFluidStack() {
        super(FieldType.Companion.create(FluidStack.class));
    }

    @Override
    @NotNull
    protected FluidStack readNBT(@NotNull NBTBase nbt, @Nullable FluidStack existing, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)NBTHelper.castOrDefault(nbt, NBTTagCompound.class));
        Intrinsics.checkNotNull((Object)fluidStack);
        return fluidStack;
    }

    @NotNull
    protected NBTTagCompound writeNBT(@NotNull FluidStack value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        NBTTagCompound nBTTagCompound = value.writeToNBT(new NBTTagCompound());
        Intrinsics.checkNotNull((Object)nBTTagCompound);
        return nBTTagCompound;
    }

    @Override
    @NotNull
    protected FluidStack readBytes(@NotNull ByteBuf buf, @Nullable FluidStack existing, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        FluidStack fluidStack = CommonUtilMethods.readFluidStack(buf);
        if (fluidStack == null) {
            fluidStack = new FluidStack(FluidRegistry.WATER, 0);
        }
        return fluidStack;
    }

    @Override
    protected void writeBytes(@NotNull ByteBuf buf, @NotNull FluidStack value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CommonUtilMethods.writeFluidStack(buf, value);
    }

    @Override
    @NotNull
    public FluidStack getDefault() {
        return new FluidStack(FluidRegistry.WATER, 0);
    }
}

