/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.primitives;

import com.teamwizardry.librarianlib.features.autoregister.SerializerRegister;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializerRegister(classes={String[].class})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0002\u0010\u0007J3\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\t\u001a\u00020\n2\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u000eJ#\u0010\u000f\u001a\u00020\n2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0011J3\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0015J+\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\f\u001a\u00020\rH\u0014\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/primitives/SerializeStringArray;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "", "", "<init>", "()V", "getDefault", "()[Ljava/lang/String;", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "existing", "syncing", "", "(Lnet/minecraft/nbt/NBTBase;[Ljava/lang/String;Z)[Ljava/lang/String;", "writeNBT", "value", "([Ljava/lang/String;Z)Lnet/minecraft/nbt/NBTBase;", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/String;Z)[Ljava/lang/String;", "writeBytes", "", "(Lio/netty/buffer/ByteBuf;[Ljava/lang/String;Z)V", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nPrimitiveArrays.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrimitiveArrays.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/builtin/primitives/SerializeStringArray\n+ 2 ExtNBT.kt\ncom/teamwizardry/librarianlib/features/kotlin/CommonUtilMethods__ExtNBTKt\n+ 3 NBTHelper.kt\ncom/teamwizardry/librarianlib/features/helpers/NBTHelper\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n29#2,2:324\n31#2:327\n61#3:326\n13346#4,2:328\n13346#4,2:332\n1863#5,2:330\n*S KotlinDebug\n*F\n+ 1 PrimitiveArrays.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/builtin/primitives/SerializeStringArray\n*L\n292#1:324,2\n292#1:327\n292#1:326\n303#1:328,2\n319#1:332,2\n310#1:330,2\n*E\n"})
public final class SerializeStringArray
extends Serializer<String[]> {
    @NotNull
    public static final SerializeStringArray INSTANCE = new SerializeStringArray();

    private SerializeStringArray() {
        super(FieldType.Companion.create(String[].class));
    }

    @Override
    @NotNull
    public String[] getDefault() {
        int n = 0;
        String[] stringArray = new String[]{};
        while (n < 0) {
            int n2 = n++;
            stringArray[n2] = "";
        }
        return stringArray;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected String[] readNBT(@NotNull NBTBase nbt, @Nullable String[] existing, boolean syncing) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        NBTTagList list = NBTHelper.castOrDefault(nbt, NBTTagList.class);
        if (existing != null && existing.length == list.func_74745_c()) {
            NBTTagList $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            Iterator iterator2 = ((Iterable)$this$forEachIndexed$iv).iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                void tag;
                int i$iv = n++;
                NBTBase tag$iv = (NBTBase)iterator2.next();
                Intrinsics.checkNotNull((Object)tag$iv);
                NBTBase $this$castOrDefault$iv$iv = tag$iv;
                boolean $i$f$castOrDefault = false;
                NBTBase nBTBase = NBTHelper.castOrDefault($this$castOrDefault$iv$iv, NBTBase.class);
                int i = i$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)NBTHelper.castOrDefault((NBTBase)tag, NBTTagString.class).func_150285_a_(), (String)"getString(...)");
            }
            stringArray = existing;
        } else {
            int n = 0;
            int n2 = list.func_74745_c();
            String[] stringArray2 = new String[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNullExpressionValue((Object)list.func_150307_f(n3), (String)"getStringTagAt(...)");
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    @NotNull
    protected NBTBase writeNBT(@NotNull String[] value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        NBTTagList tag = new NBTTagList();
        String[] $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String v = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            tag.func_74742_a((NBTBase)new NBTTagString(v));
        }
        return (NBTBase)tag;
    }

    @Override
    @NotNull
    protected String[] readBytes(@NotNull ByteBuf buf, @Nullable String[] existing, boolean syncing) {
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        int length = CommonUtilMethods.readVarInt(buf);
        if (existing != null && existing.length == length) {
            Iterable $this$forEach$iv = (Iterable)ArraysKt.getIndices((Object[])existing);
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.iterator();
            while (iterator2.hasNext()) {
                int element$iv;
                int it = element$iv = ((IntIterator)iterator2).nextInt();
                boolean bl = false;
                existing[it] = CommonUtilMethods.readString(buf);
            }
            stringArray = existing;
        } else {
            int n = 0;
            String[] stringArray2 = new String[length];
            while (n < length) {
                int n2 = n++;
                stringArray2[n2] = CommonUtilMethods.readString(buf);
            }
            stringArray = stringArray2;
        }
        return stringArray;
    }

    @Override
    protected void writeBytes(@NotNull ByteBuf buf, @NotNull String[] value, boolean syncing) {
        Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        CommonUtilMethods.writeVarInt(buf, value.length);
        String[] $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            CommonUtilMethods.writeString(buf, it);
        }
    }
}

