/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.saving.serializers.builtin.special;

import com.teamwizardry.librarianlib.features.autoregister.SerializerFactoryRegister;
import com.teamwizardry.librarianlib.features.helpers.NBTHelper;
import com.teamwizardry.librarianlib.features.kotlin.CommonUtilMethods;
import com.teamwizardry.librarianlib.features.saving.FieldCache;
import com.teamwizardry.librarianlib.features.saving.FieldType;
import com.teamwizardry.librarianlib.features.saving.Savable;
import com.teamwizardry.librarianlib.features.saving.SaveInPlace;
import com.teamwizardry.librarianlib.features.saving.SavingFieldFlag;
import com.teamwizardry.librarianlib.features.saving.serializers.Serializer;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerException;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerFactory;
import com.teamwizardry.librarianlib.features.saving.serializers.SerializerFactoryMatch;
import com.teamwizardry.librarianlib.features.saving.serializers.builtin.special.SerializerAnalysis;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.BooleanIterator;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.ArrayIteratorsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerializerFactoryRegister
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bJ\u0014\u0010\f\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializeObjectFactory;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactory;", "<init>", "()V", "canApply", "Lcom/teamwizardry/librarianlib/features/saving/serializers/SerializerFactoryMatch;", "type", "Lcom/teamwizardry/librarianlib/features/saving/FieldType;", "inPlaceCheck", "", "clazz", "Ljava/lang/Class;", "create", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "SerializeObject", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Objects.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializeObjectFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,362:1\n1#2:363\n*E\n"})
public final class SerializeObjectFactory
extends SerializerFactory {
    @NotNull
    public static final SerializeObjectFactory INSTANCE = new SerializeObjectFactory();

    private SerializeObjectFactory() {
        super("Object");
    }

    @Override
    @NotNull
    public SerializerFactoryMatch canApply(@NotNull FieldType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean savable = type.getClazz().isAnnotationPresent(Savable.class);
        boolean inplace = this.inPlaceCheck(type.getClazz());
        return savable || inplace ? SerializerFactoryMatch.GENERAL : SerializerFactoryMatch.NONE;
    }

    public final boolean inPlaceCheck(@NotNull Class<?> clazz) {
        boolean bl;
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (clazz.isAnnotationPresent(SaveInPlace.class)) {
            return true;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != null) {
            Class<?> it = clazz2;
            boolean bl2 = false;
            bl = INSTANCE.inPlaceCheck(it);
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Serializer<?> create(@NotNull FieldType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return new SerializeObject(type, new SerializerAnalysis(type));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000b\u001a\u00020\u0002H\u0016J\"\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J2\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u0011J\u0018\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J2\u0010\u001e\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u0011J\"\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J<\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u00152\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u0011H\u0002J \u0010$\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0014R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006%"}, d2={"Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializeObjectFactory$SerializeObject;", "Lcom/teamwizardry/librarianlib/features/saving/serializers/Serializer;", "", "type", "Lcom/teamwizardry/librarianlib/features/saving/FieldType;", "analysis", "Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializerAnalysis;", "<init>", "(Lcom/teamwizardry/librarianlib/features/saving/FieldType;Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializerAnalysis;)V", "getAnalysis", "()Lcom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializerAnalysis;", "getDefault", "readNBT", "nbt", "Lnet/minecraft/nbt/NBTBase;", "existing", "syncing", "", "readFields", "", "map", "", "", "Lcom/teamwizardry/librarianlib/features/saving/FieldCache;", "tag", "Lnet/minecraft/nbt/NBTTagCompound;", "instance", "sync", "writeNBT", "value", "writeFields", "readBytes", "buf", "Lio/netty/buffer/ByteBuf;", "nullsig", "Lkotlin/collections/BooleanIterator;", "writeBytes", "LibrarianLib-Continuous-1.12.2"})
    @SourceDebugExtension(value={"SMAP\nObjects.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Objects.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializeObjectFactory$SerializeObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,362:1\n1557#2:363\n1628#2,3:364\n1557#2:369\n1628#2,3:370\n1557#2:385\n1628#2,3:386\n37#3,2:367\n37#3,2:373\n37#3,2:389\n37#3,2:399\n216#4,2:375\n216#4,2:377\n216#4,2:379\n216#4,2:381\n216#4,2:383\n216#4,2:391\n216#4,2:393\n216#4,2:395\n216#4,2:397\n216#4,2:401\n216#4,2:403\n216#4,2:405\n*S KotlinDebug\n*F\n+ 1 Objects.kt\ncom/teamwizardry/librarianlib/features/saving/serializers/builtin/special/SerializeObjectFactory$SerializeObject\n*L\n43#1:363\n43#1:364,3\n62#1:369\n62#1:370,3\n177#1:385\n177#1:386,3\n45#1:367,2\n72#1:373,2\n179#1:389,2\n238#1:399,2\n82#1:375,2\n120#1:377,2\n146#1:379,2\n156#1:381,2\n166#1:383,2\n187#1:391,2\n213#1:393,2\n221#1:395,2\n229#1:397,2\n240#1:401,2\n251#1:403,2\n261#1:405,2\n*E\n"})
    public static final class SerializeObject
    extends Serializer<Object> {
        @NotNull
        private final SerializerAnalysis analysis;

        public SerializeObject(@NotNull FieldType type, @NotNull SerializerAnalysis analysis) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)analysis, (String)"analysis");
            super(type);
            this.analysis = analysis;
        }

        @NotNull
        public final SerializerAnalysis getAnalysis() {
            return this.analysis;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Object getDefault() {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = this.analysis.getConstructorArgOrder();
            Function1<Object[], Object> function1 = this.analysis.getConstructorMH();
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it);
                Intrinsics.checkNotNull(lazy);
                collection.add(((Serializer)lazy.getValue()).getDefault());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return function1.invoke((Object)thisCollection$iv.toArray(new Object[0]));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Object readNBT(@NotNull NBTBase nbt, @Nullable Object existing, boolean syncing) {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            NBTTagCompound tag;
            block14: {
                Object object;
                block15: {
                    Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
                    tag = NBTHelper.castOrDefault(nbt, NBTTagCompound.class);
                    if (!this.analysis.getMutable()) break block14;
                    if (existing != null) break block15;
                    Parameter[] parameterArray = this.analysis.getConstructor().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
                    if (!(((Object[])parameterArray).length == 0)) break block14;
                }
                if ((object = existing) == null) {
                    object = this.analysis.getConstructorMH().invoke((Object)new Object[0]);
                }
                Object instance = object;
                this.readFields(this.analysis.getAlwaysFields(), tag, instance, syncing);
                if (!syncing) {
                    this.readFields(this.analysis.getNoSyncFields(), tag, instance, syncing);
                } else {
                    this.readFields(this.analysis.getNonPersistentFields(), tag, instance, syncing);
                }
                return instance;
            }
            Iterable $this$map$iv = this.analysis.getConstructorArgOrder();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Object v5;
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                if (tag.func_74764_b((String)it)) {
                    Object var15_17;
                    try {
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it);
                        Intrinsics.checkNotNull(lazy);
                        Serializer serializer = (Serializer)lazy.getValue();
                        NBTBase nBTBase = tag.func_74781_a((String)it);
                        Intrinsics.checkNotNullExpressionValue((Object)nBTBase, (String)"getTag(...)");
                        var15_17 = serializer.read(nBTBase, null, syncing);
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error reading value for field " + (String)it + " from NBT", e);
                    }
                    v5 = var15_17;
                } else {
                    v5 = null;
                }
                collection.add(v5);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] args = thisCollection$iv.toArray(new Object[0]);
            try {
                return this.analysis.getConstructorMH().invoke((Object)args);
            }
            catch (Throwable e) {
                throw new SerializerException("Error creating instance of type " + this.getType(), e);
            }
        }

        public final void readFields(@NotNull Map<String, FieldCache> map, @NotNull NBTTagCompound tag, @NotNull Object instance, boolean sync) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Map<String, FieldCache> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FieldCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, FieldCache> element$iv;
                Map.Entry<String, FieldCache> it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    Object value;
                    Object object;
                    Object oldValue = it.getValue().getGetter().invoke(instance);
                    if (tag.func_74764_b(it.getKey())) {
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        Serializer serializer = (Serializer)lazy.getValue();
                        NBTBase nBTBase = tag.func_74781_a(it.getKey());
                        Intrinsics.checkNotNullExpressionValue((Object)nBTBase, (String)"getTag(...)");
                        object = serializer.read(nBTBase, oldValue, sync);
                    } else {
                        object = value = it.getValue().getMeta().hasFlag(SavingFieldFlag.FINAL) ? oldValue : null;
                    }
                    if (it.getValue().getMeta().hasFlag(SavingFieldFlag.FINAL)) {
                        if (oldValue == value) continue;
                        throw new SerializerException("Cannot set final field to new value. Either make the field mutable or modify the serializer to change the existing object instead of creating a new one.");
                    }
                    it.getValue().getSetter().invoke(instance, value);
                }
                catch (Throwable e) {
                    throw new SerializerException("Error reading field " + it.getValue().getName() + " from NBT", e);
                }
            }
        }

        @Override
        @NotNull
        protected NBTBase writeNBT(@NotNull Object value, boolean syncing) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            NBTTagCompound tag = new NBTTagCompound();
            this.writeFields(this.analysis.getAlwaysFields(), value, tag, syncing);
            if (!syncing) {
                this.writeFields(this.analysis.getNoSyncFields(), value, tag, syncing);
            } else {
                this.writeFields(this.analysis.getNonPersistentFields(), value, tag, syncing);
            }
            return (NBTBase)tag;
        }

        public final void writeFields(@NotNull Map<String, FieldCache> map, @NotNull Object value, @NotNull NBTTagCompound tag, boolean sync) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            Map<String, FieldCache> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FieldCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, FieldCache> element$iv;
                Map.Entry<String, FieldCache> it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    Object fieldValue = it.getValue().getGetter().invoke(value);
                    if (fieldValue == null) continue;
                    Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                    Intrinsics.checkNotNull(lazy);
                    tag.func_74782_a(it.getKey(), ((Serializer)lazy.getValue()).write(fieldValue, sync));
                }
                catch (Throwable e) {
                    throw new SerializerException("Error writing field " + it.getValue().getName() + " to NBT", e);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected Object readBytes(@NotNull ByteBuf buf, @Nullable Object existing, boolean syncing) {
            Map.Entry<String, FieldCache> it;
            Map.Entry<String, FieldCache> element$iv;
            BooleanIterator nulliter;
            block20: {
                Object object;
                block21: {
                    Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
                    boolean[] nullsig = CommonUtilMethods.readBooleanArray$default(buf, null, 1, null);
                    nulliter = ArrayIteratorsKt.iterator((boolean[])nullsig);
                    if (!this.analysis.getMutable()) break block20;
                    if (existing != null) break block21;
                    Parameter[] parameterArray = this.analysis.getConstructor().getParameters();
                    Intrinsics.checkNotNullExpressionValue((Object)parameterArray, (String)"getParameters(...)");
                    if (!(((Object[])parameterArray).length == 0)) break block20;
                }
                if ((object = existing) == null) {
                    object = this.analysis.getConstructorMH().invoke((Object)new Object[0]);
                }
                Object instance = object;
                this.readFields(this.analysis.getAlwaysFields(), buf, instance, nulliter, syncing);
                if (!syncing) {
                    this.readFields(this.analysis.getNoSyncFields(), buf, instance, nulliter, syncing);
                } else {
                    this.readFields(this.analysis.getNonPersistentFields(), buf, instance, nulliter, syncing);
                }
                return instance;
            }
            Map map = new LinkedHashMap();
            Object $this$forEach$iv = this.analysis.getAlwaysFields();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FieldCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    if (nulliter.nextBoolean()) continue;
                    String string = it.getKey();
                    Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                    Intrinsics.checkNotNull(lazy);
                    map.put(string, ((Serializer)lazy.getValue()).read(buf, null, syncing));
                }
                catch (Throwable e) {
                    throw new SerializerException("Error reading field " + it.getValue().getName() + " from bytes", e);
                }
            }
            if (!syncing) {
                $this$forEach$iv = this.analysis.getNoSyncFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        if (nulliter.nextBoolean()) continue;
                        String string = it.getKey();
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        map.put(string, ((Serializer)lazy.getValue()).read(buf, null, syncing));
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error reading field " + it.getValue().getName() + " from bytes", e);
                    }
                }
            } else {
                $this$forEach$iv = this.analysis.getNonPersistentFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        if (nulliter.nextBoolean()) continue;
                        String string = it.getKey();
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        map.put(string, ((Serializer)lazy.getValue()).read(buf, null, syncing));
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error reading field " + it.getValue().getName() + " from bytes", e);
                    }
                }
            }
            try {
                void $this$toTypedArray$iv;
                void $this$mapTo$iv$iv;
                Collection $this$map$iv;
                $this$forEach$iv = this.analysis.getConstructorArgOrder();
                Function1<Object[], Object> function1 = this.analysis.getConstructorMH();
                boolean $i$f$map = false;
                iterator2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    String string = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(map.get(it2));
                }
                $this$map$iv = (List)destination$iv$iv;
                boolean $i$f$toTypedArray = false;
                void thisCollection$iv = $this$toTypedArray$iv;
                return function1.invoke((Object)thisCollection$iv.toArray(new Object[0]));
            }
            catch (Throwable e) {
                throw new SerializerException("Error creating instance of type " + this.getType(), e);
            }
        }

        private final void readFields(Map<String, FieldCache> map, ByteBuf buf, Object instance, BooleanIterator nullsig, boolean sync) {
            Map<String, FieldCache> $this$forEach$iv = map;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FieldCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry<String, FieldCache> element$iv;
                Map.Entry<String, FieldCache> it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    Object value;
                    Object object;
                    Object oldValue = it.getValue().getGetter().invoke(instance);
                    if (nullsig.nextBoolean()) {
                        object = null;
                    } else {
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        object = value = ((Serializer)lazy.getValue()).read(buf, oldValue, sync);
                    }
                    if (it.getValue().getMeta().hasFlag(SavingFieldFlag.FINAL)) {
                        if (oldValue == value) continue;
                        throw new SerializerException("Cannot set final field to new value. Either make the field mutable or modify the serializer to change the existing object instead of creating a new one.");
                    }
                    it.getValue().getSetter().invoke(instance, value);
                }
                catch (Throwable e) {
                    throw new SerializerException("Error reading field " + it.getValue().getName() + " from bytes", e);
                }
            }
        }

        @Override
        protected void writeBytes(@NotNull ByteBuf buf, @NotNull Object value, boolean syncing) {
            Object fieldValue;
            Map.Entry<String, FieldCache> it;
            Map.Entry<String, FieldCache> element$iv;
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            List nullsig = new ArrayList();
            Map<String, FieldCache> $this$forEach$iv = this.analysis.getAlwaysFields();
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, FieldCache>> iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    nullsig.add(it.getValue().getGetter().invoke(value) == null);
                }
                catch (Throwable e) {
                    throw new SerializerException("Error getting field " + it.getValue().getName() + " for nullsig", e);
                }
            }
            if (!syncing) {
                $this$forEach$iv = this.analysis.getNoSyncFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        nullsig.add(it.getValue().getGetter().invoke(value) == null);
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error getting field " + it.getValue().getName() + " for nullsig", e);
                    }
                }
            } else {
                $this$forEach$iv = this.analysis.getNonPersistentFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        nullsig.add(it.getValue().getGetter().invoke(value) == null);
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error getting field " + it.getValue().getName() + " for nullsig", e);
                    }
                }
            }
            Collection $this$toTypedArray$iv = nullsig;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CommonUtilMethods.writeBooleanArray(buf, ArraysKt.toBooleanArray((Boolean[])thisCollection$iv.toArray(new Boolean[0])));
            $this$forEach$iv = this.analysis.getAlwaysFields();
            $i$f$forEach = false;
            iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                try {
                    fieldValue = it.getValue().getGetter().invoke(value);
                    if (fieldValue == null) continue;
                    Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                    Intrinsics.checkNotNull(lazy);
                    ((Serializer)lazy.getValue()).write(buf, fieldValue, syncing);
                }
                catch (Throwable e) {
                    throw new SerializerException("Error writing field " + it.getValue().getName() + " to bytes", e);
                }
            }
            if (!syncing) {
                $this$forEach$iv = this.analysis.getNoSyncFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        fieldValue = it.getValue().getGetter().invoke(value);
                        if (fieldValue == null) continue;
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        ((Serializer)lazy.getValue()).write(buf, fieldValue, syncing);
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error writing field " + it.getValue().getName() + " to bytes", e);
                    }
                }
            } else {
                $this$forEach$iv = this.analysis.getNonPersistentFields();
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    try {
                        fieldValue = it.getValue().getGetter().invoke(value);
                        if (fieldValue == null) continue;
                        Lazy<Serializer<Object>> lazy = this.analysis.getSerializers().get(it.getKey());
                        Intrinsics.checkNotNull(lazy);
                        ((Serializer)lazy.getValue()).write(buf, fieldValue, syncing);
                    }
                    catch (Throwable e) {
                        throw new SerializerException("Error writing field " + it.getValue().getName() + " to bytes", e);
                    }
                }
            }
        }
    }
}

