/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.shader;

import com.teamwizardry.librarianlib.core.LibrarianLog;
import com.teamwizardry.librarianlib.core.common.LibLibConfig;
import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.shader.Shader;
import com.teamwizardry.librarianlib.features.shader.uniforms.FloatTypes;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.GL20;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u001d\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00112\u0006\u0010\u0015\u001a\u0002H\u0014\u00a2\u0006\u0002\u0010\u0016J\u0006\u0010\u0017\u001a\u00020\u000bJ/\u0010\u0018\u001a\u00020\u000b\"\b\b\u0000\u0010\u0014*\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u0001H\u00142\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u0002H\u0014\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001f\u0010\u0018\u001a\u00020\u000b\"\b\b\u0000\u0010\u0014*\u00020\u00112\b\u0010\u0015\u001a\u0004\u0018\u0001H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0006\u0010\u001e\u001a\u00020\u0005J\u0010\u0010\u001f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\rH\u0002J\u0010\u0010$\u001a\u00020\"2\u0006\u0010%\u001a\u00020\rH\u0002J\u0010\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020(H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/teamwizardry/librarianlib/features/shader/ShaderHelper;", "", "<init>", "()V", "enableValidation", "", "getEnableValidation", "()Z", "setEnableValidation", "(Z)V", "init", "", "VERT", "", "FRAG", "shaders", "Ljava/util/ArrayList;", "Lcom/teamwizardry/librarianlib/features/shader/Shader;", "hasLoaded", "addShader", "T", "shader", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;)Lcom/teamwizardry/librarianlib/features/shader/Shader;", "initShaders", "useShader", "callback", "Ljava/util/function/Consumer;", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;Ljava/util/function/Consumer;)V", "(Lcom/teamwizardry/librarianlib/features/shader/Shader;)V", "releaseShader", "useShaders", "createProgram", "createShader", "fileText", "", "shaderType", "getLogInfo", "obj", "readFileAsString", "resourceLocation", "Lnet/minecraft/util/ResourceLocation;", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nShaderHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShaderHelper.kt\ncom/teamwizardry/librarianlib/features/shader/ShaderHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class ShaderHelper {
    @NotNull
    public static final ShaderHelper INSTANCE = new ShaderHelper();
    private static boolean enableValidation;
    private static final int VERT;
    private static final int FRAG;
    @NotNull
    private static final ArrayList<Shader> shaders;
    private static boolean hasLoaded;

    private ShaderHelper() {
    }

    public final boolean getEnableValidation() {
        return enableValidation;
    }

    public final void setEnableValidation(boolean bl) {
        enableValidation = bl;
    }

    public final void init() {
        this.initShaders();
        ClientRunnable.registerReloadHandler(ShaderHelper::init$lambda$0);
    }

    @NotNull
    public final <T extends Shader> T addShader(@NotNull T shader) {
        Intrinsics.checkNotNullParameter(shader, (String)"shader");
        shaders.add(shader);
        if (hasLoaded && this.useShaders()) {
            this.createProgram(shader);
        }
        return shader;
    }

    public final void initShaders() {
        if (!this.useShaders()) {
            return;
        }
        Iterator<Shader> iterator2 = shaders.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<Shader> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            Shader shader;
            Intrinsics.checkNotNullExpressionValue((Object)iterator3.next(), (String)"next(...)");
            this.createProgram(shader);
        }
        hasLoaded = true;
    }

    public final <T extends Shader> void useShader(@Nullable T shader, @Nullable Consumer<T> callback) {
        block6: {
            if (shader == null) {
                ARBShaderObjects.glUseProgramObjectARB((int)0);
                return;
            }
            if (!this.useShaders()) {
                return;
            }
            ARBShaderObjects.glUseProgramObjectARB((int)shader.getGlName());
            if (shader.getTime() != null) {
                long nanos = System.nanoTime();
                double seconds = (double)nanos / 1.0E9;
                seconds %= 100000.0;
                FloatTypes.FloatUniform floatUniform = shader.getTime();
                if (floatUniform != null) {
                    floatUniform.set(seconds);
                }
            }
            shader.uniformDefaults();
            if (enableValidation) {
                ARBShaderObjects.glValidateProgramARB((int)shader.getGlName());
                if (ARBShaderObjects.glGetObjectParameteriARB((int)shader.getGlName(), (int)35715) == 0) {
                    LibrarianLog.INSTANCE.error(this.getLogInfo(shader.getGlName()), new Object[0]);
                }
            }
            Consumer<T> consumer = callback;
            if (consumer == null) break block6;
            consumer.accept(shader);
        }
    }

    public final <T extends Shader> void useShader(@Nullable T shader) {
        this.useShader(shader, null);
    }

    public final void releaseShader() {
        this.useShader(null);
    }

    public final boolean useShaders() {
        try {
            return FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT && LibLibConfig.getShaders() && OpenGlHelper.field_148824_g;
        }
        catch (NoSuchFieldError ignored) {
            return false;
        }
    }

    private final int createProgram(Shader shader) {
        StackTraceElement elem;
        Iterator iterator2;
        ResourceLocation vert = shader.getVertRl();
        ResourceLocation frag = shader.getFragRl();
        int vertId = 0;
        int fragId = 0;
        int program = 0;
        String vertText = null;
        String fragText = null;
        if (vert != null) {
            try {
                vertText = this.readFileAsString(vert);
                vertId = this.createShader(vertText, VERT);
            }
            catch (Exception e) {
                vertText = "ERROR: \n" + e;
                iterator2 = ArrayIteratorKt.iterator((Object[])e.getStackTrace());
                while (iterator2.hasNext()) {
                    elem = (StackTraceElement)iterator2.next();
                    vertText = vertText + '\n' + elem;
                }
            }
        }
        if (frag != null) {
            try {
                fragText = this.readFileAsString(frag);
                fragId = this.createShader(fragText, FRAG);
            }
            catch (Exception e) {
                fragText = "ERROR: \n" + e;
                iterator2 = ArrayIteratorKt.iterator((Object[])e.getStackTrace());
                while (iterator2.hasNext()) {
                    elem = (StackTraceElement)iterator2.next();
                    fragText = fragText + '\n' + elem;
                }
            }
        }
        if (shader.getGlName() != 0) {
            GL20.glDeleteProgram((int)shader.getGlName());
        }
        if ((program = ARBShaderObjects.glCreateProgramObjectARB()) == 0) {
            return 0;
        }
        if (vert != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)vertId);
        }
        if (frag != null) {
            ARBShaderObjects.glAttachObjectARB((int)program, (int)fragId);
        }
        ARBShaderObjects.glLinkProgramARB((int)program);
        if (ARBShaderObjects.glGetObjectParameteriARB((int)program, (int)35714) == 0) {
            LibrarianLog.INSTANCE.error(this.getLogInfo(program), new Object[0]);
            return 0;
        }
        Object[] objectArray = new Object[]{program, vert, frag};
        LibrarianLog.INSTANCE.info("Created program %d - VERT:'%s' FRAG:'%s'", objectArray);
        shader.init(program);
        return program;
    }

    private final int createShader(String fileText, int shaderType) {
        int shader = 0;
        try {
            shader = ARBShaderObjects.glCreateShaderObjectARB((int)shaderType);
            if (shader == 0) {
                return 0;
            }
            ARBShaderObjects.glShaderSourceARB((int)shader, (CharSequence)fileText);
            ARBShaderObjects.glCompileShaderARB((int)shader);
            if (ARBShaderObjects.glGetObjectParameteriARB((int)shader, (int)35713) == 0) {
                throw new RuntimeException("Error creating shader: " + this.getLogInfo(shader));
            }
            return shader;
        }
        catch (Exception e) {
            ARBShaderObjects.glDeleteObjectARB((int)shader);
            e.printStackTrace();
            return -1;
        }
    }

    private final String getLogInfo(int obj) {
        String string = ARBShaderObjects.glGetInfoLogARB((int)obj, (int)ARBShaderObjects.glGetObjectParameteriARB((int)obj, (int)35716));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"glGetInfoLogARB(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readFileAsString(ResourceLocation resourceLocation) throws Exception {
        String string;
        Closeable closeable = Client.INSTANCE.getResourceManager().func_110536_a(resourceLocation).func_110527_b();
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            InputStream inputStream = it;
            Charset charset = Charsets.UTF_8;
            string = TextStreamsKt.readText((Reader)new InputStreamReader(inputStream, charset));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    private static final void init$lambda$0() {
        INSTANCE.initShaders();
    }

    static {
        VERT = 35633;
        FRAG = 35632;
        shaders = new ArrayList();
    }
}

