/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.sprite.ISprite;
import java.util.ArrayList;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0002;<B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\u000b\u001a\u00020\nJH\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0007J6\u0010\u0018\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J8\u0010\u001a\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J8\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0002Jp\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00122\u0006\u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u00122\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020\u0012H\u0002J>\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-2\u0006\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u00122\u0006\u00101\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u00052\u0006\u00103\u001a\u00020\u00052\u0006\u00104\u001a\u00020\u0012H\u0002JF\u00105\u001a\u00020\n2\f\u00106\u001a\b\u0012\u0004\u0012\u00020.072\u0006\u00108\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\u0006\u00104\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00122\u0006\u0010:\u001a\u00020\u00122\u0006\u00102\u001a\u00020\u0005H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0006\"\u0004\b\u0007\u0010\bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil;", "", "<init>", "()V", "isDrawing", "", "()Z", "setDrawing", "(Z)V", "startDrawingSession", "", "endDrawingSession", "drawClipped", "sprite", "Lcom/teamwizardry/librarianlib/features/sprite/ISprite;", "animTicks", "", "x", "", "y", "width", "height", "reverseX", "reverseY", "draw", "animFrames", "drawSimple", "drawComplex", "spinValue", "Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil$DestructureUVs;", "spinUVs", "rotation", "spriteMinU", "spriteMinV", "spriteUSpan", "spriteVSpan", "u0", "v0", "u1", "v1", "u2", "v2", "u3", "v3", "getSections", "", "Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil$Section;", "logicalSize", "startCap", "endCap", "pinStart", "pinEnd", "targetSize", "addMiddleSections", "sections", "", "texSize", "minPos", "minTex", "DestructureUVs", "Section", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nDrawingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DrawingUtil.kt\ncom/teamwizardry/librarianlib/features/sprite/DrawingUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,281:1\n1863#2:282\n1863#2,2:283\n1864#2:285\n*S KotlinDebug\n*F\n+ 1 DrawingUtil.kt\ncom/teamwizardry/librarianlib/features/sprite/DrawingUtil\n*L\n129#1:282\n130#1:283,2\n129#1:285\n*E\n"})
public final class DrawingUtil {
    @NotNull
    public static final DrawingUtil INSTANCE = new DrawingUtil();
    private static boolean isDrawing;
    @NotNull
    private static final DestructureUVs spinValue;

    private DrawingUtil() {
    }

    public final boolean isDrawing() {
        return isDrawing;
    }

    public final void setDrawing(boolean bl) {
        isDrawing = bl;
    }

    public final void startDrawingSession() {
        Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
        isDrawing = true;
    }

    public final void endDrawingSession() {
        Tessellator.func_178181_a().func_78381_a();
        isDrawing = false;
    }

    @Deprecated(message="Replaced with sprite pinning functionality", replaceWith=@ReplaceWith(expression="draw(sprite.pinnedWrapper(!reverseY, reverseY, !reverseX, reverseX), animTicks, x, y, width.toFloat(), height.toFloat())", imports={}))
    public final void drawClipped(@NotNull ISprite sprite, int animTicks, float x, float y, int width, int height, boolean reverseX, boolean reverseY) {
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        this.draw(sprite.pinnedWrapper(!reverseY, reverseY, !reverseX, reverseX), animTicks, x, y, width, height);
    }

    public final void draw(@NotNull ISprite sprite, int animFrames, float x, float y, float width, float height) {
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        if (!isDrawing) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        }
        if (sprite.getPinTop() && sprite.getPinBottom() && sprite.getPinLeft() && sprite.getPinRight() && sprite.getMinUCap() == 0.0f && sprite.getMinVCap() == 0.0f && sprite.getMaxUCap() == 0.0f && sprite.getMaxVCap() == 0.0f) {
            this.drawSimple(sprite, animFrames, x, y, width, height);
        } else {
            this.drawComplex(sprite, animFrames, x, y, width, height);
        }
        if (!isDrawing) {
            tessellator.func_78381_a();
        }
    }

    private final void drawSimple(ISprite sprite, int animFrames, float x, float y, float width, float height) {
        float minX = x;
        float minY = y;
        float maxX = x + width;
        float maxY = y + height;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a((double)sprite.minU(animFrames), (double)sprite.maxV(animFrames)).func_181675_d();
        vb.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a((double)sprite.maxU(animFrames), (double)sprite.maxV(animFrames)).func_181675_d();
        vb.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a((double)sprite.maxU(animFrames), (double)sprite.minV(animFrames)).func_181675_d();
        vb.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a((double)sprite.minU(animFrames), (double)sprite.minV(animFrames)).func_181675_d();
    }

    private final void drawComplex(ISprite sprite, int animFrames, float x, float y, float width, float height) {
        List<Section> xSections = this.getSections(sprite.getWidth(), sprite.getMinUCap(), sprite.getMaxUCap(), sprite.getPinLeft(), sprite.getPinRight(), width);
        List<Section> ySections = this.getSections(sprite.getHeight(), sprite.getMinVCap(), sprite.getMaxVCap(), sprite.getPinTop(), sprite.getPinBottom(), height);
        int rotation = sprite.getRotation();
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        float spriteMinU = sprite.minU(animFrames);
        float spriteMinV = sprite.minV(animFrames);
        float spriteUSpan = sprite.maxU(animFrames) - spriteMinU;
        float spriteVSpan = sprite.maxV(animFrames) - spriteMinV;
        Iterable $this$forEach$iv = xSections;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Section xSection = (Section)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = ySections;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Section ySection = (Section)element$iv2;
                boolean bl2 = false;
                float minX = x + xSection.getMinPos();
                float minY = y + ySection.getMinPos();
                float maxX = x + xSection.getMaxPos();
                float maxY = y + ySection.getMaxPos();
                DestructureUVs destructureUVs = INSTANCE.spinUVs(rotation, spriteMinU, spriteMinV, spriteUSpan, spriteVSpan, xSection.getMinTex(), ySection.getMaxTex(), xSection.getMaxTex(), ySection.getMaxTex(), xSection.getMaxTex(), ySection.getMinTex(), xSection.getMinTex(), ySection.getMinTex());
                double u0 = destructureUVs.component1();
                double v0 = destructureUVs.component2();
                double u1 = destructureUVs.component3();
                double v1 = destructureUVs.component4();
                double u2 = destructureUVs.component5();
                double v2 = destructureUVs.component6();
                double u3 = destructureUVs.component7();
                double v3 = destructureUVs.component8();
                vb.func_181662_b((double)minX, (double)maxY, 0.0).func_187315_a(u0, v0).func_181675_d();
                vb.func_181662_b((double)maxX, (double)maxY, 0.0).func_187315_a(u1, v1).func_181675_d();
                vb.func_181662_b((double)maxX, (double)minY, 0.0).func_187315_a(u2, v2).func_181675_d();
                vb.func_181662_b((double)minX, (double)minY, 0.0).func_187315_a(u3, v3).func_181675_d();
            }
        }
    }

    private final DestructureUVs spinUVs(int rotation, float spriteMinU, float spriteMinV, float spriteUSpan, float spriteVSpan, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
        double u02 = (double)u0 - 0.5;
        double v02 = (double)v0 - 0.5;
        double u12 = (double)u1 - 0.5;
        double v12 = (double)v1 - 0.5;
        double u22 = (double)u2 - 0.5;
        double v22 = (double)v2 - 0.5;
        double u32 = (double)u3 - 0.5;
        double v32 = (double)v3 - 0.5;
        switch (rotation % 4 + (rotation < 0 ? 4 : 0)) {
            case 1: {
                spinValue.setU0(v02);
                spinValue.setV0(-u02);
                spinValue.setU1(v12);
                spinValue.setV1(-u12);
                spinValue.setU2(v22);
                spinValue.setV2(-u22);
                spinValue.setU3(v32);
                spinValue.setV3(-u32);
                break;
            }
            case 2: {
                spinValue.setU0(-u02);
                spinValue.setV0(-v02);
                spinValue.setU1(-u12);
                spinValue.setV1(-v12);
                spinValue.setU2(-u22);
                spinValue.setV2(-v22);
                spinValue.setU3(-u32);
                spinValue.setV3(-v32);
                break;
            }
            case 3: {
                spinValue.setU0(-v02);
                spinValue.setV0(u02);
                spinValue.setU1(-v12);
                spinValue.setV1(u12);
                spinValue.setU2(-v22);
                spinValue.setV2(u22);
                spinValue.setU3(-v32);
                spinValue.setV3(u32);
                break;
            }
            default: {
                spinValue.setU0(u02);
                spinValue.setV0(v02);
                spinValue.setU1(u12);
                spinValue.setV1(v12);
                spinValue.setU2(u22);
                spinValue.setV2(v22);
                spinValue.setU3(u32);
                spinValue.setV3(v32);
            }
        }
        spinValue.setU0((double)spriteMinU + (spinValue.getU0() + 0.5) * (double)spriteUSpan);
        spinValue.setV0((double)spriteMinV + (spinValue.getV0() + 0.5) * (double)spriteVSpan);
        spinValue.setU1((double)spriteMinU + (spinValue.getU1() + 0.5) * (double)spriteUSpan);
        spinValue.setV1((double)spriteMinV + (spinValue.getV1() + 0.5) * (double)spriteVSpan);
        spinValue.setU2((double)spriteMinU + (spinValue.getU2() + 0.5) * (double)spriteUSpan);
        spinValue.setV2((double)spriteMinV + (spinValue.getV2() + 0.5) * (double)spriteVSpan);
        spinValue.setU3((double)spriteMinU + (spinValue.getU3() + 0.5) * (double)spriteUSpan);
        spinValue.setV3((double)spriteMinV + (spinValue.getV3() + 0.5) * (double)spriteVSpan);
        return spinValue;
    }

    private final List<Section> getSections(float logicalSize, float startCap, float endCap, boolean pinStart, boolean pinEnd, float targetSize) {
        if (targetSize == 0.0f) {
            return CollectionsKt.emptyList();
        }
        List sections = new ArrayList();
        float logicalStartCap = logicalSize * startCap;
        float logicalEndCap = logicalSize * endCap;
        if (!(logicalStartCap + logicalEndCap == 0.0f) && logicalStartCap + logicalEndCap > targetSize) {
            float factor = (logicalStartCap + logicalEndCap) / targetSize;
            sections.add(new Section(0.0f, logicalStartCap / factor, 0.0f, startCap / factor));
            sections.add(new Section(logicalStartCap / factor, logicalEndCap / factor, 1.0f - endCap / factor, 1.0f));
            return sections;
        }
        float pos2 = 0.0f;
        if (!(logicalStartCap == 0.0f)) {
            sections.add(new Section(0.0f, logicalStartCap, 0.0f, startCap));
            pos2 += logicalStartCap;
        }
        if (pinStart == pinEnd) {
            sections.add(new Section(logicalStartCap, targetSize - logicalEndCap, startCap, 1.0f - endCap));
        } else {
            this.addMiddleSections(sections, 1.0f - startCap - endCap, logicalSize - logicalStartCap - logicalEndCap, targetSize - logicalStartCap - logicalEndCap, pos2, startCap, pinStart);
        }
        if (!(logicalEndCap == 0.0f)) {
            sections.add(new Section(targetSize - logicalEndCap, targetSize, 1.0f - endCap, 1.0f));
        }
        return sections;
    }

    private final void addMiddleSections(List<Section> sections, float texSize, float logicalSize, float targetSize, float minPos, float minTex, boolean pinStart) {
        float fractionSize = targetSize % logicalSize;
        float fractionTexSize = fractionSize * texSize / logicalSize;
        int wholeCount = (int)(targetSize / logicalSize);
        float pos2 = minPos;
        float tex = minTex;
        if (!pinStart) {
            sections.add(new Section(pos2, pos2 + fractionSize, tex + texSize - fractionTexSize, tex + texSize));
            pos2 += fractionSize;
        }
        for (int i = 0; i < wholeCount; ++i) {
            sections.add(new Section(pos2, pos2 + logicalSize, tex, tex + texSize));
            pos2 += logicalSize;
        }
        if (pinStart) {
            sections.add(new Section(pos2, pos2 + fractionSize, tex, tex + fractionTexSize));
            pos2 += fractionSize;
        }
    }

    static {
        spinValue = new DestructureUVs(0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b%\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003JY\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010+\u001a\u00020,H\u00d6\u0001J\t\u0010-\u001a\u00020.H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000e\"\u0004\b\u0012\u0010\u0010R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0007\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000e\"\u0004\b\u0018\u0010\u0010R\u001a\u0010\b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u000e\"\u0004\b\u001a\u0010\u0010R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\n\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u0006/"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil$DestructureUVs;", "", "u0", "", "v0", "u1", "v1", "u2", "v2", "u3", "v3", "<init>", "(DDDDDDDD)V", "getU0", "()D", "setU0", "(D)V", "getV0", "setV0", "getU1", "setU1", "getV1", "setV1", "getU2", "setU2", "getV2", "setV2", "getU3", "setU3", "getV3", "setV3", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "equals", "", "other", "hashCode", "", "toString", "", "LibrarianLib-Continuous-1.12.2"})
    private static final class DestructureUVs {
        private double u0;
        private double v0;
        private double u1;
        private double v1;
        private double u2;
        private double v2;
        private double u3;
        private double v3;

        public DestructureUVs(double u0, double v0, double u1, double v1, double u2, double v2, double u3, double v3) {
            this.u0 = u0;
            this.v0 = v0;
            this.u1 = u1;
            this.v1 = v1;
            this.u2 = u2;
            this.v2 = v2;
            this.u3 = u3;
            this.v3 = v3;
        }

        public final double getU0() {
            return this.u0;
        }

        public final void setU0(double d) {
            this.u0 = d;
        }

        public final double getV0() {
            return this.v0;
        }

        public final void setV0(double d) {
            this.v0 = d;
        }

        public final double getU1() {
            return this.u1;
        }

        public final void setU1(double d) {
            this.u1 = d;
        }

        public final double getV1() {
            return this.v1;
        }

        public final void setV1(double d) {
            this.v1 = d;
        }

        public final double getU2() {
            return this.u2;
        }

        public final void setU2(double d) {
            this.u2 = d;
        }

        public final double getV2() {
            return this.v2;
        }

        public final void setV2(double d) {
            this.v2 = d;
        }

        public final double getU3() {
            return this.u3;
        }

        public final void setU3(double d) {
            this.u3 = d;
        }

        public final double getV3() {
            return this.v3;
        }

        public final void setV3(double d) {
            this.v3 = d;
        }

        public final double component1() {
            return this.u0;
        }

        public final double component2() {
            return this.v0;
        }

        public final double component3() {
            return this.u1;
        }

        public final double component4() {
            return this.v1;
        }

        public final double component5() {
            return this.u2;
        }

        public final double component6() {
            return this.v2;
        }

        public final double component7() {
            return this.u3;
        }

        public final double component8() {
            return this.v3;
        }

        @NotNull
        public final DestructureUVs copy(double u0, double v0, double u1, double v1, double u2, double v2, double u3, double v3) {
            return new DestructureUVs(u0, v0, u1, v1, u2, v2, u3, v3);
        }

        public static /* synthetic */ DestructureUVs copy$default(DestructureUVs destructureUVs, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, int n, Object object) {
            if ((n & 1) != 0) {
                d = destructureUVs.u0;
            }
            if ((n & 2) != 0) {
                d2 = destructureUVs.v0;
            }
            if ((n & 4) != 0) {
                d3 = destructureUVs.u1;
            }
            if ((n & 8) != 0) {
                d4 = destructureUVs.v1;
            }
            if ((n & 0x10) != 0) {
                d5 = destructureUVs.u2;
            }
            if ((n & 0x20) != 0) {
                d6 = destructureUVs.v2;
            }
            if ((n & 0x40) != 0) {
                d7 = destructureUVs.u3;
            }
            if ((n & 0x80) != 0) {
                d8 = destructureUVs.v3;
            }
            return destructureUVs.copy(d, d2, d3, d4, d5, d6, d7, d8);
        }

        @NotNull
        public String toString() {
            return "DestructureUVs(u0=" + this.u0 + ", v0=" + this.v0 + ", u1=" + this.u1 + ", v1=" + this.v1 + ", u2=" + this.u2 + ", v2=" + this.v2 + ", u3=" + this.u3 + ", v3=" + this.v3 + ')';
        }

        public int hashCode() {
            int result = Double.hashCode(this.u0);
            result = result * 31 + Double.hashCode(this.v0);
            result = result * 31 + Double.hashCode(this.u1);
            result = result * 31 + Double.hashCode(this.v1);
            result = result * 31 + Double.hashCode(this.u2);
            result = result * 31 + Double.hashCode(this.v2);
            result = result * 31 + Double.hashCode(this.u3);
            result = result * 31 + Double.hashCode(this.v3);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DestructureUVs)) {
                return false;
            }
            DestructureUVs destructureUVs = (DestructureUVs)other;
            if (Double.compare(this.u0, destructureUVs.u0) != 0) {
                return false;
            }
            if (Double.compare(this.v0, destructureUVs.v0) != 0) {
                return false;
            }
            if (Double.compare(this.u1, destructureUVs.u1) != 0) {
                return false;
            }
            if (Double.compare(this.v1, destructureUVs.v1) != 0) {
                return false;
            }
            if (Double.compare(this.u2, destructureUVs.u2) != 0) {
                return false;
            }
            if (Double.compare(this.v2, destructureUVs.v2) != 0) {
                return false;
            }
            if (Double.compare(this.u3, destructureUVs.u3) != 0) {
                return false;
            }
            return Double.compare(this.v3, destructureUVs.v3) == 0;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0010\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\n\"\u0004\b\u000e\u0010\fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/DrawingUtil$Section;", "", "minPos", "", "maxPos", "minTex", "maxTex", "<init>", "(FFFF)V", "getMinPos", "()F", "setMinPos", "(F)V", "getMaxPos", "setMaxPos", "getMinTex", "setMinTex", "getMaxTex", "setMaxTex", "LibrarianLib-Continuous-1.12.2"})
    private static final class Section {
        private float minPos;
        private float maxPos;
        private float minTex;
        private float maxTex;

        public Section(float minPos, float maxPos, float minTex, float maxTex) {
            this.minPos = minPos;
            this.maxPos = maxPos;
            this.minTex = minTex;
            this.maxTex = maxTex;
        }

        public final float getMinPos() {
            return this.minPos;
        }

        public final void setMinPos(float f) {
            this.minPos = f;
        }

        public final float getMaxPos() {
            return this.maxPos;
        }

        public final void setMaxPos(float f) {
            this.maxPos = f;
        }

        public final float getMinTex() {
            return this.minTex;
        }

        public final void setMinTex(float f) {
            this.minTex = f;
        }

        public final float getMaxTex() {
            return this.maxTex;
        }

        public final void setMaxTex(float f) {
            this.maxTex = f;
        }
    }
}

