/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.sprite.ISprite;
import com.teamwizardry.librarianlib.features.sprite.SpriteDefinition;
import com.teamwizardry.librarianlib.features.sprite.Texture;
import java.awt.image.BufferedImage;
import java.awt.image.RasterFormatException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\u000bJ\u0015\u0010?\u001a\u00020@2\u0006\u0010\u0011\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bAJ\u000e\u0010B\u001a\u00020@2\u0006\u0010C\u001a\u00020.J\u0010\u0010D\u001a\u00020\t2\u0006\u0010E\u001a\u00020\tH\u0002J\u0010\u0010F\u001a\u00020(2\u0006\u0010E\u001a\u00020\tH\u0016J\u0010\u0010G\u001a\u00020(2\u0006\u0010E\u001a\u00020\tH\u0016J\u0010\u0010H\u001a\u00020(2\u0006\u0010E\u001a\u00020\tH\u0016J\u0010\u0010I\u001a\u00020(2\u0006\u0010E\u001a\u00020\tH\u0016J\b\u0010R\u001a\u00020@H\u0016J\b\u0010S\u001a\u00020\u0015H\u0016R$\u0010\u0002\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0005R\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001bR\u0014\u0010\u001e\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001bR\u0014\u0010 \u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001bR\u0014\u0010\"\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010$R\u0014\u0010\n\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010$R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R*\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020.0-@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u001a\u00102\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b3\u00104\u001a\u0004\b5\u0010$R\u001a\u00106\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b7\u00104\u001a\u0004\b8\u0010$R\u001a\u00109\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b:\u00104\u001a\u0004\b;\u0010$R\u001a\u0010<\u001a\u00020\t8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b=\u00104\u001a\u0004\b>\u0010$R\u0014\u0010J\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bK\u0010*R\u0014\u0010L\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bM\u0010*R\u0014\u0010N\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bO\u0010*R\u0014\u0010P\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bQ\u0010*\u00a8\u0006T"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "Lcom/teamwizardry/librarianlib/features/sprite/ISprite;", "tex", "Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "<init>", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;)V", "loc", "Lnet/minecraft/util/ResourceLocation;", "width", "", "height", "(Lnet/minecraft/util/ResourceLocation;II)V", "value", "getTex", "()Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "setTex", "Lcom/teamwizardry/librarianlib/features/sprite/SpriteDefinition;", "def", "getDef", "()Lcom/teamwizardry/librarianlib/features/sprite/SpriteDefinition;", "name", "", "getName", "()Ljava/lang/String;", "pinTop", "", "getPinTop", "()Z", "pinBottom", "getPinBottom", "pinLeft", "getPinLeft", "pinRight", "getPinRight", "frameCount", "getFrameCount", "()I", "getWidth", "getHeight", "uSize", "", "getUSize", "()F", "vSize", "getVSize", "", "Ljava/awt/image/BufferedImage;", "images", "getImages", "()Ljava/util/List;", "uvWidth", "getUvWidth$annotations", "()V", "getUvWidth", "uvHeight", "getUvHeight$annotations", "getUvHeight", "u", "getU$annotations", "getU", "v", "getV$annotations", "getV", "init", "", "init$LibrarianLib_Continuous_1_12_2", "loadImage", "full", "frameMultiplier", "animFrames", "minU", "minV", "maxU", "maxV", "minUCap", "getMinUCap", "minVCap", "getMinVCap", "maxUCap", "getMaxUCap", "maxVCap", "getMaxVCap", "bind", "toString", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nSprite.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Sprite.kt\ncom/teamwizardry/librarianlib/features/sprite/Sprite\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1557#2:177\n1628#2,3:178\n1#3:181\n*S KotlinDebug\n*F\n+ 1 Sprite.kt\ncom/teamwizardry/librarianlib/features/sprite/Sprite\n*L\n111#1:177\n111#1:178,3\n*E\n"})
public final class Sprite
implements ISprite {
    @NotNull
    private Texture tex;
    @NotNull
    private SpriteDefinition def;
    @NotNull
    private List<? extends BufferedImage> images;

    @NotNull
    public final Texture getTex() {
        return this.tex;
    }

    protected final void setTex(@NotNull Texture texture) {
        Intrinsics.checkNotNullParameter((Object)texture, (String)"<set-?>");
        this.tex = texture;
    }

    @NotNull
    public final SpriteDefinition getDef() {
        return this.def;
    }

    @NotNull
    public final String getName() {
        return this.def.getName();
    }

    @Override
    public boolean getPinTop() {
        return this.def.getPinTop();
    }

    @Override
    public boolean getPinBottom() {
        return this.def.getPinBottom();
    }

    @Override
    public boolean getPinLeft() {
        return this.def.getPinLeft();
    }

    @Override
    public boolean getPinRight() {
        return this.def.getPinRight();
    }

    @Override
    public int getFrameCount() {
        return Math.max(1, this.def.getFrames().length);
    }

    @Override
    public int getWidth() {
        return this.def.getW() / this.tex.getLogicalScale();
    }

    @Override
    public int getHeight() {
        return this.def.getH() / this.tex.getLogicalScale();
    }

    @Override
    public float getUSize() {
        return (float)this.def.getW() / (float)this.tex.getWidth();
    }

    @Override
    public float getVSize() {
        return (float)this.def.getH() / (float)this.tex.getHeight();
    }

    @NotNull
    public final List<BufferedImage> getImages() {
        return this.images;
    }

    public final int getUvWidth() {
        return this.def.getW();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(expression="def.w", imports={}))
    public static /* synthetic */ void getUvWidth$annotations() {
    }

    public final int getUvHeight() {
        return this.def.getH();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(expression="def.h", imports={}))
    public static /* synthetic */ void getUvHeight$annotations() {
    }

    public final int getU() {
        return this.def.getU();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(expression="def.u", imports={}))
    public static /* synthetic */ void getU$annotations() {
    }

    public final int getV() {
        return this.def.getV();
    }

    @Deprecated(message="UV coordinates should rarely be directly used", replaceWith=@ReplaceWith(expression="def.v", imports={}))
    public static /* synthetic */ void getV$annotations() {
    }

    public Sprite(@NotNull Texture tex) {
        Intrinsics.checkNotNullParameter((Object)tex, (String)"tex");
        this.def = new SpriteDefinition("");
        this.images = CollectionsKt.emptyList();
        this.tex = tex;
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.def = new SpriteDefinition("");
        this.images = CollectionsKt.emptyList();
        PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)Client.INSTANCE.getMinecraft().func_110442_L().func_110536_a(loc));
        int pngWidth = pngSizeInfo.field_188533_a;
        int pngHeight = pngSizeInfo.field_188534_b;
        if (width > 0 && height <= 0) {
            pngWidth = width;
            pngHeight = pngHeight * width / pngWidth;
        } else if (width <= 0 && height > 0) {
            pngHeight = height;
            pngWidth = pngWidth * height / pngHeight;
        } else if (width > 0 && height > 0) {
            pngWidth = width;
            pngHeight = height;
        }
        this.def.setU(0);
        this.def.setV(0);
        this.def.setW(pngWidth);
        this.def.setH(pngHeight);
        this.def.setFrames(new int[0]);
        this.tex = new Texture(loc, pngWidth, pngHeight);
        this.tex.get_sprites$LibrarianLib_Continuous_1_12_2().put(loc.func_110623_a(), this);
        this.tex.loadSpriteData();
    }

    public /* synthetic */ Sprite(ResourceLocation resourceLocation, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = 0;
        }
        this(resourceLocation, n, n2);
    }

    public final void init$LibrarianLib_Continuous_1_12_2(@NotNull SpriteDefinition def) {
        Intrinsics.checkNotNullParameter((Object)def, (String)"def");
        this.def = def;
    }

    /*
     * WARNING - void declaration
     */
    public final void loadImage(@NotNull BufferedImage full) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)full, (String)"full");
        RasterFormatException exception = null;
        Object object = (Iterable)RangesKt.until((int)0, (int)this.getFrameCount());
        Sprite sprite = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            BufferedImage bufferedImage;
            void i;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            int minX = (int)(this.minU((int)i) * (float)full.getWidth());
            int maxX = (int)(this.maxU((int)i) * (float)full.getWidth());
            int minY = (int)(this.minV((int)i) * (float)full.getHeight());
            int maxY = (int)(this.maxV((int)i) * (float)full.getHeight());
            try {
                bufferedImage = full.getSubimage(minX, minY, maxX - minX, maxY - minY);
            }
            catch (RasterFormatException e) {
                exception = e;
                bufferedImage = new BufferedImage(1, 1, 2);
            }
            collection.add(bufferedImage);
        }
        sprite.images = (List)destination$iv$iv;
        object = exception;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            throw it;
        }
    }

    private final int frameMultiplier(int animFrames) {
        return this.def.getFrames().length == 0 ? 0 : this.def.getFrames()[animFrames % this.def.getFrames().length];
    }

    @Override
    public float minU(int animFrames) {
        return (float)(this.def.getU() + this.def.getOffsetU() * this.frameMultiplier(animFrames)) / (float)this.tex.getWidth();
    }

    @Override
    public float minV(int animFrames) {
        return (float)(this.def.getV() + this.def.getOffsetV() * this.frameMultiplier(animFrames)) / (float)this.tex.getHeight();
    }

    @Override
    public float maxU(int animFrames) {
        return (float)(this.def.getU() + this.def.getW() + this.def.getOffsetU() * this.frameMultiplier(animFrames)) / (float)this.tex.getWidth();
    }

    @Override
    public float maxV(int animFrames) {
        return (float)(this.def.getV() + this.def.getH() + this.def.getOffsetV() * this.frameMultiplier(animFrames)) / (float)this.tex.getHeight();
    }

    @Override
    public float getMinUCap() {
        return (float)this.def.getMinUCap() / (float)this.def.getW();
    }

    @Override
    public float getMinVCap() {
        return (float)this.def.getMinVCap() / (float)this.def.getH();
    }

    @Override
    public float getMaxUCap() {
        return (float)this.def.getMaxUCap() / (float)this.def.getW();
    }

    @Override
    public float getMaxVCap() {
        return (float)this.def.getMaxVCap() / (float)this.def.getH();
    }

    @Override
    public void bind() {
        this.tex.bind();
    }

    @NotNull
    public String toString() {
        return "Sprite(texture=" + this.tex.getLoc() + ", name=" + this.getName() + ')';
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc, int width) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this(loc, width, 0, 4, null);
    }

    @JvmOverloads
    public Sprite(@NotNull ResourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this(loc, 0, 0, 6, null);
    }
}

