/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.sprite;

import com.teamwizardry.librarianlib.features.kotlin.Client;
import com.teamwizardry.librarianlib.features.sprite.ColorDefinition;
import com.teamwizardry.librarianlib.features.sprite.MutableColor;
import com.teamwizardry.librarianlib.features.sprite.Sprite;
import com.teamwizardry.librarianlib.features.sprite.SpriteDefinition;
import com.teamwizardry.librarianlib.features.sprite.SpritesMetadataSection;
import com.teamwizardry.librarianlib.features.utilities.client.ClientRunnable;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 ?2\u00020\u0001:\u0004=>?@B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ\u0006\u0010&\u001a\u00020'J\b\u0010(\u001a\u00020'H\u0002J\u0006\u0010)\u001a\u00020'J\u000e\u0010*\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001eJ \u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0007J\u000e\u0010-\u001a\u00020.2\u0006\u0010,\u001a\u00020\u001eJ\u0006\u00102\u001a\u00020'J\u0006\u00103\u001a\u00020'J\u0006\u00104\u001a\u00020'R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u001e\u0010\u0012\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0005@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\"\u0010\u0015\u001a\u0004\u0018\u00010\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0014@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020\u001f0\u001dX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001e\u0012\u0004\u0012\u00020%0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0015\u00105\u001a\u000606R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0015\u00109\u001a\u00060:R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006A"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "", "loc", "Lnet/minecraft/util/ResourceLocation;", "logicalWidth", "", "logicalHeight", "<init>", "(Lnet/minecraft/util/ResourceLocation;II)V", "(Lnet/minecraft/util/ResourceLocation;)V", "getLogicalWidth", "()I", "getLogicalHeight", "value", "getLoc", "()Lnet/minecraft/util/ResourceLocation;", "width", "getWidth", "height", "getHeight", "Ljava/awt/image/BufferedImage;", "image", "getImage", "()Ljava/awt/image/BufferedImage;", "logicalScale", "getLogicalScale", "section", "Lcom/teamwizardry/librarianlib/features/sprite/SpritesMetadataSection;", "_sprites", "", "", "Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "get_sprites$LibrarianLib_Continuous_1_12_2", "()Ljava/util/Map;", "set_sprites$LibrarianLib_Continuous_1_12_2", "(Ljava/util/Map;)V", "_colors", "Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureColor;", "loadSpriteData", "", "readSection", "loadImageData", "switchTexture", "getSprite", "name", "getColor", "Ljava/awt/Color;", "blending", "", "textureLoaded", "enableBlending", "disableBlending", "bind", "sprites", "Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureSprites;", "getSprites", "()Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureSprites;", "colors", "Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureColors;", "getColors", "()Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureColors;", "TextureSprites", "TextureColors", "Companion", "TextureColor", "LibrarianLib-Continuous-1.12.2"})
@SourceDebugExtension(value={"SMAP\nTexture.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Texture.kt\ncom/teamwizardry/librarianlib/features/sprite/Texture\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,352:1\n381#2,7:353\n381#2,7:360\n*S KotlinDebug\n*F\n+ 1 Texture.kt\ncom/teamwizardry/librarianlib/features/sprite/Texture\n*L\n224#1:353,7\n240#1:360,7\n*E\n"})
public final class Texture {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int logicalWidth;
    private final int logicalHeight;
    @NotNull
    private ResourceLocation loc;
    private int width;
    private int height;
    @Nullable
    private BufferedImage image;
    @Nullable
    private SpritesMetadataSection section;
    @NotNull
    private Map<String, Sprite> _sprites;
    @NotNull
    private Map<String, TextureColor> _colors;
    private boolean blending;
    private boolean textureLoaded;
    private final /* synthetic */ TextureSprites sprites;
    private final /* synthetic */ TextureColors colors;
    @NotNull
    private static List<WeakReference<Texture>> textures = new ArrayList();

    public Texture(@NotNull ResourceLocation loc, int logicalWidth, int logicalHeight) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.logicalWidth = logicalWidth;
        this.logicalHeight = logicalHeight;
        this.loc = loc;
        this._sprites = new LinkedHashMap();
        this._colors = new LinkedHashMap();
        textures.add(new WeakReference<Texture>(this));
        if (SpritesMetadataSection.Companion.getRegistered()) {
            this.loadSpriteData();
        }
        this.sprites = new TextureSprites();
        this.colors = new TextureColors();
    }

    public final int getLogicalWidth() {
        return this.logicalWidth;
    }

    public final int getLogicalHeight() {
        return this.logicalHeight;
    }

    @Deprecated(message="Assumes a 256x texture", replaceWith=@ReplaceWith(expression="Texture(loc, 256, 256)", imports={}))
    public Texture(@NotNull ResourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this(loc, 256, 256);
    }

    @NotNull
    public final ResourceLocation getLoc() {
        return this.loc;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @Nullable
    public final BufferedImage getImage() {
        return this.image;
    }

    public final int getLogicalScale() {
        return Math.max(1, (int)(((float)this.logicalWidth / (float)this.width + (float)this.logicalHeight / (float)this.height) / (float)2));
    }

    @NotNull
    public final Map<String, Sprite> get_sprites$LibrarianLib_Continuous_1_12_2() {
        return this._sprites;
    }

    public final void set_sprites$LibrarianLib_Continuous_1_12_2(@NotNull Map<String, Sprite> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this._sprites = map;
    }

    public final void loadSpriteData() {
        int pngWidth = 0;
        int pngHeight = 0;
        try {
            PngSizeInfo pngSizeInfo = PngSizeInfo.func_188532_a((IResource)Client.INSTANCE.getMinecraft().func_110442_L().func_110536_a(this.loc));
            pngWidth = pngSizeInfo.field_188533_a;
            pngHeight = pngSizeInfo.field_188534_b;
            if (this.width > 0 && this.height <= 0) {
                pngWidth = this.width;
                pngHeight = pngHeight * this.width / pngWidth;
            } else if (this.width <= 0 && this.height > 0) {
                pngHeight = this.height;
                pngWidth = pngWidth * this.height / pngHeight;
            } else if (this.width > 0 && this.height > 0) {
                pngWidth = this.width;
                pngHeight = this.height;
            }
        }
        catch (FileNotFoundException e) {
            pngWidth = 16;
            pngHeight = 16;
        }
        this.width = pngWidth;
        this.height = pngHeight;
        this.section = null;
        try {
            this.section = (SpritesMetadataSection)Client.INSTANCE.getMinecraft().func_110442_L().func_110536_a(this.loc).func_110526_a("spritesheet");
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        this.readSection();
        this.loadImageData();
    }

    private final void readSection() {
        SpritesMetadataSection section = this.section;
        Map<String, Sprite> oldSprites = this._sprites;
        Map<String, TextureColor> oldColors = this._colors;
        this._sprites = new LinkedHashMap();
        if (section != null) {
            this.width = section.getWidth();
            this.height = section.getHeight();
            for (SpriteDefinition spriteDefinition : section.getSprites()) {
                Sprite sprite = oldSprites.get(spriteDefinition.getName());
                if (sprite == null) {
                    sprite = new Sprite(this);
                }
                Sprite sprite2 = sprite;
                this._sprites.put(spriteDefinition.getName(), sprite2);
                sprite2.init$LibrarianLib_Continuous_1_12_2(spriteDefinition);
            }
            for (ColorDefinition colorDefinition : section.getColors()) {
                TextureColor textureColor = oldColors.get(colorDefinition.getName());
                if (textureColor == null) {
                    textureColor = new TextureColor();
                }
                TextureColor color = textureColor;
                this._colors.put(colorDefinition.getName(), color);
                color.init(colorDefinition);
            }
        }
    }

    public final void loadImageData() {
        try {
            BufferedImage image;
            this.image = image = TextureUtil.func_177053_a((InputStream)Client.INSTANCE.getMinecraft().func_110442_L().func_110536_a(this.loc).func_110527_b());
            this._sprites.forEach((arg_0, arg_1) -> Texture.loadImageData$lambda$1((arg_0, arg_1) -> Texture.loadImageData$lambda$0(image, this, arg_0, arg_1), arg_0, arg_1));
            this._colors.forEach((arg_0, arg_1) -> Texture.loadImageData$lambda$3((arg_0, arg_1) -> Texture.loadImageData$lambda$2(this, image, arg_0, arg_1), arg_0, arg_1));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public final void switchTexture(@NotNull ResourceLocation loc) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        this.loc = loc;
        this.textureLoaded = false;
        if (SpritesMetadataSection.Companion.getRegistered()) {
            this.loadSpriteData();
        }
    }

    @NotNull
    public final Sprite getSprite(@NotNull String name) {
        Sprite sprite;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, Sprite> $this$getOrPut$iv = this._sprites;
        boolean $i$f$getOrPut = false;
        Sprite value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            Sprite answer$iv = new Sprite(this);
            $this$getOrPut$iv.put(name, answer$iv);
            sprite = answer$iv;
        } else {
            sprite = value$iv;
        }
        return sprite;
    }

    @Deprecated(message="Ignores width and height parameters, width/height are based on the mcmeta file and the logical width/height", replaceWith=@ReplaceWith(expression="getSprite(name)", imports={}))
    @NotNull
    public final Sprite getSprite(@NotNull String name, int width, int height) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.getSprite(name);
    }

    @NotNull
    public final Color getColor(@NotNull String name) {
        TextureColor textureColor;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map<String, TextureColor> $this$getOrPut$iv = this._colors;
        boolean $i$f$getOrPut = false;
        TextureColor value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            TextureColor answer$iv = new TextureColor();
            $this$getOrPut$iv.put(name, answer$iv);
            textureColor = answer$iv;
        } else {
            textureColor = value$iv;
        }
        return textureColor.getColor();
    }

    public final void enableBlending() {
        this.blending = true;
        if (!this.textureLoaded) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.loc);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(this.loc).func_174936_b(true, false);
    }

    public final void disableBlending() {
        this.blending = false;
        if (!this.textureLoaded) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.loc);
        Minecraft.func_71410_x().func_110434_K().func_110581_b(this.loc).func_174936_b(false, false);
    }

    public final void bind() {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.loc);
        if (!this.textureLoaded) {
            this.textureLoaded = true;
            if (this.blending) {
                this.enableBlending();
            } else {
                this.disableBlending();
            }
        }
    }

    @NotNull
    public final TextureSprites getSprites() {
        return this.sprites;
    }

    @NotNull
    public final TextureColors getColors() {
        return this.colors;
    }

    private static final Unit loadImageData$lambda$0(BufferedImage $image, Texture this$0, String name, Sprite sprite) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)sprite, (String)"sprite");
        try {
            Intrinsics.checkNotNull((Object)$image);
            sprite.loadImage($image);
        }
        catch (Exception e) {
            new RuntimeException("Error loading sprite image " + name + " in texture " + this$0.loc, e).printStackTrace();
        }
        return Unit.INSTANCE;
    }

    private static final void loadImageData$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    private static final Unit loadImageData$lambda$2(Texture this$0, BufferedImage $image, String string, TextureColor color) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        int x = (int)((double)color.getU() / (double)this$0.width * (double)$image.getWidth());
        int y = (int)((double)color.getV() / (double)this$0.height * (double)$image.getHeight());
        color.getColor().replaceColor(new Color($image.getRGB(x, y), true));
        return Unit.INSTANCE;
    }

    private static final void loadImageData$lambda$3(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0, p1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0006J\u0006\u0010\u0007\u001a\u00020\u0005R&\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Texture$Companion;", "", "<init>", "()V", "register", "", "register$LibrarianLib_Continuous_1_12_2", "reloadTextures", "textures", "", "Ljava/lang/ref/WeakReference;", "Lcom/teamwizardry/librarianlib/features/sprite/Texture;", "getTextures", "()Ljava/util/List;", "setTextures", "(Ljava/util/List;)V", "LibrarianLib-Continuous-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public final void register$LibrarianLib_Continuous_1_12_2() {
            ClientRunnable.registerReloadHandler(Companion::register$lambda$0);
        }

        public final void reloadTextures() {
            ArrayList<WeakReference<Texture>> newList = new ArrayList<WeakReference<Texture>>();
            TextureManager textureManager = Client.INSTANCE.getRenderEngine();
            for (WeakReference<Texture> weakRef : this.getTextures()) {
                Texture tex;
                if ((Texture)weakRef.get() == null) continue;
                newList.add(weakRef);
                ITextureObject texObject = textureManager.func_110581_b(tex.getLoc());
                if (texObject != null) {
                    textureManager.func_110579_a(tex.getLoc(), texObject);
                }
                tex.loadSpriteData();
                tex.loadImageData();
            }
            this.setTextures((List<WeakReference<Texture>>)newList);
        }

        @NotNull
        public final List<WeakReference<Texture>> getTextures() {
            return textures;
        }

        public final void setTextures(@NotNull List<WeakReference<Texture>> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            textures = list;
        }

        private static final void register$lambda$0() {
            ArrayList<WeakReference<Texture>> newList = new ArrayList<WeakReference<Texture>>();
            for (WeakReference<Texture> weakRef : Companion.getTextures()) {
                Texture tex;
                if ((Texture)weakRef.get() == null) continue;
                newList.add(weakRef);
                tex.loadSpriteData();
                tex.loadImageData();
            }
            Companion.setTextures((List<WeakReference<Texture>>)newList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureColor;", "", "<init>", "()V", "u", "", "getU", "()I", "setU", "(I)V", "v", "getV", "setV", "color", "Lcom/teamwizardry/librarianlib/features/sprite/MutableColor;", "getColor", "()Lcom/teamwizardry/librarianlib/features/sprite/MutableColor;", "init", "", "def", "Lcom/teamwizardry/librarianlib/features/sprite/ColorDefinition;", "LibrarianLib-Continuous-1.12.2"})
    private static final class TextureColor {
        private int u;
        private int v;
        @NotNull
        private final MutableColor color = new MutableColor();

        public final int getU() {
            return this.u;
        }

        public final void setU(int n) {
            this.u = n;
        }

        public final int getV() {
            return this.v;
        }

        public final void setV(int n) {
            this.v = n;
        }

        @NotNull
        public final MutableColor getColor() {
            return this.color;
        }

        public final void init(@NotNull ColorDefinition def) {
            Intrinsics.checkNotNullParameter((Object)def, (String)"def");
            this.u = def.getU();
            this.v = def.getV();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureColors;", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;)V", "getValue", "Ljava/awt/Color;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "LibrarianLib-Continuous-1.12.2"})
    public final class TextureColors {
        @NotNull
        public final Color getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return Texture.this.getColor(property.getName());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bH\u0086\u0002\u00a8\u0006\t"}, d2={"Lcom/teamwizardry/librarianlib/features/sprite/Texture$TextureSprites;", "", "<init>", "(Lcom/teamwizardry/librarianlib/features/sprite/Texture;)V", "getValue", "Lcom/teamwizardry/librarianlib/features/sprite/Sprite;", "thisRef", "property", "Lkotlin/reflect/KProperty;", "LibrarianLib-Continuous-1.12.2"})
    public final class TextureSprites {
        @NotNull
        public final Sprite getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
            Intrinsics.checkNotNullParameter(property, (String)"property");
            return Texture.this.getSprite(property.getName());
        }
    }
}

