/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.structure;

import com.teamwizardry.librarianlib.features.structure.Structure;
import com.teamwizardry.librarianlib.features.structure.StructureMatchResult;
import com.teamwizardry.librarianlib.features.structure.TemplateBlockAccess;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="librarianlib")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u0010\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020!H\u0007J\u0010\u0010\"\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010#\u001a\u00020\u001bJ\u0016\u0010\f\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u0010$\u001a\u00020\u001bJ \u0010%\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0002J \u0010)\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0007H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006*"}, d2={"Lcom/teamwizardry/librarianlib/features/structure/InWorldRender;", "", "<init>", "()V", "pos", "Lnet/minecraft/util/math/BlockPos;", "rot", "Lnet/minecraft/util/Rotation;", "structure", "Lcom/teamwizardry/librarianlib/features/structure/Structure;", "getStructure", "()Lcom/teamwizardry/librarianlib/features/structure/Structure;", "setStructure", "(Lcom/teamwizardry/librarianlib/features/structure/Structure;)V", "verts", "", "getVerts", "()[I", "setVerts", "([I)V", "match", "Lcom/teamwizardry/librarianlib/features/structure/StructureMatchResult;", "getMatch", "()Lcom/teamwizardry/librarianlib/features/structure/StructureMatchResult;", "setMatch", "(Lcom/teamwizardry/librarianlib/features/structure/StructureMatchResult;)V", "worldLast", "", "event", "Lnet/minecraftforge/client/event/RenderWorldLastEvent;", "blockPlace", "Lnet/minecraftforge/event/world/BlockEvent$PlaceEvent;", "blockBreak", "Lnet/minecraftforge/event/world/BlockEvent$BreakEvent;", "worldToStructure", "unsetStructure", "refreshVerts", "transformedBlockPos", "mirrorIn", "Lnet/minecraft/util/Mirror;", "rotationIn", "inverseTransformedBlockPos", "LibrarianLib-Continuous-1.12.2"})
public final class InWorldRender {
    @NotNull
    public static final InWorldRender INSTANCE = new InWorldRender();
    @Nullable
    private static BlockPos pos;
    @Nullable
    private static Rotation rot;
    @Nullable
    private static Structure structure;
    @Nullable
    private static int[] verts;
    @Nullable
    private static StructureMatchResult match;

    private InWorldRender() {
    }

    @Nullable
    public final Structure getStructure() {
        return structure;
    }

    public final void setStructure(@Nullable Structure structure) {
        InWorldRender.structure = structure;
    }

    @Nullable
    public final int[] getVerts() {
        return verts;
    }

    public final void setVerts(@Nullable int[] nArray) {
        verts = nArray;
    }

    @Nullable
    public final StructureMatchResult getMatch() {
        return match;
    }

    public final void setMatch(@Nullable StructureMatchResult structureMatchResult) {
        match = structureMatchResult;
    }

    @JvmStatic
    @SubscribeEvent
    public static final void worldLast(@NotNull RenderWorldLastEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (verts == null) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        double x = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)event.getPartialTicks();
        double y = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)event.getPartialTicks();
        double z = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)event.getPartialTicks();
        GlStateManager.func_179137_b((double)(-x), (double)(-y), (double)(-z));
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        float f = blockPos.func_177958_n();
        BlockPos blockPos2 = pos;
        Intrinsics.checkNotNull((Object)blockPos2);
        float f2 = blockPos2.func_177956_o();
        BlockPos blockPos3 = pos;
        Intrinsics.checkNotNull((Object)blockPos3);
        GlStateManager.func_179109_b((float)f, (float)f2, (float)blockPos3.func_177952_p());
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vb = tessellator.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        Intrinsics.checkNotNull((Object)verts);
        vb.func_178981_a(verts);
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    @JvmStatic
    @SubscribeEvent
    public static final void blockPlace(@NotNull BlockEvent.PlaceEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (match == null) {
            return;
        }
        BlockPos blockPos = event.getPos();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
        BlockPos pos2 = INSTANCE.worldToStructure(blockPos);
        StructureMatchResult structureMatchResult = match;
        Intrinsics.checkNotNull((Object)structureMatchResult);
        if (structureMatchResult.getAllErrors().contains(pos2)) {
            INSTANCE.refreshVerts();
        }
    }

    @JvmStatic
    @SubscribeEvent
    public static final void blockBreak(@NotNull BlockEvent.BreakEvent event) {
        block5: {
            block4: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (match == null) {
                    return;
                }
                BlockPos blockPos = event.getPos();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"getPos(...)");
                BlockPos pos2 = INSTANCE.worldToStructure(blockPos);
                StructureMatchResult structureMatchResult = match;
                Intrinsics.checkNotNull((Object)structureMatchResult);
                if (structureMatchResult.getMatches().contains(pos2)) break block4;
                StructureMatchResult structureMatchResult2 = match;
                Intrinsics.checkNotNull((Object)structureMatchResult2);
                if (!structureMatchResult2.getAllErrors().contains(pos2)) break block5;
            }
            INSTANCE.refreshVerts();
        }
    }

    private final BlockPos worldToStructure(BlockPos pos2) {
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        BlockPos blockPos2 = pos2.func_177973_b((Vec3i)blockPos);
        Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"subtract(...)");
        StructureMatchResult structureMatchResult = match;
        Intrinsics.checkNotNull((Object)structureMatchResult);
        BlockPos blockPos3 = this.inverseTransformedBlockPos(blockPos2, Mirror.NONE, structureMatchResult.getRotation());
        Structure structure = InWorldRender.structure;
        Intrinsics.checkNotNull((Object)structure);
        BlockPos blockPos4 = blockPos3.func_177971_a((Vec3i)structure.getOrigin());
        Intrinsics.checkNotNullExpressionValue((Object)blockPos4, (String)"add(...)");
        return blockPos4;
    }

    public final void unsetStructure() {
        structure = null;
        pos = null;
        verts = null;
        match = null;
    }

    public final void setStructure(@NotNull Structure structure, @NotNull BlockPos pos2) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        InWorldRender.structure = structure;
        pos = pos2;
        this.refreshVerts();
    }

    public final void refreshVerts() {
        BlockPos pos2;
        StructureMatchResult match;
        Structure structure = InWorldRender.structure;
        if (structure == null) {
            return;
        }
        Structure struct = structure;
        WorldClient worldClient = Minecraft.func_71410_x().field_71441_e;
        Intrinsics.checkNotNullExpressionValue((Object)worldClient, (String)"world");
        World world = (World)worldClient;
        BlockPos blockPos = pos;
        Intrinsics.checkNotNull((Object)blockPos);
        InWorldRender.match = match = struct.match(world, blockPos);
        rot = struct.getMatchedRotation();
        TemplateBlockAccess templateBlockAccess = struct.getBlockAccess();
        BlockPos blockPos2 = struct.getOrigin();
        IBlockState iBlockState = Blocks.field_150350_a.func_176223_P();
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getDefaultState(...)");
        templateBlockAccess.setBlockState(blockPos2, iBlockState);
        Object object = match;
        if (object == null || (object = ((StructureMatchResult)object).getMatches()) == null) {
            object = CollectionsKt.emptyList();
        }
        Iterator iterator2 = object.iterator();
        while (iterator2.hasNext()) {
            pos2 = (BlockPos)iterator2.next();
            TemplateBlockAccess templateBlockAccess2 = struct.getBlockAccess();
            IBlockState iBlockState2 = Blocks.field_150350_a.func_176223_P();
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState2, (String)"getDefaultState(...)");
            templateBlockAccess2.setBlockState(pos2, iBlockState2);
        }
        Object object2 = match;
        if (object2 == null || (object2 = ((StructureMatchResult)object2).getNonAirErrors()) == null) {
            object2 = CollectionsKt.emptyList();
        }
        iterator2 = object2.iterator();
        while (iterator2.hasNext()) {
            pos2 = (BlockPos)iterator2.next();
            TemplateBlockAccess templateBlockAccess3 = struct.getBlockAccess();
            IBlockState iBlockState3 = Blocks.field_150350_a.func_176223_P();
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState3, (String)"getDefaultState(...)");
            templateBlockAccess3.setBlockState(pos2, iBlockState3);
        }
        Object object3 = match;
        if (object3 == null || (object3 = ((StructureMatchResult)object3).getPropertyErrors()) == null) {
            object3 = CollectionsKt.emptyList();
        }
        iterator2 = object3.iterator();
        while (iterator2.hasNext()) {
            pos2 = (BlockPos)iterator2.next();
            TemplateBlockAccess templateBlockAccess4 = struct.getBlockAccess();
            IBlockState iBlockState4 = Blocks.field_150350_a.func_176223_P();
            Intrinsics.checkNotNullExpressionValue((Object)iBlockState4, (String)"getDefaultState(...)");
            templateBlockAccess4.setBlockState(pos2, iBlockState4);
        }
        Structure structure2 = InWorldRender.structure;
        Intrinsics.checkNotNull((Object)structure2);
        structure2.getBlockAccess().resetSetBlocks();
    }

    private final BlockPos transformedBlockPos(BlockPos pos2, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos2.func_177958_n();
        int j = pos2.func_177956_o();
        int k = pos2.func_177952_p();
        boolean flag = true;
        switch (WhenMappings.$EnumSwitchMapping$0[mirrorIn.ordinal()]) {
            case 1: {
                k = -k;
                break;
            }
            case 2: {
                i = -i;
                break;
            }
            default: {
                flag = false;
            }
        }
        switch (WhenMappings.$EnumSwitchMapping$1[rotationIn.ordinal()]) {
            case 1: {
                return new BlockPos(k, j, -i);
            }
            case 2: {
                return new BlockPos(-k, j, i);
            }
            case 3: {
                return new BlockPos(-i, j, -k);
            }
        }
        return flag ? new BlockPos(i, j, k) : pos2;
    }

    private final BlockPos inverseTransformedBlockPos(BlockPos pos2, Mirror mirrorIn, Rotation rotationIn) {
        int i = pos2.func_177958_n();
        int j = pos2.func_177956_o();
        int k = pos2.func_177952_p();
        if (rotationIn == Rotation.COUNTERCLOCKWISE_90) {
            i = -i;
            k = -k;
            i = -i;
            k = -k;
        } else if (rotationIn == Rotation.CLOCKWISE_90) {
            k = -k;
            i = -i;
            k = -k;
        } else if (rotationIn == Rotation.CLOCKWISE_180) {
            i = -i;
            k = -k;
        }
        if (mirrorIn == Mirror.LEFT_RIGHT) {
            k = -k;
        } else if (mirrorIn == Mirror.FRONT_BACK) {
            i = -i;
        }
        return new BlockPos(i, j, k);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Mirror.values().length];
            try {
                nArray[Mirror.LEFT_RIGHT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Mirror.FRONT_BACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Rotation.values().length];
            try {
                nArray[Rotation.COUNTERCLOCKWISE_90.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_90.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rotation.CLOCKWISE_180.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

